/*File Name: Color.cpp
  Author: Betti sterholz ; Date: 06.08.2003
  System: C++
  
  This is implementation of the Basisclass of all Vector objects


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "Color.h"
//---------------------------------------------------------------------------


   //Construktors:
Color::Color():Vector(3)
//standart constructor
//makes a blank object for RGB colors, it has 3 components
{}


Color::Color(unsigned int noc):Vector(noc)
//parameter constructor
//makes a color vector object with noc components all values set to 0
//the depth of the color component i is given by the i'th component of
//the unsigned int array dp wich has noc components(eg.: if dp[1]=10
//the Component[1] con return values from 0 til 9)
//pre: the number of components to produce and the depth of each component
{}

Color::Color(const Color& col):Vector(col)
//copy constructor
//makes a color vector object with the same values as the given color
//vector
//pre: the color vector to copy
{}


unsigned long Color::getTimeNeed() const
//to get a idea how long the object need to evaluate
//post: a number for how much time the object need to evaluate
{return getNumberOfComponents();}

Color* Color::copy()
//copy this object(means all, even the objects in it)
//post: a pointer to the copy of this object
{
return (new Color(*this));
}
	
std::string Color::classnameOf() const
//returns the classname of this object as a string
//post: the classname of this object as a string
{return "Color";}

Color* Color::copyValue() const
//returns a Color vector with all Components as values set to the values 
//that are actual in the values and variables of this Color vector rounded to int
//post: a Color vector with all Components as values set to the values 
//that are actual in the values and variables of this Color vector rounded to int
{	
Color *col=new Color(getNumberOfComponents());
for (unsigned int i=1;i<=getNumberOfComponents();i++)
{
	col->setValueToValue(i,(int)(*getComponentPointer(i)));
}
return col;
}





