/*File Name: UnderArea.h
  Author: Betti sterholz ; Date: 13.08.2003
  System: C++
  
  This is header of the Basisclass of all Vector objects


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___UNDERAREA_h__
#define ___UNDERAREA_h__

#include "Vector.h"




class UnderArea:public Vector
{
public:
	UnderArea();
	//standart constructor
	//makes a blank object

	UnderArea(unsigned int noc);
	//parameter constructor
	//makes a UnderArea vector object with noc components all values set to 0
	//pre: the number of components to produce

	UnderArea(const UnderArea& col);
	//copy constructor
	//makes a UnderArea vector object with the same values as the given UnderArea
	//vector
	//pre: the UnderArea vector to copy

	unsigned long getTimeNeed() const;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate

	virtual UnderArea* copy();
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	virtual std::string classnameOf() const;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

};

#endif
