/*File Name: Point.h
  Author: Betti sterholz ; Date: 18.08.2003
  System: C++


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef ___AREA_h__
#define ___AREA_h__

#include <sstream>
#include <string>
#include <list>
#include "ListObject.h"


class Area: public ListObject
{
protected:

public:
//constructors:
	Area();
	//standart constructor
	//constructs a blank Area object

	Area(PicturObject* uob,std::list<Vector*> vl);
	//special constructor
	//constructs a Area object with a new pointer for the defined variable
	//the given vector list vl for the VectorList and a UnderObject pointer 
	//pointed to the given pointer uob 


	Area(const Area& are);
	//copy constructor
	//constructs a copy of the given Area "are" object
	//attention: copy the objects from the given Area object 
	//pre: the Area object "are" to copy

	~Area();
	//destructor
	//attention: this destructor destruct just the element and not the 
	//objects in it

//Methodes to get greatness of order:
	unsigned int getNumberOfFunctions() const;
	//evaluate the number of Function in this object
	//post: Numbers of Function in this object

	unsigned int getNumberOfArea() const;
	//evaluate the number of Area objects in this object
	//post: Numbers of Area objects in this object


//other get methodes:

	unsigned long getTimeNeed(unsigned long max) const;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate


//methodes wich changes the object:

	bool insertFunctionVector(unsigned int n,UnderFunction* fkt);
	//insert the UnderFunction vector fkt in the UnderFunction vector list 
	//of the object with the value n in the order of Function objects
	//pre: the to insert UnderFunction vector fkt and the position in the
	//  order of Function objects to insert it
	//post: true if the UnderFunction is inserted, else false

	bool insertAreaVector(unsigned int n,UnderArea* area);
	//insert the UnderArea vector area in the UnderArea vector list 
	//of the object with the value n in the order of Area objects
	//pre: the to insert UnderArea vector area and the position in the
	//  order of Area objects to insert it
	//post: true if the UnderArea is inserted, else false


//common methodes:

	virtual Area* copy();
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	PicturObject* copyElement(unsigned int n);
	//copy the element(not the objects in it) wich has the value
	//n in the order of objects
	//don't copy the defined variable, instead makes a new
	//pre: the value n of the element to copy in the order of objects
	//post: a pointer to the copy of the element

	void operator=(const GraphicObject* obj);
	//copy the given object obj(means all, even the objects in it)
	//don't copy the defined variable, instead makes a new
	//pre: the object obj to copy
	//post: this object with the values of the given object obj

	bool equalValue(const GraphicObject* obj) const;
	//returns if this object and the given object obj are equal
	//(have the same values and equal under objects)
	//pre: the other object obj to test
	//post: true if this and obj are equal	

	std::string classnameOf() const;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	bool store(unsigned int& n,std::stringstream& stream) const;
	//store the object to the stream, with the syntax from the docu
	//pre: the number for the variables to count from
	//post: the string for this object in the output stream

	void makeMatrix(PicturMatrix* pm) const;
	//make the PicturMatrix of this object
	//pre: the PicturMatrix to store the values to
	//post: the PicturMatrix of this object

	void makeMatrixOfObject(PicturMatrix* pm,unsigned int n) const;
	//make the PicturMatrix of object wich has the value n in the order 
	//of part objects
	//pre: the value of the object, to make the PicturMatrix from, in the 
	//  order of part objects
	//post: the PicturMatrix of the object


};

#endif
