/*File Name: Individual.h
  Author: Betti sterholz ; Date: 03.08.2003
  System: C++
  
  This is the Basisclass of PicturObject and Vector
  most functions are pure virtual


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___INDIVIDUAL_h__
#define ___INDIVIDUAL_h__

#include "PicturObject.h"



class Individual
{
protected:
	PicturObject* Object;
	double Goodness;
	unsigned long Identifier;
	bool Immortal;

public:


	Individual(PicturObject* obj,double good,unsigned long id,bool im=false):
			Object(obj),Goodness(good),Identifier(id),Immortal(im)
	//special constructor
	//constructs a object with the given Picturobject as the object,
	//the value good for the Goodness and the value of id for the Identifier
	{}

	Individual(Individual *idv):Goodness(idv->getGoodness()),Identifier(idv->getIdentifier()),
			Immortal(idv->getImmortal())
	//copy constructor
	//constructs a object with the given Picturobject as the object,
	//the value good for the Goodness and the value of id for the Identifier
	{Object=(idv->getObject())->copy();}

	~Individual()
	//destructor
	{
	Object->deleteObject();
	delete Object;
	}

	PicturObject* getObject() const
	//returns a pointer to the object of this Individual
	//post: a pointer of object of this Individual
	{return Object;}

	double getGoodness() const
	//returns the value of Goodness of this Individual
	//post: the value of Goodness of this Individual
	{return Goodness;}

	unsigned long getIdentifier() const
	//returns the value the Identifier of this Individual
	//post: the value the Identifier of this Individual
	{return Identifier;}

	bool getImmortal() const
	//returns if the individual is Immortal
	//post: the value the Immortal of this Individual
	{return Immortal;}

	void setObject(PicturObject* obj)
	//set the pointer of the object of this Individual to the given pointer obj
	//pre: a pointer of the new object of this Individual
	{Object=obj;}

	void setGoodness(double good)
	//set the value of the Goodness of this Individual to the given value good
	//pre: a double value good for the new Goodness of this Individual
	{Goodness=good;}

	void setIdentifier(unsigned long id)
	//set the value of the Identifier of this Individual to the given value id
	//pre: a double value id for the new Identifier of this Individual
	{Identifier=id;}

	void setImmortal(bool im)
	//set if the individual is Immortal
	//pre: the value to set Immortal of this Individual to
	{Immortal=im;}

	bool operator<(const Individual idv) const
	//returns true if the given Individual idv is better then this,
	//means has a higher Goodness
	//true: if the given Individual has a higher Goodness as this Individual, else false
	{return (getGoodness()<(idv.getGoodness()));}



};
#endif
