/*File Name: UnderFunction.cpp
  Author: Betti sterholz ; Date: 06.08.2003
  System: C++
  
  This is implementation of the Basisclass of all Vector objects


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "UnderFunction.h"
//---------------------------------------------------------------------------


   //Construktors:
UnderFunction::UnderFunction():Vector(3)
//standart constructor
//makes a blank object for x*y^z UnderFunctions, it has 3 components
{}

UnderFunction::UnderFunction(const UnderFunction& udf):Vector(udf)
//copy constructor
//makes a UnderFunction vector object with the same values as the given UnderFunction
//vector
//pre: the UnderFunction vector to copy
{}

unsigned long UnderFunction::getTimeNeed() const
//to get a idea how long the object need to evaluate
//post: a number for how much time the object need to evaluate
{return getNumberOfComponents();}

UnderFunction* UnderFunction::copy()
//copy this object(means all, even the objects in it)
//post: a pointer to the copy of this object
{
return (new UnderFunction(*this));
}

std::string UnderFunction::classnameOf() const
//returns the classname of this object as a string
//post: the classname of this object as a string
{return "UnderFunction";}





