/*File Name: PicturObject.h
  Author: Betti sterholz ; Date: 17.08.2003
  System: C++
  
  This is the Basisclass of pictur objects
  most functions are pure virtual


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___PICTUROBJECT_h__
#define ___PICTUROBJECT_h__

#include <sstream>
#include <string>
#include <list>
#include "GraphicObject.h"
#include "Vector.h"
#include "UnderFunction.h"
#include "UnderArea.h"
#include "PicturMatrix.h"

class PicturObject: public GraphicObject
{
public:
//constructors:

	PicturObject();
	//blank standart constructor

	virtual ~PicturObject();
	//blank destructor

//Methodes to get greatnes of order:
	virtual unsigned int getNumberOfValue() const = 0;
	//evaluate the number of values in this object
	//post: Numbers of values in this object

	virtual unsigned int getNumberOfVariable() const = 0;
	//evaluate the number of variables in this object
	//post: Numbers of Variables in this object

	virtual unsigned int getNumberOfListVectors() const = 0;
	//evaluate the number of List Vectors in this object
	//post: Numbers of List Vectors in this object

	virtual unsigned int getNumberOfMovePoints() const = 0;
	//evaluate the number of Move Points in this object
	//post: Numbers of Move Points in this object

	virtual unsigned int getNumberOfObjects() const = 0;
	//evaluate the number of PicturObject in this object
	//post: Numbers of PicturObject in this object

	virtual unsigned int getNumberOfConc() const = 0;
	//evaluate the number of conc Objects in this object
	//post: Numbers of conc Objects in this object

	virtual unsigned int getNumberOfPoints() const = 0;
	//evaluate the number of PointObject in this object
	//post: Numbers of PointObject in this object

	virtual unsigned int getNumberOfObjectPoints() const = 0;
	//evaluate the number of real part objects in this object,
	//real part objects are part objects how has from a conc 
	//object downwarts all objects in the conc objects and
	//upwarts just one
	//post: Numbers of real part objects in this object

	virtual unsigned int getNumberOfFunctions() const = 0;
	//evaluate the number of Function in this object
	//post: Numbers of Function in this object

	virtual unsigned int getNumberOfArea() const = 0;
	//evaluate the number of area Objects in this object
	//post: Numbers of area Objects in this object


//other get Functions:

	virtual int getValue(unsigned int n) const = 0;
	//to get the value, of the value with number n in the order of values
	//pre: the number n, in the order of values, of the value to return
	//post: the value of the value

	virtual double* getVariable(unsigned int n) const = 0;
	//to get the pointer to the variable with number n in the order of variables
	//pre: the number n, in the order of variables, of the variable to return
	//post: the pointe for the variable

	virtual unsigned long getGreatness() const = 0;
	//to get a idea how great the object is
	//post: a number for how great the object is

	virtual unsigned long getTimeNeed(unsigned long max) const = 0;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate

	virtual bool isUsedVariable(double* var) const = 0;
	//checks if the given pointer for a variable var is somewhere in the 
	//object(than it is used in the object)
	//pre: the pointer for the variable var to search for
	//post: true if the variable is find(used), false else

	virtual PicturObject* getObjectFrom(unsigned int n) const = 0;
	//to get the object wich has the value n in the order of objects
	//pre: the value n in the order of objects of the object to get
	//post: the object with the value n in the order of objects if exsits
	//     or 0 if not

	virtual Vector* getListVectorFrom(unsigned int n) const = 0;
	//to get the list vector wich has the value n in the order of list vectors
	//pre: the value n in the order of list vectors of the list vector to get
	//post: the list vector with the value n in the order of list vectors 
	//    if exsits or 0 if not

	virtual PicturObject* getNext(bool b=true) const = 0;
	//to get the next object, means the object under the object from wich 
	//it is called, if the object from wich it is called is a conc object
	//gets the first of his objects if b ist true else the second
	//pre: a bool value if you want the first(true) or the second(false)
	//   object, if ther are two
	//post: the object with the value n in the order of objects if exsits
	//     or 0 if not

	virtual unsigned int partObjectToPointPartObject(unsigned int n) const = 0;
	//to get the value in the point part object order of the object wich 
	//has the value n in the order of part objects
	//pre: the value n in the order of part objects of the object
	//post: the value n in the order of point part objects of the same object
	//  or 0 if it is no point part object

	virtual unsigned int pointPartObjectToPartObject(unsigned int n) const = 0;
	//to get the value in the part object order of the object wich 
	//has the value n in the order of point part objects
	//pre: the value n in the order of point part objects of the object
	//post: the value n in the order of part objects of the same object

	virtual unsigned int movePointToObjectPoint(unsigned int n) const = 0;
	//to get the value in the object order of the object wich
	//has the value n in the order of move point objects
	//pre: the value n in the order of move point objects of the object
	//post: the value n in the order of objects of the same object

	virtual bool isDeletableElement() const = 0;
	//checks if the Element(this) is deletable(Points and conc objects 
	//never are, Functions and Area objects are if the variable they define
	//is not used)
	//post: true if the element is deletable else false

	virtual bool isUsedVariableInElement(double* var) const = 0;
	//checks if the variable var is used in the object if so returens
	//true else false
	//pre: the double pointer for the variable to check
	//post: true if the variable is used else false

	virtual double* getDefinedVariableFrom(unsigned int n) const = 0;
	//to get the variable the object, with the value n in the order of
	//move point, defined
	//pre: the value n of a object in the order of move points
	//post: the double pointer of the variable the same object defined 
	//  or 0 if no such variable/object

	virtual std::list<double*> getAllDefinedVariableOver(unsigned int n) const = 0;
	//to get a list off all the Variables defined over the object, with
	//the value n in the order of move points
	//so you know wich varibles this object can use
	//pre: the value of the object, in the order of move point, from
	//  wich to get the list of variables defined in objects wich
	//  are over it
	//post: the list of double pointer of variables wich are defined over it

	virtual std::list<double*> getAllDefinedVariableOverValue(unsigned int n) const = 0;
	//to get a list off all the Variables defined over the value, with
	//the value n in the order of values
	//so you know wich varibles this value can be seted to
	//pre: the value of the value, in the order of values, from
	//  wich to get the list of variables defined in objects wich
	//  are over it
	//post: the list of double pointer of variables wich are defined over it

	virtual std::list<double*> getAllDefinedVariableOverVariable(unsigned int n) const = 0;
	//to get a list off all the variables defined over the variable, with
	//the value n in the order of variable
	//so you know wich varibles this variable can be seted to
	//pre: the value of the variable, in the order of variable, from
	//  wich to get the list of variables defined in objects wich
	//  are over it
	//post: the list of double pointer of variables wich are defined over it


//Methodes wich changes the Object:

	virtual bool setValueToValue(unsigned int n, int val) = 0;
	//set the value, of the value with number n in the order of values,
	//to the given new value val
	//pre: the number n, in the order of values, of the value to set and
	//     the value val to set it to
	//post: true if the value is set, false else

	virtual bool setValueToVariable(unsigned int n, double* var) = 0;
	//set the value, of the value with number n in the order of values,
	//to the given pointer for the variable var
	//pre: the number n, in the order of values, of the value to set and
	//     the pointer for the variable var to set it to
	//post: true if the value is set, false else

	virtual bool setVariableToVariable(unsigned int n, double* var) = 0;
	//set the variable, with number n in the order of variables,
	//to the given pointer for the new variable var
	//pre: the number n, in the order of variables, of the variable to set and
	//     the pointer for the new variable var to set it to
	//post: true if the varable is set, false else

	virtual unsigned int setVariableToVariable(double* var1,double* var2) = 0;
	//set on the positions wher the variable var1 in the object stand the
	//variable var2

	//pre: the variable var1 to set to the variable var2 and the variable var2
	//post: the number of variables set

	virtual bool setVariableToValue(unsigned int n, int val) = 0;
	//set the variable, with number n in the order of variables,
	//to the given value val and make it a value
	//pre: the number n, in the order of variables, of the variable to set and
	//     the value val to set it to
	//post: true if the varable is set, false else

	virtual unsigned int setVariableToValue(double* var1,int val) = 0;
	//set on the positions wher the variable var1 in the object stand the
	//value val
	//pre: the variable var1 to set to the value val and the value val
	//post: the number of variables set

	virtual bool changeValueAbout(unsigned int n, int dist) = 0;
	//set the value, of the value with number n in the order of values,
	//to a new value, wich is evaluated from the old value plus the
	//value dist
	//pre: the number n, in the order of values, of the value to set and
	//     the distance dist, to change it about
	//post: true if the value is set, false else

	virtual bool insertObjectInObject(unsigned int n, PicturObject* obj,bool ov) = 0;
	//insert the object obj in the object with the value n in the order
	//of objects, 
	//if ov are true obj is inserted as the first object in the new conc 
	//object(obj can be overlapped) else as the secound(not overlapped)
	//pre: the position in the object order to insert it(should not be 
	//  a point), the pointer to the object to insert(the pointer is inserted)
	//  and the bool value if it can be overlapped
	//post: true if the object obj was inserted

	virtual bool overwriteObjectWithObject(unsigned int n, PicturObject* obj) = 0;
	//overwrite the object, wich has the value n in the order of objects,
	//with the given object obj
	//attention: the overwriten object will not be deleted
	//pre: the position n in the order of objects of the object to 
	//   overwrite and the object obj with wich to overwrite it
	//post: true if the object is overwriten else false

	virtual bool removeObject(unsigned int n) = 0;
	//removes the object wich has the value n in the part object order
	//pre: the value n, in the order of part objects, of object to remove
	//post: true if the object was removed else false

	virtual bool removeElement(unsigned int n) = 0;
	//removes the element wich has the value n in the order of move points
	//(the object the element contain goes to the position wher the 
	//element was)
	//pre: the value n in the order of move points of the element to remove
	//post: true if the element is removed else false

	virtual bool removeListVector(unsigned int n) = 0;
	//removes the vector in a list wich has the value n in the order of 
	//list vectors
	//pre: the value n in the order of list vectors of the vector to remove
	//post: true if the vector is removed else false

	virtual PicturObject* cutElement(unsigned int n,bool b=false) = 0;
	//cut the element wich has the value n in the order of move point
	//(delete the element on the position and return it)
	//if b is false test if the variable the object define is needed and
	//if that is true don't delete the object
	//pre: the value n in the order of move points of the element to cut
	//post: the cuted element

	virtual void deleteObject() = 0;
	//deletes the object(the element and all objects in it, uses the 
	//destructors)

	virtual bool flipObjects(unsigned int n) = 0;
	//flips the objects of the conc object with the value n in the order
	//of flip points(=conc objects) (oject1:=object2 and object2:=object1)
	//pre: the value n in the order of flip point of the conc object
	//  wich contained objects shold be fliped
	//post true if the objects are fliped else false

	virtual bool moveElement(unsigned int n, int howfar) = 0;
	//move the element with the value n in the order of move points
	//howfar steps(over howvar elements down if howfar is positiv else
	//over howfar steps up)
	//pre: the value n in the order of move point of the object to move
	//  and the distanc howfar to move it
	//post: true if the object is moved(even if just not howfar steps)
	//  else false

	virtual bool moveElementTo(unsigned int & n,PicturObject* obj,int& howfar) = 0;
	//moves the object obj that(should) stand an the position n in the 
	//order of move points howfar steps(over howvar elements down if 
	//howfar is positiv else over howfar steps up)
	//obj is needed for the algorithmus of moving
	//pre: the position n in the order ofmove points wher the object
	//  obj (should)stand, howfar to move it and a Picturobject pointer
	//  for the object
	//post: true if the object is moved (even if just not howfar steps)
	//  else false

	virtual bool insertObject(PicturObject* obj) = 0;
	//insert the object obj in this object
	//attention: the old (now overwriten) object don't be deleted
	//pre: the to insert object obj
	//post: true if the object is inserted else false

	virtual bool insertFunctionVector(unsigned int n,UnderFunction* fkt) = 0;
	//insert the UnderFunction vector fkt in the UnderFunction vector list 
	//of object with the value n in the order of Function objects
	//pre: the to insert UnderFunction vector fkt and the position in the
	//  order of Function objects to insert it
	//post: true if the UnderFunction is inserted else false

	virtual bool insertAreaVector(unsigned int n,UnderArea* area) = 0;
	//insert the UnderArea vector area in the UnderArea vector list
	//of object with the value n in the order of Area objects
	//pre: the to insert UnderArea vector area and the position in the
	//  order of Area objects to insert it
	//post: true if the UnderArea is inserted else false


//common Methodes:

	virtual PicturObject* copy() = 0;
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	virtual PicturObject* copy(unsigned int n) = 0;
	//copy the part object(means all, even the objects in it) wich has the value
	//n in the order of part objects
	//pre: the value n of the object to copy in the order of objects
	//post: a pointer to the copy of the object

	virtual PicturObject* copyElement(unsigned int n) = 0;
	//copy the element(not the objects in it) wich has the value
	//n in the order of objects
	//pre: the value n of the element to copy in the order of objects
	//post: a pointer to the copy of the element

	virtual void operator=(const GraphicObject* obj) = 0;
	//copy the given object obj(means all, even the objects in it)
	//pre: the object obj to copy
	//post: this object with the values of the given object obj

	virtual bool equalValue(const GraphicObject* obj) const = 0 ;
	//returns if this object and the given object obj are equal
	//(have the same values and objects)
	//pre: the other object obj to test
	//post: true if this and obj are equal	

	virtual std::string classnameOf() const = 0;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	virtual bool store(unsigned int& n,std::stringstream& stream) const =0;
	//store the object to the stream, with the syntax from the docu
	//pre: the number for the variables to cont from
	//post: the string for this object in the output stream

	virtual bool restore(std::stringstream& in,std::list<double*>& varl) = 0;
	//restore the object from the stream in, wich is ther given with the
	//syntax from the docu, varl is a list with the variables jet defined
	//!this object must be created and his syntax(e.g "fkt(" or "p(") deleted
	//from the stream
	//pre: the input stream to read from and the variablen list of variables
	//     jet defined(ever of this is set to his number (eg. to 3 if his 
	//     syntax is "x3"))
	//post: the object like in the stream

	PicturObject* restoreElementTyp(std::stringstream& in);
	//restore the element Typ from the stream in, wich is ther given with the
	//syntax from the docu, varl is a list with the variables jet defined
	//!this object must be created and his syntax(e.g "fkt(" or "p(") deleted
	//from the stream
	//pre: the input stream to read from
	//post: the object of the Type like in the stream(e.G. a blank Point object)

	virtual void makeMatrix(PicturMatrix *pm) const = 0;
	//make the PicturMatrix of this object
	//post: the PicturMatrix of this object

	virtual void makeMatrixOfObject(PicturMatrix *pm, unsigned int n) const = 0;
	//make the PicturMatrix of object wich has the value n in the order 
	//of part objects
	//pre: the value of the object, to make the PicturMatrix from, in the 
	//  order of part objects
	//post: the PicturMatrix of the object

	virtual void makeMatrixOfPoint(PicturMatrix *pm, unsigned int n) const = 0;
	//make the PicturMatrix of object wich has the value n in the order 
	//of point part objects
	//pre: the value of the object, to make the PicturMatrix from, in the 
	//  order of point part objects
	//post: the PicturMatrix of the object

	virtual bool hasUnderAllObjects() const = 0;
	//checks if this object contain for all his contained objects real 
	//objects(ther are no null pointer for a contained object) 
	//post: true if all contained objects are not null else false

};

#endif
