/*File Name: PicturMatrixV.h
  Author: Betti sterholz ; Date: 18.08.2003
  System: C++

*/

#ifndef ___PICTURMatrixV_h__
#define ___PICTURMatrixV_h__

#include <sstream>
#include <stdio.h>
#include <string>
#include <fstream>
#include "Color.h"


class PicturMatrix
{
protected:
Color***** Matrix;
unsigned long* Size;
unsigned int* Depth; //to know the Color typ used in the MatrixVV
unsigned int NumberOfColorComponents;
unsigned int NumberOfPositionComponents;
Color *Background;

public:

	PicturMatrix();
	//standart constructor constructs a blank object
	
	PicturMatrix(unsigned long* sz,unsigned int ncc,unsigned int* dep);
	//parameter constructor
	//constructs a Matrix sz great with everywher 0 pointer(no entry)
	//pre: the size sz the new Matrix should have
	//  the number of components of the color vectors and the depth of
	//  each of this components

	PicturMatrix(const PicturMatrix& matrx,bool copy=true);
	//copy constructor
	//if copy is true constructs a object with the same values as the given
	//else constructs a object with the same values but the Matrix values/Color pointers are all set to 0

	PicturMatrix(char* file);
	//load constructor
	//constructs a object with the values as the given fram a file

	~PicturMatrix();
	//destructor

	unsigned long* getSize() const;
	//returns the size of the Matrix
	//post: the unsigned long[4] array of the size

	inline unsigned int getNumberOfColorComponents() const
	//to get the number of color components in the Color vectors of the Matrix
	//post: the number of color components in the Color vectors of the Matrix
	{
	return 3;
	}

	inline unsigned int getNumberOfPositionComponents() const
	//to get the number of Position components in the Color vectors of the Matrix
	//post: the number of Position components in the Color vectors of the Matrix
	{
	return 2;
	}

	inline unsigned int getDepthOfComponent(unsigned int n) const
	//to get the depth of the n'th color components in the Color vectors 
	//of the Matrix(counting from 1)
	//post: the number of the n'th color components in the Color vectors
	//  of the Matrix
	{
	return 2;
	}
	
	inline Color* getBackgroundColor() const
	//to get the BackgroundColor of this Pictur Matrix
	{
	return Background;
	}

	inline Color* getColorFrom(unsigned long pos[4]) const
	//returns the color from position pos, the lowest position is [0,0,0,0]
	//pre: the unsigned int[4] array of the position to get the color
	//  pointer from
	//post: the pointer to the Color vector on position pos if exsists
	//  else the 0 pointer
	{
	return Background;
	}

	bool setColorOnPosition(unsigned long* pos,Color col);
	//insert on the position ps in the Matrix a copy of the given color
	//object col, the eventuell old Color object on this position is deleted
	//if no ReferenceColor is defined it set also the ReferenceColor to
	//the same type as the given Color object col
	//pre: the Color col to insert an the position pos to insert

	void overlap(PicturMatrix matrix);
	//if in the given Matrix is on a position a Color Object a copy
	//of this is insert on the same Position in the Matrix of this Object
	//if on this position is a 0 pointer and the position exsists(lower 
	//Size)
	//pre: the PicturMatrix Matrix to insert with this Pictur Matrix oferlapping

	bool load(char* file);
	//load a pictur Matrix from the file with name file
	//pre: the name of the file to load the PicturMatrix from

	bool store(char* file);
	//store this pictur Matrix to the file with name file
	//pre: the name of the file to load the PicturMatrix from

	unsigned long distanceTo(PicturMatrix matrix) const;
	//evaluate the distance from the given PicturMatrix Matrix
	//pre: the PicturMatrix to evaluate the distance from this PicturMatrix
	//post: a unsigned long number for the distance

	unsigned long distanceOfArea(PicturMatrix matrix, unsigned long* from, unsigned long* to) const;
	//evaluate the distance from the given PicturMatrixVV Matrix in the area
	//from to to(inclusiv to)
	//pre: the PicturMatrix to evaluate the distance from this PicturMatrix,
	//  the lower bound from and upper bound to of the area
	//post: a unsigned long number for the distance

	void resize(unsigned long* nsize);
	//resize the Matrix to the new size nsize
	//pre: the new size of of the object nsize
	
	void clear();
	//clears the matrix; deletes all Color Objects in it
	//post: a blank Matrix

	bool loadBitmap(char* file);
	//load a pictur Matrix from the bitmap pictur file with name file
	//pre: the name of the bitmap pictur file to load the PicturMatrix from
	
	bool saveBitmap(char* file) const;
	//store this pictur Matrix to the bitmap pictur file with name file
	//pre: the name of the bitmap pictur file to store this PicturMatrix to
	
	unsigned int readint(ifstream *stream,unsigned short byte) const;
	//reads a value with byte bytes from the stream and returns his integer value
	//pre: the ifstream stream to read from and the number of bytes byte to read
	//post: the readed value
	
	void PicturMatrix::writeint(ofstream *stream,unsigned short byte,int write) const;
	//writes the value of write with byte bytes to the stream stream
	//pre: the value write to write, how much byte byte write should use and the stream to write to
	//post: the value of write with byte bytes in the stream stream

	bool load_btx(char* file);
	//load a saved btx(own format)
	//post: the data of the btx file in this Matrix
	
	int charToInt(char c);
	//makes the char c to a integer number
	//pre: the char c
	//post: the integer number the char c represents(e.g. "1"=1)


};

#endif
