/*File Name: Color.h
  Author: Betti sterholz ; Date: 13.08.2003
  System: C++
  
  This is header of the Basisclass of all Vector objects

*/

#ifndef ___COLOR_h__
#define ___COLOR_h__

#include "Vector.h"




class Color:public Vector
{
private:

public:
	Color();
	//standart constructor
	//makes a blank object with 3 components with each depth of 256(RGB)

	Color(unsigned int noc);
	//parameter constructor
	//makes a color vector object with noc components all values set to 0
	//the depth of the color component i is given by the i'th component of
	//the unsigned int array dp wich has noc components(eg.: if dp[1]=10
	//the Component[1] con return values from 0 til 9)
	//pre: the number of components to produce and the depth of each component

	Color(const Color& col);
	//copy constructor
	//makes a color vector object with the same values as the given color
	//vector
	//pre: the color vector col to copied

	unsigned long getTimeNeed() const;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate

	virtual Color* copy();
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	virtual string classnameOf() const;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	Color* copyValue() const;
	//returns a Color vector with all Components as values set to the values 
	//that are actual in the values and variables of this Color vector rounded to int
	//post: a Color vector with all Components as values set to the values 
	//that are actual in the values and variables of this Color vector rounded to int

};

#endif
