/*File Name: Point.h
  Author: Betti sterholz ; Date: 18.08.2003
  System: C++
  
*/

#ifndef ___FUNCTION_h__
#define ___FUNCTION_h__

#include <sstream>
#include <string>
#include <list>
#include "ListObject.h"


class Function: public ListObject
{
protected:

public:
//constructors:
	Function();
	//standart constructor
	//constructs a blank Function object

	Function(PicturObject* uob,list<Vector*> vl);
	//special constructor
	//constructs a Function object with a new pointer for the defined variable
	//the given vector list vl for the VectorList and a UnderObject pointer 
	//pointed to the given pointer uob 


	Function(const Function& are);
	//copy constructor
	//constructs a copy of the given Function are object
	//attention: copy the objects from the given Function object 
	//pre: the Function object are to copy

	~Function();
	//destructor
	//attention: this destructor destruct just the element and not the 
	//objects in it

//Methodes to get greatnes of order:
	unsigned int getNumberOfFunctions() const;
	//evaluate the number of Function in this object
	//post: Numbers of Function in this object

	unsigned int getNumberOfArea() const;
	//evaluate the number of Area Objects in this object
	//post: Numbers of Function Objects in this object


//other get Functions:

	unsigned long getTimeNeed() const;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate


//Methodes wich changes the Object:

	bool insertFunctionVector(unsigned int n,UnderFunction* fkt);
	//insert the UnderFunction vector fkt in the UnderFunction vector list 
	//of object with the value n in the order of Function objects
	//pre: the to insert UnderFunction vector fkt and the position in the
	//  order of Function objects to insert it
	//post: true if the UnderFunction is inserted else false

	bool insertAreaVector(unsigned int n,UnderArea* area);
	//insert the UnderArea vector Area in the UnderArea vector list 
	//of object with the value n in the order of Area objects
	//pre: the to insert UnderArea vector area and the position in the
	//  order of Area objects to insert it
	//post: true if the UnderArea is inserted else false


//common Methodes:

	virtual Function* copy();
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	PicturObject* copyElement(unsigned int n);
	//copy the element(not the objects in it) wich has the value
	//n in the order of objects
	//pre: the value n of the element to copy in the order of objects
	//post: a pointer to the copy of the element

	void operator=(const GraphicObject* obj);
	//copy the given object obj(means all, even the objects in it)
	//pre: the object obj to copy
	//post: this object with the values of the given object obj

	bool equalValue(const GraphicObject* obj) const;
	//returns if this object and the given object obj are equal
	//(have the same values and objects)
	//pre: the other object obj to test
	//post: true if this and obj are equal	

	string classnameOf() const;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	bool store(unsigned int& n,std::stringstream& stream) const;
	//store the object to the stream, with the syntax from the docu
	//pre: the number for the variables to cont from
	//post: the string for this object in the output stream

	void makeMatrix(PicturMatrix *pm) const;
	//make the PicturMatrix of this object
	//post: the PicturMatrix of this object

	void makeMatrixOfObject(PicturMatrix *pm,unsigned int n) const;
	//make the PicturMatrix of object wich has the value n in the order 
	//of part objects
	//pre: the value of the object, to make the PicturMatrix from, in the 
	//  order of part objects
	//post: the PicturMatrix of the object


};

#endif
