/*

  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <iostream>
#include <sstream>
#include <string>
#include <list>


#include "CCheck.h"
#include "CDoubleOut.h"

#include "Conc.h"
#include "Function.h"
#include "Area.h"
#include "Point.h"

#include "Color.h"
#include "Position.h"
#include "UnderFunction.h"
#include "UnderArea.h"

void testConc()
{

CDoubleOut dout=CDoubleOut();
CCheck ch=CCheck();
//char yesno;

Position pos1;
ch.Check((string)"pos1.setValueToValue(1, 10) ",pos1.setValueToValue(1, 1),true);
ch.Check((string)"pos1.setValueToValue(2, 20) ",pos1.setValueToValue(2, 2),true);
ch.Check((string)"pos1.getNumberOfComponents() ",pos1.getNumberOfComponents(),2);
ch.Check((string)"pos1.getNumberOfValue() ",pos1.getNumberOfValue(),2);
ch.Check((string)"pos1.getNumberOfVariable() ",pos1.getNumberOfVariable(),0);

Color col2;
ch.Check((string)"col2.setValueToValue(1, 1) ",col2.setValueToValue(1, 1),true);
ch.Check((string)"col2.setValueToValue(2, 2) ",col2.setValueToValue(2, 2),true);
ch.Check((string)"col2.setValueToValue(3, 3) ",col2.setValueToValue(3, 3),true);
ch.Check((string)"col2.getNumberOfComponents() ",col2.getNumberOfComponents(),3);
ch.Check((string)"col2.getNumberOfValue() ",col2.getNumberOfValue(),3);
ch.Check((string)"col2.getNumberOfVariable() ",col2.getNumberOfVariable(),0);

//Object: p((1,2)(1,2,3))
dout.Print("Point *p1=Point(pos1,col2) \n");
Point *p1=new Point(pos1,col2);

ch.Check((string)"pos1.setValueToValue(1, 10) ",pos1.setValueToValue(1, 3),true);
ch.Check((string)"pos1.setValueToValue(2, 20) ",pos1.setValueToValue(2, 1),true);
ch.Check((string)"pos1.getNumberOfComponents() ",pos1.getNumberOfComponents(),2);
ch.Check((string)"pos1.getNumberOfValue() ",pos1.getNumberOfValue(),2);
ch.Check((string)"pos1.getNumberOfVariable() ",pos1.getNumberOfVariable(),0);

ch.Check((string)"col2.setValueToValue(1, 1) ",col2.setValueToValue(1, 5),true);
ch.Check((string)"col2.setValueToValue(2, 2) ",col2.setValueToValue(2, 3),true);
ch.Check((string)"col2.setValueToValue(3, 3) ",col2.setValueToValue(3, 4),true);
ch.Check((string)"col2.getNumberOfComponents() ",col2.getNumberOfComponents(),3);
ch.Check((string)"col2.getNumberOfValue() ",col2.getNumberOfValue(),3);
ch.Check((string)"col2.getNumberOfVariable() ",col2.getNumberOfVariable(),0);

//Object: p((3,1)(5,3,4))
dout.Print("Point *p2=Point(pos1,col2) \n");
Point *p2=new Point(pos1,col2);
dout.Print("\n\nConc conc1=Conc(p1,p2); \n");
Conc conc1=Conc(p1,p2);

ch.Check((string)"conc1.getNumberOfValue() ",conc1.getNumberOfValue(),10);
ch.Check((string)"conc1.getNumberOfVariable() ",conc1.getNumberOfVariable(),0);
ch.Check((string)"conc1.getNumberOfListVectors() ",conc1.getNumberOfListVectors(),0);
ch.Check((string)"conc1.getNumberOfMovePoints() ",conc1.getNumberOfMovePoints(),0);
ch.Check((string)"conc1.getNumberOfObjects() ",conc1.getNumberOfObjects(),3);
ch.Check((string)"conc1.getNumberOfConc() ",conc1.getNumberOfConc(),1);
ch.Check((string)"conc1.getNumberOfPoints() ",conc1.getNumberOfPoints(),2);
ch.Check((string)"conc1.getNumberOfObjectPoints() ",conc1.getNumberOfObjectPoints(),2);
ch.Check((string)"conc1.getGreatness() ",conc1.getGreatness(),13);

unsigned int i1=0;
stringstream *strstr=new stringstream;
dout.Print("\nconc1.store(i1,*strstr);\n");
conc1.store(i1,*strstr);
cout<<" conc1 : "<<strstr->str()<<endl<<flush;


//test restore

stringstream *strstr1=new stringstream;
dout.Print("\n(*strstr1)<<strstr->str();\n");
(*strstr1)<<strstr->str();
dout.Print("\nPicturObject *pob1=p1->restoreElementTyp(strstr);\n");
PicturObject *pob1=p1->restoreElementTyp(*strstr);

ch.Check((string)"pob1->classnameOf() ",pob1->classnameOf(),"Conc");


dout.Print("\nlist<double*> list;");
list<double*> list;
dout.Print("\npob1->restore((*strstr),list);\n");
pob1->restore((*strstr),list);

i1=0;
delete strstr;
strstr=new stringstream;
dout.Print("\npob1->store(i1,*strstr);\n");
pob1->store(i1,*strstr);
cout<<" pob1 : "<<strstr->str()<<endl<<flush;

ch.Check((string)"fkt1->getNumberOfValue() ",pob1->getNumberOfValue(),10);
ch.Check((string)"pob1->getNumberOfVariable() ",pob1->getNumberOfVariable(),0);




delete p1;
delete p2;

};
