/*

  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <iostream>
#include <sstream>
#include <string>
#include <list>


#include "CCheck.h"
#include "CDoubleOut.h"

#include "Conc.h"
#include "Function.h"
#include "Area.h"
#include "Point.h"

#include "Color.h"
#include "Position.h"
#include "UnderFunction.h"
#include "UnderArea.h"

void testFunction()
{

CDoubleOut dout=CDoubleOut();
CCheck ch=CCheck();
//char yesno;




Position pos1;
ch.Check((string)"pos1.setValueToValue(1, 10) ",pos1.setValueToValue(1, 10),true);
ch.Check((string)"pos1.setValueToValue(2, 20) ",pos1.setValueToValue(2, 20),true);
ch.Check((string)"pos1.getNumberOfComponents() ",pos1.getNumberOfComponents(),2);
ch.Check((string)"pos1.getNumberOfValue() ",pos1.getNumberOfValue(),2);
ch.Check((string)"pos1.getNumberOfVariable() ",pos1.getNumberOfVariable(),0);

Color col2;
ch.Check((string)"col2.setValueToValue(1, 1) ",col2.setValueToValue(1, 1),true);
ch.Check((string)"col2.setValueToValue(2, 2) ",col2.setValueToValue(2, 2),true);
ch.Check((string)"col2.setValueToValue(3, 3) ",col2.setValueToValue(3, 3),true);
ch.Check((string)"col2.getNumberOfComponents() ",col2.getNumberOfComponents(),3);
ch.Check((string)"col2.getNumberOfValue() ",col2.getNumberOfValue(),3);
ch.Check((string)"col2.getNumberOfVariable() ",col2.getNumberOfVariable(),0);

//Object: p((10,20)(1,2,3))
dout.Print("Point p1=Point(pos1,col2) \n");
Point p1=Point(pos1,col2);


//object: fkt(x1,{(3,2,1)},p((10,20)(1,2,3)) )
UnderFunction *ufkt1=new UnderFunction();
ch.Check((string)"ufkt1->setValueToValue(1, 1) ",ufkt1->setValueToValue(1, 3),true);
ch.Check((string)"ufkt1->setValueToValue(2, 2) ",ufkt1->setValueToValue(2, 2),true);
ch.Check((string)"ufkt1->setValueToValue(3, 3) ",ufkt1->setValueToValue(3, 1),true);
ch.Check((string)"ufkt1->getNumberOfComponents() ",ufkt1->getNumberOfComponents(),3);
ch.Check((string)"ufkt1->getNumberOfValue() ",ufkt1->getNumberOfValue(),3);
ch.Check((string)"ufkt1->getNumberOfVariable() ",ufkt1->getNumberOfVariable(),0);


list<Vector*>* vlist=new list<Vector*>;
vlist->insert(vlist->end(),ufkt1);

Function* fkt1=new Function(&p1,*vlist);

stringstream *strstr=new stringstream;
unsigned int i1=0;
fkt1->store(i1,*strstr);
cout<<" fkt1 : "<<strstr->str()<<endl<<flush;

dout.Print("delete vlist; \n");
delete vlist;

delete strstr;
strstr=new stringstream;
fkt1->store(i1,*strstr);
cout<<" fkt1 : "<<strstr->str()<<endl<<flush;

//object: fkt(x1,{(7,8,9)},fkt(x1,{(3,2,1)},p((10,20)(1,2,3)) ))
ufkt1=new UnderFunction();
ch.Check((string)"ufkt1->setValueToValue(1, 7) ",ufkt1->setValueToValue(1, 7),true);
ch.Check((string)"ufkt1->setValueToValue(2, 8) ",ufkt1->setValueToValue(2, 8),true);
ch.Check((string)"ufkt1->setValueToValue(3, 9) ",ufkt1->setValueToValue(3, 9),true);
ch.Check((string)"ufkt1->getNumberOfComponents() ",ufkt1->getNumberOfComponents(),3);
ch.Check((string)"ufkt1->getNumberOfValue() ",ufkt1->getNumberOfValue(),3);
ch.Check((string)"ufkt1->getNumberOfVariable() ",ufkt1->getNumberOfVariable(),0);


vlist=new list<Vector*>;
vlist->insert(vlist->end(),ufkt1);

fkt1=new Function(fkt1,*vlist);

delete strstr;
strstr=new stringstream;
fkt1->store(i1,*strstr);
cout<<" fkt1 : "<<strstr->str()<<endl<<flush;

dout.Print("\nfkt1->makeMatrix(matrix); \n");
PicturMatrix *matrix=new PicturMatrix();
fkt1->makeMatrix(matrix);

ch.Check((string)"fkt1->getNumberOfValue() ",fkt1->getNumberOfValue(),11);
ch.Check((string)"fkt1->getNumberOfVariable() ",fkt1->getNumberOfVariable(),0);
ch.Check((string)"fkt1->getNumberOfListVectors() ",fkt1->getNumberOfListVectors(),2);
ch.Check((string)"fkt1->getNumberOfMovePoints() ",fkt1->getNumberOfMovePoints(),2);
ch.Check((string)"fkt1->getNumberOfObjects() ",fkt1->getNumberOfObjects(),3);
ch.Check((string)"fkt1->getNumberOfConc() ",fkt1->getNumberOfConc(),0);
ch.Check((string)"fkt1->getNumberOfPoints() ",fkt1->getNumberOfPoints(),1);
ch.Check((string)"fkt1->getNumberOfObjectPoints() ",fkt1->getNumberOfObjectPoints(),0);
ch.Check((string)"fkt1->getValue(7) ",fkt1->getValue(7),2);
ch.Check((string)"fkt1->getVariable(2) ",(int)(fkt1->getVariable(2)),0);
ch.Check((string)"fkt1->getGreatness() ",fkt1->getGreatness(),14);
//ch.Check((string)"fkt1->getListVectorFrom(2) ",(*(fkt1->getListVectorFrom(2))).equalValue(ufkt1),true);




//to do:isUsedVariable(double* var);getObjectFrom(unsigned int n);getNext(bool b=true)
dout.Print("\ndouble* var1=fkt1->getDefinedVariableFrom(fkt1->getNumberOfMovePoints()); \n");
double* var1=fkt1->getDefinedVariableFrom(fkt1->getNumberOfMovePoints());//get the defined variable of the ne Function object
ch.Check((string)"fkt1->setValueToVariable(3,var1) ",fkt1->setValueToVariable(3,var1),true);
dout.Print("\nvar1=fkt1->getDefinedVariableFrom(2);//get the defined variable of the Function object \n");
var1=fkt1->getDefinedVariableFrom(2);//get the defined variable of the Function object
ch.Check((string)"fkt1->setValueToVariable(7,var1) ",fkt1->setValueToVariable(7,var1),true);
dout.Print("\nvar1=fkt1->getDefinedVariableFrom(1);//get the defined variable of the Function object \n");
var1=fkt1->getDefinedVariableFrom(1);//get the defined variable of the Function object
ch.Check((string)"fkt1->setValueToVariable(1,var1) ",fkt1->setValueToVariable(1,var1),true);

i1=0;
delete strstr;
strstr=new stringstream;
dout.Print("\nfkt1->store(i1,*strstr);\n");
fkt1->store(i1,*strstr);
cout<<" fkt1 : "<<strstr->str()<<endl<<flush;
dout.Print("\nFunction *fkt2=new Function(*fkt1);\n");
Function *fkt2=new Function(*fkt1);
dout.Print("\ndelete fkt1;\n");
delete fkt1;

i1=0;
delete strstr;
strstr=new stringstream;
dout.Print("\nfkt2->store(i1,*strstr);\n");
fkt2->store(i1,*strstr);
cout<<" fkt2 : "<<strstr->str()<<endl<<flush;
dout.Print("\ndelete fkt2;\n");
delete fkt2;


//test restore
stringstream *strstr1=new stringstream;
dout.Print("\n(*strstr1)<<strstr->str();\n");
(*strstr1)<<strstr->str();
dout.Print("\nPicturObject *pob1=p1.restoreElementTyp(strstr);\n");
PicturObject *pob1=p1.restoreElementTyp(*strstr);

ch.Check((string)"pob1->classnameOf() ",pob1->classnameOf(),"Function");


dout.Print("\nlist<double*> list;");
list<double*> list;
dout.Print("\npob1->restore((*strstr),list);\n");
pob1->restore((*strstr),list);

i1=0;
delete strstr;
strstr=new stringstream;
dout.Print("\npob1->store(i1,*strstr);\n");
pob1->store(i1,*strstr);
cout<<" pob1 : "<<strstr->str()<<endl<<flush;

ch.Check((string)"fkt1->getNumberOfValue() ",pob1->getNumberOfValue(),8);
ch.Check((string)"pob1->getNumberOfVariable() ",pob1->getNumberOfVariable(),3);
ch.Check((string)"pob1->getNumberOfListVectors() ",pob1->getNumberOfListVectors(),2);
ch.Check((string)"pob1->getNumberOfMovePoints() ",pob1->getNumberOfMovePoints(),2);
ch.Check((string)"pob1->getNumberOfObjects() ",pob1->getNumberOfObjects(),3);
ch.Check((string)"pob1->getNumberOfConc() ",pob1->getNumberOfConc(),0);
ch.Check((string)"pob1->getNumberOfPoints() ",pob1->getNumberOfPoints(),1);
ch.Check((string)"pob1->getNumberOfObjectPoints() ",pob1->getNumberOfObjectPoints(),0);
ch.Check((string)"pob1->getGreatness() ",pob1->getGreatness(),14);




};

