/*File Name: CCheck.cpp
  Author: Betti sterholz ; Date: 20.08.2002
  Mat. Nr.: 706585


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "CCheck.h"
#include "CDoubleOut.h"

CCheck::CCheck():YetChecked(0),Errors(0)
   //Constructs the objekt CCheck
   //pre:free Memory for the objekt
	//post:a CCheck objekt if enougth space was aviable
   {}

CCheck::~CCheck()
   //Destructs the objekt
   //no dynamic Memmory used in CCheck
	//prints the number of checkt values and the Errors ocured in them to dout
	//pre: this objekt
	//post:free memory and the number of checkt values and the Errors 
	//ocured in them in dout
   {
   CDoubleOut dout=CDoubleOut();//for doble output in Protocoll file and Monitor
   dout.Print("\n\n\n >>>> Checked values : ");
   dout.Printi((long)GetYetChecked());
   dout.Print("      Errors happend : ");
   dout.Printi((long)GetErrors());
   dout.Print("  <<<<\n\n");
   }

bool CCheck::Check(const string& out,const bool& is,const bool& should)
   //checks if the bool values are equal, give back true and write Ok if they are
   //give gack false and write No if they not equal
   //after the Output out
   //pre: string out, bool is and should
   //post: true if ther are equal, false else
   {
   CDoubleOut dout=CDoubleOut();//for doble output in Protocoll file and Monitor
   dout.Print(out+" is : "+ChangeBool(is)+" should be : "+ChangeBool(should));
   if(is==should){
      dout.Print(" | Ok\n");
      YetChecked++;
      return true;
   }else{
      dout.Print(" | No\n");
      YetChecked++;
      Errors++;
      return false;
   }
   }


bool CCheck::Check(const string& out,const int& is,const int& should)
   //checks if the int values are equal, give back true and write Ok if they are
   //give back false and write No if they not equal
   //after the Output out
   //pre: string out, int is and should
   //post: true if ther are equal, false else
   {
   CDoubleOut dout=CDoubleOut();//for doble output in Protocoll file and Monitor
   dout.Print(out+" is : ");
   dout.Printi(is);
   dout.Print(" should be : ");
   dout.Printi(should);
   if(is==should){
      dout.Print(" | Ok\n");
      YetChecked++;
      return true;
   }else{
      dout.Print(" | No\n");
      YetChecked++;
      Errors++;
      return false;
   }
   }

bool CCheck::Check(const string& out,const long& is,const long& should)
   //checks if the int values are equal, give back true and write Ok if they are
   //give back false and write No if they not equal
   //after the Output out
   //pre: string out, long is and should
   //post: true if ther are equal, false else
   {
   CDoubleOut dout=CDoubleOut();//for doble output in Protocoll file and Monitor
   dout.Print(out+" is : ");
   dout.Printi(is);
   dout.Print(" should be : ");
   dout.Printi(should);
   if(is==should){
      dout.Print(" | Ok\n");
      YetChecked++;
      return true;
   }else{
      dout.Print(" | No\n");
      YetChecked++;
      Errors++;
      return false;
   }
   }

bool CCheck::Check(const string& out,const double& is,const double& should)
   //checks if the double values are equal, give back true and write Ok if they are
   //give back false and write No if they not equal
   //after the Output out
   //pre: string out, double vlaue is and should
   //post: true if ther are equal, false else
   {
   CDoubleOut dout=CDoubleOut();//for doble output in Protocoll file and Monitor
   dout.Print(out+" is : ");
   dout.Printd(is);
   dout.Print(" should be : ");
   dout.Printd(should);
   if(is==should){
      dout.Print(" | Ok\n");
      YetChecked++;
      return true;
   }else{
      dout.Print(" | No\n");
      YetChecked++;
      Errors++;
      return false;
   }
   }

   bool CCheck::Check(const string& out,const string& is,const string& should)
   //checks if the string is and should values are equal, give back true write Ok if they are,
   //give back false and write No if they not equal
   //after the Output out
   //pre: string out, sring is and should
   //post: true if ther are equal, false else
   {
   CDoubleOut dout=CDoubleOut();//for doble output in Protocoll file and Monitor
   dout.Print(out+" is : "+is+" should be : "+should);
   if(is==should){
      dout.Print(" | Ok\n");
      YetChecked++;
      return true;
   }else{
      dout.Print(" | No\n");
      YetChecked++;
      Errors++;
      return false;
   }
   }

unsigned int CCheck::GetYetChecked() const
   //to get the Number of the Checked values
   //pre:this Objekt
	//post: int YetChecked
   {
   return YetChecked;
   }

unsigned int CCheck::GetErrors() const
   //to get the Numbers of the Errors happned in the test
   //pre:this Objekt
   //post: int Errors
   {
   return Errors;
   }

string CCheck::ChangeBool(const bool& bol) const
     //Changes the bool values of bol in words: 0="no", 1="yes"
     //makes the bool values redable
     //in this form(chang to string) it's easy to put it in a cout line
     //pre:bool bol
     //post: the string "yes" for bool 1 and "no" for bool 0
     {
       if (bol){
          return "yes";
       }else{
          return "no";
       }
     }






