/*File Name: ListObject.cpp
  Author: Betti sterholz ; Date: 31.08.2003
  System: C++

  This is implementation of the Basisclass of all ListObject objects


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ListObject.h"
#include "Conc.h"
//---------------------------------------------------------------------------



//constructors:
ListObject::ListObject():PicturObject(),UnderObject(0)
//standart constructor
//constructs a ListObject object with a new pointer for the defined variable
//a blank VectorList and a UnderObject pointer pointed to 0
{
VectorList=new std::list<Vector*>;
DefinedVariable=new double;
}

ListObject::ListObject(PicturObject* uob,std::list<Vector*> vl):PicturObject(),UnderObject(uob)//,VectorList(new list<Vector*>(vl))
//special constructor
//constructs a ListObject object with a new pointer for the defined variable
//the given vector list vl for the VectorList and a UnderObject pointer pointed to the given pointer uob
//pre: the UnderObject uob and the VectorList vl for the new ListObject
{
VectorList=new std::list<Vector*>;
(*VectorList)=vl;
DefinedVariable=new double;
}

ListObject::ListObject(const ListObject& lobj):PicturObject()//,UnderObject((lobj.getNext())->copy())
//copy constructor
//constructs a copy of the given ListObject object
//attention: copy the objects from the given ListObject object
//pre: the ListObject object poi to copy
{
UnderObject=((lobj.getNext())->copy());
double* tmpdef=lobj.getDefinedVariableFrom(lobj.getNumberOfMovePoints());//for setVariableToVariable(var1,var2)
DefinedVariable=new double;
Vector* tmpvec;
VectorList=new std::list<Vector*>;
std::list<Vector*>* tmpvl=lobj.getVectorList();
if (!tmpvl->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator itr=tmpvl->begin();itr!=tmpvl->end();itr++)
	{
		tmpvec=(*itr)->copy();
		VectorList->insert(VectorList->end(),tmpvec);
	}
}
UnderObject->setVariableToVariable(tmpdef,DefinedVariable);
}

ListObject::~ListObject()
//destructor
//attention: this destructor destruct just the element and not the
//objects(object are not Vectors) in it
{
if (!VectorList->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator itr=VectorList->begin();itr!=VectorList->end();itr++)
	{
		delete (*itr);
	}
}
delete VectorList;
delete DefinedVariable;
}

//Methodes to get greatnes of order:
unsigned int ListObject::getNumberOfValue() const
//evaluate the number of values in this object
//post: Numbers of values in this object
{
unsigned int nof=0;
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator itr=tmvl->begin();itr!=tmvl->end();itr++)
	{
		nof=nof+(*itr)->getNumberOfValue();
	}
}
return ((UnderObject->getNumberOfValue())+nof);
}

unsigned int ListObject::getNumberOfVariable() const
//evaluate the number of variables in this object
//post: Numbers of Variables in this object
{
unsigned int nov=0;
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator itr=tmvl->begin();itr!=tmvl->end();itr++)
	{
		nov=nov+(*itr)->getNumberOfVariable();
	}
}
return ((UnderObject->getNumberOfVariable())+nov);
}

unsigned int ListObject::getNumberOfListVectors() const
//evaluate the number of List Vectors in this object
//post: Numbers of List Vectors in this object
{return ((UnderObject->getNumberOfListVectors())+VectorList->size());}

unsigned int ListObject::getNumberOfMovePoints() const
//evaluate the number of Move Points in this object
//post: Numbers of Move Points in this object
{
if (UnderObject)
	{return ((UnderObject->getNumberOfMovePoints())+1);}
return 0;
}

unsigned int ListObject::getNumberOfObjects() const
//evaluate the number of Point in this object
//post: Numbers of Point in this object
{return ((UnderObject->getNumberOfObjects())+1);}

unsigned int ListObject::getNumberOfConc() const
//evaluate the number of Point Objects in this object
//post: Numbers of Point Objects in this object
{return (UnderObject->getNumberOfConc());}

unsigned int ListObject::getNumberOfPoints() const
//evaluate the number of PointObject in this object
//post: Numbers of PointObject in this object
{return getNumberOfConc()+1;}

unsigned int ListObject::getNumberOfObjectPoints() const
//evaluate the number of real part objects in this object,
//real part objects are part objects how has from a Point
//object downwarts all objects in the Point objects and
//upwarts just one
//post: Numbers of real part objects in this object
{return getNumberOfConc()*2;}


//other get Functions:

int ListObject::getValue(unsigned int n) const
//to get the value, of the value with number n in the order of values
//pre: the number n, in the order of values, of the value to return
//post: the value of the value
{
unsigned int x=UnderObject->getNumberOfValue();
if (x>=n)//the value is in the UnderObject
	{return (UnderObject->getValue(n));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator i=tmvl->begin();i!=tmvl->end();i++)
	{
		x=(*i)->getNumberOfValue();
		if (x<=n)//the value is not in the vector i
		{
			n=n-x;
		}else{//the value is in the vector
			return (*i)->getValue(n);//return it
		}
	}
}
return 0;//error: n to great
}

double* ListObject::getVariable(unsigned int n) const
//to get the pointer to the variable with number n in the order of variables
//pre: the number n, in the order of variables, of the variable to return
//post: the pointe for the variable
{
unsigned int x=UnderObject->getNumberOfVariable();
if (x>=n)//the variable is in the UnderObject
	{return (UnderObject->getVariable(n));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator i=tmvl->begin();i!=tmvl->end();i++)
	{
		x=(*i)->getNumberOfVariable();
		if (x<=n)//the variable is not in the vector i
		{
			n=n-x;
		}else{//the variable is in the vector
			return (*i)->getVariable(n);//return it
		}
	}
}
return 0;//error: n to great
}

unsigned long ListObject::getGreatness() const
//to get a idea how great the object is
//post: a number for how great the object is
{
unsigned long x=0;
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator i=tmvl->begin();i!=tmvl->end();i++)
	{
		x=x+(*i)->getGreatness();
	}
}
return ((UnderObject->getGreatness())+x+1);
}

bool ListObject::isUsedVariable(double* var) const
//checks if the given pointer for a variable var is somewhere in the
//object(than it is used in the object)
//pre: the pointer for the variable var to search for
//post: true if the variable is find(used), false else
{return ((UnderObject->isUsedVariable(var))||isUsedVariableInElement(var));}
	//return if the variable is needed in this object or the UnderObject

PicturObject* ListObject::getObjectFrom(unsigned int n) const
//to get the object wich has the value n in the order of objects
//pre: the value n in the order of objects of the object to get
//post: the object with the value n in the order of objects if exsits
//     or 0 if not
{
if ((UnderObject->getNumberOfObjects())==n) //if the Object n is the UnderObject
	{return UnderObject;}//return his pointer
return UnderObject->getObjectFrom(n);//else the object is in the UnderObject
}

Vector* ListObject::getListVectorFrom(unsigned int n) const
//to get the list vector wich has the value n in the order of list vectors
//pre: the value n in the order of list vectors of the list vector to get
//post: the list vector with the value n in the order of list vectors
//    if exsits or 0 if not
{
unsigned int x=UnderObject->getNumberOfListVectors();
if (x>=n)//the list vector is in the UnderObject
	{return (UnderObject->getListVectorFrom(n));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator i=tmvl->begin();i!=tmvl->end();i++)
	{
		if (1<n)//the list vector is not the vector i
		{
			n=n-1;
		}else{//the list vector is the vector
			Vector* vtmp=(*i);
			return vtmp;//return it
		}
	}
}
return 0;//error: n to great
}

PicturObject* ListObject::getNext(bool b) const
//to get the next object, means the object under the object from wich
//it is called, if the object from wich it is called is a Point object
//gets the first of his objects if b ist true else the second
//pre: a bool value if you want the first(true) or the second(false)
//   object, if ther are two
//post: the object with the value n in the order of objects if exsits
//     or 0 if not
{return UnderObject;}

unsigned int ListObject::partObjectToPointPartObject(unsigned int n) const
//to get the value in the point part object order of the object wich
//has the value n in the order of part objects
//pre: the value n in the order of part objects of the object
//post: the value n in the order of point part objects of the same object
//  or 0 if it is no point part object
{return UnderObject->partObjectToPointPartObject(n);}

unsigned int ListObject::pointPartObjectToPartObject(unsigned int n) const
//to get the value in the part object order of the object wich
//has the value n in the order of point part objects
//pre: the value n in the order of point part objects of the object
//post: the value n in the order of part objects of the same object
{return UnderObject->pointPartObjectToPartObject(n);}

unsigned int ListObject::movePointToObjectPoint(unsigned int n) const
//to get the value in the object order of the object wich
//has the value n in the order of move point objects
//pre: the value n in the order of move point objects of the object
//post: the value n in the order of objects of the same object
{
if (((UnderObject->getNumberOfMovePoints())+1)==n)
	{return ((UnderObject->getNumberOfObjects())+1);}
return UnderObject->movePointToObjectPoint(n);
}

bool ListObject::isDeletableElement() const
//checks if the Element(this) is deletable(Points and Point objects
//never are, Functions and Area objects are if the variable they define
//is not used)
//post: true if the element is deletable else false
{return !(UnderObject->isUsedVariable(DefinedVariable));}
	//if the defined variable is not needed in the UnderObejct

bool ListObject::isUsedVariableInElement(double* var) const
//checks if the variable var is used in the object if so returens
//true else false
//pre: the double pointer for the variable to check
//post: true if the variable is used else false
{
if (!VectorList->empty())//if the VectorList is not empty
{
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator i=tmvl->begin();i!=tmvl->end();i++)
	{
		if ((*i)->isUsedVariable(var)) {return true;}
	}
}
return false;
}

double* ListObject::getDefinedVariableFrom(unsigned int n) const
//to get the variable the object, with the value n in the order of
//move point, defined
//pre: the value n of a object in the order of move points
//post: the double pointer of the variable the same object defined
//  or 0 if no such variable/object
{
if (n==(getNumberOfMovePoints()))
	{return DefinedVariable;}
if (UnderObject)
	{return UnderObject->getDefinedVariableFrom(n);}
return 0;
}

std::list<double*> ListObject::getAllDefinedVariableOver(unsigned int n) const
//to get a list off all the Variables defined over the object, with
//the value n in the order of move points
//so you know wich varibles this object can use
//pre: the value of the object, in the order of move point, from
//  wich to get the list of variables defined in objects wich
//  are over it
//post: the list of double pointer of variables wich are defined over it
{
std::list<double*> ltmp;
if (n<(UnderObject->getNumberOfMovePoints()))
{//this is a object over the object from over wich to get all defined variables
	ltmp=UnderObject->getAllDefinedVariableOver(n);
	ltmp.insert(ltmp.end(),DefinedVariable);
}
return ltmp;//this is the object from over wich to get all defined variables
}

std::list<double*> ListObject::getAllDefinedVariableOverValue(unsigned int n) const
//to get a list off all the Variables defined over the value, with
//the value n in the order of values
//so you know wich varibles this value can be seted to
//pre: the value of the value, in the order of values, from
//  wich to get the list of variables defined in objects wich
//  are over it
//post: the list of double pointer of variables wich are defined over it
{
std::list<double*> ltmp;
if (n<(UnderObject->getNumberOfValue()))//the value is not under or in this object
{//this is a object over the value from over wich to get all defined variables
	ltmp=UnderObject->getAllDefinedVariableOverValue(n);
	ltmp.insert(ltmp.end(),DefinedVariable);
}
return ltmp;//this is the object from over wich to get all defined variables
}

std::list<double*> ListObject::getAllDefinedVariableOverVariable(unsigned int n) const
//to get a list off all the variables defined over the variable, with
//the value n in the order of variable
//so you know wich varibles this variable can be seted to
//pre: the value of the variable, in the order of variable, from
//  wich to get the list of variables defined in objects wich
//  are over it
//post: the list of double pointer of variables wich are defined over it
{
std::list<double*> ltmp;
if (n<(UnderObject->getNumberOfVariable()))//the variable is not under or in this object
{//this is a object over the value from over wich to get all defined variables
	ltmp=UnderObject->getAllDefinedVariableOverVariable(n);
	ltmp.insert(ltmp.end(),DefinedVariable);
}
return ltmp;//this is the object from over wich to get all defined variables
}


std::list<Vector*>* ListObject::getVectorList() const
//to get the color of this point
//post: the Color of this point
{return VectorList;}


//Methodes wich changes the Object:

bool ListObject::setValueToValue(unsigned int n, int val)
//set the value, of the value with number n in the order of values,
//to the given new value val
//pre: the number n, in the order of values, of the value to set and
//     the value val to set it to
//post: true if the value is set, false else
{
unsigned int x=UnderObject->getNumberOfValue();
if (x>=n)//the value is in the UnderObject
	{return (UnderObject->setValueToValue(n,val));}
n=n-x;//else it is in this Object
if (!(VectorList->empty()))//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=(*i)->getNumberOfValue();
		if (x<n)//the value is not in the vector i
		{
			n=n-x;
		}else{//the value is in the vector
			return (*i)->setValueToValue(n,val);//return it
		}
	}
}
return false;//error: n to great
}

bool ListObject::setValueToVariable(unsigned int n, double* var)
//set the value, of the value with number n in the order of values,
//to the given pointer for the variable var
//pre: the number n, in the order of values, of the value to set and
//     the pointer for the variable var to set it to
//post: true if the value is set, false else
{
unsigned int x=UnderObject->getNumberOfValue();
if (x>=n)//the value is in the UnderObject
	{return (UnderObject->setValueToVariable(n,var));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=(*i)->getNumberOfValue();
		if (x<n)//the value is not in the vector i
		{
			n=n-x;
		}else{//the value is in the vector
			return (*i)->setValueToVariable(n,var);
		}
	}
}
return false;//error: n to great
}

bool ListObject::setVariableToVariable(unsigned int n, double* var)
//set the variable, with number n in the order of variables,
//to the given pointer for the new variable var
//pre: the number n, in the order of variables, of the variable to set and
//     the pointer for the new variable var to set it to
//post: true if the varable is set, false else
{
unsigned int x=UnderObject->getNumberOfVariable();
if (x>=n)//the variable is in the UnderObject
	{return (UnderObject->setVariableToVariable(n,var));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=(*i)->getNumberOfVariable();
		if (x<n)//the variable is not in the vector i
		{
			n=n-x;
		}else{//the variable is in the vector
			return (*i)->setVariableToVariable(n,var);
		}
	}
}
return false;//error: n to great
}

unsigned int ListObject::setVariableToVariable(double* var1,double* var2)
//set on the positions wher the variable var1 in the object stand the
//variable var2
//pre: the variable var1 to set to the variable var2 and the variable var2
//post: the number of variables set
{
unsigned int x=UnderObject->setVariableToVariable(var1,var2);
if (!VectorList->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=x+((*i)->setVariableToVariable(var1,var2));
	}
}
return x;
}

bool ListObject::setVariableToValue(unsigned int n, int val)
//set the variable, with number n in the order of variables,
//to the given value val and make it a value
//pre: the number n, in the order of variables, of the variable to set and
//     the value val to set it to
//post: true if the varable is set, false else
{
unsigned int x=UnderObject->getNumberOfVariable();
if (x>=n)//the variable is in the UnderObject
	{return (UnderObject->setVariableToValue(n,val));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{	
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=(*i)->getNumberOfVariable();
		if (x<n)//the variable is not in the vector i
		{
			n=n-x;	
		}else{//the variable is in the vector
			return (*i)->setVariableToValue(n,val);
		}
	}
}
return false;//error: n to great
}

unsigned int ListObject::setVariableToValue(double* var1,int val)
//set on the positions wher the variable var1 in the object stand the
//value int val
//pre: the variable var1 to set to the value val and the value val
//post: the number of variables set
{
unsigned int x=UnderObject->setVariableToValue(var1,val);
if (!VectorList->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=x+((*i)->setVariableToValue(var1,val));
	}
}
return x;
}

bool ListObject::changeValueAbout(unsigned int n, int dist)
//set the value, of the value with number n in the order of values,
//to a new value, wich is evaluated from the old value plus the
//value dist
//pre: the number n, in the order of values, of the value to set and
//     the distance dist, to change it about
//post: true if the value is set, false else
{
unsigned int x=UnderObject->getNumberOfValue();
if (x>=n)//the value is in the UnderObject
	{return (UnderObject->changeValueAbout(n,dist));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{	
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=(*i)->getNumberOfValue();
		if (x<n)//the value is not in the vector i
		{
			n=n-x;	
		}else{//the value is in the vector
			return (*i)->changeValueAbout(n,dist);
		}
	}
}
return false;//error: n to great
}

bool ListObject::insertObjectInObject(unsigned int n, PicturObject* obj,bool ov)
//insert the object obj in the object with the value n in the order
//of objects,
//if ov are true obj is inserted as the first object in the new Point
//object(obj can be overlapped) else as the secound(not overlapped)
//pre: the position in the object order to insert it(should not be
//  a point), the pointer to the object to insert(the pointer is inserted)
//  and the bool value if it can be overlapped
//post: true if the object obj was inserted
{
if (n==(UnderObject->getNumberOfObjects()))//if this is the Object to insert
{
	if (ov) {UnderObject= new Conc(UnderObject,obj);}
	else {UnderObject= new Conc(obj,UnderObject);}
	return true;
}
return UnderObject->insertObjectInObject(n,obj,ov);
}


bool ListObject::overwriteObjectWithObject(unsigned int n, PicturObject* obj)
//overwrite the object, wich has the value n in the order of objects,
//with the given object obj
//attention: the overwriten object will not be deleted
//pre: the position n in the order of objects of the object to
//   overwrite and the object obj with wich to overwrite it
//post: true if the object is overwriten else false
{
if (n==(UnderObject->getNumberOfObjects()))//if UnderObject is the Object to overwrite
{
	UnderObject=obj;
	return true;
}
return UnderObject->overwriteObjectWithObject(n,obj);
}

bool ListObject::removeObject(unsigned int n)
//removes the object wich has the value n in the part object order
//pre: the value n, in the order of part objects, of object to remove
//post: true if the object was removed else false
{
if (UnderObject->removeObject(n))//if a object in a conc object is deleted
{
	if (UnderObject->hasUnderAllObjects())//if the object under this has all objects, it is not the object wher a object was deleted
		{return true;}
	else{//if the UnderObject was the conc object wher a object was deleted
		unsigned int x=UnderObject->getNumberOfObjects();
		PicturObject* tobj=UnderObject->getObjectFrom(x-1);//get the object under it, that was not deleted
		delete UnderObject;//delete the conc object
		UnderObject=tobj;//set the not deleted object as the nes UnderObject
		return true;
	}
}
return false;
}

bool ListObject::removeElement(unsigned int n)
//removes the element wich has the value n in the order of move points
//(the object the element contain goes to the position wher the
//element was)
//pre: the value n in the order of move points of the element to remove
//post: true if the element is removed else false
{
PicturObject* tobj= cutElement(n);
if (tobj)
{
	delete tobj;
	return true;
}
return false;
}

bool ListObject::removeListVector(unsigned int n)
//removes the vector in a list wich has the value n in the order of
//list vectors
//pre: the value n in the order of list vectors of the vector to remove
//post: true if the vector is removed else false
{
unsigned int x=UnderObject->getNumberOfListVectors();
if (x>=n)//the ListVector is in the UnderObject
	{return (UnderObject->removeListVector(n));}
n=n-x;//else it is in this Object
if (!VectorList->empty())//if the VectorList is not empty
{
	for (std::list<Vector*>::iterator i=VectorList->begin();i!=VectorList->end();i++)
	{
		x=x-1;
		if (x==0)//the ListVector is the vector i
		{
			Vector* tmpv=(*i);
			delete tmpv;//delete the vector
			VectorList->erase(i);//delete the pointer from the list
			return true;
		}
	}
}
return false;//error: n to great
}

PicturObject* ListObject::cutElement(unsigned int n,bool b)
//cut the element wich has the value n in the order of move point
//(delete the element on the position and return it)
//if b is false test if the variable the object define is needed and
//if that is true don't delete the object
//pre: the value n in the order of move points of the element to cut
//post: the cuted element
{
unsigned int x = UnderObject->getNumberOfMovePoints();
if (n>x){return 0;}//if ther is no object with the value n in the move point order
if (n==x)
{
	if ((UnderObject->classnameOf())!="Conc")//if no conc is betwean this and the to cut object
	{
		if (b||(UnderObject->isDeletableElement()))
		{
			PicturObject* tmp=UnderObject;
			UnderObject=UnderObject->getNext();
			return tmp;
		}else{return 0;}
	}//else the next element is a conc object
}
return UnderObject->cutElement(n);
}

void ListObject::deleteObject()
//deletes the object(all objects in it, uses the
//destructors)
{
UnderObject->deleteObject();//delete UnderObject
delete UnderObject;
UnderObject=0;
}

bool ListObject::flipObjects(unsigned int n)
//flips the objects of the Point object with the value n in the order
//of flip points(=Point objects) (oject1:=object2 and object2:=object1)
//pre: the value n in the order of flip point of the Point object
//  wich contained objects shold be fliped
//post true if the objects are fliped else false
{return UnderObject->flipObjects(n);}

bool ListObject::moveElement(unsigned int n, int howfar)
//move the element with the value n in the order of move points
//howfar steps(over howvar elements down if howfar is positiv else
//over howfar steps up)
//pre: the value n in the order of move point of the object to move
//  and the distanc howfar to move it
//post: true if the object is moved(even if just not howfar steps)
//  else false
{return moveElementTo(n,0,howfar);}

bool ListObject::moveElementTo(unsigned int & n,PicturObject* obj,int& howfar)
//moves the object obj that(should) stand an the position n in the
//order of move points howfar steps(over howvar elements down if
//howfar is positiv else over howfar steps up)
//obj is needed for the algorithmus of moving
//pre: the position n in the order ofmove points wher the object
//  obj (should)stand, howfar to move it and a Point pointer
//  for the object
//post: true if the object is moved (even if just not howfar steps)
//  else false
{
if (n==0) {return false;}//no object to move
if (howfar==0)
{
	if (obj==0) {return true;}//nothing to do
	obj->insertObject(UnderObject);//aktuell in the to move object
	UnderObject=obj;//to move object as actual
	return true;
}//end howfar==0
if (howfar>0)//move obj down
{
	unsigned int mp = UnderObject->getNumberOfMovePoints();
	if (mp==n)//the UnderObject is the element to move?
	{
		unsigned int o=UnderObject->movePointToObjectPoint(n);
		if ((UnderObject->classnameOf())!="Conc")//the UnderObject is the element to move= no conc object
		{
			//test if moving is posible
			PicturObject* obj2=UnderObject->getObjectFrom(o-1);//get the object over the to moving
			double* var=UnderObject->getDefinedVariableFrom(n);
			if (obj2->isUsedVariableInElement(var))//can not move
			{return true;}
			else{
				PicturObject* obj1=UnderObject;
				UnderObject=obj2;
				howfar=howfar-1;
				if (UnderObject->moveElementTo(n,obj1,howfar))//object is moved
					{return true;}
				else{
					howfar=0;
					return moveElementTo(n,obj1,howfar);
				}
			}
		}else
		{return UnderObject->moveElementTo(n,obj,howfar);}
	}
	if (mp>n)//the to move object is in the UnderObject
		{return UnderObject->moveElementTo(n,obj,howfar);}
	//else the to move object is to move further down (mp<n n is
	//over this object)
	if (obj==0) return true;//nothing to do should not happen
	double* dvar=obj->getDefinedVariableFrom(n);
	if (UnderObject->isUsedVariableInElement(dvar))//can not move
		{howfar=0;
		return moveElementTo(n,obj,howfar);}//insert here
	else{
		howfar=howfar-1;
		if (UnderObject->moveElementTo(n,obj,howfar))//object is moved
			{return true;}
		else{
			howfar=0;
			return moveElementTo(n,obj,howfar);//insert here when not moved
		}
	}
}//end howfar>0
if (howfar<0)//move obj up
{
	unsigned int x=UnderObject->getNumberOfMovePoints();
	if (x>=n)//to move object is in the UnderObject
	{
		if (x==n)//to move object is the first object in the UnderObject(if conc object)
		{
			if ((UnderObject->classnameOf())!="Conc")//to move object is the UnderObject=not a conc object
			{
				return true;
			}else{//to move object is the last object in the UnderObject(if conc obje
				PicturObject* objv=cutElement(n,true);
				if (objv)
				{
					objv->insertObject(UnderObject);
					UnderObject=objv;//flip them
					n=UnderObject->getNumberOfMovePoints();//aktualisize n
					return true;
				}else{return false;}
			}
		}
		if (x>n)//to move object is in the UnderObject, but not it
		{
			bool ok=UnderObject->moveElementTo(n,obj,howfar);
			if (!ok)//doesn't move
				{return false;}
			if (howfar>0) {return true;}//the to move object is at the rigth plase
			unsigned int o=UnderObject->movePointToObjectPoint(n);//n could change
			unsigned int y=UnderObject->getNumberOfObjects();//could change
			if ((o+1)==y)//the to move object is two steps down
			{
				//test if moving is posible
				PicturObject* obj=UnderObject->getObjectFrom(o);
				double* var=UnderObject->getDefinedVariableFrom(UnderObject->getNumberOfMovePoints());
				if (obj->isUsedVariableInElement(var))//can not move
				{
					howfar=1;
					return true;
				}
				else{//move to move object in secound object
					PicturObject* obv=cutElement(n,true);
					if (obv)
					{
						obv->insertObject(UnderObject);
						UnderObject=obv;//flip them
						if (howfar==-1)//has moved one step upwarts that it should
							{howfar=1;}//move more then one step upwarts
						else{howfar=howfar+1;}
						n=(UnderObject->getNumberOfMovePoints());
						//new position n
						return true;
					}else{return false;}
				}
			}else{//last a conc object move the to move object
				PicturObject* objv=cutElement(n,true);
				if (objv)
				{
					objv->insertObject(UnderObject);
					UnderObject=objv;
					n=UnderObject->getNumberOfMovePoints();
					return true;
				}else{return false;}
			}
		}
	}
return false;
}//end howfar>0
if ((howfar>=0)&&(obj!=0)) {delete obj;}
return false;
}

bool ListObject::insertObject(PicturObject* obj)
//insert the object obj in this object
//attention: the old (now overwriten) object don't be deleted
//pre: the to insert object obj
//post: true if the object is inserted else false
{
UnderObject=obj;
return true;
}

bool ListObject::insertVector(Vector* vec)
//insert the vector vec in the vector list of this object
//pre: the to insert vector vec
//post: true if the vector vec is inserted else false
{
VectorList->insert(VectorList->end(),vec);
return true;
}


//common Methodes:

PicturObject* ListObject::copy(unsigned int n)
//copy the part object(means all, even the objects in it) wich has the value
//n in the order of part objects
//pre: the value n of the object to copy in the order of objects
//post: a pointer to the copy of the object
{
if ((UnderObject->getNumberOfObjectPoints())>n)
{
	//copy UnderObject of this object
	PicturObject *tuob=(UnderObject->copy(n));
	if (tuob)
	{
		//copy this element
		ListObject* lobj=(ListObject*)copyElement(getNumberOfObjects());
		//change variable in the UnderObject to the defined variable of the new object
		double *tvar=lobj->getDefinedVariableFrom(0);
		tuob->setVariableToVariable(DefinedVariable,tvar);
		lobj->insertObject(tuob);
		return lobj;
	}else{
		return 0;
	}

}
return this->copy();
}

bool ListObject::store(unsigned int& n,std::stringstream& stream) const
//store the object to the stream, with the syntax from the docu
//pre: the number for the variables to cont from
//post: the string for this object in the output stream
{
n=n+1;
(*DefinedVariable)=n;
stream<<"x"<<n<<",";
if (!VectorList->empty())//if the VectorList is not empty
{
	stream<<"{";
	std::list<Vector*>* tmvl=const_cast<std::list<Vector*>* >(VectorList);
	for (std::list<Vector*>::iterator i=tmvl->begin();i!=tmvl->end();i++)
	{
		if (i!=tmvl->begin()) {stream<<",";}
		(*i)->store(n,stream);
	}
	stream<<"},";
}else{stream<<"_,";}
UnderObject->store(n,stream);
stream<<")";
return true;
}

bool ListObject::restore(std::stringstream& in,std::list<double*>& varl)
//restore the object from the stream in, wich is ther given with the
//syntax from the docu, varl is a list with the variables jet defined
//!this object must be created and his syntax(e.g "fkt(" or "p(") deleted
//from the stream
//pre: the input stream to read from and the variablen list of variables
//     jet defined(ever of this is set to his number (eg. to 3 if his 
//     syntax is "x3"))
//post: the object like in the stream
{
char c;
bool b=true;//true if the restoring is working
Vector* tmpvec;
//next is the x.. for the defined Variable
in>>c;//"x"
long l=0;
in>>c;//" " or "}"
while (!(c==','))//read value
{
	l=l*10+charToInt(c);
	in>>c;
}
(*DefinedVariable)=l;
varl.insert(varl.end(),DefinedVariable);
in>>c;//"{" or "_"
//read the vectors
bool fkt=((this->classnameOf())=="Function");
if (c!='_')
while (!(c=='}'))//one vector must be inside
{
	if (fkt){tmpvec=new UnderFunction();}
		else {tmpvec=new UnderArea();}
	b=b&&(tmpvec->restore(in,varl));
	VectorList->insert(VectorList->end(),tmpvec);
	in>>c;//read "," or "}"
}
in>>c;//read ","
UnderObject=restoreElementTyp(in);
b=b&&(!(UnderObject==0));
if ((UnderObject->classnameOf()=="Function")||(UnderObject->classnameOf()=="Area")
	||(UnderObject->classnameOf()=="Conc")||(UnderObject->classnameOf()=="Point"))
	{b=b&&UnderObject->restore(in,varl);}
in>>c;//')'
return b;
}

void ListObject::makeMatrixOfPoint(PicturMatrix *pm, unsigned int n) const
//make the PicturMatrix of object wich has the value n in the order 
//of point part objects
//pre: the value of the object, to make the PicturMatrix from, in the 
//  order of point part objects
//post: the PicturMatrix of the object
{
makeMatrixOfObject(pm, pointPartObjectToPartObject(n));
}

bool ListObject::hasUnderAllObjects() const
//checks if this object contain for all his contained objects real 
//objects(ther are no null pointer for a contained object) 
//post: true if all contained objects are not null else false
{
if (UnderObject) {return true;}
return false;
}
