/*File Name: Conc.h
  Author: Betti sterholz ; Date: 18.08.2003
  System: C++
  
*/

#ifndef ___CONC_h__
#define ___CONC_h__

#include <sstream>
#include <string>
#include <list>
#include "PicturObject.h"


class Conc : public PicturObject
{
protected:
PicturObject* Object1;
PicturObject* Object2;

public:
//constructors:
	Conc();
	//standart constructor
	//constructs a conc object with two PicturObject poiter pointed to 0

	Conc(PicturObject* obj1,PicturObject* obj2=0);
	//special constructor
	//constructs a conc object with two PicturObject poiter pointed to
	//the given objects(if just one given the secound pointer pointed to 0)
	//attention: the given objects will not be copied
	//pre: the two PicturObject pointers of the Picturobjects to insert

	Conc(const Conc& conc);
	//copy constructor
	//constructs a copy of the given Conc object
	//attention: copy the objects from the given conc object with ther
	//  copy constructor
	//pre: the Conc object conc to copy

	~Conc();
	//destructor
	//attention: this destructor destruct just the element and not the 
	//objects in it

//Methodes to get greatnes of order:
	unsigned int getNumberOfValue() const;
	//evaluate the number of values in this object
	//post: Numbers of values in this object

	unsigned int getNumberOfVariable() const;
	//evaluate the number of variables in this object
	//post: Numbers of Variables in this object

	unsigned int getNumberOfListVectors() const;
	//evaluate the number of List Vectors in this object
	//post: Numbers of List Vectors in this object

	unsigned int getNumberOfMovePoints() const;
	//evaluate the number of Move Points in this object
	//post: Numbers of Move Points in this object

	unsigned int getNumberOfObjects() const;
	//evaluate the number of Conc in this object
	//post: Numbers of Conc in this object

	unsigned int getNumberOfConc() const;
	//evaluate the number of conc Objects in this object
	//post: Numbers of conc Objects in this object

	unsigned int getNumberOfPoints() const;
	//evaluate the number of PointObject in this object
	//post: Numbers of PointObject in this object

	unsigned int getNumberOfObjectPoints() const;
	//evaluate the number of real part objects in this object,
	//real part objects are part objects how has from a conc 
	//object downwarts all objects in the conc objects and
	//upwarts just one
	//post: Numbers of real part objects in this object

	unsigned int getNumberOfFunctions() const;
	//evaluate the number of Function in this object
	//post: Numbers of Function in this object

	unsigned int getNumberOfArea() const;
	//evaluate the number of area Objects in this object
	//post: Numbers of area Objects in this object


//other get Functions:

	int getValue(unsigned int n) const;
	//to get the value, of the value with number n in the order of values
	//pre: the number n, in the order of values, of the value to return
	//post: the value of the value

	double* getVariable(unsigned int n) const;
	//to get the pointer to the variable with number n in the order of variables
	//pre: the number n, in the order of variables, of the variable to return
	//post: the pointe for the variable

	unsigned long getGreatness() const;
	//to get a idea how great the object is
	//post: a number for how great the object is

	unsigned long getTimeNeed() const;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate

	bool isUsedVariable(double* var) const  ;
	//checks if the given pointer for a variable var is somewhere in the 
	//object(than it is used in the object)
	//pre: the pointer for the variable var to search for
	//post: true if the variable is find(used), false else

	PicturObject* getObjectFrom(unsigned int n) const;
	//to get the object wich has the value n in the order of objects
	//pre: the value n in the order of objects of the object to get
	//post: the object with the value n in the order of objects if exsits
	//     or 0 if not

	Vector* getListVectorFrom(unsigned int n) const;
	//to get the list vector wich has the value n in the order of list vectors
	//pre: the value n in the order of list vectors of the list vector to get
	//post: the list vector with the value n in the order of list vectors 
	//    if exsits or 0 if not

	PicturObject* getNext(bool b=true) const;
	//to get the next object, means the object under the object from wich
	//it is called, if the object from wich it is called is a conc object
	//gets the first of his objects if b ist true else the second
	//pre: a bool value if you want the first(true) or the second(false)
	//   object, if ther are two
	//post: the object with the value n in the order of objects if exsits
	//     or 0 if not

	unsigned int partObjectToPointPartObject(unsigned int n) const;
	//to get the value in the point part object order of the object wich 
	//has the value n in the order of part objects
	//pre: the value n in the order of part objects of the object
	//post: the value n in the order of point part objects of the same object

	unsigned int pointPartObjectToPartObject(unsigned int n) const;
	//to get the value in the part object order of the object wich 
	//has the value n in the order of point part objects
	//pre: the value n in the order of point part objects of the object
	//post: the value n in the order of part objects of the same object

	unsigned int movePointToObjectPoint(unsigned int n) const;
	//to get the value in the object order of the object wich 
	//has the value n in the order of move point objects
	//pre: the value n in the order of move point objects of the object
	//post: the value n in the order of objects of the same object

	bool isDeletableElement() const ;
	//checks if the Element(this) is deletable(Points and conc objects 
	//never are, Functions and Area objects are if the variable they define
	//is not used)
	//post: true if the element is deletable else false

	bool isUsedVariableInElement(double* var) const;
	//checks if the variable var is used in the object if so returens
	//true else false
	//pre: the double pointer for the variable to check
	//post: true if the variable is used else false

	double* getDefinedVariableFrom(unsigned int n) const;
	//to get the variable the object, with the value n in the order of
	//move point, defined
	//pre: the value n of a object in the order of move points
	//post: the double pointer of the variable the same object defined
	//  or 0 if no such variable/object
	
	list<double*> getAllDefinedVariableOver(unsigned int n) const;
	//to get a list off all the Variables defined over the object, with 
	//the value n in the order of move points
	//so you know wich varibles this object can use
	//pre: the value of the object, in the order of move point, from
	//  wich to get the list of variables defined in objects wich
	//  are over it
	//post: the list of double pointer of variables wich are defined over it
	
	list<double*> getAllDefinedVariableOverValue(unsigned int n) const;
	//to get a list off all the Variables defined over the value, with
	//the value n in the order of values
	//so you know wich varibles this value can be seted to
	//pre: the value of the value, in the order of values, from
	//  wich to get the list of variables defined in objects wich
	//  are over it
	//post: the list of double pointer of variables wich are defined over it

	list<double*> getAllDefinedVariableOverVariable(unsigned int n) const;
	//to get a list off all the variables defined over the variable, with
	//the value n in the order of variable
	//so you know wich varibles this variable can be seted to
	//pre: the value of the variable, in the order of variable, from
	//  wich to get the list of variables defined in objects wich
	//  are over it
	//post: the list of double pointer of variables wich are defined over it


//Methodes wich changes the Object:

	bool setValueToValue(unsigned int n, int val);
	//set the value, of the value with number n in the order of values,
	//to the given new value val
	//pre: the number n, in the order of values, of the value to set and
	//     the value val to set it to
	//post: true if the value is set, false else

	bool setValueToVariable(unsigned int n, double* var);
	//set the value, of the value with number n in the order of values,
	//to the given pointer for the variable var
	//pre: the number n, in the order of values, of the value to set and
	//     the pointer for the variable var to set it to
	//post: true if the value is set, false else

	bool setVariableToVariable(unsigned int n, double* var);
	//set the variable, with number n in the order of variables,
	//to the given pointer for the new variable var
	//pre: the number n, in the order of variables, of the variable to set and
	//     the pointer for the new variable var to set it to
	//post: true if the varable is set, false else

	unsigned int setVariableToVariable(double* var1,double* var2);
	//set on the positions wher the variable var1 in the object stand the
	//variable var2
	//pre: the variable var1 to set to the variable var2 and the variable var2
	//post: the number of variables set

	bool setVariableToValue(unsigned int n, int val);
	//set the variable, with number n in the order of variables,
	//to the given value val and make it a value
	//pre: the number n, in the order of variables, of the variable to set and
	//     the value val to set it to
	//post: true if the varable is set, false else

	bool changeValueAbout(unsigned int n, int dist);
	//set the value, of the value with number n in the order of values,
	//to a new value, wich is evaluated from the old value plus the
	//value dist
	//pre: the number n, in the order of values, of the value to set and
	//     the distance dist, to change it about
	//post: true if the value is set, false else

	bool insertObjectInObject(unsigned int n, PicturObject* obj,bool ov);
	//insert the object obj in the object with the value n in the order
	//of objects, 
	//if ov are true obj is inserted as the first object in the new conc 
	//object(obj can be overlapped) else as the secound(not overlapped)
	//pre: the position in the object order to insert it(should not be 
	//  a point), the pointer to the object to insert(the pointer is inserted)
	//  and the bool value if it can be overlapped
	//post: true if the object obj was inserted

	bool overwriteObjectWithObject(unsigned int n, PicturObject* obj);
	//overwrite the object, wich has the value n in the order of objects,
	//with the given object obj
	//attention: the overwriten object will not be deleted
	//pre: the position n in the order of objects of the object to 
	//   overwrite and the object obj with wich to overwrite it
	//post: true if the object is overwriten else false

	bool removeObject(unsigned int n);
	//removes the object wich has the value n in the part object order
	//pre: the value n, in the order of part objects, of object to remove
	//post: true if the object was removed else false

	bool removeElement(unsigned int n);
	//removes the element wich has the value n in the order of move points
	//(the object the element contain goes to the position wher the 
	//element was)
	//pre: the value n in the order of move points of the element to remove
	//post: true if the element is removed else false

	bool removeListVector(unsigned int n);
	//removes the vector in a list wich has the value n in the order of 
	//list vectors
	//pre: the value n in the order of list vectors of the vector to remove
	//post: true if the vector is removed else false

	PicturObject* cutElement(unsigned int n);
	//cut the element wich has the value n in the order of move point
	//(delete the element on the position and return it)
	//pre: the value n in the order of move points of the element to cut
	//post: the cuted element

	void deleteObject();
	//deletes the object(the element and all objects in it, uses the 
	//destructors)

	bool flipObjects(unsigned int n);
	//flips the objects of the conc object with the value n in the order
	//of flip points(=conc objects) (oject1:=object2 and object2:=object1)
	//pre: the value n in the order of flip point of the conc object
	//  wich contained objects shold be fliped
	//post true if the objects are fliped else false

	bool moveElement(unsigned int n, int howfar);
	//move the element with the value n in the order of move points
	//howfar steps(over howvar elements down if howfar is positiv else
	//over howfar steps up)
	//pre: the value n in the order of move point of the object to move
	//  and the distanc howfar to move it
	//post: true if the object is moved(even if just not howfar steps)
	//  else false

	bool insertObject(PicturObject* obj);
	//insert the object obj in this object
	//attention: the old (now overwriten) object don't be deleted
	//pre: the to insert object obj
	//post: true if the object is inserted else false

	bool insertFunctionVector(unsigned int n,UnderFunction* fkt);
	//insert the UnderFunction vector fkt in the UnderFunction vector list 
	//of object with the value n in the order of Function objects
	//pre: the to insert UnderFunction vector fkt and the position in the
	//  order of Function objects to insert it
	//post: true if the UnderFunction is inserted else false

	bool insertAreaVector(unsigned int n,UnderArea* area);
	//insert the UnderArea vector area in the UnderArea vector list 
	//of object with the value n in the order of Area objects
	//pre: the to insert UnderArea vector area and the position in the
	//  order of Area objects to insert it
	//post: true if the UnderArea is inserted else false


//common Methodes:

	virtual Conc* copy();
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	PicturObject* copy(unsigned int n);
	//copy the part object(means all, even the objects in it) wich has the value
	//n in the order of part objects
	//pre: the value n of the object to copy in the order of objects
	//post: a pointer to the copy of the object

	PicturObject* copyElement(unsigned int n);
	//copy the element(not the objects in it) wich has the value
	//n in the order of objects
	//pre: the value n of the element to copy in the order of objects
	//post: a pointer to the copy of the element

	void operator=(const GraphicObject* obj);
	//copy the given object obj(means all, even the objects in it)
	//pre: the object obj to copy
	//post: this object with the values of the given object obj

	bool equalValue(const GraphicObject* obj) const;
	//returns if this object and the given object obj are equal
	//(have the same values and objects)
	//pre: the other object obj to test
	//post: true if this and obj are equal	

	string classnameOf() const;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	bool store(unsigned int& n,std::stringstream& stream) const;
	//store the object to the stream, with the syntax from the docu
	//pre: the number for the variables to cont from
	//post: the string for this object in the output stream

	bool restore(std::stringstream& in,list<double*>& varl);
	//restore the object from the stream in, wich is ther given with the
	//syntax from the docu, varl is a list with the variables jet defined
	//!this object must be created and his syntax(e.g "fkt(" or "p(") deleted
	//from the stream
	//pre: the input stream to read from and the variablen list of variables
	//     jet defined(ever of this is set to his number (eg. to 3 if his 
	//     syntax is "x3"))
	//post: the object like in the stream

	void makeMatrix(PicturMatrix *pm) const;
	//make the PicturMatrix of this object
	//post: the PicturMatrix of this object

	void makeMatrixOfObject(PicturMatrix *pm,unsigned int n) const;
	//make the PicturMatrix of object wich has the value n in the order 
	//of part objects
	//pre: the value of the object, to make the PicturMatrix from, in the 
	//  order of part objects
	//post: the PicturMatrix of the object

	void makeMatrixOfPoint(PicturMatrix *pm,unsigned int n) const;
	//make the PicturMatrix of object wich has the value n in the order 
	//of point part objects
	//pre: the value of the object, to make the PicturMatrix from, in the 
	//  order of point part objects
	//post: the PicturMatrix of the object

private:

	bool hasUnderAllObjects() const;
	//checks if this object contain for all his contained objects real 
	//objects(ther are no null pointer for a contained object) 
	//post: true if all contained objects are not null else false

	bool moveElementTo(unsigned int & n,PicturObject* obj,int& howfar);
	//moves the object obj that(should) stand an the position n in the 
	//order of move points howfar steps(over howvar elements down if 
	//howfar is positiv else over howfar steps up)
	//obj is needed for the algorithmus of moving
	//pre: the position n in the order ofmove points wher the object
	//  obj (should)stand, howfar to move it and a Conc pointer
	//  for the object
	//post: true if the object is moved (even if just not howfar steps)
	//  else false

};

#endif
