/*File Name: Vector.h
  Author: Betti sterholz ; Date: 03.08.2003
  System: C++
  
  This is header of the Basisclass of all Vector objects

*/

#ifndef ___VECTOR_h__
#define ___VECTOR_h__

#include "GraphicObject.h"




class Vector:public GraphicObject
{
protected:
	typedef struct {
      double* Value;
      bool IsValue;
   }TComponent;

	unsigned int NumberOfComponents;
	TComponent* Component;

	Vector(const Vector& vec);
	//copy constructor
	//makes a vector object with the same values as the given vector
	//pre: the vector to copy

	Vector(unsigned int noc);
	//parameter constructor
	//makes a vector object with noc components all values set to 0
	//pre: the number of components to produce

public:

	Vector();
	//standart constructor
	//makes a blank object

	virtual ~Vector();
	//destructor
	//deletes the components

	inline unsigned int getNumberOfComponents() const
	//evaluate the number of values in this object
	//post: Numbers of values in this object
	{return NumberOfComponents;}

	inline unsigned int getNumberOfValue() const
	//evaluate the number of values in this object
	//post: Numbers of values in this object
	{
	int nov=0;
	for (unsigned int i=0;i<NumberOfComponents;i++)
	{
		if (Component[i].IsValue) nov++;
	}
	return nov;
	}

	inline unsigned int getNumberOfVariable() const
	//evaluate the number of variables in this object
	//post: Numbers of Variables in this object
	{
	int nov=0;
	for (unsigned int i=0;i<NumberOfComponents;i++)
	{
		if (!Component[i].IsValue) nov++;
	}
	return nov;
	}

	inline double* getComponentPointer(unsigned int n) const
	//to get the value pointer, of the n'th component
	//pre: the number n of the component
	//post: the pointer of the value or 0 if not exsists
	{
	if ((n>0)&&(n<=NumberOfComponents)) return (Component[n-1].Value);
	return 0;
	}

	inline bool setComponentPointer(unsigned int n, double* ptr)
	//to set the value pointer, of the n'th component
	//pre: the number n of the component
	//post: true if the value pointer is set, false else
	{
	if ((n>0)&&(n<=NumberOfComponents))
	{
		if (Component[n-1].IsValue) {delete Component[n-1].Value;}
		Component[n-1].Value=ptr;
		return true;
	}
	return false;
	}

	inline bool isComponentValue(unsigned int n) const
	//to get if the n'th component is a value
	//pre: the number n of the component
	//post: true if is a value, false else
	{
	if ((n>0)&&(n<=NumberOfComponents)) {return (Component[n-1].IsValue);}
	return false;
	}

	inline bool setIsComponentValue(unsigned int n,bool val) const
	//to set get if the n'th component is a value
	//pre: the number n of the component and if the component should be a value
	//post: true if set, false else
	{
	if ((n>0)&&(n<=NumberOfComponents))
	{ 
		Component[n-1].IsValue=val;
		return true;
	}
	return false;
	}


	int getValue(unsigned int n) const;
	//to get the value, of the value with number n in the order of values
	//pre: the number n, in the order of values, of the value to return
	//post: the value of the value or 0 if not exsists


	double* getVariable(unsigned int n) const;
	//to get the pointer to the variable with number n in the order of variables
	//pre: the number n, in the order of variables, of the variable to return
	//post: the pointe for the variable or 0 if not exsists

	unsigned long getGreatness() const;
	//to get a idea how great the object is
	//post: a number for how great the object is, her number of components
	
	virtual unsigned long getTimeNeed() const = 0;
	//to get a idea how long the object need to evaluate
	//post: a number for how much time the object need to evaluate

	bool setValueToValue(unsigned int n, int val);
	//set the value, of the value with number n in the order of values,
	//to the given new value val
	//pre: the number n, in the order of values, of the value to set and
	//     the value val to set it to
	//post: true if the value is set, false else

	bool setValueToVariable(unsigned int n, double* var);
	//set the value, of the value with number n in the order of values,
	//to the given pointer for the variable var
	//pre: the number n, in the order of values, of the value to set and
	//     the pointer for the variable var to set it to
	//post: true if the value is set, false else

	bool setVariableToVariable(unsigned int n, double* var);
	//set the variable, with number n in the order of variables,
	//to the given pointer for the new variable var
	//pre: the number n, in the order of variables, of the variable to set and
	//     the pointer for the new variable var to set it to
	//post: true if the varable is set, false else

	unsigned int setVariableToVariable(double* var1,double* var2);
	//set on the positions wher the variable var1 in the object stand the
	//variable var2
	//pre: the variable var1 to set to the variable var2 and the variable var2
	//post: the number of variables set

	bool setVariableToValue(unsigned int n, int val);
	//set the variable, with number n in the order of variables,
	//to the given value val and make it a value
	//pre: the number n, in the order of variables, of the variable to set and
	//     the value val to set it to
	//post: true if the varable is set, false else

	bool changeValueAbout(unsigned int n, int dist);
	//set the value, of the value with number n in the order of values,
	//to a new value, wich is evaluated from the old value plus the
	//value dist
	//pre: the number n, in the order of values, of the value to set and
	//     the distance dist, to change it about
	//post: true if the value is set, false else

	bool isUsedVariable(double* var) const;
	//checks if the given pointer for a variable var is somewhere in the
	//object(than it is used in the object)
	//pre: the pointer for the variable var to search for
	//post: true if the variable is find(used), false else

	virtual Vector* copy() = 0;
	//copy this object
	//post: a pointer to the copy of this object

	virtual void operator=(const GraphicObject* obj);
	//copy the given object obj
	//pre: the object obj to copy
	//post: this object with the values of the given object obj

	bool equalValue(const GraphicObject* obj) const;
	//returns if this object and the given object obj are equal
	//(have the same values and objects)
	//pre: the other object obj to test
	//post: true if this and obj are equal

	virtual string classnameOf() const=0;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	bool store(unsigned int& n,std::stringstream& stream) const;
	//store the object to the stream, with the syntax from the docu
	//pre: the number for the variables to cont from
	//post: the string for this object in the output stream

	bool restore(std::stringstream& in,list<double*>& varl);
	//restore the object from the stream in, wich is ther given with the
	//syntax from the docu, varl is a list with the variables jet defined
	//!this object must be created and his syntax(e.g "fkt(" or "p(") deleted
	//from the stream
	//pre: the input stream to read from and the variablen list of variables
	//     jet defined(ever of this is set to his number (eg. to 3 if his
	//     syntax is "x3"))
	//post: the object like in the stream

};

#endif
