/*

  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <sstream>
#include <string>
#include <list>


#include "CCheck.h"
#include "CDoubleOut.h"

#include "Conc.h"
#include "Function.h"
#include "Area.h"
#include "Point.h"

#include "Color.h"
#include "Position.h"
#include "UnderFunction.h"
#include "UnderArea.h"

#include "PicturMatrix.h"

void testPicturMatrix()
{
CDoubleOut dout=CDoubleOut();
CCheck ch=CCheck();


PicturMatrix picm1=PicturMatrix("farbe8_8.bmp");
/*
unsigned long* sze=picm1.getSize();
unsigned long pos[4]={0,0,0,0};
Color *col=0;
cout<<endl<<endl;
for (pos[0]=0;pos[0]<sze[0];pos[0]++ )
{
	for (pos[1]=0;pos[1]<sze[1];pos[1]++ )
	{
		cout<<"color "<<pos[0]<<","<<pos[1]<<"  B;G;R ";
		col=picm1.getColorFrom(pos);
		cout<<(col->getValue(1)) <<";"<<(col->getValue(2))<<";"<<(col->getValue(3))<<endl;
	}
}

picm1.store("test1.bmp");
*/


PicturMatrix picm2=PicturMatrix(picm1,false);

dout.Print("Position pos1; \n");
Position pos1;
ch.Check((string)"pos1.setValueToValue(1, 2) ",pos1.setValueToValue(1, 2),true);
ch.Check((string)"pos1.setValueToValue(2, 2) ",pos1.setValueToValue(2, 2),true);
dout.Print("Color col2; \n");
Color col2;
ch.Check((string)"col2.setValueToValue(1, 100) ",col2.setValueToValue(1, 100),true);
ch.Check((string)"col2.setValueToValue(2, 150) ",col2.setValueToValue(2, 150),true);
ch.Check((string)"col2.setValueToValue(3, 200) ",col2.setValueToValue(3, 200),true);
//Object p((2,2)(100,150,200))
dout.Print("Point p1=Point(col2,pos1) \n");
Point p1=Point(pos1,col2);

p1.makeMatrix(&picm2);

/*unsigned long* sze=picm2.getSize();
unsigned long pos[4]={0,0,0,0};
Color *col=0;
cout<<endl<<endl;
for (pos[0]=0;pos[0]<sze[0];pos[0]++ )
{
	for (pos[1]=0;pos[1]<sze[1];pos[1]++ )
	{
		cout<<"color "<<pos[0]<<","<<pos[1]<<"  B;G;R ";
		col=picm2.getColorFrom(pos);
		cout<<(col->getValue(1)) <<";"<<(col->getValue(2))<<";"<<(col->getValue(3))<<endl;
	}
}
*/
//picm2.store("test2.bmp");

dout.Print("Position pos2; \n");
Position pos2;
ch.Check((string)"pos2.setValueToValue(1, 10) ",pos2.setValueToValue(1, 3),true);
ch.Check((string)"pos2.setValueToValue(2, 20) ",pos2.setValueToValue(2, 3),true);
dout.Print("Color col3; \n");
Color col3;
ch.Check((string)"col3.setValueToValue(1, 255) ",col3.setValueToValue(1, 255),true);
ch.Check((string)"col3.setValueToValue(2, 255) ",col3.setValueToValue(2, 255),true);
ch.Check((string)"col3.setValueToValue(3, 255) ",col3.setValueToValue(3, 255),true);
//Object p((3,3)(255,255,255))
dout.Print("Point p2=Point(col3,pos2) \n");
Point p2=Point(pos2,col3);

Conc con1=Conc(&p1,&p2);

PicturMatrix picm3=PicturMatrix(picm1,false);
con1.makeMatrix(&picm3);

//picm3.store("test3.bmp");


dout.Print("Position pos3; \n");
Position pos3;
ch.Check((string)"pos3.setValueToValue(1, 4) ",pos3.setValueToValue(1, 4),true);
dout.Print("Color col4; \n");
Color col4;
ch.Check((string)"col4.setValueToValue(1, 255) ",col4.setValueToValue(1, 255),true);
ch.Check((string)"col4.setValueToValue(2, 0) ",col4.setValueToValue(2, 0),true);
ch.Check((string)"col4.setValueToValue(3, 255) ",col4.setValueToValue(3, 255),true);
//Object p((4,0)(255,0,255))
dout.Print("Point p3=Point(col4,pos3) \n");
Point p3=Point(pos3,col4);

//generate UnderArea list
UnderArea *area=new UnderArea();
area->setValueToValue(1,1);
area->setValueToValue(2,6);
list<Vector*> vl;
vl.insert(vl.begin(),area);
//generate Area object
Area are1=Area(&p3,vl);
//insert the defined variable of the new Area object

double* var1=are1.getDefinedVariableFrom(are1.getNumberOfMovePoints());//get the defined variable of the ne Area object
Position *pos4=p3.getPosition();
ch.Check((string)"pos3.setValueToVariable(2, var1) ",pos4->setValueToVariable(2, var1),true);


PicturMatrix picm4=PicturMatrix(picm1,false);
are1.makeMatrix(&picm4);

/*
unsigned long* sze=picm4.getSize();
unsigned long pos[4]={0,0,0,0};
Color *col=0;
cout<<endl<<endl;
for (pos[0]=0;pos[0]<sze[0];pos[0]++ )
{
	for (pos[1]=0;pos[1]<sze[1];pos[1]++ )
	{
		cout<<"color "<<pos[0]<<","<<pos[1]<<"  B;G;R ";
		col=picm4.getColorFrom(pos);
		cout<<(col->getValue(1)) <<";"<<(col->getValue(2))<<";"<<(col->getValue(3))<<endl;
	}
}
*/

//picm4.store("test4.bmp");

//generate UnderFunction list
UnderFunction *ufkt=new UnderFunction();
ufkt->setValueToValue(2,2);
ufkt->setValueToValue(3,(-1));
ufkt->setValueToVariable(1,var1);
list<Vector*> vl1;
vl1.insert(vl1.begin(),ufkt);
//generate Area object
Function fkt1=Function(&p3,vl1);
//insert the defined variable of the new Area object
are1.overwriteObjectWithObject(1,&fkt1);

var1=fkt1.getDefinedVariableFrom(fkt1.getNumberOfMovePoints());//get the defined variable of the ne Area object

ch.Check((string)"pos3.setValueToVariable(2, var1) ",pos4->setValueToVariable(1, var1),true);
stringstream strstr;
unsigned int i1=0;
are1.store(i1,strstr);
cout<<strstr.str()<<endl;

picm4.clear();
are1.makeMatrix(&picm4);
picm4.store("test5.bmp");


//test btx


PicturMatrix picm5=PicturMatrix("sw_blocks.btx");

unsigned long* sze=picm5.getSize();
unsigned long pos[4]={0,0,0,0};
Color *col=0;
cout<<endl<<endl;
for (pos[0]=0;pos[0]<sze[0];pos[0]++ )
{
	for (pos[1]=0;pos[1]<sze[1];pos[1]++ )
	{
		cout<<"color "<<pos[0]<<","<<pos[1]<<"  s/w ";
		col=picm5.getColorFrom(pos);
		cout<<(col->getValue(1))<<endl;
	}
}

dout.Print("\n\n\nloading sw pictur \n");


PicturMatrix picm6=PicturMatrix("/home/biokom/bel/bilder/sw8_8.bmp");
dout.Print("\npicm6.store(\"sw_test.btx\");\n");
picm6.store("sw_test.btx");
picm6.store("sw_test.bmp");

PicturMatrix picm7=PicturMatrix("/home/biokom/bel/bilder/sw_H_16_16.bmp");
dout.Print("\npicm7.store(\"sw_test1.btx\");\n");
picm7.store("sw_test1.btx");
picm7.store("sw_test1.bmp");

PicturMatrix picm8=PicturMatrix("/home/biokom/bel/bilder/Ray-bwk.bmp");
dout.Print("\npicm8.store(\"sw_test1.btx\");\n");
picm8.store("sw_test2.btx");
picm8.store("sw_test2.bmp");


//test bmp 16 colors

dout.Print("\nPicturMatrix picm9=PicturMatrix(\"/home/biokom/bel/bilder/farbe16_16_blocks.bmp\");\n");
PicturMatrix picm9=PicturMatrix("/home/biokom/bel/bilder/farbe16_16_blocks.bmp");

unsigned long* sze1=picm9.getSize();
unsigned long posi[4]={0,0,0,0};
Color *cole1=0;
cout<<endl<<endl;
for (posi[0]=0;posi[0]<sze1[0];posi[0]++ )
{
	for (posi[1]=0;posi[1]<sze1[1];posi[1]++ )
	{
		cole1=picm9.getColorFrom(posi);
		cout<<(cole1->getValue(1))<<" ";
	}
	cout<<endl;
}

dout.Print("\nPicturMatrix picm10=PicturMatrix(\"/home/biokom/bel/bilder/farbe16_16_13_blocks.bmp\");\n");
PicturMatrix picm10=PicturMatrix("/home/biokom/bel/bilder/farbe16_16_13_blocks.bmp");

unsigned long* sze2=picm10.getSize();
unsigned long posi1[4]={0,0,0,0};
Color *cole2=0;
cout<<endl<<endl;
for (posi1[0]=0;posi1[0]<sze2[0];posi1[0]++ )
{
	for (posi1[1]=0;posi1[1]<sze2[1];posi1[1]++ )
	{
		cole2=picm10.getColorFrom(posi1);
		cout<<(cole2->getValue(1))<<" ";
	}
	cout<<endl;
}














};
