/*

  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <sstream>
#include <string>
#include <list>


#include "CCheck.h"
#include "CDoubleOut.h"

#include "Conc.h"
#include "Function.h"
#include "Area.h"
#include "Point.h"

#include "Color.h"
#include "Position.h"
#include "UnderFunction.h"
#include "UnderArea.h"

void testPoint()
{

CDoubleOut dout=CDoubleOut();
CCheck ch=CCheck();
//char yesno;




Position pos1;

ch.Check((string)"pos1.setValueToValue(1, 10) ",pos1.setValueToValue(1, 10),true);
ch.Check((string)"pos1.setValueToValue(2, 20) ",pos1.setValueToValue(2, 20),true);
ch.Check((string)"pos1.getNumberOfComponents() ",pos1.getNumberOfComponents(),2);
ch.Check((string)"pos1.getNumberOfValue() ",pos1.getNumberOfValue(),2);
ch.Check((string)"pos1.getNumberOfVariable() ",pos1.getNumberOfVariable(),0);
ch.Check((string)"(*pos1.getComponentPointer(1)) ",(*pos1.getComponentPointer(1)),10.0);
ch.Check((string)"(*pos1.getComponentPointer(2)) ",(*pos1.getComponentPointer(2)),20.0);
ch.Check((string)"pos1.isComponentValue(1) ",pos1.isComponentValue(1),true);
ch.Check((string)"pos1.isComponentValue(2) ",pos1.isComponentValue(2),true);


Color col2;
ch.Check((string)"col2.setValueToValue(1, 1) ",col2.setValueToValue(1, 1),true);
ch.Check((string)"col2.setValueToValue(2, 2) ",col2.setValueToValue(2, 2),true);
ch.Check((string)"col2.setValueToValue(3, 3) ",col2.setValueToValue(3, 3),true);
ch.Check((string)"col2.getNumberOfComponents() ",col2.getNumberOfComponents(),3);
ch.Check((string)"col2.getNumberOfValue() ",col2.getNumberOfValue(),3);
ch.Check((string)"col2.getNumberOfVariable() ",col2.getNumberOfVariable(),0);
ch.Check((string)"(*col2.getComponentPointer(1)) ",(*col2.getComponentPointer(1)),1.0);
ch.Check((string)"(*col2.getComponentPointer(2)) ",(*col2.getComponentPointer(2)),2.0);
ch.Check((string)"(*col2.getComponentPointer(3)) ",(*col2.getComponentPointer(3)),3.0);
ch.Check((string)"col2.isComponentValue(1) ",col2.isComponentValue(1),true);
ch.Check((string)"col2.isComponentValue(2) ",col2.isComponentValue(2),true);
ch.Check((string)"col2.isComponentValue(3) ",col2.isComponentValue(3),true);


//Object p((10,20)(1,2,3))
dout.Print("Point p1=Point(pos1,col2) \n");
Point p1=Point(pos1,col2);

dout.Print("p1.store(0,ostrstr) \n");
unsigned int i1=0;
stringstream ostrstr2;
p1.store(i1,ostrstr2);
cout<<ostrstr2.str();//rdbuf() str()
dout.Print("\nIs this the right string for the Point? (Y/N) ");
//cin>>yesno;
//dout.Printb((yesno=='y')||(yesno=='Y'));

dout.Print("\nPoint p2=Point(p1) \n");
Point p2=Point(p1);
ch.Check((string)"\np1.equalValue(&p2) ",p1.equalValue(&p2),true);


ch.Check((string)"p1.getNumberOfValue() ",p1.getNumberOfValue(),5);
ch.Check((string)"p1.getNumberOfVariable() ",p1.getNumberOfVariable(),0);
ch.Check((string)"p1.getNumberOfListVectors() ",p1.getNumberOfListVectors(),0);
ch.Check((string)"p1.getNumberOfMovePoints() ",p1.getNumberOfMovePoints(),0);
ch.Check((string)"p1.getNumberOfObjects() ",p1.getNumberOfObjects(),1);
ch.Check((string)"p1.getNumberOfConc() ",p1.getNumberOfConc(),0);
ch.Check((string)"p1.getNumberOfPoints() ",p1.getNumberOfPoints(),1);
ch.Check((string)"p1.getNumberOfObjectPoints() ",p1.getNumberOfObjectPoints(),0);
ch.Check((string)"p1.getNumberOfFunctions() ",p1.getNumberOfFunctions(),0);
ch.Check((string)"p1.getNumberOfArea() ",p1.getNumberOfArea(),0);
ch.Check((string)"p1.getValue(1) ",p1.getValue(1),10);
ch.Check((string)"p1.getValue(2) ",p1.getValue(2),20);
ch.Check((string)"p1.getValue(3) ",p1.getValue(3),1);
ch.Check((string)"p1.getValue(4) ",p1.getValue(4),2);
ch.Check((string)"p1.getValue(5) ",p1.getValue(5),3);
ch.Check((string)"p1.classnameOf() ",p1.classnameOf(),"Point");
ch.Check((string)"p1.getGreatness() ",p1.getGreatness(),6);
ch.Check((string)"p1.getTimeNeed() ",p1.getTimeNeed(100000),6);
ch.Check((string)"p1.getObjectFrom(2) ",(int)(p1.getObjectFrom(2)),0);
ch.Check((string)"p1.getListVectorFrom(5) ",(int)(p1.getListVectorFrom(5)),0);
ch.Check((string)"p1.getNext() ",p1.getNext(),0);
ch.Check((string)"p1.partObjectToPointPartObject(0) ",p1.partObjectToPointPartObject(0),1);
ch.Check((string)"p1.pointPartObjectToPartObject(2) ",p1.pointPartObjectToPartObject(2),0);
ch.Check((string)"p1.pointPartObjectToPartObject(7) ",p1.pointPartObjectToPartObject(7),5);
ch.Check((string)"p1.movePointToObjectPoint(3) ",p1.movePointToObjectPoint(3),0);
ch.Check((string)"p1.isDeletableElement() ",p1.isDeletableElement(),false);
ch.Check((string)"p1.getDefinedVariableFrom(4) ",p1.getDefinedVariableFrom(4),0);


//to do:getColor();getPosition()

//test restore
dout.Print("\nstringstream strstr1; \n");
stringstream strstr1;
dout.Print("\nstrstr1<<ostrstr2.str() \n");
strstr1<<(ostrstr2.str());
dout.Print("\nlist<double*> list1;\n");
list<double*> list1;
dout.Print("\nPicturObject* p3; \n");
PicturObject* p3;
dout.Print("\np3=p1.restoreElementTyp(strstr1); \n");
p3=p1.restoreElementTyp(strstr1);
ch.Check((string)"p3->classnameOf() ",p3->classnameOf(),"Point");
dout.Print("\np3->restore(strstr1,list1); \n");
p3->restore(strstr1,list1);
ch.Check((string)"\np1.equalValue(p3) ",p1.equalValue(p3),true);

ch.Check((string)"p3->getValue(1) ",p3->getValue(1),10);
ch.Check((string)"p3->getValue(2) ",p3->getValue(2),20);
ch.Check((string)"p3->getValue(3) ",p3->getValue(3),1);
ch.Check((string)"p3->getValue(4) ",p3->getValue(4),2);
ch.Check((string)"p3->getValue(5) ",p3->getValue(5),3);

stringstream strstr3;
p3->store(i1,strstr3);
cout<<strstr3.str();

//to do:isUsedVariable();getObjectFrom();isUsedVariableInElement(m);getAllDefinedVariableOver(n)
//getAllDefinedVariableOverValue(n);getAllDefinedVariableOverVariable(n);...

};
