/*File Name: GraphicObject.h
  Author: Betti sterholz ; Date: 03.08.2003
  System: C++
  
  This is the Basisclass of PicturObject and Vector
  most functions are pure virtual


  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___GRAPHICOBJECT_h__
#define ___GRAPHICOBJECT_h__

#include <sstream>
#include <string>
#include <list>


class GraphicObject
{
public:

	virtual unsigned int getNumberOfValue() const = 0;
	//evaluate the number of values in this object
	//post: Numbers of values in this object

	virtual unsigned int getNumberOfVariable() const = 0;
	//evaluate the number of variables in this object
	//post: Numbers of Variables in this object

	virtual int getValue(unsigned int n) const = 0;
	//to get the value, of the value with number n in the order of values
	//pre: the number n, in the order of values, of the value to return
	//post: the value of the value

	virtual double* getVariable(unsigned int n)const = 0;
	//to get the pointer to the variable with number n in the order of variables
	//pre: the number n, in the order of variables, of the variable to return
	//post: the pointe for the variable

	virtual unsigned long getGreatness()const = 0;
	//to get a idea how great the object is
	//post: a number for how great the object is

	virtual bool setValueToValue(unsigned int n, int val) = 0;
	//set the value, of the value with number n in the order of values,
	//to the given new value val
	//pre: the number n, in the order of values, of the value to set and
	//     the value val to set it to
	//post: true if the value is set, false else

	virtual bool setValueToVariable(unsigned int n, double* var) = 0;
	//set the value, of the value with number n in the order of values,
	//to the given pointer for the variable var
	//pre: the number n, in the order of values, of the value to set and
	//     the pointer for the variable var to set it to
	//post: true if the value is set, false else

	virtual bool setVariableToVariable(unsigned int n, double* var) = 0;
	//set the variable, with number n in the order of variables,
	//to the given pointer for the new variable var
	//pre: the number n, in the order of variables, of the variable to set and
	//     the pointer for the new variable var to set it to
	//post: true if the varable is set, false else

	virtual unsigned int setVariableToVariable(double* var1,double* var2) = 0;
	//set on the positions wher the variable var1 in the object stand the
	//variable var2
	//pre: the variable var1 to set to the variable var2 and the variable var2
	//post: the number of variables set

	virtual bool setVariableToValue(unsigned int n, int val) = 0;
	//set the variable, with number n in the order of variables,
	//to the given value val and make it a value
	//pre: the number n, in the order of variables, of the variable to set and
	//     the value val to set it to
	//post: true if the varable is set, false else

	virtual unsigned int setVariableToValue(double* var1,int val) = 0;
	//set on the positions wher the variable var1 in the object stand the
	//value val
	//pre: the variable var1 to set to the value val and the value val
	//post: the number of variables set

	virtual bool changeValueAbout(unsigned int n, int dist) = 0;
	//set the value, of the value with number n in the order of values,
	//to a new value, wich is evaluated from the old value plus the
	//value dist
	//pre: the number n, in the order of values, of the value to set and
	//     the distance dist, to change it about
	//post: true if the value is set, false else

	virtual bool isUsedVariable(double* var) const = 0;
	//checks if the given pointer for a variable var is somewhere in the 
	//object(than it is used in the object)
	//pre: the pointer for the variable var to search for
	//post: true if the variable is find(used), false else

	virtual GraphicObject* copy() = 0;
	//copy this object(means all, even the objects in it)
	//post: a pointer to the copy of this object

	virtual void operator=(const GraphicObject* obj) = 0;
	//copy the given object obj(means all, even the objects in it)
	//pre: the object obj to copy
	//post: this object with the values of the given object obj

	inline bool equal(const GraphicObject* obj) const
	//returns if this object and the given object obj are the same
	//(have the same memory pointer)
	//pre: the other object obj to test
	//post: true if this and obj are the same object
	{
	return (this==obj);
	}

	virtual bool equalValue(const GraphicObject* obj) const = 0 ;
	//returns if this object and the given object obj are equal
	//(have the same values and objects)
	//pre: the other object obj to test
	//post: true if this and obj are equal

	virtual std::string classnameOf() const = 0;
	//returns the classname of this object as a string
	//post: the classname of this object as a string

	virtual bool store(unsigned int& n,std::stringstream& stream) const =0;
	//store the object to the stream, with the syntax from the docu
	//pre: the number for the variables to cont from
	//post: the string for this object in the output stream

	virtual bool restore(std::stringstream& in,std::list<double*>& varl) = 0;
	//restore the object from the stream in, wich is ther given with the
	//syntax from the docu, varl is a list with the variables jet defined
	//!this object must be created and his syntax(e.g "fkt(" or "p(") deleted
	//from the stream
	//pre: the input stream to read from and the variablen list of variables
	//     jet defined(ever of this is set to his number (eg. to 3 if his 
	//     syntax is "x3"))
	//post: the object like in the stream

protected:

	int charToInt(char c);
	//makes the char c to a integer number
	//pre: the char c
	//post: the integer number the char c represents(e.g. "1"=1) 

};

#endif
