/*File Name: Parameter.h
  Author: Betti sterholz ; Date: 07.09.2003
  System: C++

  This class is for the parameters of the genetic allgorthim.

  
  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___PARAMETER_h__
#define ___PARAMETER_h__

#include <string>
//#include <stdio.h>
#include <iostream>

using std::cout;
using std::endl;
using std::flush;

class Parameter
{
unsigned long Init[50];
double TerminalCondition[50];
double Operations[100];
char* Names[50];
bool Document[50];

public:

Parameter()
//standart constructor
//set all to 0
{
for (int i=0;i<50;i++) {Init[i]=0;}
for (int i=0;i<50;i++) {TerminalCondition[i]=0;}
for (int i=0;i<100;i++) {Operations[i]=0;}
for (int i=0;i<50;i++) {Names[i]=new char[50];}
for (int i=0;i<50;i++) {Document[i]=false;}
}

Parameter(const Parameter& parm)
//copy constructor
//copy all values of the given Parameter parm
{
for (int i=0;i<50;i++) {Init[i]=parm.getInitParameter(i);}
for (int i=0;i<50;i++) {TerminalCondition[i]=parm.getTerminalConditionParameter(i);}
for (int i=0;i<100;i++) {Operations[i]=parm.getOperationsParameter(i);}
for (int i=0;i<50;i++)
{
	Names[i]=new char[50];
	setNamesParameter(i,parm.getNamesParameter(i));
}
for (int i=0;i<50;i++) {Document[i]=parm.getDocumentParameter(i);}
}

Parameter(char* file)
//file constructor
//load all values from a given file with name file
{
for (int i=0;i<50;i++) {Names[i]=new char[50];}
load(file);
}


~Parameter()
//destructor
{
for (int i=0;i<50;i++) {delete Names[i];}
}

unsigned long getInitParameter(unsigned int n) const
//to get the n'th Init parameter(counting from 0)
//pre: the number n of the parameter to get
//post: the n'th Init parameter
{
if ((n>=0)&&(n<50)) {return Init[n];}
return 0;
}

double getTerminalConditionParameter(unsigned int n) const
//to get the n'th TerminalCondition parameter(counting from 0)
//pre: the number n of the parameter to get
//post: the n'th TerminalCondition parameter
{
if ((n>=0)&&(n<50)) {return TerminalCondition[n];}
return 0;
}

double getOperationsParameter(unsigned int n) const
//to get the n'th Operations parameter(counting from 0)
//pre: the number n of the parameter to get
//post: the n'th iOperation parameter
{
if ((n>=0)&&(n<100)) {return Operations[n];}
return 0;
}

char* getNamesParameter(unsigned int n) const
//to get the n'th Names parameter(counting from 0)
//pre: the number n of the parameter to get
//post: the n'th Names parameter
{
if ((n>=0)&&(n<50)) {return Names[n];}
return "";
}

bool getDocumentParameter(unsigned int n) const
//to get the n'th Document parameter(counting from 0)
//pre: the number n of the parameter to get
//post: the n'th Document parameter
{
if ((n>=0)&&(n<50)) {return Document[n];}
return false;
}

bool setInitParameter(unsigned int n,unsigned long v)
//to set the n'th init parameter(counting from 0) to the value v
//pre: the number n of the parameter to set and the new value v for the parameter
//post: true if the parameter is set
{
if ((n>=0)&&(n<50))
{
	Init[n]=v;
	return true;
}
return false;
}

bool setTerminalConditionParameter(unsigned int n,double v)
//to set the n'th TerminalCondition parameter(counting from 0) to the value v
//pre: the number n of the parameter to set and the new value v for the parameter
//post: true if the parameter is set
{
if ((n>=0)&&(n<50))
{
	TerminalCondition[n]=v;
	return true;
}
return false;
}

bool setOperationsParameter(unsigned int n,double v)
//to set the n'th Operations parameter(counting from 0) to the value v
//pre: the number n of the parameter to set and the new value v for the parameter
//post: true if the parameter is set
{
if ((n>=0)&&(n<100))
{
	Operations[n]=v;
	return true;
}
return false;
}

bool setNamesParameter(unsigned int n,char* nam)
//to set the n'th Names parameter(counting from 0) to the value v
//pre: the number n of the parameter to set and the new value v for the parameter
//post: true if the parameter is set
{
if ((n>=0)&&(n<50))
{
	for (int i=0;i<50;i++)
	{
		if (nam[i]==' '){break;}
		Names[n][i]=nam[i];
	}
	return true;
}
return false;
}

bool setDocumentParameter(unsigned int n,bool v)
//to set the n'th Document parameter(counting from 0) to the value v
//pre: the number n of the parameter to set and the new value v for the parameter
//post: true if the parameter is set
{
if ((n>=0)&&(n<50))
{
	Document[n]=v;
	return true;
}
return false;
}

bool load(char* file)
//load the parameters that re represents by the file with the name file
//pre: the filename file to load the parameters from
//post: true if the parameters are loaded from the file file, false else,
//	maybe then some parameters of this object are inconsistent
{
FILE *stream;
if( (stream = fopen( file, "r" )) != NULL )
{
	cout<<"reading from file : "<<file<<endl;

	fread( Init, sizeof(unsigned long ), 50, stream );
	fread( TerminalCondition, sizeof( double), 50, stream );
	fread( Operations, sizeof( double ), 100, stream );
	for (unsigned int i=0;i<50;i++)
	{
		fread( Names[i], sizeof( char ), 50, stream );
	}
	fread( Document, sizeof( bool ), 50, stream );
	fclose( stream );
	return true;
}
else
      {printf( "File could not be opened\n" );}
return false;
}

bool save(char* file)
//save the parameters to a file with the given name file, if the file
//allready exsits overwrite it
//pre: the name of the file file to save the parameters to
//post: true if the parameters are saved in a file with the name file,
//	false else
{
FILE *stream;
/* Open file in text mode: */
if( (stream = fopen( file, "w" )) != NULL )
{
	cout<<"writing to file : "<<file<<endl;

	fwrite( Init, sizeof(unsigned long ), 50, stream );
	fwrite( TerminalCondition, sizeof( double), 50, stream );
	fwrite( Operations, sizeof( double ), 100, stream );
	for (unsigned int i=0;i<50;i++)
	{
		fwrite( Names[i], sizeof( char ), 50, stream );
	}
	fwrite( Document, sizeof( bool ), 50, stream );
	fclose( stream );
	return true;
}else{
	printf( "Problem opening the file\n" );
}
return false;
}

};

#endif
