/*File Name: main.cpp
  Author: Betti sterholz ; Date: 03.02.2003
  System: C++

  In this file you can set parameter and save them to a parameter file.

  
  Copyright (C) 2004  Betti sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <sstream>
#include <string>
#include <list>

#include "Parameter.h"


int main(int argv,char* argc[])
{

Parameter para;

	para.setOperationsParameter(0,3);//number of immortal individuals (the best n are immortal)

	para.setOperationsParameter(10,0.0);//insert Point which overlaps
	para.setOperationsParameter(11,0.0);//insert Point which is overlapped
	para.setOperationsParameter(12,0.07);//insert part-object which overlaps
	para.setOperationsParameter(13,0.07);//insert part-object which is overlapped
	para.setOperationsParameter(14,0.05);//delete part-object
	para.setOperationsParameter(15,0.25);//change value
	para.setOperationsParameter(16,0.05);//change variable
	para.setOperationsParameter(17,0.05);//replace value with variable
	para.setOperationsParameter(18,0.05);//replace variable with value
	para.setOperationsParameter(19,0.02);//create Function
	para.setOperationsParameter(20,0.02);//create Area
	para.setOperationsParameter(21,0.02);//choose randomly 10 Area or Function elements and delete one if possible
	para.setOperationsParameter(22,0.02);//insert a Function vector into a Function VectorList
	para.setOperationsParameter(23,0.02);//insert an Area vector into an Area VectorList
	para.setOperationsParameter(24,0.04);//remove a randomly chosen list Vector
	para.setOperationsParameter(25,0.05);//move a randomly chosen element
	para.setOperationsParameter(26,0.01);//flip the objects of a randomly chosen conc object
	para.setOperationsParameter(27,0.01);//insert Point from the original PicturMatrix which overlaps
	para.setOperationsParameter(28,0.01);//insert Point from the original PicturMatrix which is overlapped
	para.setOperationsParameter(29,0.04);//choose randomly 10 Area or Function elements and delete one that is not needed
	para.setOperationsParameter(30,0.05);//insert sloping variables
	para.setOperationsParameter(31,0.1);//insert a sloping line



	para.setTerminalConditionParameter(0,100000000.0);//number of maximal loops
	para.setTerminalConditionParameter(1,1000000.0);//maximal goodness for the best Individual
	para.setTerminalConditionParameter(11,500.0);//weight: distance to original
	para.setTerminalConditionParameter(12,20.0);//weight: greatness
	para.setTerminalConditionParameter(13,0.5);//weight: timeNeeded

	//parameters for the documentation(0=false; 1=true)
	para.setDocumentParameter(0,0);//insert
	para.setDocumentParameter(1,0);//operation
	para.setDocumentParameter(2,0);//erase
	para.setDocumentParameter(3,0);//distance
	para.setDocumentParameter(4,1);//number of last Individual
	para.setDocumentParameter(5,0);//goodness

	para.setDocumentParameter(6,1);//append best object to best-object-file
	para.setDocumentParameter(7,1);//best and average goodness for number of last individual
				//(if number of last individual is 0 returns nothing)
	para.setDocumentParameter(8,1);//number of last individual, best and average goodness for
				//number of last individual as an text exel import file to the best_exel file
				//(if number of last individual is 0 returns nothing)


	para.setInitParameter(0,1000);//number of Individuals
	para.setInitParameter(1,0);//initialize with a random point
	para.setInitParameter(2,90);//initialize with point objects of the orginal picture
	para.setInitParameter(3,0);//initialize correct picture objects which randomly
			//generated (positions of the Points in the conc-objects)
	para.setInitParameter(4,100);//how much init-objects to load from the file
	para.setInitParameter(5,0);//init korrect pictur objects rondom generated 2(positions of
		//the new point in the new conc objects); faster then the init3 procedure

	para.setInitParameter(20,100);//primitiv documentation distance; if this parameter is
		//n just every n loops the documentation for DocumentParameter 7 and 8 are printed


	para.setNamesParameter(0,"/home/biokom/bel/bilder/sw32_Haus.bmp ");//picture to load
	para.setNamesParameter(1,"best.bmp ");	//where to store the best picture
	para.setNamesParameter(2,"best_object.txt ");//where to store the best picture in fib; best-object-file

	para.setNamesParameter(3,"oldobj.txt ");//from wich file to load init-objects
	para.setNamesParameter(4,"haus6e.txt ");//name of the best_exel file to store the best data to, see DocumentParameter 8

para.save("haus6.par");//file to store the parameters in

};

