/*File Name: PProgramm.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  This is implementation of the Basisclass of all ListObject objects


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//---------------------------------------------------------------------------

#include "PProgramm.h"

//constructors:
PProgramm::PProgramm(unsigned int maxNumberOfAtoms):MaxNumberOfAtoms(maxNumberOfAtoms)
//standart constructor
//constructs a PProgram object
{}

PProgramm::~PProgramm()
//destructor
{}

unsigned int PProgramm::getNumberOfAtoms() const
//returns the number of possibel Atoms for this object
//post: Numbers of possibel atoms fore this object
{return MaxNumberOfAtoms;}

unsigned int PProgramm::getNumberOfClauses() const
//returns the number of clauses for this object
//post: Numbers of clauses fore this object
{return Clausels.size();}

bool PProgramm::createClause()
//creates a new empty clause
//post: true if a new clausel is created, and the new clausel at the end
//of the PProgramm
{
Clausels.insert(Clausels.end(),*(new TPClausel));
return true;
}

bool PProgramm::deleteClause(unsigned int nOClausel)
//delete the clause on position n (counting from 0)
//pre: the position of the clause to delete
//post: true if a new clausel is deleted
{
if (nOClausel>=getNumberOfClauses()){return false;}
list<TPClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
Clausels.erase(itr);
return true;
}


list<double> PProgramm::getPOfHead(unsigned int nOClausel) const
//returns the head atoms propability of the n'th clause
//pre: the number of clause wich head p. to return
//post: the head probability of the n'th clause or a empty list
{
if (nOClausel>=getNumberOfClauses())
	{list<double> tmpl;return tmpl;}
list<TPClausel>* tmpc=const_cast< list<TPClausel>* >(&Clausels);
list<TPClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return (itr->head);
}

bool PProgramm::setPOfHead(unsigned int nOClausel, list<double> headP)
//sets the head atoms propability of the n'th clause to th given
//head probability headP if it is valid (it's summ is between 0 and 1)
//and ther is a clause clausel
//pre: the number of clause wich head p. to change and the new head p.
//post: true if the head p. is changed
{
if ((nOClausel>=getNumberOfClauses())||(headP.size()!=getNumberOfAtoms()))//(!isPList1(headP))||
	{return false;}
list<TPClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
(itr->head)=headP;
return true;
}

list<double> PProgramm::getPOfPositivBody(unsigned int nOClausel) const
//returns the positve body atoms propability of the n'th clause
//pre: the number of clause wich positve body p. to return
//post: the positve body probability of the n'th clause or a empty list
{
if (nOClausel>=getNumberOfClauses()){list<double> tmpl;return tmpl;}
list<TPClausel>* tmpc=const_cast< list<TPClausel>* >(&Clausels);
list<TPClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return (itr->bodyP);
}

bool PProgramm::setPOfPositivBody(unsigned int nOClausel, list<double> bodyPP)
//sets the positve body atoms propability of the n'th clause to th given
//positv body probability bodyPP if it is valid and ther is a clause clausel
//pre: the number of clause wich positve body p. to change and the new positve body p.
//post: true if the positve body p. is changed
{
if ((nOClausel>=getNumberOfClauses())||(bodyPP.size()!=getNumberOfAtoms())){return false;}//(!isPList(bodyPP))||
list<TPClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
(itr->bodyP)=bodyPP;
return true;
}

list<double> PProgramm::getPOfNegativBody(unsigned int nOClausel) const
//returns the negative body atoms propability of the n'th clause
//pre: the number of clause wich negative body p. to return
//post: the negative body probability of the n'th clause or a empty list
{
if (nOClausel>=getNumberOfClauses()){list<double> tmpl;return tmpl;}
list<TPClausel>* tmpc=const_cast< list<TPClausel>* >(&Clausels);
list<TPClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return (itr->bodyN);
}

bool PProgramm::setPOfNegativBody(unsigned int nOClausel, list<double> bodyNP)
//sets the negative body atoms propability of the n'th clause to th given
//negative body probability bodyNP if it is valid and ther is a clause clausel
//pre: the number of clause wich negative body p. to change and the new negative body p.
//post: true if the negative body p. is changed
{
if ((!isPList(bodyNP))||(nOClausel>=getNumberOfClauses())||(bodyNP.size()!=getNumberOfAtoms())){return false;}
list<TPClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
(itr->bodyN)=bodyNP;
return true;
}

double PProgramm::getPOfHeadAtom(unsigned int nOClausel,unsigned int nOAtom) const
//returns the head atom propability of the n'th clause of the n'th atom
//pre: the number of clause and atom wich head p. to return
//post: the head probability of the n'th clause and n'th atom if exists or 0.0
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>=getNumberOfAtoms())){return 0.0;}
list<TPClausel>* tmpc=const_cast< list<TPClausel>* >(&Clausels);
list<TPClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
list<double>::iterator itr2=(itr->head).begin();
for (unsigned int i=0;i<nOAtom;i++){itr2++;}
return (*itr2);
}

double PProgramm::getPOfPBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const
//returns the positive body atom propability of the n'th clause of the n'th atom
//pre: the number of clause and atom wich positive body p. to return
//post: the positive body probability of the n'th clause and n'th atom if exists or 0.0
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>=getNumberOfAtoms())){return 0.0;}
list<TPClausel>* tmpc=const_cast< list<TPClausel>* >(&Clausels);
list<TPClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
list<double>::iterator itr2=(itr->bodyP).begin();
for (unsigned int i=0;i<nOAtom;i++){itr2++;}
return (*itr2);
}

double PProgramm::getPOfNBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const
//returns the negative body atom propability of the n'th clause of the n'th atom
//pre: the number of clause and atom wich negative body p. to return
//post: the negative body probability of the n'th clause and n'th atom if exists or 0.0
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>=getNumberOfAtoms())){return 0.0;}
list<TPClausel>* tmpc=const_cast< list<TPClausel>* >(&Clausels);
list<TPClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
list<double>::iterator itr2=(itr->bodyN).begin();
for (unsigned int i=0;i<nOAtom;i++){itr2++;}
return (*itr2);
}

void PProgramm::print()
//prints the program
{
list<double> bodyP,bodyN,head;

cout<<endl<<endl;
for (unsigned int i=0;i<getNumberOfClauses();i++)
{
	head=getPOfHead(i);
	unsigned int a=0;
	for (list<double>::iterator itr=head.begin();itr!=head.end();itr++)
	{
		cout<<" p("<<a<<")="<<(*itr)<<",";
		a++;
	}
	cout<<" :- ";
	bodyP=getPOfPositivBody(i);
	bodyN=getPOfNegativBody(i);
	a=0;
	for (list<double>::iterator itr=bodyN.begin();itr!=bodyN.end();itr++)
	{
		cout<<"not p("<<a<<")="<<(*itr)<<",";
		a++;
	}
	a=0;
	for (list<double>::iterator itr=bodyP.begin();itr!=bodyP.end();itr++)
	{
		cout<<" p("<<a<<")="<<(*itr)<<",";
		a++;
	}
	cout<<endl;
}
cout<<endl;
}

Programm* PProgramm::generateProgram(TRandomMersenne* rg)
//generates a programm for this p. Programm
{
list<double> bodyP,bodyN,head;
Programm* prog=new Programm(getNumberOfAtoms());
double rand;
unsigned int a;
for (unsigned int i=0;i<getNumberOfClauses();i++)
{
	prog->createClause();
	head=getPOfHead(i);
	a=0;
	rand=rg->Random();
	//evalue head, using weel selection
	for (list<double>::iterator itr=head.begin();itr!=head.end();itr++)
	{
		if(rand<=(*itr)){break;}
		rand-=(*itr);//weel selection
		a++;
	}
	prog->setHead(i,a);
	bodyP=getPOfPositivBody(i);
	bodyN=getPOfNegativBody(i);
	a=0;
	for (list<double>::iterator itr=bodyN.begin();itr!=bodyN.end();itr++)
	{
		rand=rg->Random();
		if(rand<=(*itr)){prog->setNBodyAtom(i,a,true);}
		a++;
	}
	a=0;
	for (list<double>::iterator itr=bodyP.begin();itr!=bodyP.end();itr++)
	{
		rand=rg->Random();
		if(rand<=(*itr)){prog->setPBodyAtom(i,a,true);}
		a++;
	}
}
return prog;
}




















//EOF

