/*File Name: PProgramm.h
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PPROGRAMM_h__
#define __PPROGRAMM_h__

#include <iostream>
#include <list>
#include "mersenne.h"
#include "Programm.h"

using std::list;
using std::cout;
using std::endl;

//P means probability
//the counting of clauses begins with 0

class PProgramm
{
protected:

typedef struct TPClausel {
	list<double> head;
	list<double> bodyP;
	list<double> bodyN;
} TPClausel;

std::list<TPClausel> Clausels;
unsigned int MaxNumberOfAtoms;//maximal number of Atoms

public:
//constructors:
	PProgramm(unsigned int maxNumberOfAtoms);
	//standart constructor
	//constructs a PProgramm object

	~PProgramm();
	//destructor

	double summList(list<double> slist)
	//evalue the the sum of the given list
	//pre: the list to sum
	//post: the sum of the list
	{
	double sum;
	for (list<double>::iterator itr=slist.begin();itr!=slist.end();itr++)
		{sum+=(*itr);}
	return sum;
	};

	double isPList(list<double> plist)
	//checks if all elements in the given list are propabilities
	//pre: the list to check
	//post: true if all elements in the given list are propabilities
	{
	bool isp=true;
	for (list<double>::iterator itr=plist.begin();itr!=plist.end();itr++)
		{isp=isp&&((*itr)<=1)&&((*itr)>=0);}
//	cout<<" ipl "<<isp<<endl;
	return (isp);
	};

	double isPList1(list<double> plist)
	//checks if all elements in the given list are propabilities and has a
	//sum between 0 and 1
	//pre: the list to check
	//post: true if all elements in the given list are propabilities and the
	//sum is between 0 and 1
	{
	double sum;
	bool isp=true;
	for (list<double>::iterator itr=plist.begin();itr!=plist.end();itr++)
		{sum+=(*itr);isp=isp&&((*itr)<=1)&&((*itr)>=0);}
//	cout<<endl<<"sum "<<sum<<" v : "<<(isp&&(sum<=1)&&(sum>=0))<<" i "<<isp<<endl;
	return (isp&&(sum<=1)&&(sum>=0));
	};

	unsigned int getNumberOfAtoms() const;
	//evaluate the number of possibel Atoms for this object
	//post: Numbers of possibel atoms fore this object

	unsigned int getNumberOfClauses() const;
	//returns the number of clauses for this object
	//post: Numbers of clauses fore this object

	bool createClause();
	//creates a new empty clause
	//post: true if a new clausel is created, and the new clausel at the end
	//of the PProgram

	bool deleteClause(unsigned int nOClausel);
	//delete the clause on position n (counting from 0)
	//pre: the position of the clause to delete
	//post: true if a new clausel is delete

	list<double> getPOfHead(unsigned int nOClausel) const;
	//returns the head atoms propability of the n'th clause
	//pre: the number of clause wich head p. to return
	//post: the head probability of the n'th clause

	bool setPOfHead(unsigned int nOClausel, list<double> headP);
	//sets the head atoms propability of the n'th clause to th given
	//head probability headP if it is valid (it's summ is between 0 and 1)
	//and ther is a clause clausel
	//pre: the number of clause wich head p. to change and the new head p.
	//post: true if the head p. is changed

	list<double> getPOfPositivBody(unsigned int nOClausel) const;
	//returns the positve body atoms propability of the n'th clause
	//pre: the number of clause wich positve body p. to return
	//post: the positve body probability of the n'th clause or a empty list

	bool setPOfPositivBody(unsigned int nOClausel, list<double> bodyPP);
	//sets the positve body atoms propability of the n'th clause to th given
	//positv body probability bodyPP if it is valid and ther is a clause clausel
	//pre: the number of clause wich positve body p. to change and the new positve body p.
	//post: true if the positve body p. is changed

	list<double> getPOfNegativBody(unsigned int nOClausel) const;
	//returns the negative body atoms propability of the n'th clause
	//pre: the number of clause wich negative body p. to return
	//post: the negative body probability of the n'th clause or a empty list

	bool setPOfNegativBody(unsigned int nOClausel, list<double> bodyNP);
	//sets the negative body atoms propability of the n'th clause to th given
	//positv body probability bodyNP if it is valid and ther is a clause clausel
	//pre: the number of clause wich negative body p. to change and the new negative body p.
	//post: true if the negative body p. is changed

	double getPOfHeadAtom(unsigned int nOClausel,unsigned int nOAtom) const;
	//returns the head atom propability of the n'th clause of the n'th atom
	//pre: the number of clause and atom wich head p. to return
	//post: the head probability of the n'th clause and n'th atom if exists or 0.0

	double getPOfPBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const;
	//returns the positive body atom propability of the n'th clause of the n'th atom
	//pre: the number of clause and atom wich positive body p. to return
	//post: the positive body probability of the n'th clause and n'th atom if exists or 0.0

	double getPOfNBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const;
	//returns the negative body atom propability of the n'th clause of the n'th atom
	//pre: the number of clause and atom wich negative body p. to return
	//post: the negative body probability of the n'th clause and n'th atom if exists or 0.0

	void print();
	//prints the program

	Programm* generateProgram(TRandomMersenne* rg);
	//generates a programm for this p. Programm

};

#endif








