/*File Name: Programm.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  This is implementation of the Basisclass of all ListObject objects


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//---------------------------------------------------------------------------

#include "Programm.h"

//constructors:
Programm::Programm():MaxNumberOfAtoms(0)
//standart constructor
//constructs a Program object
{}

Programm::Programm(unsigned int maxNumberOfAtoms):MaxNumberOfAtoms(maxNumberOfAtoms)
//standart constructor
//constructs a Program object
{}

Programm::~Programm()
//destructor
{}

unsigned int Programm::getNumberOfAtoms() const
//returns the number of possibel Atoms for this object
//post: Numbers of possibel atoms fore this object
{return MaxNumberOfAtoms;}

unsigned int Programm::getNumberOfClauses() const
//returns the number of clauses for this object
//post: Numbers of clauses fore this object
{return Clausels.size();}

bool Programm::createClause()
//creates a new empty clause
//post: true if a new clausel is created, and the new clausel at the end
//of the Programm
{
TClausel tmpc;
tmpc.head=0;
Clausels.insert(Clausels.end(),tmpc);
return true;
}

bool Programm::deleteClause(unsigned int nOClausel)
//delete the clause on position n (counting from 0)
//pre: the position of the clause to delete
//post: true if a new clausel is deleted
{
if (nOClausel>=getNumberOfClauses()){return false;}
list<TClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
Clausels.erase(itr);
return true;
}


bool Programm::setHead(unsigned int nOClausel, unsigned int head)
//sets the head atoms of the n'th clause to th given head atom head
//if ther is a clause clausel
//pre: the number of clause wich head to change and the new head
//post: true if the head is changed
{
if ((nOClausel>=getNumberOfClauses())||(head>getNumberOfAtoms())){return false;}
list<TClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
(itr->head)=head;
return true;
}

list<unsigned int> Programm::getPositivBody(unsigned int nOClausel) const
//returns the positve body atoms of the n'th clause
//pre: the number of clause wich positve body to return
//post: the positve body of the n'th clause or a empty list
{
if (nOClausel>=getNumberOfClauses()){list<unsigned int> tmpl;return tmpl;}
list<TClausel>* tmpc=const_cast< list<TClausel>* >(&Clausels);
list<TClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return (itr->bodyP);
}

bool Programm::setPositivBody(unsigned int nOClausel, list<unsigned int> bodyP)
//sets the positve body atoms of the n'th clause to th given
//positv body bodyP, if ther is a clause clausel
//pre: the number of clause wich positve body to change and the new positve body
//post: true if the positve body is changed
{
if (nOClausel>=getNumberOfClauses()){return false;}
list<TClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
(itr->bodyP)=bodyP;
return true;
}

list<unsigned int> Programm::getNegativBody(unsigned int nOClausel) const
//returns the negative body atoms of the n'th clause
//pre: the number of clause wich negative body to return
//post: the negative body of the n'th clause or a empty list
{
if (nOClausel>=getNumberOfClauses()){list<unsigned int> tmpl;return tmpl;}
list<TClausel>* tmpc=const_cast< list<TClausel>* >(&Clausels);
list<TClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return (itr->bodyN);
}

bool Programm::setNegativBody(unsigned int nOClausel, list<unsigned int> bodyN)
//sets the negative body atoms of the n'th clause to th given
//negative body bodyN, if ther is a clause clausel
//pre: the number of clause wich negative body to change and the new negative body
//post: true if the negative body is changed
{
if (nOClausel>=getNumberOfClauses()){return false;}
list<TClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
(itr->bodyN)=bodyN;
return true;
}

unsigned int Programm::getNOLiteralsNB(unsigned int nOClausel) const
//returns the number of literals in the negativ body
//pre: the number of clause from wich the number of literals to return
//post: the number of literals in the negativ body of the n'th clause
{
if (nOClausel>=getNumberOfClauses()){return 0;}
list<TClausel>* tmpc=const_cast< list<TClausel>* >(&Clausels);
list<TClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return ((itr->bodyN).size());
}

unsigned int Programm::getHeadAtom(unsigned int nOClausel) const
//returns the head atom of the n'th clause of the n'th atom
//pre: the number of clause
//post: the head of the n'th clause and n'th atom if exists or 0
{
if (nOClausel>=getNumberOfClauses()){return 0;}
list<TClausel>* tmpc=const_cast< list<TClausel>* >(&Clausels);
list<TClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
return (itr->head);
}

bool Programm::getPBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const
//returns if ther is n'th atom in the positive body of the n'th clause
//pre: the number of clause and atom of the positive body to return
//post: true if ther is the n'th atom in the positive body the n'th clause
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>getNumberOfAtoms())){return false;}
list<TClausel>* tmpc=const_cast< list<TClausel>* >(&Clausels);
list<TClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
list<unsigned int>::iterator itr2=(itr->bodyP).begin();
for (unsigned int i=0;i<nOAtom;i++){if ((*itr2)==nOAtom) {return true;};}
return false;
}

bool Programm::setPBodyAtom(unsigned int nOClausel,unsigned int nOAtom,bool value)
//set the n'th atom in the positive body of the n'th clause
//pre: the number of clause and atom of the positive body to set
//post: true if the atom was set
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>getNumberOfAtoms())){return false;}
list<TClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
for (list<unsigned int>::iterator itr2=(itr->bodyP).begin();itr2!=(itr->bodyP).end();itr2++)
{
	if ((*itr2)==nOAtom)
		{if (value) {return true;}
		else{itr2=((itr->bodyP).erase(itr2));}
		};
}
if (value)
{
	(itr->bodyP).insert((itr->bodyP).end(),nOAtom);
}
return true;
}

bool Programm::getNBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const
//returns if ther is n'th atom in the negative body of the n'th clause
//pre: the number of clause and atom of the negative body to return
//post: true if ther is the n'th atom in the negative body the n'th clause
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>getNumberOfAtoms())){return false;}
list<TClausel>* tmpc=const_cast< list<TClausel>* >(&Clausels);
list<TClausel>::iterator itr=tmpc->begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
list<unsigned int>::iterator itr2=(itr->bodyN).begin();
for (unsigned int i=0;i<nOAtom;i++){if ((*itr2)==nOAtom) {return true;};}
return false;
}

bool Programm::setNBodyAtom(unsigned int nOClausel,unsigned int nOAtom,bool value)
//set the n'th atom in the negative body of the n'th clause
//pre: the number of clause and atom of the negative body to set
//post: true if the atom was set
{
if ((nOClausel>=getNumberOfClauses())||(nOAtom>getNumberOfAtoms())){return false;}
list<TClausel>::iterator itr=Clausels.begin();
for (unsigned int i=0;i<nOClausel;i++){itr++;}
for (list<unsigned int>::iterator itr2=(itr->bodyN).begin();itr2!=(itr->bodyN).end();itr2++)
{
	if ((*itr2)==nOAtom)
	{
		if (value) {return true;}
		else{itr2=((itr->bodyN).erase(itr2));}
	};
}
if (value)
{
	(itr->bodyN).insert((itr->bodyN).end(),nOAtom);
}
return true;
}

bool Programm::readProgram(ifstream* stream)
//reads a program in lparse format from the stream istr
//pre: the stream to read the program from
//post: true if the reading was sucessfull
{
unsigned int z,bodyAtoms,negB;
unsigned int maxAtom=0;
MaxNumberOfAtoms=0-1;//set to maximum
bool moreRules=true;

//read rule
while (moreRules)
{
	(*stream)>>z;
	if (z==0) {break;}
	if (z!=1) {return false;}
	createClause();
	(*stream)>>z;//read head
	setHead(getNumberOfClauses()-1, z);
	if (z>maxAtom) {maxAtom=z;}
	(*stream)>>bodyAtoms;
	(*stream)>>negB;//negativ body literals
	//read body
	for (unsigned int i=0;i<bodyAtoms;i++)
	{
		if (negB)
		{
			negB--;
//			(*stream)>>c;//blank
			(*stream)>>z;
			if (z>maxAtom) {maxAtom=z;}
			setNBodyAtom(getNumberOfClauses()-1,z,true);
		}else{
//			(*stream)>>c;//blank
			(*stream)>>z;
			if (z>maxAtom) {maxAtom=z;}
			setPBodyAtom(getNumberOfClauses()-1,z,true);
		}
	}
}
MaxNumberOfAtoms=maxAtom+1;
return true;
}

void Programm::print()
//prints the program
{
list<unsigned int> bodyP,bodyN;

cout<<endl<<endl;
for (unsigned int i=0;i<getNumberOfClauses();i++)
{
	cout<<getHeadAtom(i);
	bodyP=getPositivBody(i);
	bodyN=getNegativBody(i);
	if (((bodyP.size())+(bodyN.size()))){cout<<" :- ";}
	for (list<unsigned int>::iterator itr=bodyN.begin();itr!=bodyN.end();itr++)
	{
		if (itr!=bodyN.begin()){cout<<",";}
		cout<<"not "<<(*itr);
	}
	if ((bodyP.size())&&(bodyN.size())){cout<<",";}
	for (list<unsigned int>::iterator itr=bodyP.begin();itr!=bodyP.end();itr++)
	{
		if (itr!=bodyP.begin()){cout<<",";}
		cout<<" "<<(*itr);
	}
	cout<<".";
	cout<<endl;
}
cout<<endl;
}

void Programm::print(ofstream *outstr)
//prints the program to the stream
{
list<unsigned int> bodyP,bodyN;
for (unsigned int i=0;i<getNumberOfClauses();i++)
{
	(*outstr)<<"a"<<getHeadAtom(i);
	bodyP=getPositivBody(i);
	bodyN=getNegativBody(i);
	if (((bodyP.size())+(bodyN.size()))){(*outstr)<<" :- ";}
	for (list<unsigned int>::iterator itr=bodyN.begin();itr!=bodyN.end();itr++)
	{
		if (itr!=bodyN.begin()){(*outstr)<<",";}
		(*outstr)<<"not a"<<(*itr);
	}
	if ((bodyP.size())&&(bodyN.size())){(*outstr)<<",";}
	for (list<unsigned int>::iterator itr=bodyP.begin();itr!=bodyP.end();itr++)
	{
		if (itr!=bodyP.begin()){(*outstr)<<",";}
		(*outstr)<<"a"<<(*itr);
	}
	(*outstr)<<".";
	(*outstr)<<endl;
}
}


















//EOF

