//g++ -Wall -g -o genM generateM.cpp
/*
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <list>
#include <time.h>

#include "PProgramm.h"
#include "Programm.h"

using namespace std;

TRandomMersenne* rg1;

void evOutput(ofstream *ostream,unsigned int num)
/*This method reads (pars) the output of the solver and writes the data, with
the BMTool Form, to the given output stream
pre: the output stream ostream to write the readed data to and the number
	of the actual example num
post: the readed data in the stream*/
{
char c;
unsigned int answer=0,choice=0,wchoice=0,trueAS=0,atoms=0,rules=0,searchSp=0;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>100000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';i=0;
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		answer=1;
	}else{//no Answer
		answer=0;
	}
	c='A';i=0;
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>wchoice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>atoms;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>rules;
/*	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>trueAS;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>searchSp;
*/
//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<wchoice<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<"  |"<<endl;
	delete tstream;
}
else
	printf( "Problem opening the file\n" );
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}

int evResult(char* output,unsigned int nboAtoms,unsigned int nboLiteralsPerClauseTen,unsigned int nboClause,unsigned int nOExamples)
/*this method generates a test point, by generating the logic programs
(with the mixed body length modell, wher every bodyatom has the same
probability to be choosen), evaluating them with the ASP-solver and
outputs the results to a file
pre:the name output of the file wher to output (with the BMTool form) the
	result, the number of atoms nboAtoms, rules nboClause, number average
	literals per rule body (nboLiteralsPerClauseTen/10) and the number
	of examples/programs to generate
post: the results of the testcases in the file with name output*/
{
PProgramm pProg=PProgramm(nboAtoms);
Programm *prog;
//set parameter for the programs to generate
list<double> headProb,bodyPProb,bodyNProb;
double nboLiteralsPerClause=(double)(nboLiteralsPerClauseTen)/10.0;
for (unsigned int i=0;i<nboAtoms;i++)
{
	headProb.insert(headProb.end(),1.0/(double)(nboAtoms));
}
for (unsigned int i=0;i<nboAtoms;i++)
{
	bodyPProb.insert(bodyPProb.end(),(double)(nboLiteralsPerClause)/((double)(nboAtoms)*2.0));
}
for (unsigned int i=0;i<nboAtoms;i++)
{
	bodyNProb.insert(bodyNProb.end(),(double)(nboLiteralsPerClause)/((double)(nboAtoms)*2.0));
}
for (unsigned int i=0;i<nboClause;i++)
{
	pProg.createClause();
	pProg.setPOfHead(i, headProb);
	pProg.setPOfPositivBody(i,bodyPProb);
	pProg.setPOfNegativBody(i,bodyNProb);
}
int ret=0;
ofstream *pstream;
ofstream *ostream=new ofstream(output);
(*ostream)<<"smodels-2.28"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;

if( ostream!= NULL )
{
	for (unsigned int i=0;i<nOExamples;i++)
	{
		pstream=new ofstream("./tmp_prog.lp");
		(*pstream)<<"%"<<endl;
		prog=pProg.generateProgram(rg1);
		prog->print(pstream);
		delete prog;
		delete pstream;
		char ev[100];
		sprintf(ev,"(~/wv/lparse-1.0.13/src/lparse ./tmp_prog.lp | (~/wv/smodels-2.28/smodels -nolookahead))>tmp.txt");
//		sprintf(ev,"(lparse ./%s/b%i.lp | smodels)>tmp.txt",folder,i);
		cout<<i<<" : "<<ev<<endl;
		ret=system(ev);
		if (WIFSIGNALED(ret)) break;
		evOutput(ostream,i);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else
	printf( "Problem opening the file\n" );
return ret;
}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;
unsigned int nboAtoms, nboClause,nboLiteralsPerClauseTen;//nboLiteralsPerClause=nboLiteralsPerClauseTen/10
/* load last end point as start point */
ifstream *stream=new ifstream("todo.txt");
int ret=0;
while(true)
{
	if( stream!= NULL )
	{
		char ch;
		(*stream)>>nboLiteralsPerClauseTen;
		(*stream)>>ch;
		if (ch=='.') {break;}
		(*stream)>>nboClause;
		(*stream)>>ch;
		(*stream)>>nboAtoms;
		(*stream)>>ch;
		cout<<"point :"<<endl<<" literals : "<<nboLiteralsPerClauseTen<<"; clause : "<<nboClause<<"; atoms : "<<nboAtoms<<endl<<endl;
	} else {printf( "Problem opening the file\n" );}

	//save this point as last end state
	ofstream *ostream=new ofstream("spointM.txt");
	if( stream!= NULL )
	{
		(*ostream)<<nboLiteralsPerClauseTen<<";"<<nboClause<<";"<<nboAtoms<<";"<<endl;
		delete ostream;
	} else {printf( "Problem opening the file\n" );}

	//go into directory; execute BMTool; delete testcase
	char result[40];
	sprintf(result,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClauseTen,nboClause);
	ret=evResult(result,nboAtoms,nboLiteralsPerClauseTen,nboClause,1000);
	if (WIFSIGNALED(ret)) break;
}
if( stream!= NULL ){delete stream;}
cout<<endl;
}



