
class TData {
/*This class is to store the values of one example.*/
public:
	double time;
	unsigned int choice;
	unsigned int choiceP;
	unsigned int answer;
	bool operator<(const TData tdat) const
	{
		return (time<tdat.time);
	}
	bool static lowerChoice(const TData tdat1,const TData tdat2)
	{
		return (tdat1.choice<tdat2.choice);
	}
	bool static lowerWChoice(const TData tdat1,const TData tdat2)
	{
		return (tdat1.choiceP<tdat2.choiceP);
	}
};

class TTupel{
public:
	unsigned int x,y;
	bool operator<(const TTupel tup) const
	{
		return (x<tup.x);
	}
};

class TDResult
{
/*This class is to store the evaluate results values of one testcase.*/
public:
	char name[100];//name of the testcase
	unsigned int literals;//literals parameter of the generator
	unsigned int atoms;//atoms parameter of the generator
	unsigned int rules;//rules parameter of the generator
	unsigned int examples;//examples in the testcase
	double avTime;//average time
	double avChoice;//average choice
	double avChoiceP;//average choice points
	unsigned int posExamples;//positive examples
	double posAvTime;//average time of positive examples
	double posAvChoice;//average choice of positive examples
	unsigned int negExamples;//negative examples
	double negAvTime;//average time of negative examples
	double negAvChoice;//average choice of negative examples
	double minTime;//minimal time
	double maxTime[10];//maximal time of the classes with 10 per cent of examples
	//, which are the next better after maxTime[n-1](btw if n=0 minTime)
	double clAvTime[10];//average time of the classes with 10 per cent of examples
	double timeSpread;//spread of the time values
	double timeVarianz;//time varianz
	double choiceVarianz;//choice point varianze
	double ChoicePVarianz;//varianc of the choice pointse
	double avCTQutient;//average choise/time qutient
	double cTQutientVarianz;//average choise/time qutient varianze
	double medianTime;//time median
	double medianChoice;//choice median
	double medianChoiceP;//choice point median
	double minChoice;//minimal choices
	double maxChoice;//maximal choices
	double minChoiceP;//minimal choice points
	double maxChoiceP;//maximal choice points
	double posAvChoiceP;//positiv average choice points
	double negAvChoiceP;//negativ average choice points
	double avCPTQutient;//average choice point/time qutient
	double wCTQutientVarianz;//average choice point/time qutient varianze
	double avDChoice;//average choice-choiceP value
	double dChoiceVarianz;//varianz choice-choiceP value

	double mNTimePTime;//(negativ time) - (positiv time)
	double dNTimePTime;//(negativ time)/(positiv time)
	double logDNTimePTime;//log(negativ time)/log(positiv time)
	double mNChoicePChoice;//(negativ choices) - (positiv choices)
	double dNChoicePChoice;//(negativ choices)/(positiv choices)
	double logDNChoicePChoice;//log(negativ choices)/log(positiv choices)
	double mNChoicePPChoiceP;//(negativ choice points) - (positiv choice points)
	double dNChoicePPChoiceP;//(negativ choice points)/(positiv choice points)
	double logDNChoicePPChoiceP;//log(negativ choice points)/log(positiv choice points)


	bool operator<(const TDResult tres) const
	/*the lower realtion for TDResult
	to order the TDResults, first coms the literals, then the atoms and then
	the rules
	pre: two TDResult
	post: true if first TDResult is lower than the secound, else false*/
	{
	return ((literals<tres.literals)||
		((literals==tres.literals)&&((atoms<tres.atoms)||
		((atoms==tres.atoms)&&(rules<tres.rules)))));
	}

	bool static lowerAtoms(const TDResult tres1,const TDResult tres2)
	{
		return (tres1.atoms<tres2.atoms);
	}

	bool static lowerRules(const TDResult tres1,const TDResult tres2)
	{
		return (tres1.rules<tres2.rules);
	}

	bool static lowerLiterals(const TDResult tres1,const TDResult tres2)
	{
		return (tres1.literals<tres2.literals);
	}
};

list<TData> readData(char* file)
/*This method reads the data of one testcase and store it to a list of TData
pre: the name of the file wher the data of the testcase is stored in the
	BMTool output form
post: the TData list with the readed values*/
{
list<TData> tmpDataL;
char c=' ';
unsigned int i;
char name[100];
TData dat;
dat.time=0.0;
dat.choice=0;
dat.choiceP=0;
dat.answer=0;
char ls[100];

sprintf(ls,"ls %s",file);
int existsT=system(ls);//test if ther exists such file
if (existsT!=0){return tmpDataL;}

ifstream *stream=new ifstream(file);
if( stream!= NULL )
{
	//read first part till the first data set
	i=0;
	while (c!='|')
	{
		(*stream)>>c;
		if (!((c=='|')||(c==' '))) {name[i]=c;i++;}
	}
	name[i+1]=0;
	cout<<name<<endl<<flush;
	(*stream)>>c;
	while (c!='|'){(*stream)>>c;}
	while (c!='l'){(*stream)>>c;}
	//read line
	while (true)
	{
		c='a';
		//read till the first values of the data begin
		while (!((c=='|')||(c=='-'))){(*stream)>>c;}
		if (c=='-'){break;}
		(*stream)>>dat.time;
		(*stream)>>c;//read ';'
		(*stream)>>dat.choice;
		(*stream)>>c;//read ';'
		(*stream)>>dat.choiceP;
		(*stream)>>c;//read ';'
		(*stream)>>c;
		if(c=='1')//read if ther is a answer
		{
			dat.answer=1;
		}else{//"NV"
			dat.answer=0;
			(*stream)>>c;
		}
		while (c!='|'){(*stream)>>c;}

//		cout<<dat.time<<";"<<dat.choice<<";"<<dat.choiceP<<";"<<dat.answer;
//		cout<<";"<<dat.trueAss<<";"<<dat.atoms<<";"<<dat.rules<<endl;
		tmpDataL.insert(tmpDataL.end(),dat);
	}
	stream->close();
	delete stream;
}
else
	{printf( "Problem opening the file\n" );}
return tmpDataL;
}

TDResult evalueResult(char *file,unsigned int at,unsigned int rl,unsigned int lit)
/*evaluates the results of the testcase in the file file
pre: the name of the file file wher testcase data ist stored, the number of
	atoms, rules and literals with wich the testcase was generated
post: the results of the testcase as a TDResult*/
{
//read data of testcase
list<TData> dataL;
dataL=readData(file);
TDResult result;
unsigned int i=0;
while ((file[i]!=0)||(i<100))
	{result.name[i]=file[i];i++;}
dataL.sort();
i=0;
//init values of the result
result.literals=lit;
result.atoms=at;
result.rules=rl;
result.examples=dataL.size();
//average time
result.avTime=0.0;
result.avChoice=0.0;
//positive examples
result.posExamples=0;
//average time of positive examples
result.posAvTime=0.0;
result.posAvChoice=0.0;
result.posAvChoiceP=0.0;
//average time of negative examples
result.negAvTime=0.0;
result.negAvChoice=0.0;
result.negAvChoiceP=0.0;
result.minChoice=(dataL.begin())->choice;//minimal choices
result.maxChoice=(dataL.begin())->choice;//maximal choices
result.minChoiceP=(dataL.begin())->choiceP;//minimal choice points
result.maxChoiceP=(dataL.begin())->choiceP;//maximal choice points
result.timeVarianz=0.0;//time varianz
result.choiceVarianz=0.0;
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=0;}
result.avCTQutient=0.0;
result.cTQutientVarianz=0.0;
result.avCPTQutient=0.0;
result.wCTQutientVarianz=0.0;
result.avChoiceP=0.0;
result.ChoicePVarianz=0.0;

result.avDChoice=0.0;//average choice-choiceP value
result.dChoiceVarianz=0.0;//varianz choice-choiceP value


//evalue values of the testcase
list<TData>::iterator itr;
for (itr=dataL.begin();itr!=dataL.end();itr++)
{
	result.avTime+=itr->time;
	result.avChoice+=(double)(itr->choice);
	result.avChoiceP+=(double)(itr->choiceP);
	result.avDChoice+=(double)((itr->choice)-(itr->choiceP));
	i++;
	if ((((i*10)/dataL.size())*dataL.size())==(i*10))
		{result.maxTime[((i-1)*10)/dataL.size()]=itr->time;}
	result.clAvTime[(i*10)/dataL.size()]+=itr->time;
	if ((itr->answer)>0)
	{	result.posExamples++;
		result.posAvTime+=itr->time;
		result.posAvChoice+=(double)(itr->choice);
		result.posAvChoiceP+=(double)(itr->choiceP);
	}else{
		result.negAvTime+=itr->time;
		result.negAvChoice+=(double)(itr->choice);
		result.negAvChoiceP+=(double)(itr->choiceP);
	}
	if (result.minChoice>(itr->choice)) {result.minChoice=(itr->choice);}
	if (result.maxChoice<(itr->choice)) {result.maxChoice=(itr->choice);}
	if (result.minChoiceP>(itr->choiceP)) {result.minChoiceP=(itr->choiceP);}
	if (result.maxChoiceP<(itr->choiceP)) {result.maxChoiceP=(itr->choiceP);}
	result.timeVarianz+=(itr->time)*(itr->time);
	result.choiceVarianz+=(double)(itr->choice)*(double)(itr->choice);
	result.ChoicePVarianz+=(double)(itr->choiceP)*(double)(itr->choiceP);
	result.dChoiceVarianz+=(double)((itr->choice)-(itr->choiceP))*(double)((itr->choice)-(itr->choiceP));
	if ((itr->time)>0)
	{
		result.avCTQutient+=((double)(itr->choice))/(itr->time);
		result.cTQutientVarianz+=(((double)(itr->choice))/(itr->time))*(((double)(itr->choice))/(itr->time));
		result.avCPTQutient+=((double)(itr->choiceP))/(itr->time);
		result.wCTQutientVarianz+=(((double)(itr->choiceP))/(itr->time))*(((double)(itr->choiceP))/(itr->time));
	}
	if(dataL.size()/2==i){result.medianTime=itr->time;}
}
result.avTime=result.avTime/dataL.size();
result.avChoice=result.avChoice/dataL.size();
result.avChoiceP=result.avChoiceP/dataL.size();
result.avDChoice=result.avDChoice/dataL.size();
result.avCTQutient=result.avCTQutient/dataL.size();
result.avCPTQutient=result.avCPTQutient/dataL.size();

result.posAvTime=result.posAvTime/result.posExamples;
result.posAvChoice=result.posAvChoice/result.posExamples;
result.posAvChoiceP=result.posAvChoiceP/result.posExamples;

result.negExamples=dataL.size()-result.posExamples;//negative examples

result.negAvTime=result.negAvTime/result.negExamples;
result.negAvChoice=result.negAvChoice/result.negExamples;
result.negAvChoiceP=result.negAvChoiceP/result.negExamples;

result.minTime=(dataL.begin())->time;//minimal time
result.timeSpread=result.maxTime[9]-result.minTime;
result.timeVarianz=(result.timeVarianz)/dataL.size()-(result.avTime)*(result.avTime);
result.choiceVarianz=(result.choiceVarianz)/dataL.size()-(result.avChoice)*(result.avChoice);
result.cTQutientVarianz=(result.cTQutientVarianz)/dataL.size()-(result.avCTQutient)*(result.avCTQutient);
result.wCTQutientVarianz=(result.wCTQutientVarianz)/dataL.size()-(result.avCPTQutient)*(result.avCPTQutient);
result.ChoicePVarianz=(result.ChoicePVarianz)/dataL.size()-(result.avChoiceP)*(result.avChoiceP);
result.dChoiceVarianz=(result.dChoiceVarianz)/dataL.size()-(result.avDChoice)*(result.avDChoice);
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=(result.clAvTime[a]*10.0)/dataL.size();}

//correct divede 0 values
if (dataL.size()==0){result.avTime=0.0;result.avChoice=0.0;result.avCTQutient=0.0;
	result.timeVarianz=0.0;result.choiceVarianz=0.0;
	result.cTQutientVarianz=0.0;result.avChoiceP=0.0;result.ChoicePVarianz=0.0;
	result.avDChoice=0.0;
	for (unsigned int a=0;a<10;a++)
		{result.clAvTime[a]=0.0;}
	}
if (result.posExamples==0){result.posAvTime=0.0;result.posAvChoice=0.0;result.posAvChoiceP=0.0;}
if (result.negExamples==0){result.negAvTime=0.0;result.negAvChoice=0.0;result.negAvChoiceP=0.0;}

dataL.sort(&TData::lowerChoice);
itr=dataL.begin();
for (i=0;i<=(dataL.size()/2);i++)
	{itr++;}
result.medianChoice=(itr->choice);
dataL.sort(&TData::lowerWChoice);
itr=dataL.begin();
for (i=0;i<=(dataL.size()/2);i++)
	{itr++;}
result.medianChoiceP=(itr->choiceP);

result.mNTimePTime=result.negAvTime-result.posAvTime;//(negativ time) - (positiv time)
result.dNTimePTime=result.negAvTime/result.posAvTime;//(negativ time)/(positiv time)
if ((result.negAvTime>0.0)&&(result.posAvTime>0.0))//log(negativ time)/log(positiv time)
	{result.logDNTimePTime=log(result.negAvTime)/log(result.posAvTime);}
else{result.logDNTimePTime=0.0;}
result.mNChoicePChoice=result.negAvChoice-result.posAvChoice;//(negativ choice point) - (positiv choices)
result.dNChoicePChoice=result.negAvChoice/result.posAvChoice;//(negativ choice point)/(positiv choices)
if ((result.negAvChoice>0.0)&&(result.posAvChoice>0.0))//log(negativ choice point)/log(positiv choice point)
	{result.logDNChoicePChoice=log(result.negAvChoice)/log(result.posAvChoice);}
else{result.logDNChoicePChoice=0.0;}
result.mNChoicePPChoiceP=result.negAvChoiceP-result.posAvChoiceP;//(negativ choice points) - (positiv choice points)
result.dNChoicePPChoiceP=result.negAvChoiceP/result.posAvChoiceP;//(negativ choice points)/(positiv choice points)
if ((result.negAvChoiceP>0.0)&&(result.posAvChoiceP>0.0))//log(negativ choice points)/log(positiv choice points)
	{result.logDNChoicePPChoiceP=log(result.negAvChoiceP)/log(result.posAvChoiceP);}
else{result.logDNChoicePPChoiceP=0.0;}


return result;
}

void writeHead(ofstream *stream)
/*writes the head of the result tabel in a excel readebel form
colums are seperated with ";"
pre: the stream to write the head to
post: the head of the table in the stream*/
{
(*stream)<<"rules/atoms ;name ;literals ;atoms ;rules ;examples ;average time ;average choices";
(*stream)<<" ;average choice points";
(*stream)<<" ;time median ;choice median ;choice point median";
(*stream)<<" ;positiv examples ;positiv average time ;positiv average choices";
(*stream)<<" ;positiv average choice point";
(*stream)<<" ;negativ examples ;negativ average time ;negativ average choices";
(*stream)<<" ;negativ average choice point";
(*stream)<<" ;min Time";
for (unsigned int i=0;i<10;i++){(*stream)<<" ;max time "<<i;}
for (unsigned int i=0;i<10;i++){(*stream)<<" ;class av. time "<<i;}
(*stream)<<" ;minimal choice ; maximal choice ;minimal choice point ; maximal choice point";
(*stream)<<" ;time spread ;time varianz ;choice varianz ;choice point varianz";
(*stream)<<" ;average choice time qutient ;choice time qutient varianz";
(*stream)<<" ;average choice point time qutient ;choice point time qutient varianz";
(*stream)<<" ;average (choice-(choice point)) ;(choice-(choice point)) varianz ;average (positiv choice-(positiv choice point))";
(*stream)<<" ;(negativ time) - (positiv time) ;(negativ time)/(positiv time) ;log(negativ time)/log(positiv time)";
(*stream)<<" ;(negativ choice point) - (positiv choices) ; (negativ choice point)/(positiv choices)";
(*stream)<<" ;log(negativ choice point)/log(positiv choices)";
(*stream)<<" ;(negativ choice points) - (positiv choice points) ; (negativ choice points)/(positiv choice points)";
(*stream)<<" ;log(negativ choice points)/log(positiv choice points)"<<endl;
}

void writeResult(ofstream *stream,TDResult result)
/*writes one given result to the stream in a excel readebel form
colums are seperated with ";"
pre: the stream to print the result data to and the result to print
post: the result in the stream*/
{
(*stream)<<double(result.rules)/double(result.atoms)<<" ; "<<result.name<<" ; "<<result.literals<<" ; "<<result.atoms;
(*stream)<<" ; "<<result.rules<<" ; "<<result.examples;
(*stream)<<" ; "<<result.avTime<<" ; "<<result.avChoice<<" ; "<<result.avChoiceP;
(*stream)<<" ; "<<result.medianTime<<" ; "<<result.medianChoice<<" ; "<<result.medianChoiceP;
(*stream)<<" ; "<<result.posExamples<<" ; "<<result.posAvTime;
(*stream)<<" ; "<<result.posAvChoice<<" ; "<<result.posAvChoiceP;
(*stream)<<" ; "<<result.negExamples<<" ; "<<result.negAvTime;
(*stream)<<" ; "<<result.negAvChoice<<" ; "<<result.negAvChoiceP;
(*stream)<<" ; "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" ;"<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" ;"<<result.clAvTime[i];}
(*stream)<<" ; "<<result.minChoice<<" ; "<<result.maxChoice<<" ; "<<result.minChoiceP<<" ; "<<result.maxChoiceP;
(*stream)<<" ; "<<result.timeSpread;
(*stream)<<" ; "<<result.timeVarianz<<" ;"<<result.choiceVarianz;
(*stream)<<" ;"<<result.ChoicePVarianz;
(*stream)<<" ; "<< result.avCTQutient<<" ; "<< result.cTQutientVarianz;
(*stream)<<" ; "<< result.avCPTQutient<<" ; "<< result.wCTQutientVarianz<<" ; "<< (result.avCPTQutient);
(*stream)<<" ; "<< result.avDChoice<<" ; "<< result.dChoiceVarianz<<" ; "<<result.avDChoice*double(result.examples)/double(result.posExamples);
(*stream)<<" ; "<< result.mNTimePTime<<" ; "<< result.dNTimePTime<<" ; "<< result.logDNTimePTime;
(*stream)<<" ; "<< result.mNChoicePChoice<<" ; "<< result.dNChoicePChoice<<" ; "<< result.logDNChoicePChoice;
(*stream)<<" ; "<< result.mNChoicePPChoiceP<<" ; "<< result.dNChoicePPChoiceP<<" ; "<< result.logDNChoicePPChoiceP<<endl;
}

void writeResultBl(ofstream *stream,TDResult result)
/*writes one given result to the stream in a excel readebel form
colums are seperated with " "(blank)
pre: the stream to print the result data to and the result to print
post: the result in the stream*/
{
(*stream)<<double(result.rules)/double(result.atoms)<<" "<<result.name<<" "<<result.literals<<" "<<result.atoms;
(*stream)<<" "<<result.rules<<" "<<result.examples;
(*stream)<<" "<<result.avTime<<" "<<result.avChoice<<" "<<result.avChoiceP;
(*stream)<<" "<<result.medianTime<<" "<<result.medianChoice<<" "<<result.medianChoiceP;
(*stream)<<" "<<result.posExamples<<" "<<result.posAvTime;
(*stream)<<" "<<result.posAvChoice<<" "<<result.posAvChoiceP;
(*stream)<<" "<<result.negExamples<<" "<<result.negAvTime;
(*stream)<<" "<<result.negAvChoice<<" "<<result.negAvChoiceP;
(*stream)<<" "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" "<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" "<<result.clAvTime[i];}
(*stream)<<" "<<result.minChoice<<" "<<result.maxChoice<<" "<<result.minChoiceP<<" "<<result.maxChoiceP;
(*stream)<<" "<<result.timeSpread;
(*stream)<<" "<<result.timeVarianz<<" "<<result.choiceVarianz;
(*stream)<<" "<<result.ChoicePVarianz;
(*stream)<<" "<< result.avCTQutient<<" "<< result.cTQutientVarianz;
(*stream)<<" "<< result.avCPTQutient<<" "<< result.wCTQutientVarianz;
(*stream)<<" "<< result.avDChoice<<" "<< result.dChoiceVarianz;
(*stream)<<" "<< result.mNTimePTime<<" "<< result.dNTimePTime<<" "<< result.logDNTimePTime;
(*stream)<<" "<< result.mNChoicePChoice<<" "<< result.dNChoicePChoice<<" "<< result.logDNChoicePChoice;
(*stream)<<" "<< result.mNChoicePPChoiceP<<" "<< result.dNChoicePPChoiceP<<" "<< result.logDNChoicePPChoiceP;
(*stream)<<" "<<result.avDChoice*double(result.examples)/double(result.posExamples)<<endl;
}


void plotData(char* baseName,unsigned int wich,char* wichName,char* filePName,int titleNumber,char* titleString,unsigned int literals,char* titleString2)
/*prints the graphs to the data in the file "./gnuplotTmp.txt" (stored
results with blanks betwean), the graphs are flat (2 dimensional)
most graphs are printed in normal and log scale
the graphs are generated with gnuplot
pre: the base name baseName of the folder and file to store the graphs to,
	the number wich of the colum wher the x values of the graph stand,
	the name wichName of the x values (e.g. "rules"), the begin of name
	filePName the graph file to store the graph to, the titelNumber and
	titelString to write in the titel (eg. titelNumber=55 ;titelString="atoms"
	then a part of the title is "... 55 atoms ...") and the numbers of
	literals in the data (how much literals the testcases have)
post: the graphs of the data*/
{
ofstream *stream=new ofstream("./gnuplotTmp.txt");
//output time
(*stream)<<"set terminal postscript"<<endl;
(*stream)<<"set nokey"<<endl;
//(*stream)<<"set size 1, 1"<<endl;
(*stream)<<"set format xy \"%g\""<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set xlabel \""<<wichName<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 with linespoints "<<endl;
//output examples
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_e_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"examples n\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":6 with linespoints "<<endl;
//output choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choice for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 with linespoints "<<endl;
//output choice point
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_wc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 with linespoints "<<endl;
//output choice-choiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_dc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average (choice-(choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":54 with linespoints "<<endl;
//output pos choice-pos choiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_dpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average (positiv choice-(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":65 with linespoints "<<endl;
//output median time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"time median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":10 with linespoints "<<endl;
//output median choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice point median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":11 with linespoints "<<endl;
//output median choice points
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice points median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":12 with linespoints "<<endl;
//output minimum time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mint_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":21 with linespoints "<<endl;
//output minimum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_minc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum choices for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":42 with linespoints "<<endl;
//output maximum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_maxc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximum choices for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":43 with linespoints "<<endl;
//output minimum choice point
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_minwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":44 with linespoints "<<endl;
//output maximum choice point
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_maxc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximum choice point for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice point\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":45 with linespoints "<<endl;
//output time spread
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_sp_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"time spread for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":46 with linespoints "<<endl;
//output time varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"time varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":47 with linespoints "<<endl;
//output choice varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choices varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":48 with linespoints "<<endl;
//output choice-choiceP varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_dc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"((choices)-(choice point)) varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":55 with linespoints "<<endl;
//output choice/time quotient
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choices time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":50 with linespoints "<<endl;
//output choice/time quotient variance
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"varianz of choices time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":51 with linespoints "<<endl;
//output choiceP/time quotient
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_WCdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":52 with linespoints "<<endl;
//output choiceP/time quotient variance
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_WCdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"varianz of choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice point/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":53 with linespoints "<<endl;
//output choiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_wc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choice point for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 with linespoints "<<endl;
//output choiceP varianc
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_wc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice point varianc for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice point varianc\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":49 with linespoints "<<endl;
//output mNTimePTime
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_m_ntpt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ time) - (positiv time) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":56 with linespoints "<<endl;
//output dNTimePTime
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_d_ntpt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ time)/(positiv time) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":57 with linespoints "<<endl;
//output logDNTimePTime
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_d_log_ntpt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log(negativ time)/log(positiv time) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":58 with linespoints "<<endl;
//output mNChoicePChoice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_m_ncpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choices)-(positiv choices) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":59 with linespoints "<<endl;
//output dNChoicePChoice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_d_ncpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choices)/(positiv choices) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":60 with linespoints "<<endl;
//output dNChoicePChoice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_d_log_ncpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log(negativ choices)/log(positiv choices) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":61 with linespoints "<<endl;
//output mNChoicePPChoiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_m_nwcpwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choice points)-(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":62 with linespoints "<<endl;
//output dNChoicePPChoiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_d_nwcpwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choice points)/(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":63 with linespoints "<<endl;
//output dNChoicePPChoiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_d_log_nwcpwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log(negativ choice points)/log(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":64 with linespoints "<<endl;


//key section
//output examples pos neg
(*stream)<<"set key"<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_epn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average examples positiv, negative and all for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"examples n\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":6 title \"all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":13 title \"positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":17 title \"negativ examles\" with linespoints "<<endl;
//output time pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_tpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average time for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 title \"time all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":14 title \"time positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":18 title \"time negativ examles\" with linespoints "<<endl;
//output choice pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_cpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choices for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 title \"choice all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":15 title \"choice positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":19 title \"choice negativ examles\" with linespoints "<<endl;
//output choice point pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_wcpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choice points for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 title \"choice points all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":16 title \"choice points positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":20 title \"choice points negativ examles\" with linespoints "<<endl;
//output 10 maximal time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mtc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximal time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":21 title \"minimal time\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":22 title \"maximal time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":23 title \"maximal time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":24 title \"maximal time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":25 title \"maximal time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":26 title \"maximal time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":27 title \"maximal time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":28 title \"maximal time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":29 title \"maximal time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":30 title \"maximal time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":31 title \"maximal time in class 10\" with linespoints "<<endl;
//output 10 time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_tc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":32 title \"time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":33 title \"time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":34 title \"time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":35 title \"time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":36 title \"time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":37 title \"time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":38 title \"time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":39 title \"time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":40 title \"time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":41 title \"time in class 10\" with linespoints "<<endl;


//log part
//output log time
(*stream)<<"set logscale y"<<endl;
(*stream)<<"set nokey"<<endl;
(*stream)<<"set title \"average log time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 with linespoints "<<endl;
//output log choice
(*stream)<<"set title \"average log choices for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 with linespoints "<<endl;
//output choice point
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_wc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 with linespoints "<<endl;
//output median time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log time median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":10 with linespoints "<<endl;
//output median choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choices median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":11 with linespoints "<<endl;
//output median choice points
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choice points median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":12 with linespoints "<<endl;
//output minimum time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mint_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum log time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":21 with linespoints "<<endl;
//output minimum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_minc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum log choices for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":42 with linespoints "<<endl;
//output maximum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_maxc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximum log choices for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":43 with linespoints "<<endl;
//output minimum choice point
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_minwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum log choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":44 with linespoints "<<endl;
//output maximum choice point
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_maxc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximum log choice point for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice point\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":45 with linespoints "<<endl;
//output time spread
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_sp_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log time spread for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":46 with linespoints "<<endl;
//output time varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log time varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":47 with linespoints "<<endl;
//output choice varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choices varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":48 with linespoints "<<endl;
//output choice/time quotient
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choices time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":50 with linespoints "<<endl;
//output choice/time quotient variance
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log varianz of choices time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":51 with linespoints "<<endl;
//output choiceP/time quotient
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_WCdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":52 with linespoints "<<endl;
//output choiceP/time quotient variance
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_WCdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log varianz of choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice point/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":53 with linespoints "<<endl;
//output choiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_wc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log choice point for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 with linespoints "<<endl;
//output choiceP varianc
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_wc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choice point varianc for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice point varianc\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":49 with linespoints "<<endl;
//output mNTimePTime
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_m_ntpt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ time) - (positiv time) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":56 with linespoints "<<endl;
//output dNTimePTime
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_d_ntpt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ time)/(positiv time) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":57 with linespoints "<<endl;
//output logDNTimePTime
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_d_log_ntpt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log(negativ time)/log(positiv time) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":58 with linespoints "<<endl;
//output mNChoicePChoice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_m_ncpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choices)-(positiv choices) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":59 with linespoints "<<endl;
//output dNChoicePChoice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_d_ncpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choices)/(positiv choices) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":60 with linespoints "<<endl;
//output dNChoicePChoice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_d_log_ncpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log(negativ choices)/log(positiv choices) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":61 with linespoints "<<endl;
//output mNChoicePPChoiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_m_nwcpwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choice points)-(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":62 with linespoints "<<endl;
//output dNChoicePPChoiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_d_nwcpwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"(negativ choice points)/(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":63 with linespoints "<<endl;
//output dNChoicePPChoiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_d_log_nwcpwc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log(negativ choice points)/log(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"Faktor\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":64 with linespoints "<<endl;
//output pos choice-pos choiceP
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_dpc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average (positiv choice-(positiv choice points) for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":65 with linespoints "<<endl;

//key section
//output time pos neg
(*stream)<<"set key"<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_tpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log time for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 title \"time all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":14 title \"time positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":18 title \"time negativ examles\" with linespoints "<<endl;
//output choice pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_cpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log choices for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choices\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 title \"choice all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":15 title \"choice positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":19 title \"choice negativ examles\" with linespoints "<<endl;
//output choice point pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_wcpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log choice points for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 title \"choice points all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":16 title \"choice points positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":20 title \"choice points negativ examles\" with linespoints "<<endl;
//output 10 maximal time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mtc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximal log time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":21 title \"minimal time\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":22 title \"maximal time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":23 title \"maximal time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":24 title \"maximal time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":25 title \"maximal time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":26 title \"maximal time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":27 title \"maximal time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":28 title \"maximal time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":29 title \"maximal time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":30 title \"maximal time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":31 title \"maximal time in class 10\" with linespoints "<<endl;
//output 10 time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_tc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" "<<titleString2<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":32 title \"time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":33 title \"time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":34 title \"time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":35 title \"time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":36 title \"time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":37 title \"time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":38 title \"time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":39 title \"time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":40 title \"time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":41 title \"time in class 10\" with linespoints "<<endl;


system("gnuplot ./gnuplotTmp.txt");
stream->close();
delete stream;
}

void plotData3D(char* baseName,unsigned int wich,char* wichName,unsigned int wConst,char* wConstName,unsigned int x,unsigned int y)
/*prints the graphs to the data in the file "./gnuplotTmp.txt" (stored
results with blanks betwean), the graphs are 3 dimensional
most graphs are printed in normal and log scale
the graphs are generated with gnuplot
pre: the base name baseName of the folder and file to store the graphs to
	and the numbers of literals in the data (how much literals the testcases have)
post: the graphs of the data*/
{
ofstream *stream=new ofstream("./gnuplotTmp.txt");
if( stream!= NULL )
{
	(*stream)<<"set terminal postscript"<<endl;
//	(*stream)<<"set size 1, 1"<<endl;
	(*stream)<<"set format xy \"%g\""<<endl;

	//output examples bars
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/e_poi_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set xlabel \"rules R\""<<endl;
	(*stream)<<"set ylabel \""<<wichName<<"\""<<endl;
	(*stream)<<"set zlabel \"examples n\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":6 with points"<<endl;


	(*stream)<<"set key"<<endl;
	(*stream)<<"set contour base"<<endl<<"set surface"<<endl<<"set data style lines"<<endl<<"set dgrid3d "<<x<<","<<y<<",3"<<endl;
	//output time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average time for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":7"<<endl;
	//output examples
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/e_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"examples n\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":6"<<endl;
	//output choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/c_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average choices for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":8"<<endl;
	//output choice-choiceP
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/dc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average ((choices)-(wrong coice)) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":54"<<endl;
	//output median time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mt_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"time median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":10"<<endl;
	//output median choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"choices median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":11"<<endl;
	//output median choice point
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mwc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"choice points median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":12"<<endl;
	//output minimum time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mint_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum time for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":21"<<endl;
	//output minimum choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/minc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum choices for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":42"<<endl;
	//output maximum choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/maxc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximum choices for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":43"<<endl;
	//output minimum choice point
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/minc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":44"<<endl;
	//output maximum choice point
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/maxc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximum choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":45"<<endl;
	//output time spread
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/sp_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"time spread for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":46"<<endl;
	//output time varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"time varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":47"<<endl;
	//output choice varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_c_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"choices varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":48"<<endl;
	//output choice-choiceP varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_dc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"((choices)-(choice point)) varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":55"<<endl;
	//output choice/time quotient
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/CdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"coice points time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":50"<<endl;
	//output choice/time quotient variance
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_CdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"varianz of coice points time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"coice points/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":51"<<endl;
	//output choice point/time quotient
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/WCdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"wrong coices time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":52"<<endl;
	//output choice/time quotient variance
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_WCdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"varianz of wrong coices time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"wrong coices/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":53"<<endl;
	//output choiceP
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/wc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":9"<<endl;
	//output choiceP varianc
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_wc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"choice points variance for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":49"<<endl;
	//output mNTimePTime
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/m_ntpt_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"(negativ time) - (positiv time) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":56 with linespoints "<<endl;
	//output dNTimePTime
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/d_ntpt_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"(negativ time)/(positiv time) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"Faktor\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":57 with linespoints "<<endl;
	//output logDNTimePTime
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/d_log_ntpt_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log(negativ time)/log(positiv time) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"Faktor\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":58 with linespoints "<<endl;
	//output mNChoicePChoice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/m_ncpc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"(negativ choices)-(positiv choices) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":59 with linespoints "<<endl;
	//output dNChoicePChoice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/d_ncpc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"(negativ choices)/(positiv choices) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"Faktor\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":60 with linespoints "<<endl;
	//output dNChoicePChoice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/d_log_ncpc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log(negativ choices)/log(positiv choices) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"Faktor\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":61 with linespoints "<<endl;
	//output mNChoicePPChoiceP
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/m_nwcpwc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"(negativ choice points)-(positiv choice points) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":62 with linespoints "<<endl;
	//output dNChoicePPChoiceP
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/d_nwcpwc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"(negativ choice points)/(positiv choice points) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"Faktor\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":63 with linespoints "<<endl;
	//output dNChoicePPChoiceP
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/d_log_nwcpwc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log(negativ choice points)/log(positiv choice points) for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"Faktor\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":64 with linespoints "<<endl;

	//key section
	//output examples pos neg
//	(*stream)<<"set key"<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/epn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average examples positiv, negative and all for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"examples n\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":13 title \"positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":17 title \"negativ examles\""<<endl;
	//output examples pos
//	(*stream)<<"set key"<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/ep_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average examples positiv and all for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"examples n\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":13 title \"positiv examles\""<<endl;
	//output time pos neg
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/tpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average time for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":14 title \"time positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":18 title \"time negativ examles\""<<endl;
	//output choice pos neg
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/cpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average choices for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choices\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":15 title \"choice positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":19 title \"choice negativ examles\""<<endl;
	//output choice point pos neg
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/wcpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average choice points for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":16 title \"choice point positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":20 title \"choice point negativ examles\""<<endl;
	//output 10 maximal time classes
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mtc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximal time of 10 time classes for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":21 title \"minimal time\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":22 title \"maximal time in class 1\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":23 title \"maximal time in class 2\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":24 title \"maximal time in class 3\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":25 title \"maximal time in class 4\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":26 title \"maximal time in class 5\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":27 title \"maximal time in class 6\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":28 title \"maximal time in class 7\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":29 title \"maximal time in class 8\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":30 title \"maximal time in class 9\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":31 title \"maximal time in class 10\""<<endl;
	//output 10 time classes
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/tc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average time of 10 time classes for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":32 title \"time in class 1\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":33 title \"time in class 2\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":34 title \"time in class 3\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":35 title \"time in class 4\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":36 title \"time in class 5\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":37 title \"time in class 6\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":38 title \"time in class 7\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":39 title \"time in class 8\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":40 title \"time in class 9\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":41 title \"time in class 10\""<<endl;

	system("gnuplot ./gnuplotTmp.txt");
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
}


void makeData(list<TDResult> rL,char* baseName)
/*outputs the data of the results in the list TDResult,
outputs it in a seperated folder, wher it saves the tabel with head in a
excel readebel form, colums seperated by ";", and a number of graphs
pre: the bool atoms say if the atoms chang, rules say if the rules change
	and D3 say if the data should printed in a 3 dimensional graph or not,
	base name ist the base name of the folder and filse to store the data
	to (folders begins with "erg" and the baseName )
post: the data of the result list in a own folder*/
{
if (rL.size()<5){return;}//if net enoght results are in the list cancel the output
rL.sort();
//create the directory to store the data to
char b[20];
sprintf(b,"mkdir ./tabellen/erg%s",baseName);
cout<<b<<endl;
system(b);
//output date in a excel redebel form, with colums seperated by ";"
char outf[50];
sprintf(outf,"./tabellen/erg%s/HSC%s.txt",baseName,baseName);
ofstream *stream=new ofstream(outf);
if( stream!= NULL )
{
	writeHead(stream);
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResult(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
//output the data for gnuplot in a file
stream=new ofstream("./tmpG1.txt");
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
//output date in a excel redebel form, with colums seperated by ";"
char outfg[50];
sprintf(outfg,"./tabellen/erg%s/HSGrC%s.txt",baseName,baseName);
stream=new ofstream(outfg);
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}

}

void makeData3D(list<TDResult> rL,char* baseName)
/*outputs the data of the results in the list TDResult,
outputs it in a seperated folder "tablesLV", wher it saves the tabel with head in a
excel readebel form, colums seperated by ";"
pre: base name ist the base name of the files to store the data
post: the data of the result list in the folder*/
{
if (rL.size()<5){return;}//if net enoght results are in the list cancel the output
rL.sort();
//output date in a excel redebel form, with colums seperated by ";"
char outf[50];
sprintf(outf,"./tabellen/tabelsLV/HSC%s.txt",baseName,baseName);
ofstream *stream=new ofstream(outf);
if( stream!= NULL )
{
	(*stream)<<"number of testcases ; "<<rL.size()<<";"<<endl;
	writeHead(stream);
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResult(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
}

void plotData3DAtoms(list<TDResult> rL ,char* baseName)
{
unsigned int maxClass=0,x=0,y=0;
list<TTupel> tupL;
TTupel tup;
list<TTupel>::iterator itrT;
rL.sort(&TDResult::lowerAtoms);
list<TDResult>::iterator itr=rL.begin();
tup.x=itr->atoms;
tup.y=1;
itr++;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==itr->atoms)
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->atoms;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
//	cout<<"_"<<flush;
	if((itrT->x)<(itr->atoms))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->atoms))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{x++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}

rL.sort(&TDResult::lowerRules);
itr=rL.begin();
tup.x=itr->rules;
tup.y=1;
itr++;
maxClass=0;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==(itr->rules))
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->rules;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
	if((itrT->x)<(itr->rules))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->rules))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{y++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}
if((x<3)||(y<3)||(rL.size()<10)){return;}
ofstream *stream=new ofstream("./tmpG1.txt");
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
makeData(rL,baseName);
plotData3D(baseName,4,"Atoms A",(rL.begin())->literals,"literals",x,y);
}

void plotData3DLiterals(list<TDResult> rL ,char* baseName)
{
unsigned int maxClass=0,x=0,y=0;
list<TTupel> tupL;
TTupel tup;
list<TTupel>::iterator itrT;
rL.sort(&TDResult::lowerLiterals);
list<TDResult>::iterator itr=rL.begin();
tup.x=itr->literals;
tup.y=1;
itr++;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==itr->literals)
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->literals;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
//	cout<<"_"<<flush;
	if((itrT->x)<(itr->literals))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->literals))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{x++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}

rL.sort(&TDResult::lowerRules);
itr=rL.begin();
tup.x=itr->rules;
tup.y=1;
itr++;
maxClass=0;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==(itr->rules))
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->rules;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
	if((itrT->x)<(itr->rules))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->rules))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{y++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}
if((x<3)||(y<3)||(rL.size()<10)){return;}
ofstream *stream=new ofstream("./tmpG1.txt");
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
makeData(rL,baseName);
plotData3D(baseName,3,"Literals L",(rL.begin())->atoms,"atoms",x,y);
}
 
