//	g++ -Wall -g -o ev evaluatorAll.cpp
/*File Name: evaluatorAll.cpp
  Author: Bernd Oesterholz ; Date: 10.04.2005
  System: C++


  Copyright (C) 2004  Bernd ?sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This programm generates graphs and tables for the answerset testcases,
wich results are in the BMTool output form.
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>


using namespace std;

#include "evalueAllIOGr.cpp"

double evalueLiterals(char* file)
{
double literals,lit;
unsigned int i=0;//examples counter
char ls[50];
char c;
sprintf(ls,"ls %s",file);
int existsT=system(ls);//test if ther exists such file
if (existsT!=0){return 0.0;}

ifstream *stream=new ifstream(file);
if( stream!= NULL )
{
	//read first part till the first data set
	while (c!='|'){(*stream)>>c;}
	c='a';
	while (c!='|'){(*stream)>>c;}
	while (c!='l'){(*stream)>>c;}
	//read line
	while (true)
	{
		c='a';
		//read till the first values of the data begin
		while (!((c=='|')||(c=='-'))){(*stream)>>c;}
		if (c=='-'){break;}c='a';
		(*stream)>>lit;
		literals+=lit;i++;
		while (c!='|'){(*stream)>>c;}
	}
	stream->close();
	delete stream;
}
else
	{printf( "Problem opening the file\n" );}
return literals/double(i);

}

int main()
/*with this programm results for the testcases are evaluet and outputed as
tables for excel import and graphs generated with gnuplot*/
{
list<TDResult> allResult;
TDResult result;
unsigned int nboVertices, nboEdges;
int existsT;
//maximal values to wich the testcases should be readed
unsigned int maxNboVertices=30, maxNboEdges=400;//1000;100;5000?
//delta values
unsigned int dNboVertices=1, dNboEdges=1;//10;2;100

//read Data
for (nboVertices=2;nboVertices<=maxNboVertices;nboVertices+=dNboVertices){//5..150
	char lsa[50];
	sprintf(lsa,"(ls ./ergebnisse/gV%iE*.txt) > tmp.txt",nboVertices);
	existsT=system(lsa);
	if (existsT==0)//if existsT==0 the ther exists a test
	{
	for (nboEdges=1;nboEdges<=maxNboEdges;nboEdges+=dNboEdges){//10..1500 +10
		if (nboEdges>(nboVertices*nboVertices)){break;}
		char ls[50];
		sprintf(ls,"ls ./ergebnisse/gV%iE%i.txt",nboVertices,nboEdges);
		existsT=system(ls);
		if (existsT==0)//if existsT==0 the ther exists a test
		{
			char file[50];
			sprintf(file,"./ergebnisse/gV%iE%i.txt",nboVertices,nboEdges);
			result=evalueResult(file);
			if(result.literals<0.1)
			{
				char fileL[50];
				sprintf(fileL,"./ergebnisseL/gLV%iE%i.txt",nboVertices,nboEdges);
				result.literals=evalueLiterals(fileL);
//				cout<<"lit : "<<result.literals<<endl;
			}
			result.vertices=nboVertices;
			result.edges=nboEdges;
			allResult.insert(allResult.end(),result);
		}
	}}
}
allResult.sort();


//evalue data
list<TDResult> evResult;

//output data for one vertices value, the rules are the x values in the graphs
for (nboVertices=2;nboVertices<=30;nboVertices+=dNboVertices){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if(itr->vertices==nboVertices)
			{evResult.insert(evResult.end(),(*itr));}
	}
	if(evResult.size()>5)
	{
		char bs[50];
		sprintf(bs,"V%iEV",nboVertices);
		evResult.sort();
		makeData(evResult,bs);
		plotData(bs,75,"edges","E",nboVertices,"vertices");
		plotData(bs,4,"atoms","A",nboVertices,"vertices");
		plotData(bs,5,"rules","R",nboVertices,"vertices");
		plotData(bs,1,"rules/atoms","RdA",nboVertices,"vertices");
		plotData(bs,76,"edges/(vertices*log(vertices))","EdVlogV",nboVertices,"vertices");
		plotData(bs,77,"edges/vertices","EdV",nboVertices,"vertices");
	}
	evResult.clear();
}
//output data for one edge value, the Vertices are the x values in the graphs
for (nboEdges=1;nboEdges<=maxNboEdges;nboEdges+=dNboEdges){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if(itr->edges==nboEdges)
			{evResult.insert(evResult.end(),(*itr));}
	}
	if(evResult.size()>5)
	{
		char bs[50];
		sprintf(bs,"VVE%i",nboEdges);
		evResult.sort();
		makeData(evResult,bs);
		plotData(bs,74,"vertices","V",nboEdges,"edges");
		plotData(bs,4,"atoms","A",nboEdges,"edges");
		plotData(bs,5,"rules","R",nboEdges,"edges");
		plotData(bs,1,"rules/atoms","RdA",nboEdges,"edges");
		plotData(bs,76,"edges/(vertices*log(vertices))","EdVlogV",nboEdges,"edges");
		plotData(bs,77,"edges/vertices","EdV",nboEdges,"edges");
	}
	evResult.clear();
}
//output data for one atom area
unsigned int dAtoms=50;
for (unsigned int nboAtoms=50;nboAtoms<=900;nboAtoms+=dAtoms){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->averageAtoms>=nboAtoms)&&(itr->averageAtoms<(nboAtoms+dAtoms)))
			{evResult.insert(evResult.end(),(*itr));}
	}
	if(evResult.size()>5)
	{
		char bs[50];
		sprintf(bs,"VVEVA%iD%i",nboAtoms,dAtoms);
		evResult.sort();
		makeData(evResult,bs);
		plotData(bs,74,"vertices","V",nboAtoms,"start atoms and a area of 50 atoms");
		plotData(bs,5,"rules","R",nboAtoms,"start atoms and a area of 50 atoms");
		plotData(bs,1,"rules/atoms","RdA",nboAtoms,"start atoms and a area of 50 atoms");
	}
	evResult.clear();
}
//output data for one rules area
unsigned int dRules=50;
for (unsigned int nboRules=50;nboRules<=1400;nboRules+=dRules){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->averageRules>=nboRules)&&(itr->averageRules<(nboRules+dRules)))
			{evResult.insert(evResult.end(),(*itr));}
	}
	if(evResult.size()>5)
	{
		char bs[50];
		sprintf(bs,"VVEVR%iD%i",nboRules,dRules);
		evResult.sort();
		makeData(evResult,bs);
		plotData(bs,74,"vertices","V",nboRules,"start rules and a area of 50 rules");
		plotData(bs,4,"atoms","A",nboRules,"start rules and a area of 50 rules");
		plotData(bs,1,"rules/atoms","RdA",nboRules,"start rules and a area of 50 rules");
	}
	evResult.clear();
}

//output data for one edges/vertices
for (unsigned int Faktor=1;Faktor<=20;Faktor+=1){
	for (nboVertices=2;nboVertices<=30;nboVertices+=dNboVertices){
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if((nboVertices==(itr->vertices))&&(((itr->edges)/(itr->vertices))==Faktor))
				{evResult.insert(evResult.end(),(*itr));break;}
		}
	}
	if(evResult.size()>5)
	{
		char bs[50];
		sprintf(bs,"VVEFVF%i",Faktor);
		evResult.sort();
		makeData(evResult,bs);
		plotData(bs,74,"vertices","V",Faktor,"faktor");
		plotData(bs,4,"atoms","A",Faktor,"faktor");
		plotData(bs,1,"rules/atoms","RdA",Faktor,"faktor");
	}
	evResult.clear();
}

for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
{
	if(((itr->averageRules)/(itr->averageAtoms)>=1.49)&&((itr->averageRules)/(itr->averageAtoms)<1.51)
		&&((itr->literals)>=1.1)&&((itr->literals)<1.15))
		{evResult.insert(evResult.end(),(*itr));}
}
if(evResult.size()>5)
{
	char bs[50];
	sprintf(bs,"VVEVA1k49L1k1");
	evResult.sort();
	makeData(evResult,bs);
	plotData(bs,74,"vertices","V",0,"");
	plotData(bs,4,"atoms","A",0,"");
	plotData(bs,1,"rules/atoms","RdA",0,"");
}
evResult.clear();

//output 3 dimensional graphs for testcases
{
	char bs[50];
	sprintf(bs,"D3VVEV");
	makeData(allResult,bs);
	if ((allResult.size()>10))
		{plotData3D(bs);plotData3DAR(bs);}
}
{
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->vertices<20)&&(itr->edges<100))
			{evResult.insert(evResult.end(),(*itr));}
	}
	if(evResult.size()>5)
	{
		char bs[50];
		sprintf(bs,"D3VVEVmV20mE100");
		evResult.sort();
		makeData(evResult,bs);
		plotData3D(bs);
		plotData3DAR(bs);
	}
}



cout<<endl;
}













