set terminal postscript
set contour base
set surface
set isosamples 30,150 #30,150
set data style lines
set dgrid3d 30,150,4
set nokey
set format xy "%g"
set output "./choices3D2.ps"
set title "average time for testcases with 2 literals per body"
set xlabel "rules r"
set ylabel "atoms a"
set zlabel "choices"

set xrange [0:1500]
set yrange [0:150]
quad(r,a)=(exp(log(a)*0.993692)*1.03722+exp(log(r)*0.961426)*-0.301179+(-17.7126))
o(r,a)=quad(r,a)*quad(r,a)*(-0.0010471)+r*(0.0196881)+-3.86751
f(r,a)=exp(log(2)*o(r,a))+r*(0.00606279)
splot "./data/DatFixBL2.txt" using 5:4:8



