/*File Name: create_plan.cpp
  Author: Bernd sterholz Mat Nr:706585
  System: C++

*/

//g++ -Wall -o create_plan create_plan.cpp
#include <string>
#include <list>
#include <iostream>


using namespace std;

//class for positions of the robots
class Position
{
	public:
	int x,y,time;//wher and when
	char robot[20];//wich robot(name string)
	Position():x(0),y(0),time(0),robot()
	{}

	bool equalRobot(Position pos)
	//returns true if the robot on the given position is the same as
	//the robot on this position, else false
	{
	bool b=true;
	for (int i=0;i<20;i++){b=b&&(robot[i]==pos.robot[i]);}
	return b;
	}

	bool operator<(Position pos )
	//returns true if the given position is earlier, else false
	{return time<pos.time;}
};

list<Position> plan;//the list of positions for a plan

FILE *in;//the input file
int PlanNummer;//the number of the actual plan

int charToInt(char c)
//makes the char c to a integer number
//pre: the char c
//post: the integer number the char c represents(e.g. "1"=1)
{
switch (c)
{
	case '0':return 0;
	case '1':return 1;
	case '2':return 2;
	case '3':return 3;
	case '4':return 4;
	case '5':return 5;
	case '6':return 6;
	case '7':return 7;
	case '8':return 8;
	case '9':return 9;
}
return -1;//error
}

void readc(char &c)
//read a carecter from the input string and returns it
{fread( &c, sizeof( char ), 1, in );}

void next()
//reads till the end of the actual predicate in the input file
{
char c='g';
while ((c!=')')&&(c!=':'))
{
	readc(c);
}
}

void readIsAt()
//reads the isAt predicate and store the values to the plan
{//t(rob,x,y,time)
Position pos;
char c='i';
while (c!='(')
{
	readc(c);
}
readc(c);
int i=0;
//read the position
//read robot name for position
while (c!=',')
{
	pos.robot[i]=c;
	i++;
	readc(c);
}
readc(c);
//read x position
while (c!=',')
{
	pos.x=pos.x*10+charToInt(c);
	readc(c);
}
readc(c);
//read y position
while (c!=',')
{
	pos.y=pos.y*10+charToInt(c);
	readc(c);
}
readc(c);
//read time of move
while (c!=')')
{
	pos.time=pos.time*10+charToInt(c);
	readc(c);
}
//insert the position in the plan
plan.insert(plan.end(),pos);
}

void writePlan()
//write the plan to the standartoutput
{
plan.sort();//sort the positions in the plan with the time
cout<<"Plan "<<PlanNummer<<"{\n";
list<Position>::iterator itr1=plan.begin(),itr2=plan.begin();
//as long as ther are positions in the plan write them
while (!plan.empty())
{
	itr1=plan.begin();
	itr2=plan.begin();
	itr2++;
	while (itr2!=plan.end())
	{
		if ((((((*itr1).time)+1)==((*itr2).time))&&((*itr1).equalRobot(*itr2)))
			&&((((*itr1).x)!=((*itr2).x))||(((*itr1).y)!=((*itr2).y))))//yust write if the robot has moved
		{
			//write data
			cout<<itr2->time<<". "<<itr1->robot<<" von ("<<flush;
			cout<<(*itr1).x<<","<<(*itr1).y<<") nach ("<<(*itr2).x<<","<<(*itr2).y<<");\n";
			break;
		}
		itr2++;//next position
	}
	plan.erase(itr1);
}
cout<<"}\n";
PlanNummer++;
}

void readAnswer()
//read the next Answer
{//t(rob,time)
//if ther is a plan write it
if (!(plan.empty()))
{	writePlan();
	plan.clear();//empty plan
}
char c;
readc(c);
while (c!='\n')
{
	readc(c);
}
}

int main(int argc, char* argv[])
{
PlanNummer=1;//number of the plan is first plan
if ((in = fopen( argv[1], "r+" )) != NULL ){//open input file if posible
	char c;
	bool endof=true;
	for (int i=0;i<=36;i++){readc(c);}//read first line
	//read the predicates and text from the input file
	while (endof)
	{
		readc(c);
		switch(c)
		{
		case 'F'://False
			endof=false;
			break;
		case 'D'://Duration
			endof=false;
			break;
		case 'T'://True
			readc(c);//r
			readc(c);//u
			readc(c);//e
			readc(c);//newline
			break;
		case 'A'://Answer
			readAnswer();;
			break;
		case 't'://time
			next();
			break;
		case 'r':
			readc(c);
			if (c=='i')//right
				{next();}
			else{next();}//robot
			break;
		case 'i':
			readc(c);//s
			readc(c);
			if (c=='A')//isAt
				{readIsAt();}
			else{next();}//isBlockedR;isBlocked
			break;
		case 'f'://free
			next();
			break;
		case 'u'://up
			next();
			break;
		case 'd'://up
			next();
			break;
		case 'l'://up
			next();
			break;
		case 'B'://Blocked
			next();
			break;
		case 's':
			readc(c);
			if (c=='t')
			{	readc(c);
				if (c=='o')//stop
				{next();}
			}
			break;
		case 'S'://Stable model:
			next();
			break;
		default:
			break;

		}
}
fclose( in );
}
//write the last plan if exsists
if (!(plan.empty()))
{	writePlan();
	plan.clear();
}

};
