//	g++ -Wall -g -o grr genRR.cpp
//generates random filds for the racing robots problem
/*File Name: genRR.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <set>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"

using namespace std;

TRandomMersenne *rg1;

class TRobot {
public:
	unsigned int x;
	unsigned int y;
	bool operator<(const TRobot rob) const
	{
		return ((x<rob.x)||((x==rob.x)&&(y<rob.y)));
	}
	bool operator==(const TRobot rob) const
	{
		return ((x==rob.x)&&(y==rob.y));
	}
};

class TWall {
public:
	unsigned int x;
	unsigned int y;
	bool horizontal;
	bool operator<(const TWall wall) const
	{
		return ((x<wall.x)||((x==wall.x)&&(y<wall.y))||((x==wall.x)&&(y==wall.y)&&(!horizontal)&&(wall.horizontal)));
	}
	bool operator==(const TWall wall) const
	{
		return ((x==wall.x)&&(y==wall.y));
	}
};

void evOutput(ofstream *ostream,unsigned int num,double literals)
{
char c;
unsigned int answer,choice,wchoice,trueAS,atoms,rules,searchSp;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';i=0;
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		answer=1;
	}else{//no Answer
		answer=0;
	}
	i=0;
	c='A';
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	(*tstream)>>wchoice;
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	i=0;
	(*tstream)>>atoms;
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	(*tstream)>>rules;
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	(*tstream)>>trueAS;
	while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}};c='A';
	(*tstream)>>searchSp;

//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<wchoice<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<";"<<literals<<"  |"<<endl;
	delete tstream;
}
else
	printf( "Problem opening the file\n" );
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}

double evalueLiterals()
/*evalue the average number of literals per rule body literals in the lparse
file ./tprog.lp*/
{
double literals=0.0;
unsigned int nbORules=0;
ifstream *stream=new ifstream("./tprog.lp");
unsigned int z,bodyAtoms,negB;
//read rules
while (true)
{
	(*stream)>>z;
//	cout<<z<<flush;
	if ((z==0)||(nbORules>1000000)) {break;}
	if (z==3)
		{(*stream)>>z;}
	nbORules++;
	(*stream)>>negB;//read head
	(*stream)>>bodyAtoms;
	(*stream)>>negB;//negativ body literals
	if (z==2)
		{(*stream)>>z;}
//	cout<<" "<<z<<" "<<bodyAtoms<<" "<<negB<<flush<<endl;
	//read body
	literals+=bodyAtoms;
	for (unsigned int i=0;i<bodyAtoms;i++)
		{(*stream)>>z;}
}
delete stream;
return double(literals)/double(nbORules);
}

void evResult(char* folder,char* output,unsigned int nOExamples)
{
ofstream *ostream=new ofstream(output);
(*ostream)<<"smodels-2.28"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;
double literals=0.0;
if( ostream!= NULL )
{
	for (unsigned int i=0;i<nOExamples;i++)
	{
		char ev[100];
		sprintf(ev,"(~/wv/lparse-1.0.13/src/lparse ./rr.lp ./%s/b%i.lp )> ./tprog.lp ",folder,i);
		literals=evalueLiterals();
//		sprintf(ev,"(lparse ./rr.lp ./%s/b%i.lp | smodels )>tmp.txt",folder,i);
		cout<<ev<<endl;
		system(ev);
		char ev2[100];
		sprintf(ev2,"(~/wv/lparse-1.0.13/src/lparse ./rr.lp ./%s/b%i.lp | ~/wv/smodels-2.28/smodels )>tmp.txt",folder,i);
		cout<<ev2<<endl;
		system(ev2);
		evOutput(ostream,i,literals);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else
	printf( "Problem opening the file\n" );
}


void printProgram(char* fname, set<TRobot> robots,set<TWall> walls,set<TRobot> endRobots,unsigned int dim,unsigned int time)
{
/* Open file in text mode: */
ofstream *stream=new ofstream(fname);
if( stream!= NULL )
{
	//read range(dimension) block
	(*stream)<<"fild(0.."<<dim<<").\n";
	(*stream)<<"time(0.."<<time<<").\n";
	for (set<TWall>::iterator itr=walls.begin();itr!=walls.end();itr++)
	{
		if (itr->horizontal)
			{(*stream)<<"blocked("<<itr->x<<","<<itr->y<<","<<(itr->x)+1<<","<<itr->y<<").\n"<<endl;}
		else{(*stream)<<"blocked("<<itr->x<<","<<itr->y<<","<<itr->x<<","<<(itr->y)+1<<").\n"<<endl;}
	}
	unsigned int robCount=0;
	for (set<TRobot>::iterator itr=robots.begin();itr!=robots.end();itr++)
	{
		(*stream)<<"robot(r"<<robCount<<"). \nisAt(r"<<robCount<<","<<itr->x<<","<<itr->y<<",0).\n"<<endl;
		robCount++;
	}
	robCount=0;
	(*stream)<<"compute 1 {\n";//compute 0 for all 1
	for (set<TRobot>::iterator itr=endRobots.begin();itr!=endRobots.end();itr++)
	{
		(*stream)<<"isAt(r"<<robCount<<","<<itr->x<<","<<itr->y<<","<<time<<")\n"<<endl;
		robCount++;
	}
	(*stream)<<"}."<<endl;
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}

set<TRobot > generateRRR1(unsigned int dim,unsigned int nORobots)
//generates the start positions of the robots
//pre:dimension of the field and the number of the robots
{
set<TRobot> robots;
TRobot rob;
unsigned int max=0;
//fix lenght modell
while (robots.size()<nORobots)
{
	rob.x=(unsigned int)(rg1->Random()*dim);
	rob.y=(unsigned int)(rg1->Random()*dim);
	robots.insert(robots.end(),rob);
	max++;//don`t go infinum
	if (max>10*dim*dim) {break;}
}
return robots;
}

set<TWall > generateRRW1(unsigned int dim,unsigned int nOWalls)
//generates the walls positions
//pre: the dimension of the fild, and the number of walls on it
{
set<TWall> walls;
TWall wall;
unsigned int max=0;
//fix lenght modell
while (walls.size()<nOWalls)
{
	wall.x=(unsigned int)(rg1->Random()*dim);
	wall.y=(unsigned int)(rg1->Random()*dim);
	wall.horizontal=(rg1->Random()<0.5);
	walls.insert(walls.end(),wall);
	max++;//don`t go infinum
	if (max>10*dim*dim) {break;}
}
return walls;
}

set<TRobot > generateRRRD1(unsigned int dim,unsigned int nORobots)
//generates the end position of a/the robots
{
set<TRobot> robots;
TRobot rob;
unsigned int max=0;
//fix lenght modell
while (robots.size()<nORobots)
{
	rob.x=(unsigned int)(rg1->Random()*dim);
	rob.y=(unsigned int)(rg1->Random()*dim);
	robots.insert(robots.end(),rob);
	max++;//don`t go infinum
	if (max>10*dim*dim) {break;}
}
return robots;
}

void generateTestCase1(unsigned int dim,unsigned int walls,unsigned int robots,unsigned int time,unsigned int endRobots,unsigned int nboPrograms)
{

// Open testcase file in text mode:
char tcfile[100];
sprintf(tcfile,"./gD%iW%iR%iT%i/atestc.sweets",dim, walls,robots,time);
ofstream *stream=new ofstream(tcfile);
if( stream!= NULL )
{
	for (unsigned int i=0;i<nboPrograms;i++)
	{
		//output for testcase file
		(*stream)<<"problem(b"<<i<<".lp)"<<endl;
		(*stream)<<"options(0)"<<endl;
		(*stream)<<"files(b"<<i<<".lp)"<<endl<<endl;
		//output for the logic program
		char file[100];
		sprintf(file,"./gD%iW%iR%iT%i/b%i.lp",dim, walls,robots,time,i);

		printProgram(file,generateRRR1(dim,robots),generateRRW1(dim,walls),generateRRRD1(dim,endRobots),dim,time);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;

unsigned int dim=0, walls=0,robots=0,time=0;

/* load last end point as start point */
ifstream *stream=new ifstream("tdRR.txt");


int ret=0;
while(true)
{
	if( stream!= NULL )
	{
		char ch;
		(*stream)>>dim;
		(*stream)>>ch;
		if (ch=='.') {break;}
		(*stream)>>walls;
		(*stream)>>ch;
		(*stream)>>robots;
		(*stream)>>ch;
		(*stream)>>time;
		(*stream)>>ch;
		cout<<"point :"<<endl<<" dimension : "<<dim<<" walls : "<< walls<<" robots"<<robots<<" time : "<<time<<endl<<endl;
	} else {printf( "Problem opening the file\n" );}

	//save this point as last end state
	ofstream *ostream=new ofstream("spRR.txt");
	if( stream!= NULL )
	{
		(*ostream)<<dim<<";"<<walls<<";"<<robots<<";"<<time<<";"<<endl;
		delete ostream;
	} else {printf( "Problem opening the file\n" );}
		//make direktory
	char b[20];
	sprintf(b,"mkdir gD%iW%iR%iT%i",dim, walls,robots,time);
	cout<<b<<endl;
	system(b);
	//unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,int nboPrograms
	generateTestCase1(dim, walls,robots,time,1,1000);
	//go into directory; execute BMTool; delete testcase
	char folder[40],result[40];
	sprintf(folder,"gD%iW%iR%iT%i",dim, walls,robots,time);
	sprintf(result,"./ergebnisse/gD%iW%iR%iT%i.txt",dim, walls,robots,time);
	evResult(folder,result,1000);
	char rmf[20];
	sprintf(rmf,"rm ./gD%iW%iR%iT%i/*.*",dim, walls,robots,time);
	cout<<rmf<<endl;
	system(rmf);
	char rmd[20];
	sprintf(rmd,"rmdir gD%iW%iR%iT%i",dim, walls,robots,time);
	system(rmd);//delete testcasedir
	if (WIFSIGNALED(ret)) {break;}
}
if( stream!= NULL ){delete stream;}
cout<<endl;
}


