//	g++ -Wall -g -o evp evaluatorPoint.cpp
/*File Name: evaluatorAll.cpp
  Author: Bernd sterholz ; Date: 10.04.2005
  System: C++


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This programm generates graphs and tables for the answerset testcases,
wich results are in the BMTool output form.
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>


using namespace std;

class TData {
/*This class is to store the values of one example.*/
public:
	double time;
	unsigned int choice;
	unsigned int wchoice;
	unsigned int answer;
	unsigned int trueAss;
	unsigned int atoms;
	unsigned int rules;
	bool operator<(const TData tdat) const
	{
		return (time<tdat.time);
	}
	bool static lowerChoice(const TData tdat1,const TData tdat2)
	{
		return (tdat1.choice<tdat2.choice);
	}
	bool static lowerWChoice(const TData tdat1,const TData tdat2)
	{
		return (tdat1.wchoice<tdat2.wchoice);
	}
	bool static lowerChoiceDTime(const TData tdat1,const TData tdat2)
	{
		return ((double(tdat1.choice)/(tdat1.time))<(double(tdat2.choice)/(tdat2.time)));
	}
	bool static lowerWChoiceDTime(const TData tdat1,const TData tdat2)
	{
		return ((double(tdat1.wchoice)/(tdat1.time))<(double(tdat2.wchoice)/(tdat2.time)));
	}

};

list<TData> dataL;

list<TData> readData(char* file)
/*This method reads the data of one testcase and store it to a list of TData
pre: the name of the file wher the data of the testcase is stored in the
	BMTool output form
post: the TData list with the readed values*/
{
list<TData> tmpDataL;
char c=' ';
unsigned int i;
char name[100];
TData dat;
dat.time=0.0;
dat.choice=0;
dat.wchoice=0;
dat.answer=0;
dat.trueAss=0;
dat.atoms=0;
dat.rules=0;
char ls[100];

sprintf(ls,"ls %s",file);
int existsT=system(ls);//test if ther exists such file
if (existsT!=0){return tmpDataL;}

ifstream *stream=new ifstream(file);
if( stream!= NULL )
{
	//read first part till the first data set
	i=0;
	while (c!='|')
	{
		(*stream)>>c;
		if (!((c=='|')||(c==' '))) {name[i]=c;i++;}
	}
	name[i+1]=0;
	cout<<name<<endl<<flush;
	(*stream)>>c;
	while (c!='|'){(*stream)>>c;}
	while (c!='l'){(*stream)>>c;}
	//read line
	while (true)
	{
		c='a';
		//read till the first values of the data begin
		while (!((c=='|')||(c=='-'))){(*stream)>>c;}
		if (c=='-'){break;}
		(*stream)>>dat.time;
		(*stream)>>c;//read ';'
		(*stream)>>dat.choice;
		(*stream)>>c;//read ';'
		(*stream)>>dat.wchoice;
		(*stream)>>c;//read ';'
		(*stream)>>c;
		if(c=='1')//read if ther is a answer
		{
			dat.answer=1;
		}else{//"NV"
			dat.answer=0;
			(*stream)>>c;
		}
		(*stream)>>c;//read ';'
		//optional part, the next values are not nessesarry in ale testcases
		if ((c==';')||(c==','))
		{
			(*stream)>>dat.trueAss;
			(*stream)>>c;//read ';'
			if ((c==';')||(c==','))
			{
				(*stream)>>dat.atoms;
				(*stream)>>c;//read ';'
					if ((c==';')||(c==','))
					{
						(*stream)>>dat.rules;
						(*stream)>>c;//read ';'
		}}}
		while (c!='|'){(*stream)>>c;}

//		cout<<dat.time<<";"<<dat.choice<<";"<<dat.wchoice<<";"<<dat.answer;
//		cout<<";"<<dat.trueAss<<";"<<dat.atoms<<";"<<dat.rules<<endl;
		tmpDataL.insert(tmpDataL.end(),dat);
	}
	delete stream;
}
else
	{printf( "Problem opening the file\n" );}
return tmpDataL;
}


void evalueData(const unsigned int wich,unsigned int distance,unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double till)
{
list<TData>::iterator itr;
unsigned int maxNum=0;
if(wich==0)
{
	dataL.sort();
	itr=dataL.end();itr--;
	maxNum=(unsigned int)(itr->time*100.0);
}
if(wich==1)
{
	dataL.sort(&TData::lowerChoice);
	itr=dataL.end();itr--;
	maxNum=itr->choice;
}
if(wich==2)
{
	dataL.sort(&TData::lowerWChoice);
	itr=dataL.end();itr--;
	maxNum=itr->wchoice;
}
if(wich==3)
{
	dataL.sort(&TData::lowerChoiceDTime);
	itr=dataL.end();itr--;
	maxNum=(unsigned int)(double(itr->choice)/(itr->time));
}
if(wich==4)
{
	dataL.sort(&TData::lowerWChoiceDTime);
	itr=dataL.end();itr--;
	maxNum=(unsigned int)(double(itr->wchoice)/(itr->time));
}

cout<<wich<<" : "<<maxNum<<endl;

if (maxNum/distance>0)
{
	cout<<"classes : "<<maxNum/distance<<endl;
	unsigned int classes[maxNum/distance+1];
	for (unsigned int i=0;i<maxNum/distance+1;i++)
		{classes[i]=0;}
	for (itr=dataL.begin();itr!=dataL.end();itr++)
	{
		if(wich==0){classes[(unsigned int)(itr->time*100.0)/distance]++;}
		if(wich==1){classes[(itr->choice)/distance]++;}
		if(wich==2){classes[(itr->wchoice)/distance]++;}
		if(wich==3){classes[(unsigned int)((double(itr->choice)/(itr->time)))/distance]++;}
		if(wich==4){classes[(unsigned int)((double(itr->wchoice)/(itr->time)))/distance]++;}
	}
	char outf[100];
	if(wich==0){sprintf(outf,"./tabellen/clTimeD%iA%iL%iC%i.txt",distance,nboAtoms,nboLiteralsPerClause,nboClause);}
	if(wich==1){sprintf(outf,"./tabellen/clChoiceD%iA%iL%iC%i.txt",distance,nboAtoms,nboLiteralsPerClause,nboClause);}
	if(wich==2){sprintf(outf,"./tabellen/clWChoiceD%iA%iL%iC%i.txt",distance,nboAtoms,nboLiteralsPerClause,nboClause);}
	if(wich==3){sprintf(outf,"./tabellen/clChoiceDTimeD%iA%iL%iC%i.txt",distance,nboAtoms,nboLiteralsPerClause,nboClause);}
	if(wich==4){sprintf(outf,"./tabellen/clWChoiceDTimeD%iA%iL%iC%i.txt",distance,nboAtoms,nboLiteralsPerClause,nboClause);}
	ofstream *stream=new ofstream(outf);
	if(wich==0){
		for (unsigned int i=0;i<maxNum/distance+1;i++)
			{(*stream)<<double(i*distance)/100.0<<" "<<classes[i]<<endl;}
	}
	if(wich>=1){
		for (unsigned int i=0;i<maxNum/distance+1;i++)
			{(*stream)<<(i*distance)<<" "<<classes[i]<<endl;}
	}
	stream->close();
	char mkdir[100];
	sprintf(mkdir,"mkdir ./tabellen/grA%iL%iC%i",nboAtoms,nboLiteralsPerClause,nboClause);
	system(mkdir);

	stream=new ofstream("./graph.gp");
	(*stream)<<"set terminal postscript"<<endl<<"set data style boxes"<<endl;
	(*stream)<<"set nokey"<<endl<<"set format xy \"%g\""<<endl;
	(*stream)<<"set title \"classes of ";

	if(wich==0){(*stream)<<"time\""<<endl<<"set xlabel \"time\""<<endl<<"set ylabel \"time s\""<<endl;}
	if(wich==1){(*stream)<<"choice points\""<<endl<<"set xlabel \"choice points\""<<endl<<"set ylabel \"number\""<<endl;}
	if(wich==2){(*stream)<<"wrong choices\""<<endl<<"set xlabel \"wrong choices\""<<endl<<"set ylabel \"number\""<<endl;}
	if(wich==3){(*stream)<<"choice points/time\""<<endl<<"set xlabel \"choice point/time\""<<endl<<"set ylabel \"number/time 1/s\""<<endl;}
	if(wich==4){(*stream)<<"wrong choices/time\""<<endl<<"set xlabel \"wrong choices/time\""<<endl<<"set ylabel \"number/time 1/s\""<<endl;}

	(*stream)<<"set output \"./tabellen/grA"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause;
	if(wich==0){(*stream)<<"/clTime";}
	if(wich==1){(*stream)<<"/clChoice";}
	if(wich==2){(*stream)<<"/clWChoice";}
	if(wich==3){(*stream)<<"/clChoiceDTime";}
	if(wich==4){(*stream)<<"/clWChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<".ps\""<<endl;
	(*stream)<<"plot \"./tabellen/cl";
	if(wich==0){(*stream)<<"Time";}
	if(wich==1){(*stream)<<"Choice";}
	if(wich==2){(*stream)<<"WChoice";}
	if(wich==3){(*stream)<<"ChoiceDTime";}
	if(wich==4){(*stream)<<"WChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<".txt\" using 1:2"<<endl;

	(*stream)<<"set output \"./tabellen/grA"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause;
	if(wich==0){(*stream)<<"/clTime";}
	if(wich==1){(*stream)<<"/clChoice";}
	if(wich==2){(*stream)<<"/clWChoice";}
	if(wich==3){(*stream)<<"/clChoiceDTime";}
	if(wich==4){(*stream)<<"/clWChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<"R"<<till<<".ps\""<<endl;
	(*stream)<<"plot [0:"<<till<<"] \"./tabellen/cl";
	if(wich==0){(*stream)<<"Time";}
	if(wich==1){(*stream)<<"Choice";}
	if(wich==2){(*stream)<<"WChoice";}
	if(wich==3){(*stream)<<"ChoiceDTime";}
	if(wich==4){(*stream)<<"WChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms <<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<".txt\" using 1:2"<<endl;

	(*stream)<<"set logscale y"<<endl;
	(*stream)<<"set output \"./tabellen/grA"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause;
	if(wich==0){(*stream)<<"/clTime";}
	if(wich==1){(*stream)<<"/clChoice";}
	if(wich==2){(*stream)<<"/clWChoice";}
	if(wich==3){(*stream)<<"/clChoiceDTime";}
	if(wich==4){(*stream)<<"/clWChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<"_log.ps\""<<endl;
	(*stream)<<"plot \"./tabellen/cl";
	if(wich==0){(*stream)<<"Time";}
	if(wich==1){(*stream)<<"Choice";}
	if(wich==2){(*stream)<<"WChoice";}
	if(wich==3){(*stream)<<"ChoiceDTime";}
	if(wich==4){(*stream)<<"WChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<".txt\" using 1:2"<<endl;

	(*stream)<<"set output \"./tabellen/grA"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause;
	if(wich==0){(*stream)<<"/clTime";}
	if(wich==1){(*stream)<<"/clChoice";}
	if(wich==2){(*stream)<<"/clWChoice";}
	if(wich==3){(*stream)<<"/clChoiceDTime";}
	if(wich==4){(*stream)<<"/clWChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms<<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<"R"<<till<<"_log.ps\""<<endl;
	(*stream)<<"plot [0:"<<till<<"] \"./tabellen/cl";
	if(wich==0){(*stream)<<"Time";}
	if(wich==1){(*stream)<<"Choice";}
	if(wich==2){(*stream)<<"WChoice";}
	if(wich==3){(*stream)<<"ChoiceDTime";}
	if(wich==4){(*stream)<<"WChoiceDTime";}
	(*stream)<<"D"<<distance<<"A"<<nboAtoms <<"L"<<nboLiteralsPerClause<<"C"<<nboClause<<".txt\" using 1:2"<<endl;
	stream->close();
	delete stream;

	system("gnuplot graph.gp");

}
}

int main()
/*with this programm results for the testcases are evaluet and outputed as
tables for excel import and graphs generated with gnuplot*/
{
unsigned int nboAtoms=150, nboLiteralsPerClause=2, nboClause=750;
char file[100];
sprintf(file,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
dataL=readData(file);

evalueData(0,1,nboAtoms,nboLiteralsPerClause,nboClause,5);
evalueData(1,1,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(2,1,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(3,1,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(4,1,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(0,10,nboAtoms,nboLiteralsPerClause,nboClause,5);
evalueData(1,10,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(2,10,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(3,10,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(4,10,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(0,50,nboAtoms,nboLiteralsPerClause,nboClause,5);
evalueData(1,50,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(2,50,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(3,50,nboAtoms,nboLiteralsPerClause,nboClause,500);
evalueData(4,50,nboAtoms,nboLiteralsPerClause,nboClause,500);

cout<<endl;
}













