//	g++ -Wall -g -o gen generator.cpp
/*File Name: generator.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"

using namespace std;

TRandomMersenne *rg1;


void evOutput(ofstream *ostream,unsigned int num)
{
char c;
unsigned int answer,choice,wchoice,trueAS,atoms,rules,searchSp;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}c='A';
		i=0;
		while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}c='A';
		answer=1;
	}else{//no Answer
		answer=0;
	}
	c='A';i=0;
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>wchoice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>atoms;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>rules;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>trueAS;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>searchSp;

//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<wchoice<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<"  |"<<endl;
	delete tstream;
}
else
	printf( "Problem opening the file\n" );
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}


//first half of literals are positiv atoms next half are ther negativ
void printClausel(ofstream *outstr,list <unsigned int> literale,unsigned int nboAtoms)
{
unsigned int size=literale.size();//number of literals= two times number of atoms
//print head of clause
if (*(literale.begin())<nboAtoms)
	{(*outstr)<<"a"<<(*(literale.begin()))<<":-";}
else{(*outstr)<<":-";}//clausel is a constrain
//print body of clause

list<unsigned int>::iterator itr=literale.begin();
itr++;
for (unsigned int i=0;i<size-2;i++)
{
	if ((*itr)<nboAtoms)
		{(*outstr)<<"a"<<(*itr)<<",";}
	else{(*outstr)<<"not a"<<((*itr)-(nboAtoms))<<",";}
	itr++;
}
//print end of clause
if (*(itr)<nboAtoms)
	{(*outstr)<<"a"<<(*(itr))<<"."<<endl;}
else{(*outstr)<<"not a"<<(*(itr)-nboAtoms)<<"."<<endl;}
}

list<list <unsigned int> > generateProgram1(list<double> headProb,list<double> bodyProb, unsigned int nboClause, unsigned int nboLiteralsPerClause)
//headProb.end()--=probability of constraints
{
list<list <unsigned int> > program;
unsigned int tmp;//temporary variables
double rand;
//fix lenght modell
for (unsigned int c=0;c<nboClause;c++)
{
	list <unsigned int> clause;//temporary variables
	//choos head
	rand=rg1->Random();

	tmp=0;
	for (list<double>::iterator itr=headProb.begin();itr!=headProb.end();itr++)
	{
		if(rand<(*itr)){break;}
		rand-=(*itr);
		tmp++;
	}

//	cout<<"a"<<tmp<<":-";
	clause.insert(clause.end(),tmp);
	//choos literals; doubles allowed
	for (unsigned int l=0;l<nboLiteralsPerClause;l++)
	{
		rand=rg1->Random();
		tmp=0;
		for (list<double>::iterator itr=bodyProb.begin();itr!=bodyProb.end();itr++)
		{
			if(rand<(*itr)){break;}
			rand-=(*itr);
			tmp++;
		}

//		cout<<"a"<<tmp<<",";
		clause.insert(clause.end(),tmp);
	}

//	cout<<endl;
	program.insert(program.end(),clause);
}

return program;
}

void printProgram(char* fname,list<list <unsigned int> > program,unsigned int nboAtoms)
{
/* Open file in text mode: */
ofstream *stream=new ofstream(fname);
if( stream!= NULL )
{
	for (list<list <unsigned int> >::iterator itr=program.begin();itr!=program.end();itr++)
	{
		printClausel(stream,*itr,nboAtoms);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}


int evResult(char* output,unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,unsigned int nOExamples)
{
list<double> headProb,bodyProb;
for (unsigned int i=0;i<nboAtoms;i++)
{
	headProb.insert(headProb.end(),(1.0-constrProb)/nboAtoms);
//	cout<<(1.0-constrProb)/nboAtoms<<"   ";
}
headProb.insert(headProb.end(),constrProb);//probability of constrains
//cout<<endl;

for (unsigned int i=0;i<(nboAtoms*2);i++)
{
	bodyProb.insert(bodyProb.end(),1.0/(nboAtoms*2));
//	cout<<1.0/(nboAtoms*2)<<"   ";
}
int ret;
ofstream *ostream=new ofstream(output);
(*ostream)<<"smodels-2.27"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;

if( ostream!= NULL )
{
	for (unsigned int i=0;i<nOExamples;i++)
	{
		printProgram("./tmp_prog.lp",generateProgram1(headProb,bodyProb,nboClause, nboLiteralsPerClause),nboAtoms);
		char ev[100];
		sprintf(ev,"(lparse ./tmp_prog.lp | smodels)>tmp.txt");
//		sprintf(ev,"(lparse ./%s/b%i.lp | smodels)>tmp.txt",folder,i);
		cout<<i<<" :"<<ev<<endl;
		ret=system(ev);
		if (WIFSIGNALED(ret)) break;
		evOutput(ostream,i);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else{printf( "Problem opening the file\n" );}
return ret;
}



int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;
/* load last end point as start point */
evResult("./ergebnisse/atwA150L3C1500.txt",150,3,1500,0.0,1000000);
cout<<endl;
}
















