//	g++ -Wall -g -o ev evaluatorAll.cpp
/*File Name: evaluatorAll.cpp
  Author: Bernd Oesterholz ; Date: 10.04.2005
  System: C++


  Copyright (C) 2004  Bernd ?sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This programm generates graphs and tables for the answerset testcases,
wich results are in the BMTool output form.
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>


using namespace std;

#include "evalueAllIO.cpp"


int main()
/*with this programm results for the testcases are evaluet and outputed as
tables for excel import and graphs generated with gnuplot*/
{
list<TDResult> allResult;
unsigned int nboAtoms, nboLiteralsPerClause, nboClause;
int existsT;
//maximal values to wich the testcases should be readed
unsigned int maxNboAtoms=200, maxNboLiteralsPerClause=6, maxNboClause=5000;//1000;100;5000?
unsigned int minNboLiteralsPerClause=1;//2
//delta values
unsigned int dNboAtoms=10, dNboLiteralsPerClause=1, dNboClause=100;//10;2;100

//read Data
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
for (nboAtoms=10;nboAtoms<=maxNboAtoms;nboAtoms+=dNboAtoms){//5..150
	char lsa[50];
	sprintf(lsa,"(ls ./ergebnisse/atwA%iL%iC*.txt) > tmp.txt",nboAtoms,nboLiteralsPerClause);
	existsT=system(lsa);
	if (existsT==0)//if existsT==0 the ther exists a test
	{
	for (nboClause=100;nboClause<=maxNboClause;nboClause+=dNboClause){//10..1500 +10
		char ls[50];
		sprintf(ls,"ls ./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
		existsT=system(ls);
		if (existsT==0)//if existsT==0 the ther exists a test
		{
			char file[50];
			sprintf(file,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
			allResult.insert(allResult.end(),evalueResult(file,nboAtoms,nboClause,nboLiteralsPerClause));
		}
	}}
}
}


//evalue data
list<TDResult> evResult;

//output data for one atom value, the rules are the x values in the graphs
for (nboAtoms=10;nboAtoms<=300;nboAtoms+=dNboAtoms){//5..150
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if((itr->atoms==nboAtoms)&&(itr->literals==nboLiteralsPerClause))
				{evResult.insert(evResult.end(),(*itr));}
		}
		if(evResult.size()>5)
		{
			char bs[50];
			sprintf(bs,"L%iA%iCV",nboLiteralsPerClause,nboAtoms);
			makeData(evResult,bs);
			plotData(bs,1,"rules/atoms R/A","RdA",nboAtoms,"atoms",nboLiteralsPerClause);
			plotData(bs,5,"rules R","R",nboAtoms,"atoms",nboLiteralsPerClause);
		}
		evResult.clear();
}}
//output data for one rule value, the atoms are the x values in the graphs
for (nboClause=100;nboClause<=3000;nboClause+=dNboClause){//5..150
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if((itr->rules==nboClause)&&(itr->literals==nboLiteralsPerClause))
				{evResult.insert(evResult.end(),(*itr));}
		}
		if(evResult.size()>5)
		{
			char bs[50];
			sprintf(bs,"L%iAVC%i",nboLiteralsPerClause,nboClause);
			makeData(evResult,bs);
			plotData(bs,1,"rules/atoms R/A","RdA",nboClause,"rules",nboLiteralsPerClause);
			plotData(bs,4,"atoms A","A",nboClause,"rules",nboLiteralsPerClause);
		}
		evResult.clear();
}}
//output data for one Faktor value, the rules or atoms are the x values in the graphs
//rules * atoms=Faktor
for (double Faktor=1.0;Faktor<=15.0;Faktor+=1.0){//5..150
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if(((double(itr->rules)/double(itr->atoms))==Faktor)&&(itr->literals==nboLiteralsPerClause))
				{evResult.insert(evResult.end(),(*itr));}
		}
		if(evResult.size()>5)
		{
			char bs[50];
			sprintf(bs,"L%iAVCFxAF%i",nboLiteralsPerClause,int(Faktor));
			makeData(evResult,bs);
			plotData(bs,5,"rules R","R",(int)Faktor,"factor",nboLiteralsPerClause);
			plotData(bs,4,"atoms A","A",(int)Faktor,"factor",nboLiteralsPerClause);
		}
		evResult.clear();
}}

//output 3 dimensional graphs for testcases
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if(itr->literals==nboLiteralsPerClause)
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	if ((evResult.size()>100))
		{plotData3DAtoms(evResult,bs);}
	evResult.clear();
}

for (nboAtoms=10;nboAtoms<=300;nboAtoms+=10){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if(itr->atoms==nboAtoms)
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3LVA%iCV",nboAtoms);
	if ((evResult.size()>100))
		{plotData3DLiterals(evResult,bs);}
	evResult.clear();
}


char b[20];
sprintf(b,"mkdir ./tabellen/tabelsLV");
system(b);

for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->literals==nboLiteralsPerClause))
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	makeData3D(evResult,bs);
	evResult.clear();
}
for (nboAtoms=10;nboAtoms<=300;nboAtoms+=10){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->atoms==nboAtoms))
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	makeData3D(evResult,bs);
	evResult.clear();
}

cout<<endl;
}













