//	g++ -Wall -g -o evt evaluatorAllT.cpp
/*File Name: evaluatorAllT.cpp
  Author: Bernd sterholz ; Date: 10.04.2005
  System: C++


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This programm generates tables for the answerset testcases,
wich results are in the BMTool output form.
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>


using namespace std;

class TData {
/*This class is to store the values of one example.*/
public:
	double time;
	unsigned int choice;
	unsigned int wchoice;
	unsigned int answer;
	unsigned int trueAss;
	unsigned int atoms;
	unsigned int rules;
	bool operator<(const TData tdat) const
	{
		return (time<tdat.time);
	}
};

class TDResult
{
/*This class is to store the evaluate results values of one testcase.*/
public:
	char name[100];//name of the testcase
	unsigned int literals;//literals parameter of the generator
	unsigned int atoms;//atoms parameter of the generator
	unsigned int rules;//rules parameter of the generator
	unsigned int examples;//examples in the testcase
	double avTime;//average time
	double avSearchSp;//average search space
	double avChoice;//average choice
	unsigned int posExamples;//positive examples
	double posAvTime;//average time of positive examples
	double posAvSearchSp;//average search space of positive examples
	double posAvChoice;//average choice of positive examples
	unsigned int negExamples;//negative examples
	double negAvTime;//average time of negative examples
	double negAvSearchSp;//average search space of negative examples
	double negAvChoice;//average choice of negative examples
	double minTime;//minimal time
	double maxTime[10];//maximal time of the classes with 10 per cent of examples
	//, which are the next better after maxTime[n-1](btw if n=0 minTime)
	unsigned int minSearchSp;//minimal search space
	unsigned int maxSearchSp;//maximal search space
	double clAvTime[10];//average time of the classes with 10 per cent of examples
	double timeSpread;//spread of the time values
	double searchSpSpread;//spread of the search space values
	double timeVarianz;//time varianz
	double choiceVarianz;//choice point varianze
	double searchSpVarianz;//search space varianz
/*	double timeMean;//time mean (Streuung)
	double searchSpMean;//search space mean (Streuung)
*/	double averageAtoms;//average atoms of the testcase
	double averageRules;//average rules of the testcase
	double avCTQutient;//average choise/time qutient
	double cTQutientVarianz;//average choise/time qutient varianze

	double avWChoice;//average wrong choices
	double wChoiceVarianc;//varianc of the wrong choicese

	bool operator<(const TDResult tres) const
	/*the lower realtion for TDResult
	to order the TDResults, first coms the literals, then the atoms and then
	the rules
	pre: two TDResult
	post: true if first TDResult is lower than the secound, else false*/
	{
	return ((literals<tres.literals)||
		((literals==tres.literals)&&((atoms<tres.atoms)||
		((atoms==tres.atoms)&&(rules<tres.rules)))));
	}
};

list<TData> readData(char* file)
/*This method reads the data of one testcase and store it to a list of TData
pre: the name of the file wher the data of the testcase is stored in the
	BMTool output form
post: the TData list with the readed values*/
{
list<TData> tmpDataL;
char c=' ';
unsigned int i;
char name[100];
TData dat;
dat.time=0.0;
dat.choice=0;
dat.wchoice=0;
dat.answer=0;
dat.trueAss=0;
dat.atoms=0;
dat.rules=0;
char ls[100];

sprintf(ls,"ls %s",file);
int existsT=system(ls);//test if ther exists such file
if (existsT!=0){return tmpDataL;}

ifstream *stream=new ifstream(file);
if( stream!= NULL )
{
	//read first part till the first data set
	i=0;
	while (c!='|')
	{
		(*stream)>>c;
		if (!((c=='|')||(c==' '))) {name[i]=c;i++;}
	}
	name[i+1]=0;
	cout<<name<<endl<<flush;
	(*stream)>>c;
	while (c!='|'){(*stream)>>c;}
	while (c!='l'){(*stream)>>c;}
	//read line
	while (true)
	{
		c='a';
		//read till the first values of the data begin
		while (!((c=='|')||(c=='-'))){(*stream)>>c;}
		if (c=='-'){break;}
		(*stream)>>dat.time;
		(*stream)>>c;//read ';'
		(*stream)>>dat.choice;
		(*stream)>>c;//read ';'
		(*stream)>>dat.wchoice;
		(*stream)>>c;//read ';'
		(*stream)>>c;
		if(c=='1')//read if ther is a answer
		{
			dat.answer=1;
		}else{//"NV"
			dat.answer=0;
			(*stream)>>c;
		}
		(*stream)>>c;//read ';'
		//optional part, the next values are not nessesarry in ale testcases
		if ((c==';')||(c==','))
		{
			(*stream)>>dat.trueAss;
			(*stream)>>c;//read ';'
			if ((c==';')||(c==','))
			{
				(*stream)>>dat.atoms;
				(*stream)>>c;//read ';'
					if ((c==';')||(c==','))
					{
						(*stream)>>dat.rules;
						(*stream)>>c;//read ';'
		}}}
		while (c!='|'){(*stream)>>c;}

//		cout<<dat.time<<";"<<dat.choice<<";"<<dat.wchoice<<";"<<dat.answer;
//		cout<<";"<<dat.trueAss<<";"<<dat.atoms<<";"<<dat.rules<<endl;
		tmpDataL.insert(tmpDataL.end(),dat);
	}
	delete stream;
}
else
	{printf( "Problem opening the file\n" );}
return tmpDataL;
}

TDResult evalueResult(char *file,unsigned int at,unsigned int rl,unsigned int lit)
/*evaluates the results of the testcase in the file file
pre: the name of the file file wher testcase data ist stored, the number of
	atoms, rules and literals with wich the testcase was generated
post: the results of the testcase as a TDResult*/
{
//read data of testcase
list<TData> dataL;
dataL=readData(file);
TDResult result;
unsigned int i=0;
while ((file[i]!=0)||(i<100))
	{result.name[i]=file[i];i++;}
dataL.sort();
i=0;
//init values of the result
result.literals=lit;
result.atoms=at;
result.rules=rl;
result.examples=dataL.size();
//average time
result.avTime=0.0;
result.avChoice=0.0;
//average search space
result.avSearchSp=0.0;
//positive examples
result.posExamples=0;
//average time of positive examples
result.posAvTime=0.0;
result.posAvChoice=0.0;
//rage search space of positive examples
result.posAvSearchSp=0.0;
//average time of negative examples
result.negAvTime=0.0;
result.negAvChoice=0.0;
//average search space of negative examples
result.negAvSearchSp=0.0;
result.minSearchSp=(0-1);//minimal search space
result.maxSearchSp=0;//maximal search space
result.timeVarianz=0.0;//time varianz
result.choiceVarianz=0.0;
result.searchSpVarianz=0.0;//search space varianz
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=0;}
result.averageAtoms=0.0;
result.averageRules=0.0;
result.avCTQutient=0.0;
result.cTQutientVarianz=0.0;
result.avWChoice=0.0;
result.wChoiceVarianc=0.0;
//evalue values of the testcase
for (list<TData>::iterator itr=dataL.begin();itr!=dataL.end();itr++)
{
	result.avTime+=itr->time;
	result.avSearchSp+=(double)(itr->trueAss);
	result.avChoice+=(double)(itr->choice);
	result.averageAtoms+=itr->atoms;
	result.averageRules+=itr->rules;
	i++;
	if ((((i*10)/dataL.size())*dataL.size())==(i*10))
		{result.maxTime[((i-1)*10)/dataL.size()]=itr->time;}
	result.clAvTime[(i*10)/dataL.size()]+=itr->time;
	if (itr->answer)
	{	result.posExamples++;
		result.posAvTime+=itr->time;
		result.posAvSearchSp+=(double)(itr->trueAss);
		result.posAvChoice+=(double)(itr->choice);
	}else{
		result.negAvTime+=itr->time;
		result.negAvSearchSp+=(double)(itr->trueAss);
		result.negAvChoice+=(double)(itr->choice);
	}
	if (result.minSearchSp>((itr->trueAss))) {result.minSearchSp=(itr->trueAss);}
	if (result.maxSearchSp<((itr->trueAss))) {result.maxSearchSp=(itr->trueAss);}
	result.timeVarianz+=(itr->time)*(itr->time);
	result.choiceVarianz+=(double)(itr->choice)*(double)(itr->choice);
	result.searchSpVarianz+=(double)(itr->trueAss)*(double)(itr->trueAss);
	result.avCTQutient+=((double)(itr->choice))/(itr->time);
	result.cTQutientVarianz+=(((double)(itr->choice))/(itr->time))*(((double)(itr->choice))/(itr->time));
	result.avWChoice+=(double)(itr->wchoice);
	result.wChoiceVarianc+=(double)(itr->wchoice)*(double)(itr->wchoice);
}
result.avSearchSp=result.avSearchSp/dataL.size();
result.avTime=result.avTime/dataL.size();
result.avChoice=result.avChoice/dataL.size();
result.avCTQutient=result.avCTQutient/dataL.size();

result.posAvTime=result.posAvTime/result.posExamples;
result.posAvChoice=result.posAvChoice/result.posExamples;
result.posAvSearchSp=result.posAvSearchSp/result.posExamples;

result.negExamples=dataL.size()-result.posExamples;//negative examples

result.negAvTime=result.negAvTime/result.negExamples;
result.negAvChoice=result.negAvChoice/result.negExamples;
result.negAvSearchSp=result.negAvSearchSp/result.negExamples;

result.averageAtoms=result.averageAtoms/dataL.size();
result.averageRules=result.averageRules/dataL.size();
result.minTime=(dataL.begin())->time;//minimal time
result.timeSpread=result.maxTime[9]-result.minTime;
result.searchSpSpread=result.maxSearchSp-result.minSearchSp;
result.timeVarianz=(result.timeVarianz)/dataL.size()-(result.avTime)*(result.avTime);
result.choiceVarianz=(result.choiceVarianz)/dataL.size()-(result.avChoice)*(result.avChoice);
result.searchSpVarianz=(result.searchSpVarianz)/dataL.size()-(result.avSearchSp)*(result.avSearchSp);
result.cTQutientVarianz=(result.cTQutientVarianz)/dataL.size()-(result.avCTQutient)*(result.avCTQutient);
result.avWChoice+=result.avWChoice/dataL.size();
result.wChoiceVarianc+=(result.wChoiceVarianc)/dataL.size()-(result.avWChoice)*(result.avWChoice);
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=(result.clAvTime[a]*10.0)/dataL.size();}

//correct divede 0 values
if (dataL.size()==0){result.avSearchSp=0.0;result.avTime=0.0;result.avChoice=0.0;result.avCTQutient=0.0;
	result.averageAtoms=0.0;result.averageRules=0.0;result.timeVarianz=0.0;result.choiceVarianz=0.0;
	result.searchSpVarianz=0.0;result.cTQutientVarianz=0.0;result.avWChoice=0.0;result.wChoiceVarianc=0.0;
	for (unsigned int a=0;a<10;a++)
		{result.clAvTime[a]=0.0;}
	}
if (result.posExamples==0){result.posAvTime=0.0;result.posAvChoice=0.0;result.posAvSearchSp=0.0;}
if (result.negExamples==0){result.negAvTime=0.0;result.negAvChoice=0.0;result.negAvSearchSp=0.0;}

return result;
}

void writeHead(ofstream *stream)
/*writes the head of the result tabel in a excel readebel form
colums are seperated with ";"
pre: the stream to write the head to
post: the head of the table in the stream*/
{
(*stream)<<"rules/atoms ;name ;literals ;atoms ;rules ;examples ;average time ;average choices ;average search space";
(*stream)<<" ;positiv examples ;positiv average time ;positiv average choices ;positiv average search space";
(*stream)<<" ;negativ examples ;negativ average time ;negativ average choices ;negative average search space";
(*stream)<<" ;min Time";
for (unsigned int i=0;i<10;i++){(*stream)<<" ;max time "<<i;}
for (unsigned int i=0;i<10;i++){(*stream)<<" ;class av. time "<<i;}
(*stream)<<" ;minimal search space ;maximal search space ;time spread ;search space spread";
(*stream)<<" ;time varianz ;choicepoint varianz ;search space varianz ;average atoms ;average rules";
(*stream)<<" ;average CTQutient ;CTQutient varianz ;average wrong choice ;wrong choice varianz ;"<<endl;
}

void writeResult(ofstream *stream,TDResult result)
/*writes one given result to the stream in a excel readebel form
colums are seperated with ";"
pre: the stream to print the result data to and the result to print
post: the result in the stream*/
{
(*stream)<<(result.rules)/(result.atoms)<<" ; "<<result.name<<" ; "<<result.literals<<" ; "<<result.atoms;
(*stream)<<" ; "<<result.rules<<" ; "<<result.examples;
(*stream)<<" ; "<<result.avTime<<" ; "<<result.avChoice<<" ; "<<result.avSearchSp;
(*stream)<<" ; "<<result.posExamples<<" ; "<<result.posAvTime;
(*stream)<<" ; "<<result.posAvChoice<<" ; "<<result.posAvSearchSp;
(*stream)<<" ; "<<result.negExamples<<" ; "<<result.negAvTime;
(*stream)<<" ; "<<result.negAvChoice<<" ; "<<result.negAvSearchSp;
(*stream)<<" ; "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" ;"<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" ;"<<result.clAvTime[i];}
(*stream)<<" ; "<<result.minSearchSp<<" ;"<< result.maxSearchSp;
(*stream)<<" ; "<<result.timeSpread<<" ;"<<result.searchSpSpread;
(*stream)<<" ; "<<result.timeVarianz<<" ;"<<result.choiceVarianz<<" ; "<<result.searchSpVarianz;
(*stream)<<" ; "<< result.averageAtoms<<" ;"<< result.averageRules;
(*stream)<<" ; "<< result.avCTQutient<<" ;"<< result.cTQutientVarianz;
(*stream)<<" ;"<<result.avWChoice<<" ;"<<result.wChoiceVarianc<<endl;
}

void writeResultBl(ofstream *stream,TDResult result)
/*writes one given result to the stream in a excel readebel form
colums are seperated with " "(blank)
pre: the stream to print the result data to and the result to print
post: the result in the stream*/
{
(*stream)<<(double(result.rules)/double(result.atoms))<<" "<<result.name<<" "<<result.literals<<" "<<result.atoms;
(*stream)<<" "<<result.rules<<" "<<result.examples;
(*stream)<<" "<<result.avTime<<" "<<result.avChoice<<" "<<result.avSearchSp;
(*stream)<<" "<<result.posExamples<<" "<<result.posAvTime;
(*stream)<<" "<<result.posAvChoice<<" "<<result.posAvSearchSp;
(*stream)<<" "<<result.negExamples<<" "<<result.negAvTime;
(*stream)<<" "<<result.negAvChoice<<" "<<result.negAvSearchSp;
(*stream)<<" "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" "<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" "<<result.clAvTime[i];}
(*stream)<<" "<<result.minSearchSp<<" "<< result.maxSearchSp;
(*stream)<<" "<<result.timeSpread<<" "<<result.searchSpSpread;
(*stream)<<" "<<result.timeVarianz<<" "<<result.choiceVarianz<<" "<<result.searchSpVarianz;
(*stream)<<" "<< result.averageAtoms<<" "<< result.averageRules;
(*stream)<<" "<< result.avCTQutient<<" "<< result.cTQutientVarianz;
(*stream)<<" "<<result.avWChoice<<" "<<result.wChoiceVarianc<<endl;
}

void makeData(list<TDResult> rL,char* baseName)
/*outputs the data of the results in the list TDResult,
outputs it in a seperated folder "tablesLV", wher it saves the tabel with head in a
excel readebel form, colums seperated by ";"
pre: base name ist the base name of the files to store the data
post: the data of the result list in the folder*/
{
if (rL.size()<5){return;}//if net enoght results are in the list cancel the output
rL.sort();
//output date in a excel redebel form, with colums seperated by ";"
char outf[50];
sprintf(outf,"./tabellen/tabelsLV/HSC%s.txt",baseName,baseName);
ofstream *stream=new ofstream(outf);
if( stream!= NULL )
{
	(*stream)<<"number of testcases ; "<<rL.size()<<";"<<endl;
	writeHead(stream);
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResult(stream,(*itr));}
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
}

int main()
/*with this programm results for the testcases are evaluet and outputed as
tables for excel import and graphs generated with gnuplot*/
{
list<TDResult> allResult;
unsigned int nboAtoms, nboLiteralsPerClause, nboClause;
int existsT;
//maximal values to wich the testcases should be readed
unsigned int maxNboAtoms=500, maxNboLiteralsPerClause=100, maxNboClause=10000;//1000;5;5000?
unsigned int minNboLiteralsPerClause=2;
//delta values
unsigned int dNboAtoms=10, dNboLiteralsPerClause=2, dNboClause=100;

//create the directory to store the data to
char b[20];
sprintf(b,"mkdir ./tabellen/tabelsLV");
system(b);

//read Data
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause ;nboLiteralsPerClause+=dNboLiteralsPerClause){
	for (nboAtoms=10;nboAtoms<=maxNboAtoms;nboAtoms+=dNboAtoms){
		char lsa[50];
		sprintf(lsa,"(ls ./ergebnisse/atwA%iL%iC*.txt) > tmp.txt",nboAtoms,nboLiteralsPerClause);
		existsT=system(lsa);
		if (existsT==0)//if existsT==0 the ther exists a test
		{
		for (nboClause=100;nboClause<=maxNboClause;nboClause+=dNboClause){
			char ls[50];
			sprintf(ls,"(ls ./ergebnisse/atwA%iL%iC%i.txt) > tmp.txt",nboAtoms,nboLiteralsPerClause,nboClause);
			existsT=system(ls);
			if (existsT==0)//if existsT==0 the ther exists a test
			{
				char file[50];
				sprintf(file,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
				allResult.insert(allResult.end(),evalueResult(file,nboAtoms,nboClause,nboLiteralsPerClause));
			}
		}}
	}
	//evalue result
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	makeData(allResult,bs);
	allResult.clear();
}


cout<<endl;
}













