/*File Name: Programm.h
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __PROGRAMM_h__
#define __PROGRAMM_h__

#include <iostream>
#include <fstream>
//#include <stdio.h>
#include <list>

using std::list;
using std::ifstream;
using std::cout;
using std::endl;
using std::ofstream;

//the counting of clauses begins with 0
//atom 0 is false

class Programm
{
protected:

typedef struct TClausel {
	unsigned int head;
	list<unsigned int> bodyP;
	list<unsigned int> bodyN;
} TClausel;

std::list<TClausel> Clausels;
unsigned int MaxNumberOfAtoms;//maximal number of Atoms

public:
//constructors:
	Programm();
	//standart constructor
	//constructs a Programm object

	Programm(unsigned int maxNumberOfAtoms);
	//standart constructor
	//constructs a Programm object

	~Programm();
	//destructor

	unsigned int getNumberOfAtoms() const;
	//evaluate the number of possibel Atoms for this object
	//post: Numbers of possibel atoms fore this object

	unsigned int getNumberOfClauses() const;
	//returns the number of clauses for this object
	//post: Numbers of clauses fore this object

	bool createClause();
	//creates a new empty clause
	//post: true if a new clausel is created, and the new clausel at the end
	//of the PProgram

	bool deleteClause(unsigned int nOClausel);
	//delete the clause on position n (counting from 0)
	//pre: the position of the clause to delete
	//post: true if a new clausel is delete

	bool setHead(unsigned int nOClausel, unsigned int head);
	//sets the head atoms of the n'th clause to th given head atom head
	//if ther is a clause clausel
	//pre: the number of clause wich head to change and the new head
	//post: true if the head is changed

	list<unsigned int> getPositivBody(unsigned int nOClausel) const;
	//returns the positve body atoms of the n'th clause
	//pre: the number of clause wich positve body to return
	//post: the positve body of the n'th clause or a empty list

	bool setPositivBody(unsigned int nOClausel, list<unsigned int> bodyP);
	//sets the positve body atoms of the n'th clause to th given
	//positv body bodyP, if ther is a clause clausel
	//pre: the number of clause wich positve body to change and the new positve body
	//post: true if the positve body is changed

	list<unsigned int> getNegativBody(unsigned int nOClausel) const;
	//returns the negative body atoms of the n'th clause
	//pre: the number of clause wich negative body to return
	//post: the negative body of the n'th clause or a empty list

	bool setNegativBody(unsigned int nOClausel, list<unsigned int> bodyN);
	//sets the negative body atoms of the n'th clause to th given
	//negative body bodyN, if ther is a clause clausel
	//pre: the number of clause wich negative body to change and the new negative body
	//post: true if the negative body is changed

	unsigned int getNOLiteralsNB(unsigned int nOClausel) const;
	//returns the number of literals in the negativ body
	//pre: the number of clause from wich the number of literals to return
	//post: the number of literals in the negativ body of the n'th clause

	unsigned int getHeadAtom(unsigned int nOClausel) const;
	//returns the head atom of the n'th clause of the n'th atom
	//pre: the number of clause
	//post: the head of the n'th clause and n'th atom if exists or 0

	bool getPBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const;
	//returns if ther is n'th atom in the positive body of the n'th clause
	//pre: the number of clause and atom of the positive body to return
	//post: true if ther is the n'th atom in the positive body the n'th clause

	bool setPBodyAtom(unsigned int nOClausel,unsigned int nOAtom,bool value);
	//set the n'th atom in the positive body of the n'th clause
	//pre: the number of clause and atom of the positive body to set
	//post: true if the atom was set

	bool getNBodyAtom(unsigned int nOClausel,unsigned int nOAtom) const;
	//returns if ther is n'th atom in the negative body of the n'th clause
	//pre: the number of clause and atom of the negative body to return
	//post: true if ther is the n'th atom in the negative body the n'th clause

	bool setNBodyAtom(unsigned int nOClausel,unsigned int nOAtom,bool value);
	//set the n'th atom in the negative body of the n'th clause
	//pre: the number of clause and atom of the negative body to set
	//post: true if the atom was set

	bool readProgram(ifstream* stream);
	//reads a program in lparse format from the stream istr
	//pre: the stream to read the program from
	//post: true if the reading was sucessfull

	void print();
	//prints the program

	void print(ofstream *outstr);
	//prints the program to the stream

};

#endif








