//	g++ -Wall -g -o ev evaluatorAll.cpp
/*File Name: evaluatorAll.cpp
  Author: Bernd Oesterholz ; Date: 10.04.2005
  System: C++


  Copyright (C) 2004  Bernd ?sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This programm generates graphs and tables for the answerset testcases,
wich results are in the BMTool output form.
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>


using namespace std;

class TData {
/*This class is to store the values of one example.*/
public:
	double time;
	unsigned int choice;
	unsigned int answer;
	unsigned int atoms;
	unsigned int rules;
	bool operator<(const TData tdat) const
	{
		return (time<tdat.time);
	}
	bool static lowerChoice(const TData tdat1,const TData tdat2)
	{
		return (tdat1.choice<tdat2.choice);
	}
};

class TTupel{
public:
	unsigned int x,y;
	bool operator<(const TTupel tup) const
	{
		return (x<tup.x);
	}
};

class TDResult
{
/*This class is to store the evaluate results values of one testcase.*/
public:
	char name[100];//name of the testcase
	unsigned int literals;//literals parameter of the generator
	unsigned int atoms;//atoms parameter of the generator
	unsigned int rules;//rules parameter of the generator
	unsigned int examples;//examples in the testcase
	double avTime;//average time
	double avChoice;//average choice
	unsigned int posExamples;//positive examples
	double posAvTime;//average time of positive examples
	double posAvChoice;//average choice of positive examples
	unsigned int negExamples;//negative examples
	double negAvTime;//average time of negative examples
	double negAvChoice;//average choice of negative examples
	double minTime;//minimal time
	double maxTime[10];//maximal time of the classes with 10 per cent of examples
	//, which are the next better after maxTime[n-1](btw if n=0 minTime)
	double clAvTime[10];//average time of the classes with 10 per cent of examples
	double timeSpread;//spread of the time values
	double timeVarianz;//time varianz
	double choiceVarianz;//choice point varianze
	double averageAtoms;//average atoms of the testcase
	double averageRules;//average rules of the testcase
	double avCTQutient;//average choise/time qutient
	double cTQutientVarianz;//average choise/time qutient varianze
	double medianTime;//time median
	double medianChoice;//choice median
	double minChoice;//minimal choices
	double maxChoice;//maximal choices

	bool operator<(const TDResult tres) const
	/*the lower realtion for TDResult
	to order the TDResults, first coms the literals, then the atoms and then
	the rules
	pre: two TDResult
	post: true if first TDResult is lower than the secound, else false*/
	{
	return ((literals<tres.literals)||
		((literals==tres.literals)&&((atoms<tres.atoms)||
		((atoms==tres.atoms)&&(rules<tres.rules)))));
	}

	bool static lowerAtoms(const TDResult tres1,const TDResult tres2)
	{
		return (tres1.atoms<tres2.atoms);
	}

	bool static lowerRules(const TDResult tres1,const TDResult tres2)
	{
		return (tres1.rules<tres2.rules);
	}

	bool static lowerLiterals(const TDResult tres1,const TDResult tres2)
	{
		return (tres1.literals<tres2.literals);
	}
};

list<TData> readData(char* file)
/*This method reads the data of one testcase and store it to a list of TData
pre: the name of the file wher the data of the testcase is stored in the
	BMTool output form
post: the TData list with the readed values*/
{
list<TData> tmpDataL;
char c=' ';
unsigned int i;
char name[100];
TData dat;
dat.time=0.0;
dat.choice=0;
dat.answer=0;
dat.atoms=0;
dat.rules=0;
char ls[100];

sprintf(ls,"ls %s",file);
int existsT=system(ls);//test if ther exists such file
if (existsT!=0){return tmpDataL;}

ifstream *stream=new ifstream(file);
if( stream!= NULL )
{
	//read first part till the first data set
	i=0;
	while (c!='|')
	{
		(*stream)>>c;
		if (!((c=='|')||(c==' '))) {name[i]=c;i++;}
	}
	name[i+1]=0;
	cout<<name<<endl<<flush;
	(*stream)>>c;
	while (c!='|'){(*stream)>>c;}
	while (c!='l'){(*stream)>>c;}
	//read line
	while (true)
	{
		c='a';
		//read till the first values of the data begin
		while (!((c=='|')||(c=='-'))){(*stream)>>c;}
		if (c=='-'){break;}
		(*stream)>>dat.time;
		(*stream)>>c;//read ';'
		(*stream)>>dat.choice;
		(*stream)>>c;//read ';'
		(*stream)>>c;
		if(c=='1')//read if ther is a answer
		{
			dat.answer=1;
		}else{//"NV"
			dat.answer=0;
			(*stream)>>c;
		}
		(*stream)>>c;//read ';'
		//optional part, the next values are not nessesarry in ale testcases
		if ((c==';')||(c==','))
		{
			(*stream)>>dat.atoms;
			(*stream)>>c;//read ';'
				if ((c==';')||(c==','))
				{
					(*stream)>>dat.rules;
					(*stream)>>c;//read ';'
		}}
		while (c!='|'){(*stream)>>c;}

//		cout<<dat.time<<";"<<dat.choice<<";"<<dat.wchoice<<";"<<dat.answer;
//		cout<<";"<<dat.trueAss<<";"<<dat.atoms<<";"<<dat.rules<<endl;
		tmpDataL.insert(tmpDataL.end(),dat);
	}
	stream->close();
	delete stream;
}
else
	{printf( "Problem opening the file\n" );}
return tmpDataL;
}

TDResult evalueResult(char *file,unsigned int at,unsigned int rl,unsigned int lit)
/*evaluates the results of the testcase in the file file
pre: the name of the file file wher testcase data ist stored, the number of
	atoms, rules and literals with wich the testcase was generated
post: the results of the testcase as a TDResult*/
{
//read data of testcase
list<TData> dataL;
dataL=readData(file);
TDResult result;
unsigned int i=0;
while ((file[i]!=0)||(i<100))
	{result.name[i]=file[i];i++;}
dataL.sort();
i=0;
//init values of the result
result.literals=lit;
result.atoms=at;
result.rules=rl;
result.examples=dataL.size();
//average time
result.avTime=0.0;
result.avChoice=0.0;
//positive examples
result.posExamples=0;
//average time of positive examples
result.posAvTime=0.0;
result.posAvChoice=0.0;
//average time of negative examples
result.negAvTime=0.0;
result.negAvChoice=0.0;
result.minChoice=(dataL.begin())->choice;//minimal choices
result.maxChoice=(dataL.begin())->choice;//maximal choices
result.timeVarianz=0.0;//time varianz
result.choiceVarianz=0.0;
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=0;}
result.averageAtoms=0.0;
result.averageRules=0.0;
result.avCTQutient=0.0;
result.cTQutientVarianz=0.0;
//evalue values of the testcase
list<TData>::iterator itr;
for (itr=dataL.begin();itr!=dataL.end();itr++)
{
	result.avTime+=itr->time;
	result.avChoice+=(double)(itr->choice);
	result.averageAtoms+=itr->atoms;
	result.averageRules+=itr->rules;
	i++;
	if ((((i*10)/dataL.size())*dataL.size())==(i*10))
		{result.maxTime[((i-1)*10)/dataL.size()]=itr->time;}
	result.clAvTime[(i*10)/dataL.size()]+=itr->time;
	if (itr->answer)
	{
		result.posExamples++;
		result.posAvTime+=itr->time;
		result.posAvChoice+=(double)(itr->choice);
	}else{
		result.negAvTime+=itr->time;
		result.negAvChoice+=(double)(itr->choice);
	}
	if (result.minChoice>(itr->choice)) {result.minChoice=(itr->choice);}
	if (result.maxChoice<(itr->choice)) {result.maxChoice=(itr->choice);}
	result.timeVarianz+=(itr->time)*(itr->time);
	result.choiceVarianz+=(double)(itr->choice)*(double)(itr->choice);
	if ((itr->time)>0)
	{
		result.avCTQutient+=((double)(itr->choice))/(itr->time);
		result.cTQutientVarianz+=(((double)(itr->choice))/(itr->time))*(((double)(itr->choice))/(itr->time));
	}
	if(dataL.size()/2==i){result.medianTime=itr->time;}
}
result.avTime=result.avTime/dataL.size();
result.avChoice=result.avChoice/dataL.size();
result.avCTQutient=result.avCTQutient/dataL.size();

result.posAvTime=result.posAvTime/result.posExamples;
result.posAvChoice=result.posAvChoice/result.posExamples;

result.negExamples=dataL.size()-result.posExamples;//negative examples

result.negAvTime=result.negAvTime/result.negExamples;
result.negAvChoice=result.negAvChoice/result.negExamples;

result.averageAtoms=result.averageAtoms/dataL.size();
result.averageRules=result.averageRules/dataL.size();
result.minTime=(dataL.begin())->time;//minimal time
result.timeSpread=result.maxTime[9]-result.minTime;
result.timeVarianz=(result.timeVarianz)/dataL.size()-(result.avTime)*(result.avTime);
result.choiceVarianz=(result.choiceVarianz)/dataL.size()-(result.avChoice)*(result.avChoice);
result.cTQutientVarianz=(result.cTQutientVarianz)/dataL.size()-(result.avCTQutient)*(result.avCTQutient);
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=(result.clAvTime[a]*10.0)/dataL.size();}

//correct divede 0 values
if (dataL.size()==0){result.avTime=0.0;result.avChoice=0.0;result.avCTQutient=0.0;
	result.averageAtoms=0.0;result.averageRules=0.0;result.timeVarianz=0.0;result.choiceVarianz=0.0;
	result.cTQutientVarianz=0.0;
	for (unsigned int a=0;a<10;a++)
		{result.clAvTime[a]=0.0;}
	}
if (result.posExamples==0){result.posAvTime=0.0;result.posAvChoice=0.0;}
if (result.negExamples==0){result.negAvTime=0.0;result.negAvChoice=0.0;}

dataL.sort(&TData::lowerChoice);
itr=dataL.begin();
for (i=0;i<=(dataL.size()/2);i++)
	{itr++;}
result.medianChoice=(itr->choice);
return result;
}

void writeHead(ofstream *stream)
/*writes the head of the result tabel in a excel readebel form
colums are seperated with ";"
pre: the stream to write the head to
post: the head of the table in the stream*/
{
(*stream)<<"rules/atoms ;name ;literals ;atoms ;rules ;examples ;average time ;average choices";
(*stream)<<" ;time median ;choice median";
(*stream)<<" ;positiv examples ;positiv average time ;positiv average choices";
(*stream)<<" ;negativ examples ;negativ average time ;negativ average choices";
(*stream)<<" ;min Time";
for (unsigned int i=0;i<10;i++){(*stream)<<" ;max time "<<i;}
for (unsigned int i=0;i<10;i++){(*stream)<<" ;class av. time "<<i;}
(*stream)<<" ;minimal choice ; maximal choice ;time spread";
(*stream)<<" ;time varianz ;choice varianz ;average atoms ;average rules";
(*stream)<<" ;average choice point time qutient ;choice point time qutient varianz"<<endl;
}

void writeResult(ofstream *stream,TDResult result)
/*writes one given result to the stream in a excel readebel form
colums are seperated with ";"
pre: the stream to print the result data to and the result to print
post: the result in the stream*/
{
(*stream)<<double(result.rules)/double(result.atoms)<<" ; "<<result.name<<" ; "<<result.literals<<" ; "<<result.atoms;
(*stream)<<" ; "<<result.rules<<" ; "<<result.examples;
(*stream)<<" ; "<<result.avTime<<" ; "<<result.avChoice;
(*stream)<<" ; "<<result.medianTime<<" ; "<<result.medianChoice;
(*stream)<<" ; "<<result.posExamples<<" ; "<<result.posAvTime<<" ; "<<result.posAvChoice;
(*stream)<<" ; "<<result.negExamples<<" ; "<<result.negAvTime<<" ; "<<result.negAvChoice;
(*stream)<<" ; "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" ;"<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" ;"<<result.clAvTime[i];}
(*stream)<<" ; "<<result.minChoice<<" ; "<<result.maxChoice<<" ; "<<result.timeSpread;
(*stream)<<" ; "<<result.timeVarianz<<" ;"<<result.choiceVarianz;
(*stream)<<" ; "<< result.averageAtoms<<" ; "<<result.averageRules;
(*stream)<<" ; "<< result.avCTQutient<<" ; "<< result.cTQutientVarianz<<endl;
}

void writeResultBl(ofstream *stream,TDResult result)
/*writes one given result to the stream in a excel readebel form
colums are seperated with " "(blank)
pre: the stream to print the result data to and the result to print
post: the result in the stream*/
{
(*stream)<<double(result.rules)/double(result.atoms)<<" "<<result.name<<" "<<result.literals<<" "<<result.atoms;
(*stream)<<" "<<result.rules<<" "<<result.examples;
(*stream)<<" "<<result.avTime<<" "<<result.avChoice;
(*stream)<<" "<<result.medianTime<<" "<<result.medianChoice;
(*stream)<<" "<<result.posExamples<<" "<<result.posAvTime<<" "<<result.posAvChoice;
(*stream)<<" "<<result.negExamples<<" "<<result.negAvTime<<" "<<result.negAvChoice;
(*stream)<<" "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" "<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" "<<result.clAvTime[i];}
(*stream)<<" "<<result.minChoice<<" "<<result.maxChoice<<" "<<result.timeSpread;
(*stream)<<" "<<result.timeVarianz<<" "<<result.choiceVarianz;
(*stream)<<" "<< result.averageAtoms<<" "<<result.averageRules;
(*stream)<<" "<< result.avCTQutient<<" "<< result.cTQutientVarianz<<endl;
}

void plotData(char* baseName,unsigned int wich,char* wichName,char* filePName,int titleNumber,char* titleString,unsigned int literals)
/*prints the graphs to the data in the file "./gnuplotTmp.txt" (stored
results with blanks betwean), the graphs are flat (2 dimensional)
most graphs are printed in normal and log scale
the graphs are generated with gnuplot
pre: the base name baseName of the folder and file to store the graphs to,
	the number wich of the colum wher the x values of the graph stand,
	the name wichName of the x values (e.g. "rules"), the begin of name
	filePName the graph file to store the graph to, the titelNumber and
	titelString to write in the titel (eg. titelNumber=55 ;titelString="atoms"
	then a part of the title is "... 55 atoms ...") and the numbers of
	literals in the data (how much literals the testcases have)
post: the graphs of the data*/
{
ofstream *stream=new ofstream("./gnuplotTmp.txt");
//output time
(*stream)<<"set terminal postscript"<<endl;
(*stream)<<"set nokey"<<endl;
//(*stream)<<"set size 1, 1"<<endl;
(*stream)<<"set format xy \"%g\""<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set xlabel \""<<wichName<<"\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 with linespoints "<<endl;
//output examples
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_e_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"examples n\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":6 with linespoints "<<endl;
//output choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 with linespoints "<<endl;
//output median time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"time median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 with linespoints "<<endl;
//output median choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice points median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":10 with linespoints "<<endl;
//output minimum time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mint_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":17 with linespoints "<<endl;
//output minimum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_minc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":38 with linespoints "<<endl;
//output maximum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_maxc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximum choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":39 with linespoints "<<endl;
//output atoms
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_at_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average atoms for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"atoms A\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":43 with linespoints "<<endl;
//output rules
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_rl_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average rules for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"rules R\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":44 with linespoints "<<endl;
//output time spread
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_sp_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"time spread for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":40 with linespoints "<<endl;
//output time varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"time varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":41 with linespoints "<<endl;
//output choice varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice points varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":42 with linespoints "<<endl;
//output choice/time quotient
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":45 with linespoints "<<endl;
//output choice/time quotient variance
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_var_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"varianz of choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":46 with linespoints "<<endl;

//key section
//output examples pos neg
(*stream)<<"set key"<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_epn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average examples positiv, negative and all for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"examples n\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":6 title \"all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":11 title \"positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":14 title \"negativ examles\" with linespoints "<<endl;
//output time pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_tpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average time for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 title \"time all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":12 title \"time positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":15 title \"time negativ examles\" with linespoints "<<endl;
//output choice pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_cpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average choice points for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 title \"choice all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":13 title \"choice positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":16 title \"choice negativ examles\" with linespoints "<<endl;
//output 10 maximal time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_mtc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximal time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":17 title \"minimal time\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":18 title \"maximal time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":19 title \"maximal time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":20 title \"maximal time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":21 title \"maximal time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":22 title \"maximal time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":23 title \"maximal time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":24 title \"maximal time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":25 title \"maximal time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":26 title \"maximal time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":27 title \"maximal time in class 10\" with linespoints "<<endl;
//output 10 time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_tc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":28 title \"time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":29 title \"time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":30 title \"time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":31 title \"time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":32 title \"time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":33 title \"time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":34 title \"time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":35 title \"time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":36 title \"time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":37 title \"time in class 10\" with linespoints "<<endl;


//log part
//output log time
(*stream)<<"set logscale y"<<endl;
(*stream)<<"set nokey"<<endl;
(*stream)<<"set title \"average log time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 with linespoints "<<endl;
//output log choice
(*stream)<<"set title \"average log choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 with linespoints "<<endl;
//output median time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mt_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log time median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":9 with linespoints "<<endl;
//output median choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choice points median for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":10 with linespoints "<<endl;
//output minimum time
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mint_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum log time for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":17 with linespoints "<<endl;
//output minimum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_minc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"minimum log choice for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":38 with linespoints "<<endl;
//output maximum choice
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_maxc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximum log choice points for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":39 with linespoints "<<endl;
//output time spread
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_sp_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log time spread for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":40 with linespoints "<<endl;
//output time varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_t_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log time varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":41 with linespoints "<<endl;
//output choice varianz
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_c_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choice points varianz for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":42 with linespoints "<<endl;
//output choice/time quotient
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":45 with linespoints "<<endl;
//output choice/time quotient variance
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_var_CdT_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"log varianz of choice points time quotient for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points/time 1/s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":46 with linespoints "<<endl;

//key section
//output time pos neg
(*stream)<<"set key"<<endl;
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_tpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log time for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":7 title \"time all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":12 title \"time positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":15 title \"time negativ examles\" with linespoints "<<endl;
//output choice pos neg
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_cpn_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log choice points for positiv, negative and all examples for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"choice points\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":8 title \"choice all examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":13 title \"choice positiv examles\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":16 title \"choice negativ examles\" with linespoints "<<endl;
//output 10 maximal time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_mtc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"maximal log time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":17 title \"minimal time\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":18 title \"maximal time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":19 title \"maximal time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":20 title \"maximal time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":21 title \"maximal time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":22 title \"maximal time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":23 title \"maximal time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":24 title \"maximal time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":25 title \"maximal time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":26 title \"maximal time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":27 title \"maximal time in class 10\" with linespoints "<<endl;
//output 10 time classes
(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/"<<filePName<<"_log_tc_"<<baseName<<".ps\""<<endl;
(*stream)<<"set title \"average log time of 10 time classes for testcases with "<<titleNumber<<" "<<titleString<<" and ";
(*stream)<<literals<<" literals per body\""<<endl;
(*stream)<<"set ylabel \"time s\""<<endl;
(*stream)<<"plot \"./tmpG1.txt\" using "<<wich<<":28 title \"time in class 1\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":29 title \"time in class 2\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":30 title \"time in class 3\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":31 title \"time in class 4\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":32 title \"time in class 5\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":33 title \"time in class 6\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":34 title \"time in class 7\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":35 title \"time in class 8\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":36 title \"time in class 9\" with linespoints ";
(*stream)<<",\"./tmpG1.txt\" using "<<wich<<":37 title \"time in class 10\" with linespoints "<<endl;


system("gnuplot ./gnuplotTmp.txt");
stream->close();
delete stream;
}

void plotData3D(char* baseName,unsigned int wich,char* wichName,unsigned int wConst,char* wConstName,unsigned int x,unsigned int y)
/*prints the graphs to the data in the file "./gnuplotTmp.txt" (stored
results with blanks betwean), the graphs are 3 dimensional
most graphs are printed in normal and log scale
the graphs are generated with gnuplot
pre: the base name baseName of the folder and file to store the graphs to
	and the numbers of literals in the data (how much literals the testcases have)
post: the graphs of the data*/
{
ofstream *stream=new ofstream("./gnuplotTmp.txt");
if( stream!= NULL )
{
	//output time
	(*stream)<<"set terminal postscript"<<endl;
	(*stream)<<"set contour base"<<endl<<"set surface"<<endl<<"set data style lines"<<endl<<"set dgrid3d "<<x<<","<<y<<",3"<<endl;
	(*stream)<<"set nokey"<<endl;
//	(*stream)<<"set size 1, 1"<<endl;
	(*stream)<<"set format xy \"%g\""<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average time for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set xlabel \"rules R\""<<endl;
	(*stream)<<"set ylabel \""<<wichName<<"\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":7"<<endl;
	//output examples
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/e_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"examples n\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":6"<<endl;
	//output choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/c_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average choice for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":8"<<endl;
	//output median time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mt_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"time median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":9"<<endl;
	//output median choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"choice point median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":10"<<endl;
	//output minimum time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mint_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum time for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":17"<<endl;
	//output minimum choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/minc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":38"<<endl;
	//output maximum choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/maxc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximum choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":39"<<endl;
	//output atoms
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/at_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average atoms for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"atoms A\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":43"<<endl;
	//output rules
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/rl_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average rules for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"atoms A\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":44"<<endl;
	//output time spread
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/sp_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"time spread for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":40"<<endl;
	//output time varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"time varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":41"<<endl;
	//output choice varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_c_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"choice points varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":42"<<endl;
	//output choice/time quotient
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/CdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"coice points time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":45"<<endl;
	//output choice/time quotient variance
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/var_CdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"varianz of coice points time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"coice points/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":46"<<endl;

	//key section
	//output examples pos neg
	(*stream)<<"set key"<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/epn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average examples positiv, negative and all for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"examples n\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":11 title \"positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":14 title \"negativ examles\""<<endl;
	//output time pos neg
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/tpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average time for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":12 title \"time positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":15 title \"time negativ examles\""<<endl;
	//output choice pos neg
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/cpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average choice points for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":13 title \"choice positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":16 title \"choice negativ examles\""<<endl;
	//output 10 maximal time classes
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/mtc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximal time of 10 time classes for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":17 title \"minimal time\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":18 title \"maximal time in class 1\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":19 title \"maximal time in class 2\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":20 title \"maximal time in class 3\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":21 title \"maximal time in class 4\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":22 title \"maximal time in class 5\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":23 title \"maximal time in class 6\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":24 title \"maximal time in class 7\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":25 title \"maximal time in class 8\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":26 title \"maximal time in class 9\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":27 title \"maximal time in class 10\""<<endl;
	//output 10 time classes
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/tc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average time of 10 time classes for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":28 title \"time in class 1\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":29 title \"time in class 2\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":30 title \"time in class 3\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":31 title \"time in class 4\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":32 title \"time in class 5\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":33 title \"time in class 6\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":34 title \"time in class 7\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":35 title \"time in class 8\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":36 title \"time in class 9\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":37 title \"time in class 10\""<<endl;
/*
	//log part
	//output log time
	(*stream)<<"set logscale z"<<endl;
	(*stream)<<"set nokey"<<endl;
	(*stream)<<"set title \"average log time for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":7"<<endl;
	//output log choice
	(*stream)<<"set title \"average log choice for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_c_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":8"<<endl;
	//output median time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_mt_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log time median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":9"<<endl;
	//output median choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_mc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log choice point median for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":10"<<endl;
	//output minimum time
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_mint_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum log time for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":17"<<endl;
	//output minimum choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_minc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"minimum log choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":38"<<endl;
	//output maximum choice
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_maxc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximum log choice points for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":39"<<endl;
	//output time spread
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_sp_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log time spread for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":40"<<endl;
	//output time varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_var_t_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log time varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":41"<<endl;
	//output choice varianz
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_var_c_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log choice points varianz for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":42"<<endl;
	//output choice/time quotient
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_CdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log coice points time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":45"<<endl;
	//output choice/time quotient variance
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_var_CdT_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"log varianz of coice points time quotient for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"coice points/time 1/s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":46"<<endl;

	//key section
	//output time pos neg
	(*stream)<<"set key"<<endl;
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_tpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average log time for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":12 title \"time positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":15 title \"time negativ examles\""<<endl;
	//output choice pos neg
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_cpn_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average log choice points for positiv, negative and all examples for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"choice points\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":13 title \"choice positiv examles\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":16 title \"choice negativ examles\""<<endl;
	//output 10 maximal time classes
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_mtc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"maximal log time of 10 time classes for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":17 title \"minimal time\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":18 title \"maximal time in class 1\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":19 title \"maximal time in class 2\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":20 title \"maximal time in class 3\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":21 title \"maximal time in class 4\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":22 title \"maximal time in class 5\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":23 title \"maximal time in class 6\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":24 title \"maximal time in class 7\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":25 title \"maximal time in class 8\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":26 title \"maximal time in class 9\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":27 title \"maximal time in class 10\""<<endl;
	//output 10 time classes
	(*stream)<<"set output \"./tabellen/erg"<<baseName<<"/log_tc_"<<baseName<<".ps\""<<endl;
	(*stream)<<"set title \"average log time of 10 time classes for testcases with ";
	(*stream)<<wConst<<" "<<wConstName<<" per body\""<<endl;
	(*stream)<<"set zlabel \"time s\""<<endl;
	(*stream)<<"splot \"./tmpG1.txt\" using 5:"<<wich<<":28 title \"time in class 1\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":29 title \"time in class 2\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":30 title \"time in class 3\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":31 title \"time in class 4\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":32 title \"time in class 5\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":33 title \"time in class 6\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":34 title \"time in class 7\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":35 title \"time in class 8\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":36 title \"time in class 9\"";
	(*stream)<<",\"./tmpG1.txt\" using 5:"<<wich<<":37 title \"time in class 10\""<<endl;
*/

	system("gnuplot ./gnuplotTmp.txt");
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
}


void makeData(list<TDResult> rL,char* baseName)
/*outputs the data of the results in the list TDResult,
outputs it in a seperated folder, wher it saves the tabel with head in a
excel readebel form, colums seperated by ";", and a number of graphs
pre: the bool atoms say if the atoms chang, rules say if the rules change
	and D3 say if the data should printed in a 3 dimensional graph or not,
	base name ist the base name of the folder and filse to store the data
	to (folders begins with "erg" and the baseName )
post: the data of the result list in a own folder*/
{
if (rL.size()<5){return;}//if net enoght results are in the list cancel the output
rL.sort();
//create the directory to store the data to
char b[20];
sprintf(b,"mkdir ./tabellen/erg%s",baseName);
cout<<b<<endl;
system(b);
//output date in a excel redebel form, with colums seperated by ";"
char outf[50];
sprintf(outf,"./tabellen/erg%s/HSC%s.txt",baseName,baseName);
ofstream *stream=new ofstream(outf);
if( stream!= NULL )
{
	writeHead(stream);
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResult(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
//output the data for gnuplot in a file
stream=new ofstream("./tmpG1.txt");
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
//output date in a excel redebel form, with colums seperated by ";"
char outfg[50];
sprintf(outfg,"./tabellen/erg%s/HSGrC%s.txt",baseName,baseName);
stream=new ofstream(outfg);
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}

}

void makeData3D(list<TDResult> rL,char* baseName)
/*outputs the data of the results in the list TDResult,
outputs it in a seperated folder "tablesLV", wher it saves the tabel with head in a
excel readebel form, colums seperated by ";"
pre: base name ist the base name of the files to store the data
post: the data of the result list in the folder*/
{
if (rL.size()<5){return;}//if net enoght results are in the list cancel the output
rL.sort();
//output date in a excel redebel form, with colums seperated by ";"
char outf[50];
sprintf(outf,"./tabellen/tabelsLV/HSC%s.txt",baseName,baseName);
ofstream *stream=new ofstream(outf);
if( stream!= NULL )
{
	(*stream)<<"number of testcases ; "<<rL.size()<<";"<<endl;
	writeHead(stream);
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResult(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
}

void plotData3DAtoms(list<TDResult> rL ,char* baseName)
{
unsigned int maxClass=0,x=0,y=0;
list<TTupel> tupL;
TTupel tup;
list<TTupel>::iterator itrT;
rL.sort(&TDResult::lowerAtoms);
list<TDResult>::iterator itr=rL.begin();
tup.x=itr->atoms;
tup.y=1;
itr++;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==itr->atoms)
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->atoms;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
//	cout<<"_"<<flush;
	if((itrT->x)<(itr->atoms))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->atoms))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{x++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}

rL.sort(&TDResult::lowerRules);
itr=rL.begin();
tup.x=itr->rules;
tup.y=1;
itr++;
maxClass=0;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==(itr->rules))
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->rules;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
	if((itrT->x)<(itr->rules))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->rules))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{y++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}
if((x<3)||(y<3)||(rL.size()<10)){return;}
ofstream *stream=new ofstream("./tmpG1.txt");
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
makeData(rL,baseName);
plotData3D(baseName,4,"Atoms A",(rL.begin())->literals,"literals",x,y);
}

void plotData3DLiterals(list<TDResult> rL ,char* baseName)
{
unsigned int maxClass=0,x=0,y=0;
list<TTupel> tupL;
TTupel tup;
list<TTupel>::iterator itrT;
rL.sort(&TDResult::lowerLiterals);
list<TDResult>::iterator itr=rL.begin();
tup.x=itr->literals;
tup.y=1;
itr++;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==itr->literals)
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->literals;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
//	cout<<"_"<<flush;
	if((itrT->x)<(itr->literals))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->literals))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{x++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}

rL.sort(&TDResult::lowerRules);
itr=rL.begin();
tup.x=itr->rules;
tup.y=1;
itr++;
maxClass=0;
//get size of classes of atoms
for(;itr!=rL.end();itr++)
{
	if(tup.x==(itr->rules))
		{tup.y++;}
	else{
		tupL.insert(tupL.end(),tup);
		if(tup.y>maxClass){maxClass=tup.y;}
		tup.x=itr->rules;
		tup.y=1;
	}
}
tupL.insert(tupL.end(),tup);
//delete classes that are to small
tupL.sort();
itrT=tupL.begin();
for(itr=rL.begin();itr!=rL.end();)
{
	if((itrT->x)<(itr->rules))
		{if(itrT!=tupL.end()){itrT++;}else{break;}}
	else{
		if((itrT->x)>(itr->rules))
			{itr++;}
		else{
			if((maxClass/2)>(itrT->y))
			{
				itr=rL.erase(itr);
				if((itr!=rL.begin())&&(itr!=rL.end())){itr--;}
			}else{itr++;}
	}}
}
for(itrT=tupL.begin();itrT!=tupL.end();)
{
	if((maxClass/2)<=(itrT->y))
		{y++;}
	tupL.erase(itrT);
	itrT=tupL.begin();
}
if((x<3)||(y<3)||(rL.size()<10)){return;}
ofstream *stream=new ofstream("./tmpG1.txt");
if( stream!= NULL )
{
	for(list<TDResult>::iterator itr=rL.begin();itr!=rL.end();itr++)
		{writeResultBl(stream,(*itr));}
	stream->close();
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
makeData(rL,baseName);
plotData3D(baseName,3,"Literals L",(rL.begin())->atoms,"atoms",x,y);
}






int main()
/*with this programm results for the testcases are evaluet and outputed as
tables for excel import and graphs generated with gnuplot*/
{
list<TDResult> allResult;
unsigned int nboAtoms, nboLiteralsPerClause, nboClause;
int existsT;
//maximal values to wich the testcases should be readed
unsigned int maxNboAtoms=2000, maxNboLiteralsPerClause=6, maxNboClause=3000;//1000;2;5000?
unsigned int minNboLiteralsPerClause=1;//2
//delta values
unsigned int dNboAtoms=5, dNboLiteralsPerClause=1, dNboClause=10;//10;2;100

//read Data
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
for (nboAtoms=5;nboAtoms<=maxNboAtoms;nboAtoms+=dNboAtoms){//5..150
	char lsa[50];
	sprintf(lsa,"(ls ./ergebnisse/atwA%iL%iC*.txt) > tmp.txt",nboAtoms,nboLiteralsPerClause);
	existsT=system(lsa);
	if (existsT==0)//if existsT==0 the ther exists a test
	{
	for (nboClause=10;nboClause<=maxNboClause;nboClause+=dNboClause){//10..1500 +10
		char ls[50];
		sprintf(ls,"ls ./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
		existsT=system(ls);
		if (existsT==0)//if existsT==0 the ther exists a test
		{
			char file[50];
			sprintf(file,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
			allResult.insert(allResult.end(),evalueResult(file,nboAtoms,nboClause,nboLiteralsPerClause));
		}
	}}
}
}


//evalue data
list<TDResult> evResult;

//output data for one atom value, the rules are the x values in the graphs
for (nboAtoms=5;nboAtoms<=300;nboAtoms+=dNboAtoms){//5..150
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if((itr->atoms==nboAtoms)&&(itr->literals==nboLiteralsPerClause))
				{evResult.insert(evResult.end(),(*itr));}
		}
		if(evResult.size()>5)
		{
			char bs[50];
			sprintf(bs,"L%iA%iCV",nboLiteralsPerClause,nboAtoms);
			makeData(evResult,bs);
			plotData(bs,1,"rules/atoms R/A","RdA",nboAtoms,"atoms",nboLiteralsPerClause);
			plotData(bs,5,"rules R","R",nboAtoms,"atoms",nboLiteralsPerClause);
		}
		evResult.clear();
}}
//output data for one rule value, the atoms are the x values in the graphs
for (nboClause=10;nboClause<=3000;nboClause+=dNboClause){//5..150
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if((itr->rules==nboClause)&&(itr->literals==nboLiteralsPerClause))
				{evResult.insert(evResult.end(),(*itr));}
		}
		if(evResult.size()>5)
		{
			char bs[50];
			sprintf(bs,"L%iAVC%i",nboLiteralsPerClause,nboClause);
			makeData(evResult,bs);
			plotData(bs,1,"rules/atoms R/A","RdA",nboClause,"rules",nboLiteralsPerClause);
			plotData(bs,4,"atoms A","A",nboClause,"rules",nboLiteralsPerClause);
		}
		evResult.clear();
}}
//output data for one Faktor value, the rules or atoms are the x values in the graphs
//rules * atoms=Faktor
for (double Faktor=1.0;Faktor<=15.0;Faktor+=1.0){//5..150
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
		for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
		{
			if(((double(itr->rules)/double(itr->atoms))==Faktor)&&(itr->literals==nboLiteralsPerClause))
				{evResult.insert(evResult.end(),(*itr));}
		}
		if(evResult.size()>5)
		{
			char bs[50];
			sprintf(bs,"L%iAVCFxAF%i",nboLiteralsPerClause,int(Faktor));
			makeData(evResult,bs);
			plotData(bs,5,"rules R","R",(int)Faktor,"factor",nboLiteralsPerClause);
			plotData(bs,4,"atoms A","A",(int)Faktor,"factor",nboLiteralsPerClause);
		}
		evResult.clear();
}}

//output 3 dimensional graphs for testcases
for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->literals==nboLiteralsPerClause))
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	if ((evResult.size()>100))
		{plotData3DAtoms(evResult,bs);}
	evResult.clear();
}

for (nboAtoms=10;nboAtoms<=300;nboAtoms+=10){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->atoms==nboAtoms))
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3LVA%iCV",nboAtoms);
	if ((evResult.size()>100))
		{plotData3DLiterals(evResult,bs);}
	evResult.clear();
}


char b[20];
sprintf(b,"mkdir ./tabellen/tabelsLV");
system(b);

for (nboLiteralsPerClause=minNboLiteralsPerClause;nboLiteralsPerClause<=maxNboLiteralsPerClause;nboLiteralsPerClause+=dNboLiteralsPerClause){//2..5
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->literals==nboLiteralsPerClause))
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	makeData3D(evResult,bs);
	evResult.clear();
}
for (nboAtoms=10;nboAtoms<=300;nboAtoms+=10){
	for(list<TDResult>::iterator itr=allResult.begin();itr!=allResult.end();itr++)
	{
		if((itr->atoms==nboAtoms))
			{evResult.insert(evResult.end(),(*itr));}
	}
	char bs[50];
	sprintf(bs,"D3L%iAVCV",nboLiteralsPerClause);
	makeData3D(evResult,bs);
	evResult.clear();
}

cout<<endl;
}













