//	g++ -Wall -g -o gennf generatorNFak.cpp
/*File Name: generatorN.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++


  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"

using namespace std;

TRandomMersenne *rg1;

/*first half of literals are positiv atoms next half are ther negativ
so the values i in the literal list that are lower as the number of Atoms
in the program are the literals "ai" and the values i that are greater are
the literals "not a(i-(number of atoms))"*/
void printClausel(ofstream *outstr,list <unsigned int> literale,unsigned int nboAtoms)
/*prints a rule of the program
pre: the numbers of the literals to print in the list literale, the number
	of atoms in the program nboAtoms and the stream outstr to print the rule
	to
	the first number in the literal list is the number of the head atom
post: the rule of the literal list in the string outstr*/
{
unsigned int size=literale.size();//number of literals= two times number of atoms
//print head of clause
if (*(literale.begin())<nboAtoms)
	{(*outstr)<<"a"<<(*(literale.begin()))<<":-";}
else{(*outstr)<<":-";}//clausel is a constrain
//print body of clause

list<unsigned int>::iterator itr=literale.begin();
itr++;
for (unsigned int i=0;i<size-2;i++)
{
	if ((*itr)<nboAtoms)
		{(*outstr)<<"a"<<(*itr)<<",";}
	else{(*outstr)<<"not a"<<((*itr)-(nboAtoms))<<",";}
	itr++;
}
//print end of clause
if (*(itr)<nboAtoms)
	{(*outstr)<<"a"<<(*(itr))<<"."<<endl;}
else{(*outstr)<<"not a"<<(*(itr)-nboAtoms)<<"."<<endl;}
}

void printProgram(char* fname,list<list <unsigned int> > program,unsigned int nboAtoms)
/*prints the program that ist stored in the list of literal lists program
to a file with name fname
pre: the name fname of the file to store the program to, the program program and the number of
	possible atoms in the program
post: the program stored to a file with name fname*/
{
/* Open file in text mode: */
ofstream *stream=new ofstream(fname);
if( stream!= NULL )
{
	for (list<list <unsigned int> >::iterator itr=program.begin();itr!=program.end();itr++)
	{
		printClausel(stream,*itr,nboAtoms);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}

list<list <unsigned int> > generateProgram1(list<double> headProb,list<double> bodyProb, unsigned int nboClause, unsigned int nboLiteralsPerClause)
/*generates a program and stores it in a list of literal lists
pre: the probability list for the head atoms headprob, the probability of
	the body atoms bodyProb, the number of rules to generate nboClauses and
	the number of literals per rule body nboLiteralsPerClause
post: the generated  program with the fixed bodylength model
the last head probability is the probability in headProb that the rule is a
constraint (headProb.end()--=probability of constraints)*/
{
list<list <unsigned int> > program;
unsigned int tmp;//temporary variables
double rand;
//fix lenght modell
for (unsigned int c=0;c<nboClause;c++)
{
	list <unsigned int> clause;//temporary variables
	//choos head
	rand=rg1->Random();

	tmp=0;
	for (list<double>::iterator itr=headProb.begin();itr!=headProb.end();itr++)
	{
		if(rand<(*itr)){break;}
		rand-=(*itr);
		tmp++;
	}

//	cout<<"a"<<tmp<<":-";
	clause.insert(clause.end(),tmp);
	//choos literals; doubles allowed
	for (unsigned int l=0;l<nboLiteralsPerClause;l++)
	{
		rand=rg1->Random();
		tmp=0;
		for (list<double>::iterator itr=bodyProb.begin();itr!=bodyProb.end();itr++)
		{
			if(rand<(*itr)){break;}
			rand-=(*itr);
			tmp++;
		}

//		cout<<"a"<<tmp<<",";
		clause.insert(clause.end(),tmp);
	}

//	cout<<endl;
	program.insert(program.end(),clause);
}

return program;
}


void generateTestCase1(unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,unsigned int nboPrograms)
/*generates the programs for a testcase with the fixed body length model
pre: the number of posible atoms nboAtoms a program should have, the number
	of literals per rule body nboLiteralsPerClause, the number of rules
		nboClause a program should have, the probability constrProb that a rule
			is a constraint and the number of programs nboPrograms to generate
post: the generated number of programs in subfolder:
	"fleA(nboAtoms)L(nboLiteralsPerClause)C(nboClause)"*/
{
list<double> headProb,bodyProb;
for (unsigned int i=0;i<nboAtoms;i++)
{
	headProb.insert(headProb.end(),(1.0-constrProb)/nboAtoms);
//	cout<<(1.0-constrProb)/nboAtoms<<"   ";
}
headProb.insert(headProb.end(),constrProb);//probability of constrains
//cout<<endl;

for (unsigned int i=0;i<(nboAtoms*2);i++)
{
	bodyProb.insert(bodyProb.end(),1.0/(nboAtoms*2));
//	cout<<1.0/(nboAtoms*2)<<"   ";
}
//cout<<endl;

// Open testcase file in text mode:
char tcfile[100];
sprintf(tcfile,"./fleA%iL%iC%i/atestc.sweets",nboAtoms,nboLiteralsPerClause,nboClause);
ofstream *stream=new ofstream(tcfile);
if( stream!= NULL )
{
	for (unsigned int i=0;i<nboPrograms;i++)
	{
		//output for testcase file
		(*stream)<<"problem(b"<<i<<".lp)"<<endl;
		(*stream)<<"options(0)"<<endl;
		(*stream)<<"files(b"<<i<<".lp)"<<endl<<endl;
		//output for the logic program
		char file[100];
		sprintf(file,"./fleA%iL%iC%i/b%i.lp",nboAtoms,nboLiteralsPerClause,nboClause,i);
		printProgram(file,generateProgram1(headProb,bodyProb,nboClause, nboLiteralsPerClause),nboAtoms);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );


}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;

unsigned int nboAtoms, nboLiteralsPerClause, nboClause,Faktor;
double constrProb=0.0;

unsigned int nboStartAtoms, nboStartLiteralsPerClause, nboStartClause;
/* load last end point as start point */
ifstream *stream=new ifstream("spointf.txt");
if( stream!= NULL )
{
	char ch;
	(*stream)>>nboStartLiteralsPerClause;
	(*stream)>>ch;
	(*stream)>>nboStartClause;
	(*stream)>>ch;
	(*stream)>>nboStartAtoms;
	cout<<endl<<"Start at :"<<endl<<" Literals : "<<nboStartLiteralsPerClause<<"; Startclause : "<<nboStartClause<<"; Startatoms : "<<nboStartAtoms<<endl<<endl;
	delete stream;
}
else
	printf( "Problem opening the file\n" );

int ret=0,existsT;
bool first=true;
for (nboLiteralsPerClause=2;nboLiteralsPerClause<=5;nboLiteralsPerClause+=1){//2..5
for (Faktor=1;Faktor<=15;Faktor+=1){//10..1500 +10
for (nboAtoms=10;nboAtoms<=2000;nboAtoms+=10){//5..150
	if (first){
		nboLiteralsPerClause=nboStartLiteralsPerClause;
		Faktor=nboStartClause;
		nboAtoms=nboStartAtoms;
		first=false;
	}
	nboClause=nboAtoms*Faktor;
	char ls[50];
	sprintf(ls,"ls ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
	existsT=system(ls);
	if (existsT)//if existsT==0 the ther exists a test
	{
		//save this point as last end state
		ofstream *stream=new ofstream("spointf.txt");
		if( stream!= NULL )
		{
			(*stream)<<nboLiteralsPerClause<<";"<<Faktor<<";"<<nboAtoms<<";"<<endl;
			delete stream;
		}
		else
			printf( "Problem opening the file\n" );

		//make direktory
		char b[20];
		sprintf(b,"mkdir fleA%iL%iC%i",nboAtoms,nboLiteralsPerClause,nboClause);
		cout<<endl<<b<<endl<<endl;
		system(b);
		//unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,int nboPrograms
		generateTestCase1(nboAtoms,nboLiteralsPerClause,nboClause,constrProb,1000);
		//go into directory; execute BMTool; delete testcase
		char bmt[400];
		sprintf(bmt,"cd fleA%iL%iC%i ; bmtool -e /home/biokom/diplom/BMTool/extraction.nomore -o /home/biokom/diplom/BMTool/schemataNM -n=1 -p atestc.sweets /home/biokom/diplom/nomorepp/nomorepp/nomorepp > /home/biokom/diplom/casesN/ergebnisse/atwA%iL%iC%i.txt  ; rm * ",nboAtoms,nboLiteralsPerClause,nboClause,nboAtoms,nboLiteralsPerClause,nboClause);
		ret=system(bmt);
		char rmd[20];
		sprintf(rmd,"rmdir fleA%iL%iC%i",nboAtoms,nboLiteralsPerClause,nboClause);
		system(rmd);
	}
	if (WIFSIGNALED(ret)) break;

}
	if (WIFSIGNALED(ret)) break;
}
	if (WIFSIGNALED(ret)) break;
}

cout<<endl;
}


