//	g++ -Wall -g -o gen generator.cpp
/*File Name: generator.cpp
  Author: Bernd sterholz ; Date: 22.09.2005
  System: C++

  
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"

using namespace std;

TRandomMersenne *rg1;


void evOutput(ofstream *ostream,unsigned int num)
/*This method reads (pars) the output of the solver and writes the data, with
the BMTool Form, to the given output stream
pre: the output stream ostream to write the readed data to and the number
	of the actual example num
post: the readed data in the stream*/
{
char c;
unsigned int answer,choice,choiceP;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';i=0;
		answer=1;
	}else{//no Answer
		answer=0;
	}
	i=0;c='A';
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choiceP;


//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<choiceP<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<"  |"<<endl;
	delete tstream;
}
else
	printf( "Problem opening the file\n" );
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}

void evResult(char* folder,char* output,unsigned int nOExamples)
/*this method evalues a test point, by evaluing the generated logic programs
with the ASP-solver and outputing the results to a file
pre: the name folder of the folder wher the programs to evaluat are stored,
	the name output of the file wher to output (with the BMTool form) the
	result and the number of examples/programs to evalue
post: the results of the testcases in the file with name output*/
{
ofstream *ostream=new ofstream(output);
(*ostream)<<"nomore 1.2"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;

if( ostream!= NULL )
{
	for (unsigned int i=0;i<nOExamples;i++)
	{
		char ev[100];
		sprintf(ev,"(lparse ./%s/b%i.lp | nomore)>tmp.txt",folder,i);
		cout<<ev<<endl;
		system(ev);
		evOutput(ostream,i);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else
	printf( "Problem opening the file\n" );
}



/*first half of literals are positiv atoms next half are ther negativ
so the values i in the literal list that are lower as the number of Atoms
in the program are the literals "ai" and the values i that are greater are
the literals "not a(i-(number of atoms))"*/
void printClausel(ofstream *outstr,list <unsigned int> literale,unsigned int nboAtoms)
/*prints a rule of the program
pre: the numbers of the literals to print in the list literale, the number
	of atoms in the program nboAtoms and the stream outstr to print the rule
	to
	the first number in the literal list is the number of the head atom
post: the rule of the literal list in the string outstr*/
{
unsigned int size=literale.size();//number of literals= two times number of atoms
//print head of clause
if (*(literale.begin())<nboAtoms)
	{(*outstr)<<"a"<<(*(literale.begin()))<<":-";}
else{(*outstr)<<":-";}//clausel is a constrain
//print body of clause

list<unsigned int>::iterator itr=literale.begin();
itr++;
for (unsigned int i=0;i<size-2;i++)
{
	if ((*itr)<nboAtoms)
		{(*outstr)<<"a"<<(*itr)<<",";}
	else{(*outstr)<<"not a"<<((*itr)-(nboAtoms))<<",";}
	itr++;
}
//print end of clause
if (*(itr)<nboAtoms)
	{(*outstr)<<"a"<<(*(itr))<<"."<<endl;}
else{(*outstr)<<"not a"<<(*(itr)-nboAtoms)<<"."<<endl;}
}

void printProgram(char* fname,list<list <unsigned int> > program,unsigned int nboAtoms)
/*prints the program that ist stored in the list of literal lists program
to a file with name fname
pre: the name fname of the file to store the program to, the program program and the number of
	possible atoms in the program
post: the program stored to a file with name fname*/
{
/* Open file in text mode: */
ofstream *stream=new ofstream(fname);
if( stream!= NULL )
{
	for (list<list <unsigned int> >::iterator itr=program.begin();itr!=program.end();itr++)
	{
		printClausel(stream,*itr,nboAtoms);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}

list<list <unsigned int> > generateProgram1(list<double> headProb,list<double> bodyProb, unsigned int nboClause, unsigned int nboLiteralsPerClause)
/*generates a program and stores it in a list of literal lists
pre: the probability list for the head atoms headprob, the probability of
	the body atoms bodyProb, the number of rules to generate nboClauses and
	the number of literals per rule body nboLiteralsPerClause
post: the generated  program with the fixed bodylength model
the last head probability is the probability in headProb that the rule is a
constraint (headProb.end()--=probability of constraints)*/
{
list<list <unsigned int> > program;
unsigned int tmp;//temporary variables
double rand;
//fix lenght modell
for (unsigned int c=0;c<nboClause;c++)
{
	list <unsigned int> clause;//temporary variables
	//choos head
	rand=rg1->Random();

	tmp=0;
	for (list<double>::iterator itr=headProb.begin();itr!=headProb.end();itr++)
	{
		if(rand<(*itr)){break;}
		rand-=(*itr);
		tmp++;
	}

//	cout<<"a"<<tmp<<":-";
	clause.insert(clause.end(),tmp);
	//choos literals; doubles allowed
	for (unsigned int l=0;l<nboLiteralsPerClause;l++)
	{
		rand=rg1->Random();
		tmp=0;
		for (list<double>::iterator itr=bodyProb.begin();itr!=bodyProb.end();itr++)
		{
			if(rand<(*itr)){break;}
			rand-=(*itr);
			tmp++;
		}

//		cout<<"a"<<tmp<<",";
		clause.insert(clause.end(),tmp);
	}

//	cout<<endl;
	program.insert(program.end(),clause);
}

return program;
}


void generateTestCase1(unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,unsigned int nboPrograms)
/*generates the programs for a testcase with the fixed body length model
pre: the number of posible atoms nboAtoms a program should have, the number
	of literals per rule body nboLiteralsPerClause, the number of rules
	nboClause a program should have, the probability constrProb that a rule
	is a constraint and the number of programs nboPrograms to generate
post: the generated number of programs in subfolder:
	"fleA(nboAtoms)L(nboLiteralsPerClause)C(nboClause)"*/
{
list<double> headProb,bodyProb;
for (unsigned int i=0;i<nboAtoms;i++)
{
	headProb.insert(headProb.end(),(1.0-constrProb)/nboAtoms);
//	cout<<(1.0-constrProb)/nboAtoms<<"   ";
}
headProb.insert(headProb.end(),constrProb);//probability of constrains
//cout<<endl;

for (unsigned int i=0;i<(nboAtoms*2);i++)
{
	bodyProb.insert(bodyProb.end(),1.0/(nboAtoms*2));
//	cout<<1.0/(nboAtoms*2)<<"   ";
}
//cout<<endl;

// Open testcase file in text mode:
char tcfile[100];
sprintf(tcfile,"./fleA%iL%iC%i/atestc.sweets",nboAtoms,nboLiteralsPerClause,nboClause);
ofstream *stream=new ofstream(tcfile);
if( stream!= NULL )
{
	for (unsigned int i=0;i<nboPrograms;i++)
	{
		//output for testcase file
		(*stream)<<"problem(b"<<i<<".lp)"<<endl;
		(*stream)<<"options(0)"<<endl;
		(*stream)<<"files(b"<<i<<".lp)"<<endl<<endl;
		//output for the logic program
		char file[100];
		sprintf(file,"./fleA%iL%iC%i/b%i.lp",nboAtoms,nboLiteralsPerClause,nboClause,i);
		printProgram(file,generateProgram1(headProb,bodyProb,nboClause, nboLiteralsPerClause),nboAtoms);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );


}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;

unsigned int nboAtoms=0, nboLiteralsPerClause=0, nboClause=0;
double constrProb=0.0;

/* load last end point as start point */
ifstream *stream=new ifstream("todoN.txt");


int ret=0;
while(true)
{
	if( stream!= NULL )
	{
		char ch;
		(*stream)>>nboLiteralsPerClause;
		(*stream)>>ch;
		if (ch=='.') {break;}
		(*stream)>>nboClause;
		(*stream)>>ch;
		(*stream)>>nboAtoms;
		(*stream)>>ch;
		cout<<"point :"<<endl<<" literals : "<<nboLiteralsPerClause<<"; clause : "<<nboClause<<"; atoms : "<<nboAtoms<<endl<<endl;
	} else {printf( "Problem opening the file\n" );}

	//save this point as last end state
	ofstream *ostream=new ofstream("spoint.txt");
	if( stream!= NULL )
	{
		(*ostream)<<nboLiteralsPerClause<<";"<<nboClause<<";"<<nboAtoms<<";"<<endl;
		delete ostream;
	} else {printf( "Problem opening the file\n" );}
		//make direktory
	char b[20];
	sprintf(b,"mkdir fleA%iL%iC%i",nboAtoms,nboLiteralsPerClause,nboClause);
	cout<<b<<endl;
	system(b);
	//unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,int nboPrograms
	generateTestCase1(nboAtoms,nboLiteralsPerClause,nboClause,constrProb,1000);
	//go into directory; execute BMTool; delete testcase
	char folder[40],result[40];
	sprintf(folder,"fleA%iL%iC%i",nboAtoms,nboLiteralsPerClause,nboClause);
	sprintf(result,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClause,nboClause);
	evResult(folder,result,1000);
	char rmf[20];
	sprintf(rmf,"rm ./fleA%iL%iC%i/*.*",nboAtoms,nboLiteralsPerClause,nboClause);
	cout<<rmf<<endl;
	system(rmf);
	char rmd[20];
	sprintf(rmd,"rmdir fleA%iL%iC%i",nboAtoms,nboLiteralsPerClause,nboClause);
	system(rmd);//delete testcasedir
	if (WIFSIGNALED(ret)) {break;}
}
if( stream!= NULL ){delete stream;}
cout<<endl;
}


