//	g++ -Wall -g -o gr graph.cpp
//generates random graphs and evalue hamiltion cycles fia smodels for them
/*File Name: generator.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <set>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"

using namespace std;

TRandomMersenne *rg1;

class TEdge {
//Type for edges
public:
	unsigned int source;
	unsigned int destination;
	bool operator<(const TEdge edg) const
	{
		return ((source<edg.source)||((source==edg.source)&&(destination<edg.destination)));
	}
	bool operator==(const TEdge edg) const
	{
		return ((source==edg.source)&&(destination==edg.destination));
	}
};

void evOutput(ofstream *ostream,unsigned int num,double literals)
/*This method reads (pars) the output of the solver and writes the data, with
the BMTool Form, to the given output stream
pre: the output stream ostream to write the readed data to and the number
	of the actual example num
post: the readed data in the stream*/
{
char c;
unsigned int answer,choice,wchoice,trueAS,atoms,rules,searchSp;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
//cout<<"evalue : "<<num<<" : "<<tstream<<" ; ";
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';i=0;
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		answer=1;
	}else{//no Answer
		answer=0;
	}
	i=0;
	c='A';
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>wchoice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>atoms;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>rules;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>trueAS;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>searchSp;

//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<wchoice<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<";"<<literals<<"  |"<<endl<<flush;
//	cout<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<"  |"<<endl<<flush;
	delete tstream;
}
else{printf( "Problem opening the file\n" );}
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}

double evalueLiterals()
/*evalue the average number of literals per rule body literals in the lparse
file ./tprog.lp*/
{
double literals=0.0;
unsigned int nbORules=0;
ifstream *stream=new ifstream("./tprog.lp");
unsigned int z,bodyAtoms,negB;
//read rules
while (true)
{
	(*stream)>>z;
//	cout<<z<<flush;
	if ((z==0)||(nbORules>1000000)) {break;}
	if (z==3)
		{(*stream)>>z;}
	nbORules++;
	(*stream)>>negB;//read head
	(*stream)>>bodyAtoms;
	(*stream)>>negB;//negativ body literals
	if (z==2)
		{(*stream)>>z;}
//	cout<<" "<<z<<" "<<bodyAtoms<<" "<<negB<<flush<<endl;
	//read body
	literals+=bodyAtoms;
	for (unsigned int i=0;i<bodyAtoms;i++)
		{(*stream)>>z;}
}
delete stream;
return double(literals)/double(nbORules);
}

void evResult(char* folder,char* output,unsigned int nOExamples)
/*this method evalues a test point, by evaluing the generated logic programs
with the ASP-solver and outputing the results to a file
in the file hampath.lp is the algorithm stored for evaluing hamiltonia
cycels of graphs
pre: the name folder of the folder wher the programs to evaluat are stored,
	the name output of the file wher to output (with the BMTool form) the
	result and the number of examples/programs to evalue
post: the results of the testcases in the file with name output*/
{
ofstream *ostream=new ofstream(output);
(*ostream)<<"smodels-2.28"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;
double literals=0.0;
if( ostream!= NULL )
{
	for (unsigned int i=0;i<nOExamples;i++)
	{
		char ev[100];
		sprintf(ev,"(~/wv/lparse-1.0.13/src/lparse ./hampath.lp ./%s/b%i.lp )> ./tprog.lp ",folder,i);
//		sprintf(ev,"(lparse ./hampath.lp ./%s/b%i.lp | smodels )>tmp.txt",folder,i);
//		cout<<ev<<endl;
		system(ev);
		literals=evalueLiterals();
		cout<<ev<<endl;
		system(ev);
		char ev2[100];
		sprintf(ev2,"(~/wv/smodels-2.28/smodels < ./tprog.lp)>tmp.txt");
		cout<<ev2<<endl;
		system(ev2);
		evOutput(ostream,i,literals);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else
	printf( "Problem opening the file\n" );
}


void printProgram(char* fname,set<TEdge> edges,unsigned int vertices)
/*prints the data part of the program (the graph) that ist stored in the
set of edges edges to a file with name fname
pre: the name fname of the file to store the program to, the graph edges
	and the number of the edges in the graph
post: the data part of the program stored to a file with name fname*/
{
/* Open file in text mode: */
ofstream *stream=new ofstream(fname);
if( stream!= NULL )
{
	//print vertices
	for (unsigned int i=0;i<vertices;i++)
	{
		(*stream)<<"vertex("<<i<<")."<<endl;
	}
	(*stream)<<endl;
	for (set<TEdge>::iterator itr=edges.begin();itr!=edges.end();itr++)
	{
		(*stream)<<"arc("<<itr->source<<","<<itr->destination<<")."<<endl;
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}

set<TEdge > generateGraph1(unsigned int vertices,unsigned int edges)
/*generates a directed graph with no double edges
pre: the number of vertices and edges the grph should have
post: the graph as a set of edges*/
{
set<TEdge> graph;
TEdge edge;
unsigned int max=0;
//fix lenght modell
while (graph.size()<edges)
{
	edge.source=(unsigned int)(rg1->Random()*vertices);
	edge.destination=(unsigned int)(rg1->Random()*vertices);
	graph.insert(graph.end(),edge);
	max++;//don`t go infinum
	if (max>100000*vertices*vertices) {break;}
}
return graph;
}


void generateTestCase1(unsigned int vertices,unsigned int edges,unsigned int nboPrograms)
/*generates the programs data part (graphs) for a testcase
pre: the number of vertices and edges a graph should have, and the number
	of programs nboPrograms to generate
post: the generated number of programs in subfolder:
	"gV(vertices)E(edges)"*/
{
// Open testcase file in text mode:
char tcfile[100];
sprintf(tcfile,"./gV%iE%i/atestc.sweets",vertices,edges);
ofstream *stream=new ofstream(tcfile);
if( stream!= NULL )
{
	for (unsigned int i=0;i<nboPrograms;i++)
	{
		//output for testcase file
		(*stream)<<"problem(b"<<i<<".lp)"<<endl;
		(*stream)<<"options(0)"<<endl;
		(*stream)<<"files(b"<<i<<".lp)"<<endl<<endl;
		//output for the logic program
		char file[100];
		sprintf(file,"./gV%iE%i/b%i.lp",vertices,edges,i);
		printProgram(file,generateGraph1(vertices,edges),vertices);
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;

unsigned int vertices=0, edges=0;

/* load last end point as start point */
ifstream *stream=new ifstream("tdG.txt");


int ret=0;
while(true)
{
	if( stream!= NULL )
	{
		char ch;
		(*stream)>>vertices;
		(*stream)>>ch;
		if (ch=='.') {break;}
		(*stream)>>edges;
		(*stream)>>ch;
		cout<<"point :"<<endl<<" vertices : "<<vertices<<"; edges : "<<edges<<endl<<endl;
	} else {printf( "Problem opening the file\n" );}

	//save this point as last end state
	ofstream *ostream=new ofstream("spG.txt");
	if( stream!= NULL )
	{
		(*ostream)<<vertices<<";"<<edges<<";"<<endl;
		delete ostream;
	} else {printf( "Problem opening the file\n" );}
		//make direktory
	char b[20];
	sprintf(b,"mkdir gV%iE%i",vertices,edges);
	cout<<b<<endl;
	system(b);
	//unsigned int nboAtoms,unsigned int nboLiteralsPerClause,unsigned int nboClause,double constrProb,int nboPrograms
	generateTestCase1(vertices,edges,1000);
	//go into directory; execute BMTool; delete testcase
	char folder[40],result[40];
	sprintf(folder,"gV%iE%i",vertices,edges);
	sprintf(result,"./ergebnisse/gV%iE%i.txt",vertices,edges);
	evResult(folder,result,1000);
	char rmf[20];
	sprintf(rmf,"rm ./gV%iE%i/*.*",vertices,edges);
	cout<<rmf<<endl;
	system(rmf);
	char rmd[20];
	sprintf(rmd,"rmdir gV%iE%i",vertices,edges);
	system(rmd);//delete testcasedir
	if (WIFSIGNALED(ret)) {break;}
}
if( stream!= NULL ){delete stream;}
cout<<endl;
}


