//	g++ -Wall -g -o ev evaluatorAtRukg.cpp
/*File Name:
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>


using namespace std;

class TData {
public:
	double time;
	unsigned int choice;
	unsigned int wchoice;
	unsigned int answer;
	unsigned int trueAss;
	unsigned int atoms;
	unsigned int rules;
	unsigned int literals;
	unsigned int dim;
	unsigned int rob;
	unsigned int wall;
	unsigned int mtime;
	bool operator<(const TData tdat) const
	{
		return ((atoms<tdat.atoms)||((atoms==tdat.atoms)&&
			((rules<tdat.rules)||((rules==tdat.rules)&&
			((dim<tdat.dim))||((dim==tdat.dim)&&
			((rob<tdat.rob)||((rob==tdat.rob)&&
			((wall<tdat.wall)||((wall<tdat.wall)&&
			(mtime<tdat.mtime))))))))));
	}
	bool operator==(const TData tdat) const
	{
		return ((atoms==tdat.atoms)&&(rules==tdat.rules)&&(dim==tdat.dim)&&(rob==tdat.rob)&&
		(wall==tdat.wall)&&(mtime==tdat.mtime));
	}
};

typedef struct TDResult {
	char name[100];
	unsigned int atoms;
	unsigned int rules;
	unsigned int literals;
	unsigned int dim;
	unsigned int rob;
	unsigned int wall;
	unsigned int mtime;
	unsigned int examples;
	double avTime;//average time
	double avSearchSp;//average search space
	double avChoice;//average choice
	unsigned int posExamples;//positive examples
	double posAvTime;//average time of positive examples
	double posAvSearchSp;//average search space of positive examples
	double posAvChoice;//average choice of positive examples
	unsigned int negExamples;//negative examples
	double negAvTime;//average time of negative examples
	double negAvSearchSp;//average search space of negative examples
	double negAvChoice;//average choice of negative examples
	double minTime;//minimal time
	double maxTime[10];//maximal time of the classes with 10 per cent of examples
	//, which are the next better after maxTime[n-1](btw if n=0 minTime)
	unsigned int minSearchSp;//minimal search space
	unsigned int maxSearchSp;//maximal search space
	double clAvTime[10];//average time of the classes with 10 per cent of examples
	double timeSpread;//spread of the time values
	double searchSpSpread;//spread of the search space values
	double timeVarianz;//time varianz
	double choiceVarianz;//choice point varianze
	double searchSpVarianz;//search space varianz
/*	double timeMean;//time mean (Streuung)
	double searchSpMean;//search space mean (Streuung)
*/	double averageAtoms;
	double averageRules;
	double avCTQutient;
	double cTQutientVarianz;
} TDResult;


void readData(list<TData>* tmpDataL, char* file,unsigned int dim,unsigned int rob,unsigned int wall,unsigned int mtime)
{
char c=' ';
unsigned int i;
char name[100];
TData dat;
dat.time=0.0;
dat.choice=0;
dat.wchoice=0;
dat.answer=0;
dat.trueAss=0;
dat.atoms=0;
dat.rules=0;
dat.literals=0;
dat.dim=dim;
dat.rob=rob;
dat.wall=wall;
dat.mtime=mtime;

char ls[100];
sprintf(ls,"ls %s",file);
int existsT=system(ls);//test if ther exists such file
if (existsT!=0){return;}

ifstream *stream=new ifstream(file);
if( stream!= NULL )
{
	//read first part
	i=0;
	while (c!='|')
	{
		(*stream)>>c;
		if (!((c=='|')||(c==' '))) {name[i]=c;i++;}
	}
	name[i+1]=0;
	cout<<name<<endl<<flush;
	(*stream)>>c;
	while (c!='|'){(*stream)>>c;}
	while (c!='l'){(*stream)>>c;}
//read line
	while (true)
	{
		c='a';
		while (!((c=='|')||(c=='-'))){(*stream)>>c;}
		if (c=='-'){break;}
		(*stream)>>dat.time;
		(*stream)>>c;//read ';'
		(*stream)>>dat.choice;
		(*stream)>>c;//read ';'
		(*stream)>>dat.wchoice;
		(*stream)>>c;//read ';'
		(*stream)>>c;
		if(c=='1')
		{
			dat.answer=1;
		}else{//"NV"
			dat.answer=0;
			(*stream)>>c;
		}
		(*stream)>>c;//read ';'
		if ((c==';')||(c==','))
		{
			(*stream)>>dat.trueAss;
			(*stream)>>c;//read ';'
			if ((c==';')||(c==','))
			{
				(*stream)>>dat.atoms;
				(*stream)>>c;//read ';'
					if ((c==';')||(c==','))
					{
						(*stream)>>dat.rules;
						(*stream)>>c;//read ';'
						if ((c==';')||(c==','))
						{
							(*stream)>>i;
							(*stream)>>c;//read ';'
							if ((c==';')||(c==','))
							{
								(*stream)>>dat.literals;
								(*stream)>>c;//read ';'
		}}}}}
		while (c!='|'){(*stream)>>c;}

//		cout<<dat.time<<";"<<dat.choice<<";"<<dat.wchoice<<";"<<dat.answer;
//		cout<<";"<<dat.trueAss<<";"<<dat.atoms<<";"<<dat.rules<<endl;
		if(dat.rules>0){tmpDataL->insert(tmpDataL->end(),dat);}
	}
	delete stream;
}
else
	{printf( "Problem opening the file\n" );}
return;
}


TDResult evalueResult(list<TData> dataL,unsigned int atm,unsigned int rul,unsigned int dim,unsigned int rob,unsigned int wall,unsigned int mtime)
{
TDResult result;
unsigned int i=0;
sprintf(result.name,"A%iR%i",atm,rul);
result.atoms=atm;
result.rules=rul;
result.dim=dim;
result.rob=rob;
result.wall=wall;
result.mtime=mtime;
result.examples=dataL.size();
dataL.sort();
//average time
result.avTime=0.0;
result.avChoice=0.0;
//average search space
result.avSearchSp=0.0;
//positive examples
result.posExamples=0;
//average time of positive examples
result.posAvTime=0.0;
result.posAvChoice=0.0;
//rage search space of positive examples
result.posAvSearchSp=0.0;
//average time of negative examples
result.negAvTime=0.0;
result.negAvChoice=0.0;
//average search space of negative examples
result.negAvSearchSp=0.0;
i=0;
result.minSearchSp=(0-1);//minimal search space
result.maxSearchSp=0;//maximal search space
result.timeVarianz=0.0;//time varianz
result.choiceVarianz=0.0;
result.searchSpVarianz=0.0;//search space varianz
for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=0;}
for (unsigned int a=0;a<10;a++)
	{result.maxTime[a]=(dataL.begin())->time;}
result.averageAtoms=0.0;
result.averageRules=0.0;
result.avCTQutient=0.0;
result.cTQutientVarianz=0.0;
for (list<TData>::iterator itr=dataL.begin();itr!=dataL.end();itr++)
{
	result.avTime+=itr->time;
	result.avSearchSp+=(double)(itr->trueAss);
	result.avChoice+=(double)(itr->choice);
	result.averageAtoms+=itr->atoms;
	result.averageRules+=itr->rules;
	i++;
	if ((((i*10)/dataL.size())*dataL.size())==(i*10))
		{result.maxTime[((i-1)*10)/dataL.size()]=itr->time;}
	result.clAvTime[(i*10)/dataL.size()]+=itr->time;
	if (itr->answer)
	{	result.posExamples++;
		result.posAvTime+=itr->time;
		result.posAvSearchSp+=(double)(itr->trueAss);
		result.posAvChoice+=(double)(itr->choice);
	}else{
		result.negAvTime+=itr->time;
		result.negAvSearchSp+=(double)(itr->trueAss);
		result.negAvChoice+=(double)(itr->choice);
	}
	if (result.minSearchSp>((itr->trueAss))) {result.minSearchSp=(itr->trueAss);}
	if (result.maxSearchSp<((itr->trueAss))) {result.maxSearchSp=(itr->trueAss);}
	result.timeVarianz+=(itr->time)*(itr->time);
	result.choiceVarianz+=(double)(itr->choice)*(double)(itr->choice);
	result.searchSpVarianz+=(double)(itr->trueAss)*(double)(itr->trueAss);
	result.avCTQutient+=((double)(itr->choice))/(itr->time);
	result.cTQutientVarianz+=(((double)(itr->choice))/(itr->time))*(((double)(itr->choice))/(itr->time));
}
result.avSearchSp=result.avSearchSp/dataL.size();
result.avTime=result.avTime/dataL.size();
result.avChoice=result.avChoice/dataL.size();
result.avCTQutient=result.avCTQutient/dataL.size();
result.posAvTime=result.posAvTime/result.posExamples;
result.posAvChoice=result.posAvChoice/result.posExamples;
result.posAvSearchSp=result.posAvSearchSp/result.posExamples;
result.negExamples=dataL.size()-result.posExamples;//negative examples
result.negAvTime=result.negAvTime/result.negExamples;
result.negAvChoice=result.negAvChoice/result.negExamples;
result.negAvSearchSp=result.negAvSearchSp/result.negExamples;
result.averageAtoms=result.averageAtoms/dataL.size();
result.averageRules=result.averageRules/dataL.size();
result.minTime=(dataL.begin())->time;//minimal time
result.timeSpread=result.maxTime[9]-result.minTime;
result.searchSpSpread=result.maxSearchSp-result.minSearchSp;
result.timeVarianz=(result.timeVarianz)/dataL.size()-(result.avTime)*(result.avTime);
result.choiceVarianz=(result.choiceVarianz)/dataL.size()-(result.avChoice)*(result.avChoice);
result.searchSpVarianz=(result.searchSpVarianz)/dataL.size()-(result.avSearchSp)*(result.avSearchSp);
result.cTQutientVarianz=(result.cTQutientVarianz)/dataL.size()-(result.avCTQutient)*(result.avCTQutient);

for (unsigned int a=0;a<10;a++)
	{result.clAvTime[a]=(result.clAvTime[a]*10.0)/dataL.size();}
return result;
}

void writeResult(ofstream *stream,TDResult result)
{
(*stream)<<" ; "<<result.name<<" ; "<<result.atoms<<" ; "<<result.rules<<" ; "<<result.dim<<" ; "<<result.rob;
(*stream)<<" ; "<<result.wall<<" ; "<<result.mtime<<" ; "<<result.examples;
(*stream)<<" ; "<<result.avTime<<" ; "<<result.avChoice<<" ; "<<result.avSearchSp;
(*stream)<<" ; "<<result.posExamples<<" ; "<<(double(result.posExamples))/(double(result.examples))<<" ; "<<result.posAvTime;
(*stream)<<" ; "<<result.posAvChoice<<" ; "<<result.posAvSearchSp;
(*stream)<<" ; "<<result.negExamples<<" ; "<<(double(result.negExamples))/(double(result.examples))<<" ; "<<result.negAvTime;
(*stream)<<" ; "<<result.negAvChoice<<" ; "<<result.negAvSearchSp;
(*stream)<<" ; "<<result.minTime;
for (unsigned int i=0;i<10;i++){(*stream)<<" ; "<<result.maxTime[i];}
for (unsigned int i=0;i<10;i++){(*stream)<<" ; "<<result.clAvTime[i];}
(*stream)<<" ; "<<result.minSearchSp<<" ; "<< result.maxSearchSp;
(*stream)<<" ; "<<result.timeSpread<<" ; "<<result.searchSpSpread;
(*stream)<<" ; "<<result.timeVarianz<<" ; "<<result.choiceVarianz<<" ; "<<result.searchSpVarianz;
(*stream)<<" ; "<< result.averageAtoms<<" ; "<< result.averageRules;
(*stream)<<" ; "<< result.avCTQutient<<" ; "<< result.cTQutientVarianz<<endl;
}

void printData(list<TData>* dataL,ofstream *stream)
{
TData oldDat;
dataL->sort();
oldDat=(*(dataL->begin()));
list<TData> dataTmp;
dataTmp.insert(dataTmp.end(),oldDat);
for (list<TData>::iterator itr=dataL->begin();itr!=dataL->end();itr++)
{
	if(oldDat==(*itr))
		{dataTmp.insert(dataTmp.end(),(*itr));}
	else{
		if(dataTmp.size()>0)
			{writeResult(stream,evalueResult(dataTmp,oldDat.atoms,oldDat.rules,oldDat.dim,oldDat.rob,oldDat.wall,oldDat.mtime));}
		oldDat=(*itr);
		dataTmp.clear();
		dataTmp.insert(dataTmp.end(),(*itr));
	}
}
}

void writeHead(ofstream *stream)
{
(*stream)<<" ; name ;atoms ;rules ;dim ;rob ;wall ;max time ; examples ; average time ; average choices ; average search space";
(*stream)<<" ; positiv examples ;prop. pos. examples ; positiv average time ; positiv average choices ; positiv average search space";
(*stream)<<" ; negativ examples ;prop. pos. examples ; negativ average time ; negativ average choices ; negative average search space";
(*stream)<<" ; min Time";
for (unsigned int i=0;i<10;i++){(*stream)<<" ; max time "<<i;}
for (unsigned int i=0;i<10;i++){(*stream)<<" ; class av. time "<<i;}
(*stream)<<" ; minimal search space ; maximal search space ; time spread ; search space spread";
(*stream)<<" ; time varianz ; choicepoint varianz ; search space varianz ; average atoms ; average rules";
(*stream)<<" ; average CTQutient ; CTQutient varianz ;"<<endl;
}

int main()
{
//TDResult result;
unsigned int dim,rob, wall,time;
int existsT;
list<TData>* DataL=new list<TData>;

char outf[50];
sprintf(outf,"./tabellen/AllAtomsRulesSmallEG0.txt");
ofstream *stream=new ofstream(outf);
writeHead(stream);
if( stream!= NULL )
{
	for (dim=3;dim<=5;dim+=1){
	for (rob=1;rob<=dim;rob+=1){
	for (wall=0;wall<=dim*dim;wall+=dim){
	for (time=1;time<=100;time+=1){
		char ls[50];
		sprintf(ls,"ls ./ergebnisse/gD%iW%iR%iT%i.txt",dim,wall,rob,time);//gD3W0R1T3.txt
		existsT=system(ls);
		if (existsT==0)//if existsT==0 the ther exists a test
		{
			char file[50];
			sprintf(file,"./ergebnisse/gD%iW%iR%iT%i.txt",dim,wall,rob,time);
			readData(DataL,file,dim,rob,wall,time);
		}
	}}}}
	printData(DataL,stream);
	delete stream;
}else
	{printf( "Problem opening the file\n" );}
cout<<endl;
}













