//g++ -Wall -g -o genC generateC.cpp
/*
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <list>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"


using namespace std;

TRandomMersenne* rg1;

typedef struct TClausel {
	unsigned int head;
	list<unsigned int> bodyP;
	list<unsigned int> bodyN;
} TClausel;

void evOutput(ofstream *ostream,unsigned int num)
{
char c;
unsigned int answer,choice,wchoice,trueAS,atoms,rules,searchSp;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}c='A';
		i=0;
		while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>10000000) {delete tstream;return;}}c='A';
		answer=1;
	}else{//no Answer
		answer=0;
	}
	c='A';i=0;
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>wchoice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>atoms;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>rules;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>trueAS;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>searchSp;

//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<wchoice<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<"  |"<<endl;
	delete tstream;
}
else
	printf( "Problem opening the file\n" );
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}

bool generateProgram(unsigned int nboAtoms,unsigned int nboLiteralsPerClauseTen,unsigned int nboClause,TClausel* clauses)
{
//conect all atoms
unsigned int totalBL=0;//total number of Body literals
if (nboAtoms>nboClause){return false;}
for (unsigned int i=1;i<nboAtoms;i++)
{
	clauses[i-1].head=i;//random lower head
	if ((rg1->Random())<0.5)//insert Atom i negativ or positiv to the body?
		{clauses[i-1].bodyP.insert(clauses[i-1].bodyP.end(),rg1->IRandom(0,(i-1)));}
	else {clauses[i-1].bodyN.insert(clauses[i-1].bodyN.end(),rg1->IRandom(0,(i-1)));}
	totalBL++;
}
//generate rest heads
for (unsigned int i=(nboAtoms-1);i<nboClause;i++)
{
	clauses[i].head=rg1->IRandom(0,nboAtoms);//random head
}
unsigned int clause;//wich clause to change
while (true)
{
	if(((double)(totalBL)/(double)(nboClause))>=((double)(nboLiteralsPerClauseTen)/10)){break;}
	totalBL++;
	clause=rg1->IRandom(0,nboClause-1);//wich clause to change
	if ((rg1->Random())<0.5)//insert new Atom negativ or positiv to the body?
		{clauses[clause].bodyP.insert(clauses[clause].bodyP.end(),rg1->IRandom(0,nboAtoms-1));}
	else {clauses[clause].bodyN.insert(clauses[clause].bodyN.end(),rg1->IRandom(0,nboAtoms-1));}
}
return true;
}

void printProgram(ofstream *outstr,unsigned int nboClause,TClausel* clauses)
{
for (unsigned int i=0;i<nboClause;i++)
{
	(*outstr)<<"a"<<clauses[i].head;
	if (((clauses[i].bodyP.size())+(clauses[i].bodyN.size()))){(*outstr)<<" :- ";}
	for (list<unsigned int>::iterator itr=clauses[i].bodyN.begin();itr!=clauses[i].bodyN.end();itr++)
	{
		if (itr!=clauses[i].bodyN.begin()){(*outstr)<<",";}
		(*outstr)<<"not a"<<(*itr);
	}
	if ((clauses[i].bodyP.size())&&(clauses[i].bodyN.size())){(*outstr)<<",";}
	for (list<unsigned int>::iterator itr=clauses[i].bodyP.begin();itr!=clauses[i].bodyP.end();itr++)
	{
		if (itr!=clauses[i].bodyP.begin()){(*outstr)<<",";}
		(*outstr)<<"a"<<(*itr);
	}
	(*outstr)<<".";
	(*outstr)<<endl;
}

}

int evResult(char* output,unsigned int nboAtoms,unsigned int nboLiteralsPerClauseTen,unsigned int nboClause,unsigned int nOExamples)
{
int ret=0;
ofstream *ostream=new ofstream(output);
(*ostream)<<"smodels-2.28"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;

if( ostream!= NULL )
{
	ofstream *pstream;
	for (unsigned int i=0;i<nOExamples;i++)
	{
		TClausel clauses[nboClause];
		pstream=new ofstream("./tmp_prog.lp");
		if (generateProgram(nboAtoms,nboLiteralsPerClauseTen,nboClause,clauses))
			{printProgram(pstream,nboClause,clauses);}
		delete pstream;
		char ev[100];
//		sprintf(ev,"(~/wv/lparse-1.0.13/src/lparse ./tmp_prog.lp | ~/wv/smodels-2.28/smodels)>tmp.txt");
		sprintf(ev,"(lparse ./tmp_prog.lp | smodels)>tmp.txt",i);
		cout<<i<<" :"<<ev<<endl;
		ret=system(ev);
		if (WIFSIGNALED(ret)) break;
		evOutput(ostream,i);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else{printf( "Problem opening the file\n" );}
return ret;
}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;//722;1081
unsigned int nboAtoms=740, nboClause=1500,nboLiteralsPerClauseTen=12;//nboLiteralsPerClause=nboLiteralsPerClauseTen/10
char result[40];
sprintf(result,"./ergebnisse/atwA%iL%iC%i.txt",nboAtoms,nboLiteralsPerClauseTen,nboClause);
evResult(result,nboAtoms,nboLiteralsPerClauseTen,nboClause,1000000);
cout<<endl;
}














