//	g++ -Wall -g -o gr graph.cpp
//generates random graphs and evalue hamiltion cycles fia smodels for them
/*File Name: generator.cpp
  Author: Bernd sterholz ; Date: 25.10.2004
  System: C++

  
  Copyright (C) 2004  Bernd sterholz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, June 1991, of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <string>
#include <set>

#include <time.h>
#include "mersenne.h"
#include "mersenne.cpp"

using namespace std;

TRandomMersenne *rg1;

class TEdge {
public:
	unsigned int source;
	unsigned int destination;
	bool operator<(const TEdge edg) const
	{
		return ((source<edg.source)||((source==edg.source)&&(destination<edg.destination)));
	}
	bool operator==(const TEdge edg) const
	{
		return ((source==edg.source)&&(destination==edg.destination));
	}
};

void evOutput(ofstream *ostream,unsigned int num,double literals)
{
char c;
unsigned int answer,choice,wchoice,trueAS,atoms,rules,searchSp;
double time;
unsigned int i;
ifstream *tstream=new ifstream("./tmp.txt");
//cout<<"evalue : "<<num<<" : "<<tstream<<" ; ";
if( tstream!= NULL )
{
	i=0;
	while (!((c=='A')||(c==':'))){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}
	if (c=='A')//read Answer
	{//read till duration
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';i=0;
		while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}}c='A';
		answer=1;
	}else{//no Answer
		answer=0;
	}
	i=0;
	c='A';
	(*tstream)>>time;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>choice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>wchoice;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>atoms;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>rules;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>trueAS;
	while (c!=':'){(*tstream)>>c;i++;if (i>1000000) {delete tstream;return;}};c='A';
	(*tstream)>>searchSp;

//	cout<<"ans : "<<answer<<" co : "<<choice<<" wch : "<<wchoice<<" tA : "<<trueAS;
//	cout<<" a : "<<atoms<<" r : "<<rules<<" ss : "<<searchSp<<" time : "<<time<<endl;
	(*ostream)<<"b"<<num<<".lp  | "<<time<<";"<<choice<<";"<<wchoice<<";";
	if (answer)
		{(*ostream)<<answer<<";";}
		else{(*ostream)<<"NV;";}
	(*ostream)<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<";"<<literals<<"  |"<<endl<<flush;
//	cout<<trueAS<<";"<<atoms<<";"<<rules<<";"<<searchSp<<"  |"<<endl<<flush;
	delete tstream;
}
else{printf( "Problem opening the file\n" );}
//[arithmetic_mean [measure TIME]]	[measure_const CHOICEPOINTS]	[measure_const WCHOICEPOINTS]	[measure_const ANSWER]	[measure_const TRUEAS]	[measure_const ATOMS]	[measure_const RULES]

}

double evalueLiterals()
/*evalue the average number of literals per rule body literals in the lparse
file ./tprog.lp*/
{
double literals=0.0;
unsigned int nbORules=0;
ifstream *stream=new ifstream("./tprog.lp");
unsigned int z,bodyAtoms,negB;
//read rules
while (true)
{
	(*stream)>>z;
//	cout<<z<<flush;
	if ((z==0)||(nbORules>1000000)) {break;}
	if (z==3)
		{(*stream)>>z;}
	nbORules++;
	(*stream)>>negB;//read head
	(*stream)>>bodyAtoms;
	(*stream)>>negB;//negativ body literals
	if (z==2)
		{(*stream)>>z;}
//	cout<<" "<<z<<" "<<bodyAtoms<<" "<<negB<<flush<<endl;
	//read body
	literals+=bodyAtoms;
	for (unsigned int i=0;i<bodyAtoms;i++)
		{(*stream)>>z;}
}
delete stream;
return double(literals)/double(nbORules);
}

void printProgram(char* fname,set<TEdge> edges,unsigned int vertices)
{
/* Open file in text mode: */
ofstream *stream=new ofstream(fname);
if( stream!= NULL )
{
	//print vertices
	for (unsigned int i=0;i<vertices;i++)
	{
		(*stream)<<"vertex("<<i<<")."<<endl;
	}
	(*stream)<<endl;
	for (set<TEdge>::iterator itr=edges.begin();itr!=edges.end();itr++)
	{
		(*stream)<<"arc("<<itr->source<<","<<itr->destination<<")."<<endl;
	}
	delete stream;
}
else
	printf( "Problem opening the file\n" );
}

set<TEdge > generateGraph1(unsigned int vertices,unsigned int edges)
//generates a graph with no double edges
{
set<TEdge> graph;
TEdge edge;
unsigned int max=0;
//fix lenght modell
while (graph.size()<edges)
{
	edge.source=(unsigned int)(rg1->Random()*vertices);
	edge.destination=(unsigned int)(rg1->Random()*vertices);
	graph.insert(graph.end(),edge);
	max++;//don`t go infinum
	if (max>100000*vertices*vertices) {break;}
}
return graph;
}


void evResult(char* output,unsigned int vertices,unsigned int edges,unsigned int nOExamples)
{
ofstream *ostream=new ofstream(output);
(*ostream)<<"smodels-2.28"<<endl<<endl;
(*ostream)<<"         |            [0]             |"<<endl;
(*ostream)<<"---------+----------------------------+"<<endl;
double literals=0.0;
unsigned int ret;
if( ostream!= NULL )
{
	for (unsigned int i=0;i<nOExamples;i++)
	{
		printProgram("./tmp.lp",generateGraph1(vertices,edges),vertices);
		char ev[100];
		sprintf(ev,"(lparse ./hampath.lp ./tmp.lp )> ./tprog.lp ");
//		sprintf(ev,"(lparse ./hampath.lp ./%s/b%i.lp | smodels )>tmp.txt",folder,i);
//		cout<<ev<<endl;
		system(ev);
		literals=evalueLiterals();
		cout<<ev<<endl;
		ret=system(ev);
		if (WIFSIGNALED(ret)) {break;}
		char ev2[100];
		sprintf(ev2,"(smodels < ./tprog.lp)>tmp.txt");
		cout<<ev2<<endl;
		ret=system(ev2);
		if (WIFSIGNALED(ret)) {break;}
		evOutput(ostream,i,literals);
	}
	(*ostream)<<"---------+----------------------------+"<<endl;
	delete ostream;
}
else
	printf( "Problem opening the file\n" );
}


int main()
{
TRandomMersenne rg(time(0));            // make instance of random number generator0
rg1=&rg;

evResult("./ergebnisse/gV25E250.txt",25,250,1000000);

}




















