%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Grundgeruest (Thomas Linke, Christian Anger, Juni 2002)                 %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Anmerkungen:
%
% !!! Kommentiert Eure Praedikate !!!
% unkommentierte Programme gelten als nicht erbrachte Leistung !!
%
% Bei Fragen wendet Euch bitte an
% Christian canger@cs.uni-potsdam.de
% Thomas    linke@cs.uni-potsdam.de
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- op(300,fx,not).

%
% read_LP( +File, -LoR)
% gibt zu einer Datei File die List of Rules LoR zurueck
% File = 'name_der_datei.endung'  <- Beachtet die einfachen Quotes
% LoR  = [a,b:-a,c:-b|Rest]
%
% Falls in der Datei test1.lp die Regeln
% a.
% b :- a, not(x).
% c :- b.
% in genau der Form (ohne %) stehen, liefert der Aufruf
% read_LP('test1.lp',LoR) 
%         LoR = [a, b :- (a, not x), c :- b]
% und unter SWI
%         LoR = [a,  (b:-a, not x),  (c:-b)] 
%
read_LP( File, LoR ) :-
	open(File,read,Stream),
	read_clauses(Stream,LoR).

read_clauses( Stream, LoR ):-
	read(Stream,Clause),
	(
	    Clause = end_of_file ->
	    (
		LoR = []
	    );
	    (
		read_clauses(Stream,LoROut),
		LoR = [Clause|LoROut]
	    )
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hier kommt Eure Implementierung 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Scheibe folgende Prolog Praedikate:
%
% as(+P,+X) testet ob X Antwortmenge 
as(P,X) :-reduct(P,X,PXV),inInterneForm(PXV,PX),vereinigteTP(PX,X,[],Cn),
	zuMenge(Cn,CnM),isGleich(X,CnM),!.
	%%ist Cn(P^X)=X?; verewinigteTP/4 ist die Vereinigung der TP^i
	%%nach reduct mu dessen Ausgabe wieder in interne Form umgewandelt werden
as(_P,_X):-!,fail. 
       
%reduct(+P,+X,-R) brechnete das Redukt R von P bzgl. X also PX, mithilfe 
%von reduct1
reduct(P,X,R):-inInterneForm(P,PI),reduct1(PI,X,PA),inExterneForm(PA,R).
	%%wandelt das Programm in interne Form um und gibt dies an reduct1 weiter
	%%gibt dannach das Ergebnis in Externer Form wieder aus

% reduct(+P,+X,-R) brechnete das Redukt R von P bzgl X also PX
reduct1([],_X,[]).
reduct1([[H|P]|R1],X,[[H|R]|R2]):-bodyMinus(P,PM),ds(PM,X,[]),!,
	bodyPlus(P,R),reduct1(R1,X,R2).
	%%wenn der Durchschnitt von X und den negativen Teil des bodys 
	%%die leere Menge ist, Kopf und positiven body als neue Klausel dazupacken
reduct1([_H|R1],X,R2):-reduct1(R1,X,R2).
	%%wenn nicht die Klausel rausschmeien bei der Betrachtung


%cn(+P,-Cn) berechnet zu P die Konsequenzen Cn
cn(P,Cn) :-reduct(P,[],PI),inInterneForm(PI,PI1),vereinigteTP(PI1,[],[],Cn).
	%das reduct Programm an vereinigte TP weiterleiten mit leerer Klausel
	%als Antwortmenge
	%nach reduct mu dessen Ausgabe wieder in interne Form umgewandelt werden

% all_as(+P,-AS) berechnet alle Antwortmengen AS zu gegebenem P
all_as(P,Cn) :-inInterneForm(P,PI),ermittleX(PI,VX),zuMenge(VX,X),ps(X,PX)
	,sucheAS(P,PX,Cn).
	%es werden alle relevanten Atome ermittelt(alle Kpfe) und in X gelegt
	%davon die Potenzmenge PX gebildet und in dieser, die ja alle mglichen
	%Antwortmengen enthlt, die gesucht die richtige Antwortmengen sind und 
	%in Cn zurckgegeben 	


%%vereinigteTP(+P,+I,+Cz,-Cn) bildet die Vereinigung aller Tp(I) fr das
%%Programm P und gibt das Ergbniss in Cn zurck, Cz ist die Zwischenmenge 
%%zu der immer was dazugepackt wird bis sie sich nicht mehr verndert, 
%%dann wir die Cz in Cn geschrieben und zurckgegeben
vereinigteTP(P,I,Cz,Ca):-tP(P,I,NI),isGleich(I,NI),!,vereinige(NI,Cz,Ca).
	%%wenn tP nichts neues mehr erzeugt, die Eingabe also gleich der Ausgabe
	%%ist, verndert sich Cz auch nicht mehr und wird zurckgegeben
vereinigteTP(P,I,Cz,Cn):-tP(P,I,NI),vereinige(NI,Cz,Ca),vereinigteTP(P,NI,Ca,Cn).
	%%ansonsten wird alles neue zu Cz immer wieder dazugepackt und 
	%%vereinigteTP/4 rekursiv weiter aufgerufen 
	%%die erste Eingabe I wird nie in Cn abgelegt

%%tP(+P,+I,-NI) ist die Tp(I) Abbildung, P ist das Programm, I ist die
%%alte Menge von wahren Atomen und NI die daraus resultierende neue		
tP([],_I,[]).  			%%wenn alles durchsucht ist
tP([[H|B]|P],I,[H|NI]):-teilmenge(B,I),!,tP(P,I,NI).
      %%wenn der body einer Klausel des Programms Teilmenge von I ist, 
	%%pack ich den Kopf zum neuen I dazu
tP([[_H|_B]|P],I,NI):-tP(P,I,NI).
	%%wenn nicht, dann nicht


%%bodyPlus(+B,-PB) gibt den positiven Teil PB des Body's B zurck 
bodyPlus([],[]).
bodyPlus([not(_X)|T],B):-!,bodyPlus(T,B). %%alle not(X) Teile rausschneiden
bodyPlus([X|T],[X|B]):-bodyPlus(T,B).  %%den Rest behalten

%%bodyMinus(+B,-PB) gibt den negativen Teil PB des Body's B zurck(ohne not) 
bodyMinus([],[]).
bodyMinus([not(X)|T],[X|B]):-!,bodyMinus(T,B).  %%alle not(X) Teile 
	%%behalten, ohne das not davor
bodyMinus([_X|T],B):-bodyMinus(T,B).		%%den Rest rausschneiden

%%ermittleX(+P,-X) ermittelt alle relevanten Atome die in den Antwortmengen
%%vorkommen knne, dafr werden einfach alle Klauselkpfe(erste Element in
%%den jeweiligen Teillisten) in der Menge X ausgegeben, P ist das Programm
ermittleX([],[]).
ermittleX([[H|_T]|PR],[H|X]):-ermittleX(PR,X).
	%%der Kopf der jeweiligen Klausel wird zu X dazugelegt

%%sucheAS(+P,+MA,-RA) sucht in der Menge MA der mglichen Antwortmengen 
%%heraus, die fr das Programm P richtige Antwortmengen sind und gibt sie
%%in der Menge RA zurck
sucheAS(_P,[],[]).
	%%wenn keine mgliche Antwortmenge mehr da ist, ist auch keine mehr richtig
sucheAS(P,[A|MRA],[A|RA]):-as(P,A),!,sucheAS(P,MRA,RA).
	%%wenn A eine richtige Antwortmenge ist wird sie zu den richtigen
	%%Antwortmengen hinzugenommen
sucheAS(P,[_A|MRA],RA):-sucheAS(P,MRA,RA).
	%%sonst nicht

%%inInterneForm(+EF,-IF) wandelt einen Programm von der externen 
%%Form EX(z.B. [a,(b:-a,not x),(c:-b)] in die interne Form IF um (z.B.
%%[[a],[b,a,not x],[c,b]]); mit dieser Listenform lst sich leichter arbeiten
inInterneForm([],[]).
inInterneForm([H1|T1],[H2|T2]):-teilInInterneForm(H1,H2),inInterneForm(T1,T2).
	%%wandel jede Klausel der Liste um mit teilInInterneForm/2

%%teilInInterneForm(+EKF,-IKF) wandelt eine Klausel von der externen Form EKF
%%(z.B. a:-b,not c) in die interne Form um(z.B. [a,b,not c])
teilInInterneForm(X,[X]):-atom(X).
	%%fr immer wahre Klauseln
teilInInterneForm(X,Y):-X=..[(:-),K,T],bodyAuflsen(T,T1),Y=[K|T1].
	%%den Kopf abschneiden und den Body in eine Liste auflsen

%%bodyAuflsen(+KB,-LB) macht aus dem Body der Klausel eine Liste
bodyAuflsen(X,Y):-X=..[(','),W,R],!,bodyAuflsen(R,T),Y=[W|T].
	%%den Teil vor dem ersten Komma rausnehmen und zur Liste hinzustecken
	%%den Rest weiter auflsen
bodyAuflsen(X,[X]).
	%%wenn nur noch ein Element da is dies als Liste zurckgeben

%%inExterneForm(+IF,-EF) wandelt einen Programm von der interne 
%%Form IX(z.B.[[a],[b,a,not x],[c,b]]) in die externe Form EF um 
%%(z.B. [a,(b:-a,not x),(c:-b)]); mit dieser Listenform lst sich leichter 
%%arbeiten, dies dient zur Rckumwandlung
inExterneForm([],[]).
inExterneForm([H1|T1],[H2|T2]):-teilInExterneForm(H1,H2),inExterneForm(T1,T2).

%%teilInInterneForm(+EKF,-IKF) wandelt eine Klausel von der externen Form EKF
%%(z.B. a:-b,not c) in die interne Form IKF um(z.B. [a,b,not c])
teilInExterneForm([K|[]],K).
	%%fr immer wahre Klauseln
teilInExterneForm([K|T],Y):-bodyBilden(T,T1),Y=(K:-T1).
	%%den Kopf abschneiden und den Body in eine Liste auflsen

%%bodyBilden(+LB,-KB) macht aus dem Body in Listenform LB(z.B. [a,b,c])
%%eine Kommerform KB(z.B. a,b,c )
bodyBilden([H|[]],H).
	%wenn nur ein Element vorhanden ist dies allein zurckgeben
bodyBilden([H|T],Y):-bodyBilden(T,R),!,Y=(H,R).
	%setzt die einzelnen Listenelemente durch Komme getrennt hintereinander
	%pro Rekursiven Aufruf wird ein Listenelement dazugehngt


%%Hier beginnen die Mengenoperatoren:

%%ds(+M1,+M2,-D)ermittelt den Durchschnitt D zweier Mengen M1,M2
%%(bergeben werden natrlich Listen die Mengen darstellen sollen)
ds([],_M,[]). %%der Durchschnitt der leeren Menge und einer Menge ist die 
	%%leere Menge
ds([H|T],M,[H|D]):-!,isIn(H,M),!,ds(T,M,D). 
	%%wenn ein Element in beiden Megen vorkommt kommt es auch im Durchschnitt vor
ds([H|T],M,D):-!,\+ isIn(H,M),!,ds(T,M,D).  
	%%wenn nicht dann auch nicht im Durchschnitt

%%entf1(+E,+L1,-L2) entfernt einmal das Element E aus der Liste L1
%%und gibt das Ergebnis in L2 zurck
entf1(Y,[Y|T],T).
entf1(Y,[H|T1],[H|T2]):-entf1(Y,T1,T2).

%%isIn(+X,+L) prrt ob das Element X in der Liste L ist?
isIn(_X,[]):-fail.
isIn(H,[H|_T]).
isIn(X,[_H|T]):-isIn(X,T).

%%conc(+L1,+L2,-L1L2) hangt zwei Listen L1 L2 hintereinander zu L1L2
conc([],L,L).
conc([H|T1],L,[H|T2]):-conc(T1,L,T2).

%%isGleich(+L1,+L2)
%%Prft ob die 2 Listen die gleichen Elemente enthalten, in der
%%gleichen Anzahl
isGleich([],[]).
isGleich([H|T],Y):-isIn(H,Y),!,entf1(H,Y,Z),isGleich(T,Z).

%%vereinige(M1,M2,M3) vereinigt die Mengen M1 und M2 zu M3
vereinige([],M,M).
	%%die leere Menge vereinigt mit einer Menge ist immer die Menge
vereinige([H|T1],M2,[H|T2]):-isIn(H,M2),!,entf1(H,M2,MN),vereinige(T1,MN,T2).
	%%wenn ein element sowohl in der ersten wie auch in der zweiten Menge  
	%%vorkommt, das Element nur einmalin die dritte Menge einfgen  
vereinige([H|T1],M2,[H|T2]):-vereinige(T1,M2,T2).
	%%sonst Element in die dritte menge einfgen

%%teilmenge(+TM,+M)prft ob die Menge TM eine Teilmenge von der menge M ist
teilmenge([],_M).
teilmenge([H|T],M):-isIn(H,M),!,teilmenge(T,M).

%%ps(+x,-PS) erzeugt die Potenzmenge PS von der Menge X
ps([],[[]]).
	%%die Potenzmenge der leeren Menge ist die Menge mit der leeren Menge
ps([H|T],L):-ps(T,L1),felm(H,L1,L2),conc(L1,L2,L).

%%felm(+E,+M1,-M2) fgt das Element E an alle Teilmengen der Menge M1 ein
%%und gibt das Ergebnis in M1 zurck
felm(_X,[],[]). %%wenn keine Listen in der Liste mehr sind nichts machen
felm(X,[H1|T1],[H2|T2]):-einf(X,H1,H2),felm(X,T1,T2).
	%%X in jeder Teilliste einfgen

%%einf(+E,+L1,-L2) fgt das Element E in der Liste L1 vorn ein und gibt
%%die ergebnis Liste in L2 zurck
einf(E,T,[E|T]).

%%zuMenge(+L,-M) macht aus der Liste L eine Menge M indem es die doppelten
%%Vorkommen entfernt
zuMenge([],[]).
zuMenge([H|L],M):-isIn(H,L),!,zuMenge(L,M).
	%%wenn der Kopf nochmal in der Liste vorkommt ihn nicht hinzufgen
zuMenge([H|L],[H|M]):-zuMenge(L,M).
	%%ansonsten den Kopf hinzufgen


