% Anmerkungen:
%
% !!! Kommentiert Eure Praedikate !!!
% unkommentierte Programme gelten als nicht erbrachte Leistung !!
%
% Eure Programme muessen Testanfragen der Form
% [eclipse 1]: test1(Tree).              bzw.
% ?- test1(Tree).
% bearbeiten koennen. D.h. es wird ein Baum Tree zurueckgegeben.
% Programme, die diese Anforderung nicht erfuellen,
% gelten ebenfalls als nicht erbrachte Leistung.
%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Fr die Bearbeitung der Aufgabe ist es notwendig, Logarithmen zu berechnen.
% Dies ist in den einzelnen Prologsystemen unterschiedlich gelst.
% Ihr knnt das Prdikat mylog/3 benutzen. Hierzu einfach die entsprechende
% Version benutzen (durch lschen der Kommentarzeichen)

mylog(Argument,Basis,Ergebnis):-
% Eclipse
%	Ergebnis is ln(Argument)/ln(Basis).
% SWI
	Ergebnis is log(Argument)/log(Basis).
% Sicstus
%	Ergebnis is log(Basis,Argument).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Variablen in der Beschreibug mit "_" gekennzeichnet(z.B. _Var) sind  %
%interne Hilfsvariablen                                               %
%
%
% id3(+Trainingsdaten,+Zielattribut,+Attributmenge,-Entscheidungsbaum)
%Erzeugt einen Entscheidungsbaum mithilfe des ID 3 Algorithmuses
%aus den Trainigsdaten mit den Attributen als Knoten aus der
%Attributmenge und den Werten des Zielattributs als Endknoten/
%Blttern, dabei knnen die Attribute belibig viele Werte einnehem
%(der Baum ist nicht Binr) 
id3(T,Z,A,B):-make_attribute(T,[Z|A],[ZV|AV]),id3_1(T,ZV,AV,no_tree,B).
%es ist nicht gewhrleistet das die Datenmenge jedes Teilbaumes zu allen 
%Attributen noch alle Werte aufweist, deshalb wird, vor start des 
%eigendlichen ID3 Algorithmeses, nochmals eine Menge mit
%make_attribute/3 erzeugt in der die Attribute mit all ihren mglichen 
%zugehrigen Werten aufgelistet sind

%id3_1(+Trainingsdaten,+Zielattribut,+Attributmenge,
%_Am_meisten_im_letzten_Knoten_vorkommender _Wert,-Entscheidungsbaum)
%eigendlicher ID3 Algorithmus
id3_1(T,_Z,_A,MV,MV):-count_elements(T,0).
%wenn kein Element vorhanden ist, den am hufigsten Wert der am Knoten 
%vorher auftritt nehmen
id3_1(T,Z,_A,_MV,B):-end_root(T,Z,Target_Value),B=Target_Value.
%Wenn alle Werte zum Zielattribut aus der Datenmenge gleich sind
%(wird mit end_root/3 ermittelt und der Wert wird zurckgegeben)diese
%Wert als Endknoten(Blatt) anfgen(und hier fertig)
id3_1(T,Z,A,_MV,B):-best_gain(T,Z,A,0,none,BA),make_tree(T,Z,A,BA,B).
%ansonsten das Attribut BA mit dem besten Gain ermitteln und mit
%ihm als aktuellen Knoten ein neuen Baum herstellen

%best_gain(+Test_Data,+Ziel_Attribut,+Attribut_Menge,_Best_Gain,
%_Best_Gain_Attribut,-Best_Attribute) 
%sucht sich das Attribut heraus das den besten(hchsten) Gain hat 
best_gain(_T,_Z,[],_BG,BA,BA).
%Wenn keine Attribute mehr berprft werden knnen:fertig
%das Attribut BA mit dem bisher am hchsten Gain zurckgeben
best_gain(T,Z,[A|AL],BG,_BGA,BA):-gain(T,Z,A,G),BG<G,!,
	best_gain(T,Z,AL,G,A,BA).
%wenn der bisherige beste Gain BG kleiner als der zum aktuelle Attribut A 
%ist, neuer bester Gain auf den des Attributs A setzen(G) und Aktuelles
%Attribut als Attribut mit bissher besten Gain vermerken,nchstes Attribut 
%testen
best_gain(T,Z,[_A|AL],BG,BGA,BA):-best_gain(T,Z,AL,BG,BGA,BA).
%sonst alles beibehalten und nchstes Attribut testen

%make_tree(+T,+Z,+A,+BA,-B) erzeugt den Baum mit dem aktuellen Knoten des 
%Attributes BA und seinen sten mit Unterbumen, derart 
%knoten(name,[Unterknoten1/Blatt1,Unterknoten2/Blatt2,...]) 
make_tree(T,Z,A,[BA|W],B):-split_data(T,[BA|W],[_AG|TN]),
	delete(A,[BA|W],NA),most_value(T,Z,MV),
	make_unterknoten(TN,Z,NA,MV,UKL),B=knoten(BA,UKL).
%delete(A,[BA|W],NA) lscht das jetzt als Knoten verwendete, nicht mehr
%gebrauchte Attribut aus der Attributmenge
%most_value(T,Z,MV) ermittelt den Wert des Zielattributs der am hufigsten 
%vorkommte(wird eventuelle in einem Unterknoten bentigt)
%split_data(T,[BA|W],[_AG|TN]),make_unterknoten(TN,Z,NA,MV,UKL) stellt
%zu den nach den Werten fr das aktuelle Attribut BA aufgesplitteten 
%Daten die Unterknoten/Bume her(dazu wird id3_1 aufgerufen) 

%make_unterknoten(+Testdaten_Neu_Geordnet,+Zeilattribut,+Neue_Attribute,
%-Unter_Knoten_Liste) erzeugt die Bume zu den Unterknoten
make_unterknoten([],_Z,_A,_MV,[]).
%wenn alle Werte zum Attribut bearbeitet wurden:fertig, kein weiterer 
%Unterknoten
make_unterknoten([W,WT|TN],Z,A,MV,[ast(W,Baum)|UKL]):-id3_1(WT,Z,A,MV,Baum),
	make_unterknoten(TN,Z,A,MV,UKL).
%sonst, zum aktuellen Daten WT die zum aktuellen Wert W gehren den Baum 
%mit id3_1 erzeugen und ihn an einen ast mit der Bezeichnung W des 
%aktuellen Wertes hngen
%danach nchsten Wert/Ast bearbeiten 

%end_root(+T,+Z,-Target_Value) testet ob in den Testdaten T das Zeilattribut Z
%nur noch mit einem Wert Target_Value belegt ist
end_root(T,Z,TV):-split_data(T,Z,[_A|TN]),end_root1(TN,TV).
%wenn alle Daten bezogen auf das Attribut nur noch einen Wert haben, erzeugt
%split_data/3 nur noch hinter einem Wert aus der Werteliste eine nicht 
%leere Datenliste

%end_root1(+WL,-TV) prft ob nur eine hinter einem Wert aus der Werteliste eine 
%nicht leere Datenliste steht
end_root1([],_TV):-fail,!.
%wenn alle Datenlisten leer sind fail(es gibt keine Daten zu diesen Knoten
%,wird in der ersten id3_1 Klausel behandelt und steht hier nur der 
%Vollstndigkeit halber)
end_root1([_W,[]|TN],TV):-end_root1(TN,TV).
%wenn alle Listen zu den Werten leer sind und es noch weitere Werte gibt
%diese prfen
end_root1([W,[_H|_L]|TN],W):-end_root2(TN,W),!.
%wenn es zu einem Wert Daten gibt, schauen ob jetzt nur noch leere 
%Datenlisten kommen, das prft end_root2
end_root2([],_TV).
%fertig, es gibt keine weiteren Datenlisten
end_root2([_W,[]|TN],TV):-end_root2(TN,TV).
%die Datenliste zum aktuellem Wert ist leer also den nchsten Wert prfen

%make_attribute(+Testdaten,+Attribut_Liste,-Attribute_mit_Werten) ordnet
%den Attributen aus der Attribut_Liste die Werte zu die sie laut den
%Testdaten haben knnen; dient dazu wenn am aktuellen Knoten die Testdaten
%nicht alle Werte aufweisen trotzdem fr alle Werte Zweige zu bilden; 
%zurckgegeben wird eine Liste deren Elemente Listen sind in denen zuerst
%das Attribut und dann die Werte die es annehmen kann stehen
%(z.B.[[wetter,sturm,sonne],...])
make_attribute(_T,[],[]).
%wenn es keine weiteren Attribute gibt:fertig
make_attribute(T,[A|AL],[[A|NAW]|AWL]):-find_value(T,A,NAWV),
	list_to_set(NAWV,NAW),make_attribute(T,AL,AWL).
%ansonsten alle Werte zum Attribut finden und in einer Liste gesammelt 
%zurckgeben(mit find_value(T,A,NAWV)) dafr sorgen das jedes Element/
%jeder Wert nur einmal vorkommt(mit list_to_set(NAWV,NAW)) und das
%nchste Attribut bearbeiten, das Attribut mit der Werteliste wird in 
%einer Liste(Attribute_mit_Werten) gesammelt

%find_value(+Data,+Attribut,-Value_List) findet alle Werte vom Attribut und 
%sammelt sie in Value_List
find_value([],_A,[]).
%wenn alle Daten durchsucht wurde gibt es auch keine weiteren Werte: fertig
find_value([datum(_I,WBL)|T],A,[X|AW]):-member(val(A,X),WBL),!,
	find_value(T,A,AW).
%schauen ob es in der Liste der Attribute mit Werten eines datum einen 
%Eintrag zum gegebenen Attribut A gibt und dessen Belegung X zur 
%mglichen Werteliste hinzunehmen, danach nchstes datum untersuchen
find_value([datum(_I,_WBL)|T],A,AW):-find_value(T,A,AW).
%ansonsten nchstes datum untersuchen(sollte bei vollstndigen Daten nicht 
%auftreten, aber sicher ist sicher)

%split_data(+Testdaten,+Attribut_mit_Werten,-Eergebnisliste) 
%splittet die Testdaten nach einem Attribut mit seinen  Werten(A) auf
%,E hat die Form [Attribut,Wert1,[Daten zu Wert 1], Wert2,
%[Daten zu Wert 2],Wert3,...]
%Bsp: T=[datum(i1,[val(a,no),...]),datum(i2,[val(a,yes),...],...)
%->E=[a,no,[datum(i1,[...]),...],yes,[datum(i2,[...]),...]]
split_data(T,[A|W],[A|E]):-split_data1(T,A,W,E).
%das erste Element der Liste ist das Attribut, dieses bei der Bearbeitung
%auslassen(zur Ergebnissliste einfach hinzunehmen) und die restlichen
%Daten bearbeiten

%split_data1(+Testdaten,+Attribut,+Wertelist,-Eergebnisliste)
split_data1(_T,_A,[],[]).
%wenn alle Werte bearbeitet wurden: fertig 
split_data1(T,A,[W1|RW],[W1,DW1|E]):-search_data(T,A,W1,DW1),
	split_data1(T,A,RW,E).
%zu jedem Wert(W1) der Werteliste die entsprechenden Datenstze(DW1) in 
%denen das Attribut(A) den Wert annimmt herraussuchen
%(mit search_data(T,A,W1,DW1)) und den Wert gefolg von der Liste der 
%Datenstze zur Ergebnisliste hinzufgen 

%search_Data(+Testdaten,+Attribut,+Wert,-Daten_mit_Wert_Liste) 
%sucht in den Testdaten nach Attribut mit der Belegung W1 und gibt diese 
%in Daten_mit_Wert_Liste zurck(val(A,W) wird dabei aus dem Datensatz 
%entfernt)
search_data([],_A,_W,[]).
%sind alle Testdatenstze durchsucht worden: fertig
search_data([datum(I,VL)|T],A,W,[datum(I,VLN)|DW1]):-select(val(A,W),VL,VLN),
	!,search_data(T,A,W,DW1).
%wenn das Attribut A in dem datum die Belegung mit dem Wert W hat, diese 
%Belegung entfernen und das datum zur Ergebnisliste hinzunehmen, nach 
%weiteren Daten suchen,Backtracking hier nicht erlauben(desahlb "!")
search_data([_X|T],A,W,DW1):-search_data(T,A,W,DW1).
%sonst nur nach weiteren Daten suchen

%entropy(+T,+A,-E) Berechnet die Entropy E eines Datensatzes T bezglich
%eines Attributes A(der Form(Attribut,Wert1,Wert2,...))
entropy(T,A,E):-split_data(T,A,[_UA|ST]),count_elements(T,AID),entropy1(ST,AID,E).
%man splittet den Datensatz T in die entsprechenden Klassen zum Attribut, 
%dann brauch man noch die Zahl der gesammten Daten AID, da p=Anzahl der 
%Elemente in der Klasse/AID; mit entropy1 wird nun Rekursiv die einzelnen 
%Faktoren(p*log p) auf Subtrahiert

%entropy1(+Werte_mit_Daten_dazu_Liste,_Daten_Insgesammt,-Entropie)
%Subtrahiert die einzelnen Teilfaktoren der Entropiesumme auf
entropy1([],_AID,0).
%wenn alle Datenklassen bearbeitet wurden kann sich die Entropie nicht 
%weiter erhhen oder bei keinen Daten ist die Entropie=0
entropy1([_AW,D|ST],AID,NE):-entropy1(ST,AID,E),count_elements(D,ADC),ADC=\=0,!,
	AD is ADC/AID,mylog(AD,2,LAD),NE is (E-AD*LAD).
%Fr jede Untermenge wird die Entropie um p*log2(p) kleiner,dabei ist 
%p=(Anzahl der zugeordneten Elemente in der Untermenge)/(Elemente 
%Insgesammt)
entropy1([_AW,_D|ST],AID,E):-entropy1(ST,AID,E).
%wenn ein Wert keine zugehrigen Daten hat, wird er bei der Rechnung nicht 
%beachtet

%gain(+Testdaten,+Zielattribut,+Gain_fr_Attribut,-Gain) 
%ermittelt den Informationsgewinn Gain bei der Aufspaltung der Daten nach 
%dem Attribut Gain_fr_Attribut fr das Attribut
gain(T,Z,GA,G):-entropy(T,Z,IE),count_elements(T,S),S=\=0,!,split_data(T,GA,[_UA|ST])
	,summ_gain(ST,Z,GS),G is IE-(GS/S).
%Hier wird der Gain mit der Formel Gain=entropy(S)+
%Summe_ber_Klassen(|Element_der_Klasse|*entropy(Elemente_der_Klasse))/|S|
%Achtung bei division durch 0
gain([],_Z,_A,_GA,0).
%wenn es keine Daten gibt gibt es auch kein Informationsgewinn

%summ_gain(+ST,+A,-GS) ermittelt die Summe aller Sv*entropy(Sv)
summ_gain([],_A,0).
%wenn alle Klassen abgearbeitet wurden: fertig Rckgabe 0
summ_gain([_AW,Sv|ST],A,NGS):-summ_gain(ST,A,GS),count_elements(Sv,SvA)
	,entropy(Sv,A,ESv),NGS is SvA*ESv+GS.
%ansonsten den Faktor |Element_der_Klasse|*entropy(Elemente_der_Klasse)
%=Sv*entropy(Sv) berechnen und zur Summe hinzuaddieren

%count_elements(+Liste,-Elemente_Nummer) Zhlt die Elemente der Liste und 
%gibt ihren Anzahl in Elemente_Nummer zurck
count_elements([],0). %keine Element
count_elements([_H|T],EN):-count_elements(T,E),EN is E+1.
%fr jedes Elemet eins hinzuaddieren

%most_value(+T,+Attribut,-Most_Value) ermittelt welches der in den
%Testdaten T zum Attribut die am hufigsten auftretende Belegung ist
%indem die Testdaten nach den Werten aufgespalten werden und die Menge 
%mit den meisten Daten(datum(...) ) gesucht wird und der zugehrige 
%Wert zurckgegeben wird
most_value(T,A,MV):-split_data(T,A,[_UA|ST]),most_value1(ST,0,_MVV,MV).
%Testdaten T splitten und in der gesplitteten Liste(ohne das Attribut am 
%Anfang) den Wert mit den meisten zugehrigen Testdaten suchen 

%most_value1(+Gesplittete_Testdaten,_Hchste_Anzahl_an_zugehrigen_Testdaten,
%_Wert_mit_hchster_Anzahl_der_Zugehrigen_Testdaten,-Rckgabewert)
%Hilfsfunktion zu most_value/3 ermittelt den Wert(Rckgabewert) mit den 
%meisten zugehrigen Datenstzen
most_value1([],_AT,MV,MV).
%wenn alle Datenstze berprft wurden hat man seinen am meisten 
%auftretenden Wert (MV) diesen zurckgeben
most_value1([W,TL|ST],VM,_MVK,MV):-count_elements(TL,ATL),VM<ATL,!,
	most_value1(ST,ATL,W,MV).
%wenn der Aktuelle Wert W mehr zugehrige Daten TL hat als der bisher 
%festgestellte _MVK den Aktuellen Wert W als mglichen hchsten und die 
%zugehrige Anzahl der Elemente ATL(zum spteren vergleichen) merken
%kein Backtracking erlauben(es darf nur einen meisten Wert geben)
most_value1([_W,_TL|ST],VM,MVK,MV):-most_value1(ST,VM,MVK,MV).
%ansonsten bei dem bisherigen Wert bleiben

%
%classify(+Entscheidungsbaum, +Zielattribut, +Datum, -Class)
%Klassifiziert einen gegebenenes Datum nach einem gegebenen 
%Entscheidungsbaum, wandert dabei die seinen Attributbelegungen 
%entsprechenden ste des Baums hinunter(hinauf?, von der Wurzel ausgehend)
classify(knoten(A,AL),Z,datum(I,WL),C):-member(val(A,W),WL),
	member(ast(W,UB),AL),!,classify(UB,Z,datum(I,WL),C).
%das Attribut A mit seiner Belegung W aus dem datum suchen das dem 
%aktuellem Knoten entspricht den zum Wert zugehrigen Ast auswlen 
%und das datum nach dem Unterbaum UB an diesem weiter klassivizieren
%(runtergehen)
classify(B,Z,_D,B).
%wenn es keine weiteren knoten gibt, sind wir an einem Blatt angelang, 
%dieses als Klassivizierung zurckgegeben 
%oder es gibt zwar knoten, nur das datum enthlt nicht das entsprechende 
%Attribut mit Belegung, dan den restlichen Unterbaum zurckgegeben(beste 
%Klassivizierung die mit diesem datum und Baum mglich ist)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Tests                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% format konventionen fr testdaten:
% - Trainingsdaten T werden als Liste [] von daten gegeben, wobei
%   ein datum/2 jeweils das format datum(objektbezeichner,liste_von_werten)
%   hat und diese liste aus eintrgen der form val/2 val(attribut,wert)
%   besteht
% - das Zielattribut Z wird als atom gegeben
% - die Attributmenge A ist eine Liste von Atomen
%

datum(Ex,Attr,datum(Objekt,Liste_von_Werten)):-
	daten(Ex,Objekt,Werte),
	match(Attr,Werte,Liste_von_Werten).

datum_class(Ex,Attr,datum(Objekt,Liste_von_Werten)):-
	class(Ex,Objekt,Werte),
	match(Attr,Werte,Liste_von_Werten).

match([],[],[]).
match([A|Attr],[W|Werte],[val(A,W)|Liste]):-
	match(Attr,Werte,Liste).
	

test1:-
	attribute(1,All),
	ziel(1,Z),
	select(Z,All,A),
	findall(Datum,datum(1,All,Datum),T),!,
	id3(T,Z,A,B),!,

	datum_class(1,A,Classify),
	classify(B,Z,Classify,Class),
	Classify=datum(Name,_),
	write('Instanz '),write(Name),write(' wurde als '),write(Class),
	write(' klassifiziert.'),nl,
	fail.

attribute(1,      [wetter, temp,       kleidung,        schlittschuhlaufen]).
daten(1,instanz1, [sturm,  unter_null, vorhanden,       ja]).
daten(1,instanz2, [sonne,  ueber_null, vorhanden,       nein]).
daten(1,instanz3, [sturm,  unter_null, nicht_vorhanden, nein]).
daten(1,instanz4, [sonne,  ueber_null, nicht_vorhanden, nein]).
daten(1,instanz5, [sonne,  unter_null, nicht_vorhanden, ja]).
ziel(1,schlittschuhlaufen).

class(1,instanz6, [sturm, unter_null, vorhanden]). %ja
class(1,instanz7, [sturm, ueber_null, nicht_vorhanden]).%nein


