%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Praktikum Teil I                                                        %
%                                                                         %
% Resolutionsbeweiser fr aussagenlogische Formeln                        %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Aufgabe:
%

%
% Testanfragen: prove([(a),(a impl b),(c),(neg c or d),((b and d) impl e)],(e and a))
% Denkt Euch eigene interessantere Anfragen aus!!
%


%
% Hinweise (fr beide Praktika):
% * Haltet Euch an die vorgegebenen Schnittstellen und Formate. Lsungen,
%   die die Testanfragen nicht bearbeiten knnen, gelten als nicht
%   erbrachte Leistungen.
%
% * Kommentiert Eure Lsungen! Nichtkommentierte Prdikate gelten als
%   nicht erbracht.
%
% * Der Abgabetermin ist unter allen Umstnden einzuhalten!!
%
% * Gruppenarbeit zu zweit (nicht mehr!!) ist erlaubt.
%
% * Versucht, nicht mehr als 75 Zeichen/Zeile zu verwenden und
%   formatiert Eure Loesung so, dass sie von Menschen gelesen werden kann,
%   d.h. keine langen Einzeiler.
%
% * Schickt Eure Lsung + Plaintext Dokumentation bis zum Abgabetermin
%   an canger@cs.uni-potsdam.de
%

:-write('************************************************************'),nl,nl.
:-write('Eingabe: prove(F,P)  fr Beweise mit Konjunktiv Normalform'),nl.
:-write('Eingabe: prove1(F,P) fr Beweise mit Disjunktiv Normalform'),nl,nl.
:-write('*************************************************************'),nl.

%%Listenoperationen:

%%entf(+Y,+X,-Z) entfernt das Element Y aus der Liste X
%%Rckgabe des Ergebnisses in Z
entf(Y,[Y|T1],T2):-isIn(Y,T1),!,entf(Y,T1,T2).
entf(Y,[Y|T],T).
entf(Y,[H|T1],[H|T2]):-entf(Y,T1,T2).

%%entf1(+Y,+X,-Z) entfernt einmal das Element Y aus der Liste X
%%Rckgabe des Ergebnisses in Z
entf1(Y,[Y|T],T).
entf1(Y,[H|T1],[H|T2]):-entf1(Y,T1,T2).

%%conc(+L1,+L2,-L1L2).
%%Die ersten beiden Listen hintereinander
conc([],L,L).
conc([H|T1],L,[H|T2]):-conc(T1,L,T2).

%%isIn(+X,+L)ist das Element X in der Liste L?
isIn(_X,[]):-fail.
isIn(H,[H|_T]).
isIn(X,[_H|T]):-isIn(X,T).

%%isGleich(+L1,+L2)
%%Prft ob die 2 Listen die gleichen Elemente enthalten, in der
%%gleichen Anzahl
isGleich([],[]).
isGleich([H|T],Y):-isIn(H,Y),!,entf1(H,Y,Z),isGleich(T,Z).

%%entff(+X,+L1,-L2)
%%entfert die Liste X aus der 1. Liste von Listen und gibt das Ergebniss
%%in der 2. Liste zurck
entff(_X,[],[]).
entff(X,[H1|T1],Y):-isGleich(X,H1),!,entff(X,T1,Y).
entff(X,[H1|T1],[H1|T2]):-entff(X,T1,T2).

%%entf1(+Y,+X,-Z) 
%%entfert die Liste X einmal aus der 1. Liste von Listen und gibt das Ergebniss
%%in der 2. Liste zurck
entff1(_Y,[],_X):-fail.
entff1(Y,[H|T],T):-isGleich(Y,H).
entff1(Y,[H|T1],[H|T2]):-entff1(Y,T1,T2).

%%isInL(+X,+LL); prft ob die Liste X in der Liste von Listen 
%%ist(Reinfolge der Elemente von X wird nicht beachtet)
isInL(_X,[]):-fail,!.
isInL(X,[Y|_T]):-isGleich(X,Y).
isInL(X,[_Y|T]):-isInL(X,T).

%%isGleichL(+LL1,+LL2)
%%Prft ob die 2 Listen die gleichen Elemente Listen(Reihenfolge 
%%egal)enthalten, in der gleichen Anzahl
isGleichL([],[]).
isGleichL([H|T],Y):-isInL(H,Y),!,entff1(H,Y,Z),isGleichL(T,Z).

%%alles bis hier sind Operationen fr normale Listen

%%Erzeugung der Normalformen:

%%erzeugt eine quivallent Formel im "internen" Standart 
%%"interner" Standart:
%% nur Kommas "[[,]]"="and", "[,]"="or"(oder andersrum) und "neg"
%% gebunden an Atome


%%Definition der Operatoren
:-op(100,fy,neg).
:-op(300,xfy,or).
:-op(200,xfy,and).
:-op(500,xfy,impl).
%%umso niedriger die Zahl um so hher die Priroritt


%%teilneg(+X,-Y) macht Teilformeln quivallent wenn ein "neg" kahm
%%Hilfsfunktion fr aequi, Achtung bevor teilneg aufgerufen wird wurde 
%%schon ein "neg" abgetrennt
teilneg(X,Y):-X=.. [H,F],H=neg,!,aequi(F,G),Y = G.
%%wenn zweimal neg hintereinander kommt beide lschen(in F) und Rest
%%qivalent machen(G)
teilneg(X,Y):-X=.. [H,F1,F2],H=or,!,aequi(F1,G1),aequi(F2,G2),
	NG1 =.. [neg,G1],NG2 =.. [neg,G2],YV =.. [and,NG1,NG2],aequi(YV,Y).
%%neg(a or b)=neg a and neg b
teilneg(X,Y):-X=.. [H,F1,F2],H=and,!,aequi(F1,G1),aequi(F2,G2),
	NG1 =.. [neg,G1],NG2 =.. [neg,G2],YV =.. [or,NG1,NG2],aequi(YV,Y).
%%neg(a and b)=neg a or neg b
%%Das Ergebnis von and und or nochmal durchjagen(Vernderungen!)
%%Teilformeln werden jeweils quivallent gemacht
teilneg(X,Y):-X=.. [H,_F1,_F2],H=impl,!,aequi(X,YV),aequi(neg(YV),Y).
%%wendet auf die Formel "X impl Y" die quivallenz aequi Klausel an
%%packt dann das vorher entfernte neg wieder vor und macht diese
%%Formel dann nochmal quivallent mit aeqi(Vernderungen)
%%(hat ich vergessen das das auch mglich ist)
teilneg(X,neg(X)).
%%wenn X schon ein Atom ist

%%aequi(+X,-Y)macht die Formel quivallen, so das nur noch "and", "or"
%%und "neg" vorkommt,"neg" direkt an eine Atome gebunden
%%bearbeitet dabei zuerst den unteren Teil des Baums und arbeitet
%%sich dann zur Wurzel nach oben durch
aequi(X,Y):-X =.. [H,F],H=neg,!,teilneg(F,Y).
%%die Operation "neg" tritt auf neg(F)
aequi(X,Y):-X =.. [H,F1,F2],H=and,!,aequi(F1,G1),aequi(F2,G2),
	Y=..[and,G1,G2].
aequi(X,Y):-X =.. [H,F1,F2],H=or,!,aequi(F1,G1),aequi(F2,G2),
	Y=..[or,G1,G2].
aequi(X,Y):-X =.. [H,F1,F2],H=impl,!,aequi(F1,GV1),aequi(F2,G2),
	GD1=..[neg,GV1],aequi(GD1,G1),Y=..[or,G1,G2].
%%Das Ergebnis nochmal durchjagen(Vernderungen!)
%%Teilformeln werden jeweils quivallent gemacht
aequi(X,X).

%%spalteOr(+X,-Y,-Z); setzt da wo in der Formel "or" vorkommt "," indem es 
%%den Ausdruck in 2 Teile spaltet
%%Hilfsklausel zu eliminateOr, sucht sich dabei das nchste "or" und packt
%%die Teile links und rechts davon jeweils in eine Ausgabeliste
spalteOr(X,Y,Z):-X=..[H|T],H=or,!,T=[Y,Z].
spalteOr(X,Y,Z):-X=..[H,T1,T2],isInOr(T1),!,spalteOr(T1,Y,ZV),Z=..[H,ZV,T2].
spalteOr(X,Y,Z):-X=..[H,T1,T2],isInOr(T2),!,spalteOr(T2,YV,Z),Y=..[H,T1,YV].
%%Die letzten beiden Klausel sind bei eine Disjunktiven Normalform eigendlich
%%berflssig

%%eleminateOr(+L1,-L2); macht "or" in Liste L1 zu "," und gibt das Ergebniss
%%in der 2. Liste L2 zurck z.B. "[A or B]"->"[A,B]"
%%Spaltet die Formeln der Liste einfach solange bis kein "or" mehr vorkommt
eleminateOr([],[]).
eleminateOr([H1|T1],Y):-isInOr(H1),!,spalteOr(H1,A,B),C=[A,B|T1],eleminateOr(C,Y).
eleminateOr([H|T1],[H|T2]):-eleminateOr(T1,T2).

%%eleminateAnd(+F,-L)
%%Hilfsfunktion zu eleminateAndL, eleminiert die "and" in der Formel
eleminateAnd(H1,H2):-H1=..[and,A1,B1],!,eleminateAnd(A1,A),
      eleminateAnd(B1,B),conc(A,B,H2).
eleminateAnd(H,[H]).

%%eleminateAndL(+LF,-L2); eleminiert "and"(zu ",") in den Formeln der Liste
eleminateAndL([],[]).
eleminateAndL([H1|T1],[H2|T2]):-eleminateAnd(H1,H2),eleminateAndL(T1,T2).

%%spalteAnd(+X,-Y,-Z); setzt da wo in der Formel "and" vorkommt "," indem es 
%%den Ausdruck in 2 Teile spaltet, Hilfsfunktion von eleminateAnd1
%%Hilfsklausel zu eliminateOr, sucht sich dabei das nchste "and" und packt
%%die Teile links und rechts davon jeweils in eine Ausgabeliste
spalteAnd(X,Y,Z):-X=..[H|T],H=and,!,T=[Y,Z].
spalteAnd(X,Y,Z):-X=..[H,T1,T2],isInAnd(T1),spalteAnd(T1,Y,ZV),Z=..[H,ZV,T2].
spalteAnd(X,Y,Z):-X=..[H,T1,T2],isInAnd(T2),!,spalteAnd(T2,YV,Z),
      Y=..[H,T1,YV].
%%Die letzten beiden Klausel sind bei eine Konjunktiven Normalform eigendlich
%%berflssig

%%eleminateAnd1(+L1,-L2); macht "and" in Liste 1 zu "," und gibt das Ergebniss
%%in der 2. Liste zurck z.B. "[A and B]"->"[A,B]"
%%Spaltet die Formeln der Liste einfach solange bis kein "and" mehr vorkommt
eleminateAnd1([],[]).
eleminateAnd1([H1|T1],Y):-isInAnd(H1),!,spalteAnd(H1,A,B),C=[A,B|T1],
      eleminateAnd1(C,Y).
eleminateAnd1([H|T1],[H|T2]):-eleminateAnd1(T1,T2).

%%eleminateOr1(+F,-L); Hilfsfunktion zu eleminateOrL1, eleminiert die 
%%"or" in der Formel
eleminateOr1(H1,H2):-H1=..[or,A1,B1],!,eleminateOr1(A1,A),
	eleminateOr1(B1,B),conc(A,B,H2).
eleminateOr1(H1,H2):-H1=..[neg,A],!,eleminateOr1(A,[B]),H2=[neg(B)].
eleminateOr1(H,[H]).

%%eleminateOrL1(+LF,-L2); eleminiert "or"(zu ",") in den Formeln der Liste LF
eleminateOrL1([],[]).
eleminateOrL1([H1|T1],[H2|T2]):-eleminateOr1(H1,H2),eleminateOrL1(T1,T2).

%%isInOr(X); berprft ob in der Formel X ein "or" vorkommt
isInOr(X):-X=..[H|_T],H=or.
isInOr(X):-X=..[H,Y],H=neg,!,isInOr(Y).
isInOr(X):-X=..[H|T],H=and,!,T=[Y1,Y2],isInOr(Y1,Y2).
isInOr(X):-X=..[H|T],H=impl,!,T=[Y1,Y2],isInOr(Y1,Y2).
%%berprft 2 Formeln ob in einer ein "or" vorkommt
isInOr(X,_Y):-isInOr(X).
isInOr(_X,Y):-isInOr(Y).

%%isInAnd(X); berprft ob in der Formel X ein "and" vorkommt
isInAnd(X):-X=..[H|_T],H=and.
isInAnd(X):-X=..[H,Y],H=neg,!,isInAnd(Y).
isInAnd(X):-X=..[H|T],H=or,!,T=[Y1,Y2],isInAnd(Y1,Y2).
isInAnd(X):-X=..[H|T],H=impl,!,T=[Y1,Y2],isInAnd(Y1,Y2).
%%berprft 2 Formeln ob in einer ein "and" vorkommt
isInAnd(X,_Y):-isInAnd(X).
isInAnd(_X,Y):-isInAnd(Y).


%%toKon(+X,-Y) versucht aus X eine Konjunktion zu machen und gibt das
%%Ergibniss in Y zurck; Hilfsfunktion fr toKonjunktion
toKon(X,Y):-X=..[H,T1,T2],H=or,T1=..[H1,O1,O2],H1=and,Z1=or(T2,O1),
      Z2=or(T2,O2),Y=and(Z1,Z2),!.
%%(a and b) or c->(a or c) and (b or c) 
toKon(X,Y):-X=..[H,T1,T2],H=or,T2=..[H1,O1,O2],H1=and,Z1=or(T1,O1),
      Z2=or(T1,O2),Y=and(Z1,Z2),!.
%%c or (a and b)->(a or c) and (b or c) 
toKon(X,Y):-X=..[H,T1,T2],H=or,isInAnd(T1),T1=..[H1,_O1,_O2],
      H1=or,toKon(T1,YV),Y=or(YV,T2).
toKon(X,Y):-X=..[H,T1,T2],H=or,isInAnd(T2),T2=..[H1,_O1,_O2],
      H1=or,!,toKon(T2,YV),Y=or(T1,YV).
%%fals mehr "or" hintereinander vorkommen und dann irgendwann "and"
%%z.B. a or (b or(c and d))
toKon(X,Y):-X=..[H,T1,T2],H=and,isInAnd(T1),toKon(T1,YV),Y=and(YV,T2).
toKon(X,Y):-X=..[H,T1,T2],H=and,isInAnd(T2),!,toKon(T2,YV),Y=and(T1,YV).
%%fr mehrere "and" mit "or" verschachtelt z.B. z.B. a or (b or(c and d)) 
toKon(_X,_Y):-fail.

%%isKonjunktion(+X); prft ob die Formel X eine Konjunktiver Normalform ist
isKonjunktion(X and Y):-isKonjunktion(X),isKonjunktion(Y).
%%solange ein "and" kommt nur Teilbume untersuchen
isKonjunktion(X):-X=or(_A,_B),\+ isInAnd(X).
%%wenn ein "or" im Baum kommt, darf darunter nur noch "or" im Baum stehen
%%oder keine "and" mehr
isKonjunktion(X):-atom(X).
isKonjunktion(neg(X)):-atom(X).
%%einzelne Variablen oder deren Negation sind immer Disjunktive Normalformen

%%toKonjunktion(+X,-Y) macht aus X eine Konjunktive Normalform und gibt das
%%Ergibniss in Y zurck, Regel 2, entfernt die Klammern bei "(A) or (B and C)"
toKonjunktion(X,X):-isKonjunktion(X).
%%liefert nur wenn die Formel wirklich eine Konjunktion ist ein Ergebnis
toKonjunktion(X,Y):-toKon(X,X2),toKonjunktion(X2,Y).


%%toDis(+X,-Y) versucht aus X eine Disjunktion zu machen und gibt das
%%Ergibniss in Y zurck; Hilfsfunktion fr toDisjunktion
%%wie toKon nur "Kon" und "Dis","or" und "and" vertauscht
toDis(X,Y):-X=..[H,T1,T2],H=and,T1=..[H1,O1,O2],H1=or,Z1=and(T2,O1),
      Z2=and(T2,O2),Y=or(Z1,Z2),!.
toDis(X,Y):-X=..[H,T1,T2],H=and,T2=..[H1,O1,O2],H1=or,Z1=and(T1,O1),
      Z2=and(T1,O2),Y=or(Z1,Z2),!.
toDis(X,Y):-X=..[H,T1,T2],H=and,isInOr(T1),T1=..[H1,_O1,_O2],H1=and,
      toDis(T1,YV),Y=and(YV,T2),!.
toDis(X,Y):-X=..[H,T1,T2],H=and,isInOr(T2),T2=..[H1,_O1,_O2],H1=and,!,
      toDis(T2,YV),Y=and(T1,YV).
toDis(X,Y):-X=..[H,T1,T2],H=or,isInOr(T1),toDis(T1,YV),Y=or(YV,T2),!.
toDis(X,Y):-X=..[H,T1,T2],H=or,isInOr(T2),!,toDis(T2,YV),Y=or(T1,YV),!.
toDis(_X,_Y):-fail.

%%isDisjunktion(+X); prft ob die Formel X eine Disjunktiver Normalform ist
isDisjunktion(X or Y):-isDisjunktion(X),isDisjunktion(Y).
%%solange ein "or" kommt nur Teilbume untersuchen
isDisjunktion(X):-X=and(_A,_B),\+ isInOr(X).
%%wenn ein "and" im Baum kommt, darf darunter nur noch "and" im Baum stehen
%%oder kein "or" mehr
isDisjunktion(X):-atom(X).
isDisjunktion(neg(X)):-atom(X).
%%einzelne Variablen oder deren Negation sind immer Disjunktive Normalformen

%%toDisjunktion(+AndOrFormel,-DisjunktiveFormel)macht aus X eine Disjunktive
%%Normalform und gibt das Ergibniss in Y zurck,
%%Regel 2, entfernt die Klammern bei "(A) and (B or C)"
toDisjunktion(X,X):-isDisjunktion(X).
%%liefert nur wenn die Formel wirklich eine Disjunktive Normalform ist ein
%%Ergebnis
toDisjunktion(X,Y):-toDis(X,X2),toDisjunktion(X2,Y).

%%fuegeListeZusammen(+L,-F); eleminiert in der Anfangsliste alle "," und
%%macht sie zu "and", das Ergebnis wird in F zurckgegeben
fuegeListeZusammen([H],H).
fuegeListeZusammen([H1,H2|T],H):-HN=and(H1,H2),fuegeListeZusammen([HN|T],H).


%%Optimierungsfunktionen:
%%Dienen nur zur Verkrzung der Normalform(Rausschneiden fon Konstanten
%%und doppelten Vorkommen) um die resulution Mglichst schnell zu machen

%%entfDoppelteVorkommenL(+L1,-L2); entfernt doppelte vorkommen von Listen
%%in einer Liste L1 und gibt das Ergebniss in L2 zurck
entfDoppelteVorkommenL([],[]).
entfDoppelteVorkommenL([H1|T],X):-isInL(H1,T),!,
      entfDoppelteVorkommenL(T,Z),entff(H1,Z,Y),X=[H1|Y].
entfDoppelteVorkommenL([H1|T1],[H1|T2]):-entfDoppelteVorkommenL(T1,T2).

%%entfE(+L1,-L2); entfernt aus der Liste 1 die doppelte Vorkommen von
%%Elementen, z.B.[a,b,a]->[a,b], und gibt das Ergebniss in L2 zurck
entfE([],[]).
entfE([H1|T1],X):-isIn(H1,T1),!,entfE(T1,Y),entf(H1,Y,Z),X=[H1|Z].
entfE([H|T1],[H|T2]):-entfE(T1,T2).

%%entfDoppelteVorkommenE(+LL1,-LL2); entfernt doppelte vorkommen in den einzelnen
%%Listen von LL1 und gibt das Ergebniss in LL2 zurck
entfDoppelteVorkommenE([],[]).
entfDoppelteVorkommenE([H1|T1],[H2|T2]):-entfDoppelteVorkommenE(T1,T2),
      entfE(H1,H2).

%%entfDoppelteVorkommen(+LL1,-LL2); entfernt doppelte Vorkommen von Listen
%%(Ordnung nich relevant) in der Liste LL1 und gibt das Ergebniss in LL2 
%%zurck
entfDoppelteVorkommen(X,Y):-entfDoppelteVorkommenE(X,Z),
      entfDoppelteVorkommenL(Z,Y).

%%isKonstante(L); Prft ob die Liste L eine Konstante Formel ist, also
%%wenn F T und neg(T) enthlt,z.B.[a,b,neg(a)]
isKonstante([]):-!,fail.
isKonstante([neg(H)|T]):-isIn(H,T).
isKonstante([H|T]):-isIn(neg(H),T).
isKonstante([_H|T]):-isKonstante(T).

%%entfKonstanten(+LL1,-LL2); entfernt Teillisten von LL1 die Konstanten 
%%sind (z.B. (neg(a) or a)=1), und gibt das Ergebniss in LL2 zurck
entfKonstanten([],[]).
entfKonstanten([H1|T1],Y):-isKonstante(H1),!,entfKonstanten(T1,Y).
entfKonstanten([H|T1],[H|T2]):-entfKonstanten(T1,T2).

%%ende Optimierungsfunktionen


%%dualeKlauselform(+X,-Y), macht aus der Eingabe X die duale Klauselform
%%indem es die Formel schritt fr schritt umwandelt
dualeKlauselform(X,Y):-fuegeListeZusammen(X,Z),aequi(Z,A),
      toDisjunktion(A,B),eleminateOr([B],C), eleminateAndL(C,D),
      entfDoppelteVorkommen(D,E), entfKonstanten(E,Y).

%%Klauselform(+X,-Y), macht aus der Eingabe X die Klauselform
%%indem es die Formel schritt fr schritt umwandelt
klauselform(X,Y):-fuegeListeZusammen(X,Z),aequi(Z,A), toKonjunktion(A,B),
      eleminateAnd1([B],C), eleminateOrL1(C,D),entfDoppelteVorkommen(D,E),
      entfKonstanten(E,Y).

%%alles bis hier dient zur Bestimmung einer kurzen Klauselform


%%Ab hier ist alles fr die Resulution:

%%resEMoeglich(+EListe,+EListe)
%%prft ob eine Resuluion mit einem Element und einer Liste mglich ist
%%Hilfsklausel vin resMoeglich
resEMoeglich([],_X):-!,fail.
%%die Resulution mit "[]" ist niemals mglich
resEMoeglich([neg(H)|_T],X):-isIn(H,X).
resEMoeglich([H|_T],X):-isIn(neg(H),X).
%%Wenn die negation des Kopfes H der 1. Liste in der 2. Liste X ist
resEMoeglich([_H|T],X):-resEMoeglich(T,X).
%%die Resulution mit dem nchsten Element versuchen

%%resMoeglich(+EinfacheListe,+ListeVonListen)
%%prft ob eine Resuluion mit einem Element der Liste und der Liste von 
%%Listen mglich ist
resMoeglich(_A,[]):-!,fail.
%%wenn keine Resulution mglich ist(mit [] ist niemals 
%%eine Resulution mglich)
resMoeglich(A,[H|_T]):-resEMoeglich(A,H).
%%ist eine resulution mit dem Kopf der 2. Liste und der ersten 
%%Liste mglich?
resMoeglich(A,[_H|T]):-resMoeglich(A,T).
%%ansonsten zum das nchste Element der 2. Liste Prfen

%%res(+EListe1,+EListe2,-NeueResulution)
%%resulution mit einem gegebenen Element und der Elementen der Liste
res([H|T],X,Z):-H=..[neg,Y],!,isIn(Y,X),!, entf(Y,X,A),conc(T,A,ZV),
        entfE(ZV,Z).
%%wenn das erste Element der ersten Liste "neg Y" ist und in der 2. Liste
%%"Y" vorkommt die Listen ohne "Y" und "neg Y" zusammenhngen
res([H|T],X,Z):-isIn(neg(H),X),!,entf(neg(H),X,A), conc(T,A,ZV),entfE(ZV,Z).
%%wenn das erste Element der ersten Liste "H" ist und in der 2. Liste
%%"neg H" vorkommt die Listen ohne "H" und "neg H" zusammenhngen
res([H|T],X,Z):-res(T,X,ZV),Z=[H|ZV].

%%resV(+EinfacheListe,+ListeVonListen,-NeueResulution) eine resulution 
%%wird gesucht und Ausgegeben; wenn mit einem Element die Resulution 
%%mglich ist, wird sie mit der Klausel res() erzeugt
resV(X,[H|_T],Z):-resEMoeglich(X,H),res(X,H,Z).
%%wenn eine resulution mit dem Aktuellen Kopf der Liste mglich ist diese
%%in Z zurckgeben
resV(X,[_H|T],Z):-resV(X,T,Z).
%%ansonsten es mit dem rest der Liste versuchen

%%resulution(+X,-A,+Y): von X seinen Elementen wurde die Resulution 
%%schon angewendet, fr Y noch nicht, A ist das Aktuelle Element
%%der Liste
resulution(_X,_A,[]).
%%Wenn bei allen Elementen versucht wurde Resulutionen zu machen und
%%niemals ein "[]" enstand leifert resulution/3 true zurck
resulution(_X,A,Y):-resMoeglich(A,Y),setof(E,resV(A,Y,E),N),isIn([],N),!,fail.
%%wenn ein neues Element [] ist abbrechen und resulution =fail ausgeben
resulution(X,A,Y):-resMoeglich(A,Y),setof(E,resV(A,Y,E),N),
      conc(X,[A|Y],T),conc(N,T,N1),entfDoppelteVorkommen(N1,N2),
	entfKonstanten(N2,[H|Z]),\+ isGleichL([H|Z],T),!,resulution([],H,Z).
%%wenn resulutionen Moeglich sind und die neuen Resolutionen noch nicht drin
%%sind, Resulutionen machen und von vorn anfangen, sonst diese mglichen
%%Resulutionen nicht beachten(wurden ja schon gemacht)
%%das was noch nicht durchsucht wurde nach vorn setzen(steigert Effizenz)
%% \+ isGleich([H|Z],T)prft dabei ob die neu erzeugten Liste aus der die 
%%doppelten Vorkommen entfert wurden, nicht gleich der alten liste ist
%%Liste, wenn sie gleich ist wurden keine neuen resulutionen gemacht
resulution([],A,[H2|T2]):-resulution([A],H2,T2).
%%fr den ersten durchlauf geht die nachfolgende Klausel nicht
%%deshalb die Klausel hier vor
resulution([H1|T1],A,[H2|T2]):-resulution([A,H1|T1],H2,T2).

%%resulution(+LL)
%%startet den resulutionsbeweis und negiert dessen Ergebnis
resulution([H|T]):-resulution([],H,T),!,fail.
resulution(_X).

%%bis hier ist alles fr die Resulution

%%prove1(+P,+F)
%%Resulutionsbeweis mit der dualen Klauselform(Disjunktivenormalform)
prove1(P,F):-dualeKlauselform([neg(F)|P],Y),!,resulution(Y).

%%prove(+P,+F)
%%resulutionsbeweis mit der Klauselform(Konjunktivenormalform)
prove(P,F):-klauselform([neg(F)|P],Y),!,resulution(Y).
