%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Grundgeruest (Christian Anger, Juni 2002)                               %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% Anmerkungen:
%
% !!! Kommentiert Eure Praedikate !!!
% unkommentierte Programme gelten als nicht erbrachte Leistung !!
%
% Eure Programme muessen Testanfragen der unten angegebenen Form
% [eclipse 1]: test1.              bzw.
% ?- test1.
% bearbeiten koennen. Programme, die diese Anforderung nicht erfuellen,
% gelten ebenfalls als nicht erbrachte Leistung
%
% Bei Fragen wendet Euch bitte an
% Christian canger@cs.uni-potsdam.de
% Thomas    linke@cs.uni-potsdam.de
% oder kommt einfach im Zimmer 2.16 vorbei


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% csp(+Domians,+Relations) findet Loesungen fuer ein durch Domains und
% Relations gegebenes CSP
% beachtet bei Eurer Loesung, dass Domains und Relations das folgende Format
% haben:
%  Domains ist eine Liste der Form [dom(Variable,[Werte]),...], also
%    z.B. Domains = [dom(X,[1,2,3,4]),dom(Y,[1,2,3,4]),dom(Z,[1,2,3,4]),
%                    dom(A,[1,2,3,4])]
%  Relations ist eine Liste der Form [rel([Variablen],Relation),...], also
%    z.B. Relations = [rel([X,Y],X<Y),rel([Y,Z],Y<Z),rel([Z,A],Z<A)]
%
% Eure Aufagbe ist die Implementation von arc_consistency/3 und
% domain_splitting/3.
% Ihr muesst eine Ausgabe der Loesungen integrieren. Dafuer koennt Ihr
% pretty_print/1 verwenden, muesst aber nicht, solange die moeglichen
% Belegungen auf dem Bildschirm in einer erkennbaren Form ausgegeben werden.
% Beachtet, dass domain_splitting/3 immer eine Loesung zurueckgibt, and dass
% alle Loesungen ueber backtracking mittels fail ermittelt werden. Fuer das
% Erreichen der vollen Punktzahl muss dieses also funktionieren.
%
% Es steht Euch natuerlich frei, auch das Praedikat csp/2 zu veraendern,
% solange alle Loesungen in lesbarer Form auf dem Bildschirm ausgegeben werden
% und die Testanfragen funktionieren.
% 

csp(Domains,Relations):-
	arc_consistency(Relations,Domains,Consistent_Domains),!,
	domain_splitting(Relations,Consistent_Domains,Loesung),
	pretty_print(Loesung),
	fail.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Arc Consistency                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% arc_consistency(+Relations,+Domains,-Consistent_Domains)
% streicht Werte aus den Domains, bis die Arcs konsistent sind
% Dafr men erst alle Arcs(gerichtete Kante) hergestellt werden und dann 
% aus den Domains die nicht gltigen Elemente gestrichen werden
arc_consistency(Relations,Domains,Consistent_Domains):-
	make_all_arc(Relations,All_arc),!,
	prun_domains(All_arc,[],Domains,Consistent_Domains).

%make_all_arc(Relation,All_arc) stellt alle Relations Kanten All_arc(sind 
%gerichtet) her, bei der Eingabe existieren die Kanten(Relationen) nur in
%eine Richtung, hier wird die zweite erzeugt, z.B. wenn eine Kante 
%(Relation)"rel([X,Y],X<Y)"  in der Menge Relation ist wird diese und die 
%Kante(Relation) fr die andere "Richtung "rel([Y,X],X<Y)" zur Menge 
%All_arc aller Kanten hinzugelegt
make_all_arc([],[]).
make_all_arc([rel([X,Y],R)|T],[rel([X,Y],R),rel([Y,X],R)|NT]):-
	make_all_arc(T,NT).

%prun_domains(Todo_arcs,Done_arcs,Domains,Consistent_Domains) macht die
%Domains Konsistent,bzw. streicht alle Elemente die nicht die Relationen 
%erfllen aus der jeweiligen Domain Menge
%wenn alle Kanten berprft wurden: fertig
prun_domains([],_Done_arcs,Consistent_Domains,Consistent_Domains).
%Die aktuelle(vorderste Relation) von den noch zu prfenden Kanten(TDA)
%wird genommen, die entsprechenden Domain Mengen(XD,YD)) herausgesucht
%Dann wird die in der Relation zuerst auftretende Domain(XD zu X) konsistent
%gemacht(NXD), wenn die Domain schon konsistent war wird diese Kante 
%"bersprungen"(Letzte Regel, die Menge hat sich nicht gendert)
%ansonsten werden alle Kanten die zur Domain hin fhren(haben an zweiter
%Stelle X) von den schon bearbeiteten(DA) wieder zu den noch zu 
%bearbeitenden Kanten(TDA1) verschoben da die nderung der Domain 
%Auswirkungen auf die "benachbarten" Domains haben kann, die vernderte 
%Domain(XD) in der Domainliste(D) durch die konsistente Domain(NXD) 
%ersetzt und die bearbeitete Kante zu den bearbeiteten Kanten(DA) hinzugelegt
prun_domains([rel([X,Y],R)|TDA],DA,D,CD):-take_domain(X,D,XD),
	take_domain(Y,D,YD),make_domain_con(XD,YD,rel([X,Y],R),NXD),
	\+ is_gleiche_liste(XD,NXD),!,reorder_arcs(X,TDA,DA,TDA1,DA1),
	replace_domain(dom(X,NXD),D,D1),
	prun_domains(TDA1,[rel([X,Y],R)|DA1],D1,CD).
%wenn die erste Domain von der Kante R schon konsistent ist, verschiebe
%die Kante R von den noch zu tuenden Kanten(TDA) zu den Erledigten Kanten(DA)
prun_domains([R|TDA],DA,D,CD):-prun_domains(TDA,[R|DA],D,CD).

%is_gleich_liste(X,Y) prft ob die Listen X und Y gleich sind(mit Reihenfolge) 
is_gleiche_liste([],[]).
is_gleiche_liste([H|T1],[H|T2]):-is_gleiche_liste(T1,T2).

%take_domain(X,Domain_List,Domain) nimmt die Domain dom(X,L)
%aus der Liste und gibt deren Elemente als Menge zurck
%wenn keine Domain X existiert Fehler zurckgeben
take_domain(X,[],X):-fail.
%wenn es die richtige Domain ist deren Elementeliste zurckgeben
take_domain(X,[dom(Y,L)|_D],L):-X==Y.
%wenn die aktuelle Domain nicht die Richtige ist die nchste Domain prfen
take_domain(X,[_H|T],XD):-take_domain(X,T,XD).

%replace_domain(dom(X,L),DL,DL1)ersetzt die Domain X in der Domain Liste D 
%durch dom(X,L) und gibt das Ergebniss in D1 zurck
%wenn keine Domain X existiert Fehler zurckgeben
replace_domain(_D,[],[]):-fail.
%wenn es die richtige Domain ist deren Elementeliste ersetzen und die neue
%Domainliste zurckgeben
replace_domain(dom(X,L),[dom(Z,_L1)|DL],[dom(X,L)|DL]):-X==Z.
%wenn die aktuelle Domain nicht die Richtige ist die nchste Domain prfen
replace_domain(D,[H|T1],[H|T2]):-replace_domain(D,T1,T2).

%make_domain_con(Domain_X,Domain_Y,Arc,New_Domain_X) macht die Domain X 
%zur Domain Y unter Bercksichtigung der Relation Arc konsistent und 
%gibt das Ergebnis in New_Domain_X zurck
%sind alle Elemente berprft: fertig
make_domain_con([],_DY,_R,[]).
%schauen ob es zum aktuellen Element H ein Element ais der Domain Y gibt
%das die Relation erfllt, wenn ja nchste Klausel Element zur konsistenten 
%Domain nehmen, wenn nein Element nicht dazunehmen
make_domain_con([H|DX],DY,rel([X,Y],R),NDX):- \+ (X=H,member(Y,DY),call(R))
	,make_domain_con(DX,DY,rel([X,Y],R),NDX).
%Element zur konsistenten Domain nehmen
make_domain_con([H|DX],DY,R,[H|NDX]):-make_domain_con(DX,DY,R,NDX).

%reorder_arcs(X,TDA,DA,New_TDA,New_DA) verschiebt alle Kanten die zu X 
%fhren (z.B. dom([Y,X],R)) zu den neuen noch zu tun Kannten New_TDA
%wenn keine fertigen Kanten mehr in DA sind knnen auch keine 
%verschoben werden, also: fertig
reorder_arcs(_X,TDA,[],TDA,[]).
%Wenn die aktuelle Kante aus der fertigen Kanten Liste(DA) zu Z fhrt(Z 
%ist gleich der zweiten Domain in der Kante) verschiebe die Kante zu den
%noch zu erledigenden Kanten(TDA) und prfe die nchste DA Kante
reorder_arcs(Z,TDA,[rel([Y,X],R)|DA],[rel([Y,X],R)|New_TDA],New_DA):-Z==X
	,!,reorder_arcs(X,TDA,DA,New_TDA,New_DA).
%Wenn es  keine Kante zu Z ist lasse sie in DA
reorder_arcs(Z,TDA,[H|DA],New_TDA,[H|New_DA]):-
	reorder_arcs(Z,TDA,DA,New_TDA,New_DA).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Domain Splitting                                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% domain_splitting(+Relations,+Domains,-Loesung)
% Splittet Domains mit mehreren moeglichen Belegungen um eine endgueltigen
% Loesung eines CSP zu ermitteln. Alle Loesungen werden ueber Backtracking
% ermittelt.  
%
%erstellt eine neue Domain Liste durch aufspalten von Domains der alten Liste
%prft ob es eine Lsung sein kann(jede Domain entlt ein Element) und schaut
%ob die Domains in ihr konsistent sind, wenn die beiden Test fehlschlagen sind 
%eine neue potentielle Lsung mittels backtracking von make_new_Domains ermittelt
domain_splitting(R,D,ND):-make_new_Domains(D,ND),is_result(ND),
	arc_consistency(R,ND,ND).

%make_new_Domains(Domains,New_Domains) macht aus einer Domain Liste eine
%neue Liste durch aufspalten von Domains
%Wenn keine Domains da sind knnen keine aufgespalten werden, also:fertig
make_new_Domains([],[]).
%die aktuelle Domain in zwei Teile aufspalten und den ersten Teil nehmen
%die Domain kann eventuell nocheinmal gespalten werden
make_new_Domains([dom(X,[H1,H2|L])|D],ND):-
	split_list([H1,H2|L],L1,_L2),make_new_Domains([dom(X,L1)|D],ND).
%die aktuelle Domain in zwei Teile aufspalten und den zweiten Teil nehmen
%die Domain kann eventuell nocheinmal gespalten werden
make_new_Domains([dom(X,[H1,H2|L])|D],ND):-
	split_list([H1,H2|L],_L1,L2),make_new_Domains([dom(X,L2)|D],ND).
%oder die aktuelle Domain so lassen und die nchste Domain nehmen
make_new_Domains([H|D],[H|ND]):-make_new_Domains(D,ND).
%beim Backtracking werden jeweils die Regeln in einer anderen Reihnfolge
%genommen, wodurch immer neue Domain Listen entstehen und am Ende(wenn 
%alle Reihnfolgen der Klauseln ausprobiert wurden) alle mglichen Domain 
%Listen entstanden sind

%is_result(domain_list) prft ob eine Domainliste eine Lsung ist(jede Domain
%enthlt ein Element)
is_result([]).
is_result([dom(_X,[_H])|T]):-is_result(T).

%split_list(Liste,Teil_Liste_1,Teil_Liste_2) spaltet eine Liste in zwei Teilisten
split_list([],[],[]).
split_list([H],[H],[]).
split_list([H1,H2|T],[H1|T1],[H2|T2]):-split_list(T,T1,T2).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Hilfestellung                                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% prettyprint(+Domains)
% gibt die Domains in lesbarer Form auf dem Bildschirm aus
% Voraussetzungen sind, dass jede Domain nur genau eine Belegung hat,
% die Domains in der geforderten Form vorliegen und es sich um genau eine
% Loesung handelt!!
%
pretty_print([]):-nl.
pretty_print([dom(X,[Val])|Doms]):-
	write(X),write('='),write(Val),write(' '),
	pretty_print(Doms).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Tests                                                                   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

test1:-csp([dom(X,[1,2,3,4]),dom(Y,[1,2,3,4]),dom(Z,[1,2,3,4]),dom(A,[1,2,3,4])],
            [rel([X,Y],X<Y),rel([Y,Z],Y<Z),rel([Z,A],Z<A)]).

test2:-csp([dom(X,[1,2,3,4]),dom(Y,[1,2,3,4]),dom(Z,[1,2,3,4]),dom(A,[1,2,3,4])]
	,[rel([X,Y],X<Y),rel([Y,Z],Y<Z),rel([Y,A],Y<A)]).

test3:-csp([dom(X,[1,2,3,4]),dom(Y,[1,2,3,4]),dom(Z,[1,2,3,4]),dom(A,[1,2,3,4])]
  ,[rel([X,Y],X>Y),rel([X,Z],X==Z),rel([X,A],X=\=A),rel([Z,A],Z>A),rel([A,Y],((A+Y)mod 2)=:=0)] ).
%
