%%entfernen eines Elements Y
entf(Y,[Y|T1],T2):-isIn(Y,T1),!,entf(Y,T1,T2).
entf(Y,[Y|T],T).
entf(Y,[H|T1],[H|T2]):-entf(Y,T1,T2).

%%entf1(+E,+L1,-L2) entfernt einmal das Element E aus der Liste L1
%%und gibt das Ergebnis in L2 zurck
entf1(Y,[Y|T],T).
entf1(Y,[H|T1],[H|T2]):-entf1(Y,T1,T2).

%% Zwei Listen hintereinander
conc([],L,L).
conc([H|T1],L,[H|T2]):-conc(T1,L,T2).

%%Durchschnitt geordnete Listen
ds([],_X,[]).
ds([H|T1],L2,L3):-isIn(H,L2),!,L3=[H|T3],ds(T1,L2,T3).
ds([_H|T1],L2,L3):-ds(T1,L2,L3).

%%isIn(+X,+L) prrt ob das Element X in der Liste L ist?
isIn(_X,[]):-fail.
isIn(H,[H|_T]).
isIn(X,[_H|T]):-isIn(X,T).

%%ps(+x,-PS) erzeugt die Potenzmenge PS von der Menge X
ps([],[[]]).
	%%die potenzmenge der leeren Menge ist die Menge mit der leeren Menge
ps([H|T],L):-ps(T,L1),felm(H,L1,L2),conc(L1,L2,L).

%%felm(+E,+M1,-M2) fgt das Element E an alle Teilmengen der Menge M1 ein
%%und gibt das Ergebnis in M1 zurck
felm(_X,[],[]). %%wenn keine Listen in der Liste mehr sind nichts machen
felm(X,[H1|T1],[H2|T2]):-einf(X,H1,H2),felm(X,T1,T2).
	%%X in jeder Teilliste einfgen

%%einf(+E,+L1,-L2) fgt das Element E in der Liste L1 vorn ein und gibt
%%die ergebnis Liste in L2 zurck
einf(E,T,[E|T]).

%%gibt X aus
ausg(X):-write(X),nl.

%%prft ob die Menge geordnet ist
geordnet([_X|[]]).
geordnet([X|[Y|Z]]):-kleinerg(X,Y),geordnet([Y|Z]).

%%prft ob die erste Menge die gleichen Elemente wie die 2. geordnete hat
ordneu([X],[X]).
ordneu([H|T],X):-isIn(H,X),!,entf1(H,X,Y),ordneu(T,Y).
ordne(X,Y):-glang(X,Y),!,geordnet(Y),ordneu(X,Y).  %%nur einmal prfen ob die 2. Liste geordnet ist

%%gibt die Lnger einer Liste zurck
laenge([],0).
laenge([_H|T],X):-laenge(T,Y),X is Y+1.

%%gibt an ob die listen gleichlang sind
glang([],[]).
glang([_H1|T1],[_H2|T2]):-glang(T1,T2).

%%prft ob das erste Element das kleinste ist
kleinste(_X,[]):-fail.
kleinste(X,[X|T]):-kleinergals(X,T).
kleinste(X,[H|T]):-kleinste(X,T),kleinerg(X,H).

%%prft ob es kein kleineres Element in der Liste gibt als das gegebene
kleinergals(_X,[]).
kleinergals(X,[H|T]):-kleinerg(X,H),!,kleinergals(X,T).

%%die erste Liste ist die unsortierte Liste die zweite die sortierte
sort1([],[]).
sort1(X,[H|T]):-kleinste(H,X),!,entf1(H,X,Y),sort1(Y,T).

%%Permutation
perm([],[]).
perm([H|T],X):-perm(T,Y),entf1(H,X,Y).

%%liste mit allen Permutationen der 1. Liste
all_perms([],[[]]).
all_perms(L,P):-setof(X,perm(L,X),P).

%%ist das n-te Element der Liste L E
nth([E|_H],1,E).
nth([_X|H],N,E):-nth(H,NE,E),N is NE+1.

%%arg2
arg2(N,F,A):-F=..[_G|L],nth(L,N,A).

%%functor2
functor2(F,G,La):-F=..[G|R],laenge(R,La).

%%reverse dreht die Liste um
reverse1([],[]).
reverse1([X|Xs],Zs):-reverse1(Xs,Ys),append(Ys,[X],Zs).
reverse2(Xs,Ys):-rev(Xs,[],Ys).
rev([X|Xs],Akk,Ys):-rev(Xs,[X|Akk],Ys).
rev([],Akk,Akk).

%%sum_pos_neg(+L,-Pos,-Neg) Summe der Positiven bzw. Negativen Zahlen
sum_pos_neg([],0,0).
sum_pos_neg([H|T],P,N):-H<0,!,sum_pos_neg(T,P,N2),N is N2+H.
sum_pos_neg([H|T],P,N):-sum_pos_neg(T,P2,N),P is P2+H.

%%ist das Element kleiner
%%kleiner(X,Y):-X<Y.


kleiner(1,2).
kleiner(2,3).
kleiner(3,4).
kleiner(4,5).
kleiner(5,6).
kleiner(6,7).
kleiner(7,8).
kleiner(8,9).
kleiner(9,10).
kleiner(10,_X):-!,fail.
kleiner(_X,1):-!,fail.
kleiner(X,Y):-kleiner(X,Z),!,kleiner(Z,Y).

%%ist das Element kleinergleich
%%kleinerg(X,Y):-X<=Y.
kleinerg(X,X).
kleinerg(X,Y):-kleiner(X,Y).


