;;this file is for the fast loading the required RAP and lisp files of this project

;;the path wher the loader.lisp file of the RAP System can be found
(defparameter *rap-system-loader* "/home/boesterh/CogRob/RAP-System/loader.lisp")
;;the directory wher the files of the project can be found
(defparameter *pathname* "/home/boesterh/selbst/cogrob/")
;;the files of the project
(defparameter *system-files* '("function-communication.lisp"
						"function.lisp"
                               	"skill-interface.lisp"
						"memory.lisp"
						"declarations.lisp"
						"worlds.raps"
						"factory.raps"
						"basic.raps"))

;;load-all is a fuction for load all required files
(defun load-all ()
   ;load RAP system
   (load *rap-system-loader*)
   (load-rap-system)
   
   ;load files
   (mapcar #'(lambda (x)
               (load (namestring (merge-pathnames x *pathname*))))
           *system-files*)
   
   ;synchronize the RAP memory 
   (sync-memory))
