
;;sends the two chars byte x1 x2 to the Robot(they should stand for a
;;integer nummer, e.g. 12= (x1='1' x2='2') ) over the file output that
;;is readed by prolog main that send the number over the infrared port 
(defun send-to-robot (x1 x2)
	(defparameter *o-file*
		(make-pathname :name "output"));;the filename is "output"
	(defparameter bufer nil)
	;;test if the file exsists and should not be opened to write
	(loop until bufer do
		(setq o-stream
			(open *o-file* :direction :output :element-type 'string-char :if-exists :append :if-does-not-exist nil));;try to open file
		(if o-stream (close o-stream)(defparameter bufer 1));;if the file is open(it exsists) close it, else end the loop
	)
	;;if the file doesn't exsists creat a new file
	(setq o-stream
		(open *o-file* :direction :io :element-type 'string-char :if-exists :overwrite :if-does-not-exist :create))
	;;write the two chars(number) to the file
	(write-char x1 o-stream)
	(write-char x2 o-stream)
	(close o-stream)
)

;;gets the number over prolog and the file "input" from the Robot and
;;returns the number, asks the whol time if no file exsists;
;;if ther is a file returns the number x that stands in the file
(defun wait-for-input()
	(defparameter *i-file*(make-pathname :name "input" ));;make filename
	;;test if the file exsists and should be opened to read
	(setq i-stream nil)
	(loop until i-stream do	;;as long i-stream is nil(the file does not exsists) loop
		(setq i-stream
			(open *i-file* :direction :input :element-type 'string-char :if-does-not-exist nil))
	)
	;;read two chars if the file exsists(the message from the robot)
	(defparameter bufer1 (read-char i-stream nil))
	(defparameter bufer2 (read-char i-stream nil))
	(close i-stream)	;;close file
	(delete-file *i-file*)	;;delete the file
;;	(terpri)
;;	(princ (+ (* (- (char-int bufer1) 48) 10) (- (char-int bufer2) 48)))	;;write message
	;;evaluate and return the number that was readed
	(+ (* (- (char-int bufer1) 48) 10) (- (char-int bufer2) 48))
)


;;next are the functions for send commands to the robot and return results
;;from the robot
;;if for lines with "send-to-robot" and "wait-for-input" are ";", the
;;communication is dectivated and the function works in simulation mode
;;(withput realy sending or reading enything to the robot)

;;command-move-next-station send the command for moving to the next
;;station to the robot
(defun command-move-next-station ()
	(terpri)
	(princ "next station ")
	(setq steps (+ steps 1))
	(princ steps)
	(send-to-robot #\1 #\2)			;;send the command
	(sleep 0.1)
	(defparameter tmp (wait-for-input))	;;read the return value from the robot
	(if (not (= tmp 17)) (wait-for-input))	;;if it whas not a correct return value wait for more
	'Ok	;;return Ok
)

;;command-move-over-station send the command for moving over the
;;station to the robot
(defun command-move-over-station ()
	(terpri)
	(princ "over station")
	(send-to-robot #\1 #\3)			;;send the command
	(defparameter tmp (wait-for-input))	;;read the return value from the robot
	(if (not (= tmp 17)) (wait-for-input));;if it whas not a correct return value wait for more
	'Ok
)

;;command-turn-left send the command for turning left to the robot
(defun command-turn-left ()
	(terpri)
	(princ "turn left")
	(send-to-robot #\1 #\4)
	(defparameter tmp (wait-for-input))
	(if (not (= tmp 17)) (wait-for-input))
	'Ok
)

;;command-turn-right send the command for turning right to the robot
(defun command-turn-right()
	(terpri)
	(princ "turn right")
	(send-to-robot #\1 #\5)
	(defparameter tmp (wait-for-input))
	(if (not (= tmp 17)) (wait-for-input))
	'Ok
)

;;command-eye-scan send the command for eye scan the sourroundings to the robot
;;(not implemented yet on the robot)
(defun command-eye-scan()
	(terpri)
	(princ "eye-scan")
;	(send-to-robot #\1 #\6)
;	(defparameter tmp (wait-for-input))
;	(if (not (= tmp 17)) (wait-for-input))
	'Ok
)

;;command-load-object send the command for load the object(to the robot bay) to the robot
;;(not implemented yet on the robot)
(defun command-load-object(object)
	(terpri)
	(princ "load object")
;	(send-to-robot #\1 #\7)
;	(defparameter tmp (wait-for-input))
;	(if (not (= tmp 17)) (wait-for-input))
	'Ok
)

;;command-unload-object send the command for unload the object(from the robot bay) to the robot
;;(not implemented yet on the robot)
(defun command-unload-object(object)
	(terpri)
	(princ "unload object")
;	(send-to-robot #\1 #\8)
;	(defparameter tmp (wait-for-input))
;	(if (not (= tmp 17)) (wait-for-input))
	'Ok
)

;;the functions to communicate with the fabrik

;;get-from get from fabrik with name how_much things from position wich
;;open the file with name and reduce the wich position about how_much
(defun get-from(name wich how_much)
	(terpri)
	(princ "get from ")(princ name)(princ " wich : ")(princ wich)(princ " number : ")(princ how_much)
	(setq factory-path (make-path name))

	(defparameter *wb-file*
		(make-pathname :name factory-path :type "fb"))
	(setq b-io-stream
		(open *wb-file* :direction :io :element-type 'unsigned-byte :if-exists :overwrite :if-does-not-exist :create))
	(file-position b-io-stream wich)
	(defparameter bufer (read-byte b-io-stream nil))
	(if (< bufer how_much) nil)	;;if ther isn't enought to get return nil
	(defparameter bufer (- bufer how_much))
	(file-position b-io-stream wich)
	(write-byte bufer b-io-stream)
	(close b-io-stream)
	'OK
)

;;put-at put at fabrik with name how_much things to position wich
;;open the file with name and adds to the wich position about how_much
(defun put-at(name wich how_much)
	(terpri)
	(princ "put at ")(princ name)(princ " wich : ")(princ wich)(princ " number : ")(princ how_much)
	(setq factory-path (make-path name))

	(defparameter *wb-file*
		(make-pathname :name factory-path :type "fb"))
	(setq b-io-stream
		(open *wb-file* :direction :io :element-type 'unsigned-byte :if-exists :overwrite :if-does-not-exist :create))
	(file-position b-io-stream wich)
	(defparameter bufer (+ how_much (read-byte b-io-stream nil)))
	(if (> bufer 250) nil)	;;if ther is to much when putted down, return nil
	(file-position b-io-stream wich)
	(write-byte bufer b-io-stream)
	(close b-io-stream)
	'OK
)

;;how-much returns how much thing are on position wich in the at fabrik with name
;;open the file with name and returns the wich position
(defun how-much(name wich)
	(setq factory-path (make-path name))

	(defparameter *wb-file*
		(make-pathname :name factory-path :type "fb"))
	(setq b-io-stream
		(open *wb-file* :direction :io :element-type 'unsigned-byte :if-exists :overwrite :if-does-not-exist :create))
	(file-position b-io-stream wich)
	(defparameter bufer (read-byte b-io-stream nil))
	(close b-io-stream)
	(princ " ")
	(princ wich)
	(princ ":")
	(princ bufer)
	(princ " ")

	bufer
)

;;make-path returns the file name of the factory with the name name
(defun make-path(name)
	(if (eq name 'lager) (setq factory-path "lager"))
	(if (eq name 'factory) (setq factory-path "factory"))
	;;example 2
	(if (eq name 'el-store) (setq factory-path "el-store"))
	(if (eq name 'cir-factory) (setq factory-path "cir-factory"))
	(if (eq name 'end-factory) (setq factory-path "end-factory"))
	(if (eq name 'hou-factory) (setq factory-path "hou-factory"))
	(if (eq name 'scr-store) (setq factory-path "scr-store"))
	(if (eq name 'pl-store) (setq factory-path "pl-store"))
	factory-path
)


(define-rap-function (how-much-r ?name ?wich => ?number)
	#'(lambda (name wich)
		(how-much name wich)
))

