;;; Before the real-arm-move-p RAP can execute, the RAP system must know about the events that
;;; can occur in the skill-level.
;;; Succeeded is an event declaring that the given action has completed as expected.
;;; ?result will have the success-code (e.g. 'okay).
(define-primitive-event (succeeded ?action ?result)
  (event-definition (succeeded ?action))
  (event-values :bound nil))

;;; Faild is an event declaring that the given action has completed, but not as expected.
;;; ?result will have the error-code (e.g. 'arm-cannot-find-place). 
(define-primitive-event (failed ?action ?result)
  (event-definition (failed ?action))
  (event-values :bound nil))

;;;For debugging purposes :low
;;(set-show-level :hyper)
(set-show-level :off)