
;;get-head ?list-head; returns the head of the plan list
;;plan is a global lisp list variable
(define-rap-function (get-head  => ?list-head)
	#'(lambda ()
		(car plan)
))

;;pop-plan ?plan; removes the first element of the plan list
;;plan is a global lisp list variable
(define-rap-function (pop-plan)
	#'(lambda ()
		(setq plan (cdr plan))
))

;;print-fkt ?a; print the value of ?a with a new line befor
(define-rap-function (print-fkt ?a )
	#'(lambda (?a)
		(terpri)
		(print ?a)
))


;;the A* search; a rap function that generates a plan with the A* allgorithm
;;and store it in the global Lisp variable plan;uses data of the RAP memory(underground and way) 
(define-rap-function (A-star ?from-X ?from-Y ?to-X ?to-Y)
  #'(lambda (?from-X ?from-Y ?to-X ?to-Y)
  	(defparameter counter 0)	;;this conter is for furtil loop detection; without it A* would 			;;search infinite when no plan exsists
	(setq plan (car (A-star1 ?to-X ?to-Y counter (list (list (list nil) ?from-X ?from-Y 0)))))
		;;A-star1 is a Lisp function that genarates a plan, the first Element in the genarted plan is the last to execute(last step for the robot to move)
	(setq plan (revers-plan plan) );;revers the plan, so the first element of the plan list is the first element to move 
	(princ "plan : ")
	(princ plan)	;;print the plan
	)
)

;;just returns 'Ok
(defun Ok () 'Ok
)

;;revers-plan list; revers the given plan list an returns it 
(defun revers-plan (list)
	(defparameter r-list nil)	;;reverst list
	(defparameter tlist list)	;;list
	(loop while (car tlist) do	;;as long list is not nil
		(defparameter r-list (cons (cdr tlist) r-list))
		(defparameter tlist (car tlist))
	)
	r-list		;;return revers list
)

;;the help function for the A* search
(defun A-star1 (to-X to-Y counter plan-list)
;;plan-list is of the form (list first-plan=(list (list of the plan til now) actual-X-position actual-Y-position cost-till-hear) next-plan ...)
	(defparameter counter (+ counter 1))
	(defparameter shortest-plan (select-shortest-plan plan-list to-X to-Y)) ;;select shortest plan, with lowes cost = (cost till now) + (cost heristic till destinatin)
	(if (> counter 1000) nil	;;for futil loop detection; if the counter is greater 1000 return nil
		(if (and (= to-X (car (cdr shortest-plan))) (= to-Y (car (cdr (cdr shortest-plan)))) )
			;;test if this plan is the plan that reach the position (to-X,to-Y)
			shortest-plan ;;then return the shortest plan plan
			(A-star2 to-X to-Y counter shortest-plan plan-list);;secound part of A*
		)
	)
)

;;the help function for the A-star1 function
(defun A-star2 (to-X to-Y counter shortest-plan plan-list)
	(defparameter new-plan-list (delete-plan-from shortest-plan plan-list))
	;;make plan for all posible nighbours of the end position of the shortest plan and insert them
	;;(insert them all and not yust the best, because the evalute wich the 
	;;nighbours are is the difficult not the inserting in the plan list)
	(if (posible shortest-plan 'N) (defparameter new-plan-list (inset-plan (plan-for-step shortest-plan 'N) new-plan-list to-X to-Y)) nil)
	(if (posible shortest-plan 'S) (defparameter new-plan-list (inset-plan (plan-for-step shortest-plan 'S) new-plan-list to-X to-Y)) nil)
	(if (posible shortest-plan 'O) (defparameter new-plan-list (inset-plan (plan-for-step shortest-plan 'O) new-plan-list to-X to-Y)) nil)
	(if (posible shortest-plan 'W) (defparameter new-plan-list (inset-plan (plan-for-step shortest-plan 'W) new-plan-list to-X to-Y)) nil)
	(A-star1 to-X to-Y counter new-plan-list);;next iteration of A*
)

;;select the plan with the lowest cost+heuristic
(defun select-shortest-plan (plan-list to-X to-Y)
	(if (cdr plan-list) ;;if more then one element is in the plan-list
		(return-shortest-plan-of-two (car plan-list) (select-shortest-plan (cdr plan-list) to-X to-Y) to-X to-Y);;return the shortest of the first element of the plan list and the shortest that are finded in the rest of the plan list
		;;else:
		(car plan-list);;return first element of plan list
	)
)

(defun return-shortest-plan-of-two (first-plan secound-plan to-X to-Y)
	;;evaluate heuristic of the two plans ( (car (cdr plan))=X (car (cdr (cdr plan)))=Y)
	(defparameter heur1 (to-go-heuristic (car (cdr first-plan)) to-X (car (cdr (cdr first-plan))) to-Y ))
	(defparameter heur2 (to-go-heuristic (car (cdr secound-plan)) to-X (car (cdr (cdr secound-plan))) to-Y ))
	;;return the shortest(with lowest heuristic+(cost til now) )
	(if (< (+ heur1 (car (cdr (cdr (cdr first-plan)))))  (+ heur2 (car (cdr (cdr (cdr secound-plan))))) )
		first-plan
		secound-plan
	)
)

;;insert a plan in the plan list if no shorter plan exsits; 
;;if a longer plan exsits with the same end position it is deleted
(defun inset-plan (plan plan-list  to-X to-Y)
	(if plan-list  ;;if ther are elements in the plan list
		(if (and (= (car (cdr plan)) (car (cdr (car plan-list)))) ;;if X1==X2 (X2 is the X position of the first plan in the plan list)
				 (= (car (cdr (cdr plan))) (car (cdr (cdr (car plan-list)))))) ;;and Y1=Y2(like by X)
				(cons (return-shortest-plan-of-two plan (car plan-list) to-X to-Y) (cdr plan-list)) ;;insert the shortest of the two plans 
				;;else X1!=X2 or Y1!=Y2
				(cons (car plan-list) (inset-plan plan (cdr plan-list) to-X to-Y));;test next element
		)
		(list plan);; if plan-list is emty return a list with yust plan(the rest of the plan list is appended down)
	)
)

;;delete the plan from the plan-list one time
(defun delete-plan-from (plan plan-list)
	(if (car plan-list) ;;if the plan list is not emty
		(if (and (= (car (cdr plan)) (car (cdr (car plan-list))) )
			(= (car (cdr (cdr plan))) (car (cdr (cdr(car plan-list)))) ) )
;;if the x and y position of the plan is the same as the of the first plan in the plan list, return yust the rest of the plan-list
			(cdr plan-list)
			(cons (car plan-list) (delete-plan-from plan (cdr plan-list)));;else test next element of the plan-list
		)
		nil
	)
)

;;plan-for-step makes the plan for a step in the direction direction of the input plan
(defun plan-for-step (plan direction)
	;;evaluate the next X and Y position
	(defparameter new-X (if (eq direction 'N) (+ (car (cdr plan)) 1)
		(if (eq direction 'S) (- (car (cdr plan)) 1) (car (cdr plan)) )))
	(defparameter new-Y (if (eq direction 'O) (+ (car (cdr (cdr plan))) 1)
		(if (eq direction 'W) (- (car (cdr (cdr plan))) 1) (car (cdr (cdr plan))))))
	;;evaluate the new cost 
	(defparameter cost (car (cdr (cdr (cdr plan)))))	
	(defparameter new-cost ( if (eq (cdr (car plan)) direction) (+ cost 1) (+ cost 2)));;if the robot must not turn cost+1, else cost+2
	;;constructs the new plan
	(defparameter new-plan (push (car plan) direction));;append the next step on the plan
	(list new-plan new-X new-Y new-cost)	;;return the new plan with the evaluated values
)

;;posible tests if a step in direction from the end position of the plan is posible
;;,means if this new end point is not blocked
(defun posible (plan direction)
	;;evaluate the X and Y position, if a step in the given direction is done
	;; from the end point of the given  plan
	(defparameter new-X (if (eq direction 'N) (+ (car (cdr plan)) 1)
		(if (eq direction 'S) (- (car (cdr plan)) 1) (car (cdr plan)) )))
	(defparameter new-Y (if (eq direction 'O) (+ (car (cdr (cdr plan))) 1)
		(if (eq direction 'W) (- (car (cdr (cdr plan))) 1) (car (cdr (cdr plan))))))
	(not (is_blocked new-X new-Y))	;;the step is posible if the new X and Y position is not blocked
)

;;returns if the place on the position X Y is blocked;
;;it is when ther is a obstracle or no way(inclusiv stations) on the ground
(defun is_blocked (X Y)
	(if  (or (blocked X Y 'blocked) (not (or (underground X Y 'way) (underground X Y 'station)))) T nil)
)

;;to-go-heuristic is the minimal distance between position from-X from-Y 
;;to position to-X to-Y, if the robot move over a grid(yust in directions 
;;parallel to each other)
(defun to-go-heuristic (from-X from-Y to-X to-Y)
	(+ (dist from-X to-X) (dist from-Y to-Y))
)

;;dist is the absulut distanc betwean two values X Y
(defun dist (X Y)
	(if (< X Y) (- Y X) (- X Y))
)

;;underground is a lisp function that returns true if in the RAP memory  
;;the underground on one position (X;Y) equal what
(defun underground (X Y what)
	(let (	(query '(underground ?X ?Y ?what))	;;make query
 	      	(env   (create-binding-environment)));;make environment bindings
		;;bind variables X Y in environment
		(set-rap-var-binding env '?X X)
		(set-rap-var-binding env '?Y Y)
		(set-rap-var-binding env '?what what)
		(let (	(value (memory-query main-memory* env query)));;make the query in the environment
		value	;;return result of the query
		)
	)
)

;;blocked is a lisp function that returns true if in the RAP memory
;;the position (X;Y) is blocked  ;;(way 3 4 blocked)
(defun blocked (X Y Object)
	(let (	(query '(way ?X ?Y ?what))	;;make query
 	      	(env   (create-binding-environment)));;make environment bindings
		;;bind variables X Y in environment
		(set-rap-var-binding env '?X X)
		(set-rap-var-binding env '?Y Y)
		(set-rap-var-binding env '?what Object)
		(let (	(value (memory-query main-memory* env query)));;make the query in the environment
		value	;;return result of the query
		)
	)
)


